/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.event;

import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.EnumUtil;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.event.CellMouseEvent;
import java.util.Map;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuRequests;
import org.zkoss.zk.ui.Component;

public class CellHyperlinkEvent
extends CellMouseEvent {
    private String _address;
    private Hyperlink.HyperlinkType _type;

    public static CellHyperlinkEvent getHyperlinkEvent(AuRequest request) {
        Map data = request.getData();
        Component comp = request.getComponent();
        String sheetId = (String)data.get("sheetId");
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        if (!((SheetImpl)sheet).getNative().getId().equals(sheetId)) {
            return null;
        }
        String name = request.getCommand();
        int keys = AuRequests.parseKeys((Map)data);
        int type = AuRequests.getInt((Map)data, (String)"type", (int)0, (boolean)true);
        return new CellHyperlinkEvent(name, comp, sheet, AuRequests.getInt((Map)data, (String)"row", (int)0, (boolean)true), AuRequests.getInt((Map)data, (String)"col", (int)0, (boolean)true), (String)data.get("href"), EnumUtil.toHyperlinkType(type), AuRequests.getInt((Map)data, (String)"x", (int)0, (boolean)true), AuRequests.getInt((Map)data, (String)"y", (int)0, (boolean)true), AuRequests.getInt((Map)data, (String)"pageX", (int)0, (boolean)true), AuRequests.getInt((Map)data, (String)"pageY", (int)0, (boolean)true), keys);
    }

    public CellHyperlinkEvent(String name, Component target, Sheet sheet, int row, int col, String address, Hyperlink.HyperlinkType type, int x, int y, int pageX, int pageY, int keys) {
        super(name, target, sheet, row, col, x, y, keys, pageX, pageY);
        this._address = address;
        this._type = type;
    }

    public String getAddress() {
        return this._address;
    }

    public Hyperlink.HyperlinkType getType() {
        return this._type;
    }
}

