/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.undo;

import io.keikai.api.CellOperationUtil;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.Book;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.ui.impl.undo.AbstractCellDataStyleAction;

public class CellBorderAction
extends AbstractCellDataStyleAction {
    private static final long serialVersionUID = -235160919724611839L;
    private final Range.ApplyBorderType _applyType;
    private final CellStyle.BorderType _borderType;
    private final String _htmlColor;
    private final int _reservedRow;
    private final int _reservedColumn;
    private final int _reservedLastRow;
    private final int _reservedLastColumn;

    public CellBorderAction(String label, Sheet sheet, int row, int column, int lastRow, int lastColumn, Range.ApplyBorderType applyType, CellStyle.BorderType borderType, String htmlColor) {
        super(label, sheet, row, column, lastRow, lastColumn, 2);
        this._applyType = applyType;
        this._borderType = borderType;
        this._htmlColor = htmlColor;
        Book book = sheet.getBook();
        this._reservedRow = this._row > 0 ? this._row - 1 : this._row;
        this._reservedColumn = this._column > 0 ? this._column - 1 : this._column;
        this._reservedLastRow = lastRow < book.getMaxRows() - 1 ? lastRow + 1 : lastRow;
        this._reservedLastColumn = lastColumn < book.getMaxColumns() - 1 ? lastColumn + 1 : lastColumn;
    }

    @Override
    protected int getReservedRow() {
        return this._reservedRow;
    }

    @Override
    protected int getReservedColumn() {
        return this._reservedColumn;
    }

    @Override
    protected int getReservedLastRow() {
        return this._reservedLastRow;
    }

    @Override
    protected int getReservedLastColumn() {
        return this._reservedLastColumn;
    }

    @Override
    protected void applyAction() {
        Range r = Ranges.range(this._sheet, this._row, this._column, this._lastRow, this._lastColumn);
        CellOperationUtil.applyBorder(r, this._applyType, this._borderType, this._htmlColor);
    }
}

