/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRef;
import io.keikai.api.Range;
import io.keikai.api.Ranges;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Sheet;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractCellHandler;
import io.keikai.ui.impl.undo.CellBorderAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Labels;

public class ApplyBorderHandler
extends AbstractCellHandler {
    private static final long serialVersionUID = 8882420154583823676L;
    private final Range.ApplyBorderType _applyType;
    private final CellStyle.BorderType _borderType;

    public ApplyBorderHandler(Range.ApplyBorderType applyType, CellStyle.BorderType borderType) {
        this._applyType = applyType;
        this._borderType = borderType;
    }

    @Override
    protected boolean processAction(UserActionContext ctx) {
        AreaRef selection;
        Sheet sheet = ctx.getSheet();
        Range range = Ranges.range(sheet, selection = ctx.getSelection());
        if (range.isProtected() && !range.getSheetProtection().isFormatCellsAllowed()) {
            this.showProtectMessage();
            return true;
        }
        String color = this.getColor(ctx);
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        uam.doAction(new CellBorderAction(Labels.getLabel((String)"zss.undo.cellBorder"), sheet, selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn(), this._applyType, this._borderType, color));
        return true;
    }

    protected String getColor(UserActionContext ctx) {
        String color = (String)ctx.getData("color");
        if (Strings.isEmpty((String)color)) {
            color = this.getDefaultColor();
        }
        return color;
    }

    protected String getDefaultColor() {
        return "#000000";
    }
}

