/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api.impl;

import io.keikai.api.AreaRef;
import io.keikai.api.Exporter;
import io.keikai.api.model.Book;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.model.SheetRegion;
import io.keikai.range.SExporter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;

public class ExporterImpl
implements Exporter,
Serializable {
    private static final long serialVersionUID = 7397284261685721810L;
    private SExporter _exporter;

    public ExporterImpl(SExporter exporter) {
        if (exporter == null) {
            throw new IllegalAccessError("exporter not found");
        }
        this._exporter = exporter;
    }

    @Override
    public void export(Book book, OutputStream fos) throws IOException {
        this._exporter.export(((BookImpl)book).getNative(), fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void export(Book book, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            this._exporter.export(((BookImpl)book).getNative(), (OutputStream)fos);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    @Deprecated
    public void export(Sheet sheet, OutputStream fos) throws IOException {
        this._exporter.export(((SheetImpl)sheet).getNative(), fos);
    }

    @Override
    @Deprecated
    public void export(Sheet sheet, AreaRef selection, OutputStream fos) throws IOException {
        this._exporter.export(new SheetRegion(((SheetImpl)sheet).getNative(), selection.getRow(), selection.getColumn(), selection.getLastRow(), selection.getLastColumn()), fos);
    }
}

