/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui;

import io.keikai.api.AreaRef;
import io.keikai.api.AreaRefWithType;
import io.keikai.api.CellOperationUtil;
import io.keikai.api.CellRef;
import io.keikai.api.IllegalFormulaException;
import io.keikai.api.Importer;
import io.keikai.api.Ranges;
import io.keikai.api.impl.ImporterImpl;
import io.keikai.api.model.Book;
import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.SheetProtection;
import io.keikai.api.model.impl.BookImpl;
import io.keikai.api.model.impl.SheetImpl;
import io.keikai.api.model.impl.SimpleRef;
import io.keikai.model.CellRegion;
import io.keikai.model.InvalidModelOpException;
import io.keikai.model.ModelEvent;
import io.keikai.model.ModelEventListener;
import io.keikai.model.SAutoFilter;
import io.keikai.model.SBook;
import io.keikai.model.SCell;
import io.keikai.model.SCellStyle;
import io.keikai.model.SChart;
import io.keikai.model.SColorFilter;
import io.keikai.model.SColumnArray;
import io.keikai.model.SComment;
import io.keikai.model.SConditionalStyle;
import io.keikai.model.SCustomFilter;
import io.keikai.model.SCustomFilters;
import io.keikai.model.SDynamicFilter;
import io.keikai.model.SFill;
import io.keikai.model.SFont;
import io.keikai.model.SName;
import io.keikai.model.SPicture;
import io.keikai.model.SRichText;
import io.keikai.model.SRow;
import io.keikai.model.SSheet;
import io.keikai.model.STable;
import io.keikai.model.STop10Filter;
import io.keikai.model.impl.AbstractBookAdv;
import io.keikai.model.impl.AbstractCellAdv;
import io.keikai.model.impl.AbstractSheetAdv;
import io.keikai.model.impl.AbstractTableAdv;
import io.keikai.model.impl.ConditionalStyleImpl;
import io.keikai.model.impl.TableImpl;
import io.keikai.model.sys.format.FormatResult;
import io.keikai.model.sys.formula.EvaluationContributor;
import io.keikai.model.sys.formula.EvaluationContributorContainer;
import io.keikai.model.util.RichTextHelper;
import io.keikai.range.SImporter;
import io.keikai.range.SImporters;
import io.keikai.range.SRange;
import io.keikai.range.SRanges;
import io.keikai.range.impl.StyleUtil;
import io.keikai.ui.AuxAction;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.FriendFocusHelper;
import io.keikai.ui.InnerEvts;
import io.keikai.ui.ModelEventDispatcher;
import io.keikai.ui.UserActionManager;
import io.keikai.ui.Widget;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.au.out.AuCellFocus;
import io.keikai.ui.au.out.AuCellFocusTo;
import io.keikai.ui.au.out.AuDataUpdate;
import io.keikai.ui.au.out.AuHighlight;
import io.keikai.ui.au.out.AuInsertRowColumn;
import io.keikai.ui.au.out.AuMergeCell;
import io.keikai.ui.au.out.AuRemoveRowColumn;
import io.keikai.ui.au.out.AuRetrieveFocus;
import io.keikai.ui.au.out.AuSelection;
import io.keikai.ui.event.CellAreaEvent;
import io.keikai.ui.event.CellEvent;
import io.keikai.ui.event.CellHyperlinkEvent;
import io.keikai.ui.event.SheetDeleteEvent;
import io.keikai.ui.event.SheetEvent;
import io.keikai.ui.event.StartEditingEvent;
import io.keikai.ui.event.StopEditingEvent;
import io.keikai.ui.event.SyncFriendFocusEvent;
import io.keikai.ui.impl.ActiveRangeHelper;
import io.keikai.ui.impl.CellFormatHelper;
import io.keikai.ui.impl.ComponentEvaluationContributor;
import io.keikai.ui.impl.DefaultUserActionManagerCtrl;
import io.keikai.ui.impl.DummyDataValidationHandler;
import io.keikai.ui.impl.DummyFreezeInfoLoader;
import io.keikai.ui.impl.DummyUndoableActionManager;
import io.keikai.ui.impl.Focus;
import io.keikai.ui.impl.HeaderPositionHelper;
import io.keikai.ui.impl.JSONObj;
import io.keikai.ui.impl.JavaScriptValue;
import io.keikai.ui.impl.MergeAggregation;
import io.keikai.ui.impl.MergeMatrixHelper;
import io.keikai.ui.impl.MergedRect;
import io.keikai.ui.impl.SequenceId;
import io.keikai.ui.impl.SimpleCellDisplayLoader;
import io.keikai.ui.impl.StringAggregation;
import io.keikai.ui.impl.VoidWidgetHandler;
import io.keikai.ui.impl.XUtils;
import io.keikai.ui.impl.undo.AggregatedAction;
import io.keikai.ui.impl.undo.CellEditTextAction;
import io.keikai.ui.impl.undo.HideHeaderAction;
import io.keikai.ui.impl.undo.ResizeHeaderAction;
import io.keikai.ui.sys.CellDisplayLoader;
import io.keikai.ui.sys.DataValidationHandler;
import io.keikai.ui.sys.FreezeInfoLoader;
import io.keikai.ui.sys.SpreadsheetCtrl;
import io.keikai.ui.sys.SpreadsheetInCtrl;
import io.keikai.ui.sys.SpreadsheetOutCtrl;
import io.keikai.ui.sys.UndoableAction;
import io.keikai.ui.sys.UndoableActionManager;
import io.keikai.ui.sys.UserActionManagerCtrl;
import io.keikai.ui.sys.WidgetHandler;
import io.keikai.ui.sys.WidgetLoader;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.zkoss.json.JSONArray;
import org.zkoss.json.JSONObject;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.Strings;
import org.zkoss.poi.ss.SpreadsheetVersion;
import org.zkoss.poi.ss.formula.SheetNameFormatter;
import org.zkoss.poi.ss.util.AreaReference;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.util.media.AMedia;
import org.zkoss.util.media.Media;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Labels;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelException;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.au.AuResponse;
import org.zkoss.zk.au.out.AuInvoke;
import org.zkoss.zk.ui.AbstractComponent;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Execution;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.WebApp;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.SerializableEventListener;
import org.zkoss.zk.ui.ext.AfterCompose;
import org.zkoss.zk.ui.ext.render.DynamicMedia;
import org.zkoss.zk.ui.sys.ContentRenderer;
import org.zkoss.zk.ui.util.DesktopCleanup;
import org.zkoss.zul.Messagebox;
import org.zkoss.zul.impl.XulElement;

public class Spreadsheet
extends XulElement
implements Serializable,
AfterCompose {
    private static final Logger log = Logger.getLogger(Spreadsheet.class.getName());
    private static final long serialVersionUID = 1L;
    private static final String ROW_SIZE_HELPER_KEY = "_rowCellSize";
    private static final String COLUMN_SIZE_HELPER_KEY = "_colCellSize";
    private static final String MERGE_MATRIX_KEY = "_mergeRange";
    private static final String ACTIVE_RANGE_KEY = "_activeRange";
    private static final String WIDGET_HANDLER_CLS = "io.keikai.ui.sys.WidgetHandler.class";
    private static final String WIDGET_LOADERS = "io.keikai.ui.sys.WidgetLoader.class";
    private static final String USER_ACTION_MANAGER_CTRL_CLS = "io.keikai.ui.UserActionManagerCtrl.class";
    private static final String UNDOABLE_ACTION_MANAGER_CLS = "io.keikai.ui.UndoableActionManager.class";
    private static final String CELL_DISPLAY_LOADER_CLS = "io.keikai.ui.CellDisplayLoader.class";
    private static final String DATA_VALIDATION_HANDLER_CLS = "io.keikai.ui.DataValidationHandler.class";
    private static final String FREEZE_INFO_LOCADER_CLS = "io.keikai.ui.FreezeInfoLoader.class";
    private static final String COLOR_PICKER_EX_USED_KEY = "io.keikai.colorPickerExUsed";
    private static final int DEFAULT_TOP_HEAD_HEIGHT = 20;
    private static final int DEFAULT_LEFT_HEAD_WIDTH = 36;
    private static final int DEFAULT_CELL_PADDING = 2;
    private static final int DEFAULT_MAX_ROWS = 200;
    private static final int DEFAULT_MAX_COLUMNS = 40;
    private static final int DEFAULT_ROW_HEIGHT = 20;
    private static final int DEFAULT_MAX_RENDERED_CELL_SIZE = 8000;
    private transient SBook _book;
    private String _src;
    private transient SImporter _importer;
    private int _maxRows = 0;
    private int _maxColumns = 0;
    private Map<String, int[]> _sheetMaxRowsCols;
    private int _preloadRowSize = -1;
    private int _preloadColumnSize = -1;
    private transient SSheet _selectedSheet;
    private boolean _hideRowhead;
    private boolean _hideColhead;
    private boolean _hideGridlines;
    private boolean _protectSheet;
    private boolean _showFormulabar;
    private boolean _showToolbar;
    private boolean _showSheetbar;
    private boolean _showAddRow = true;
    private boolean _showAddColumn = true;
    private Map<String, Focus> _editorFocuses = new HashMap<String, Focus>(20);
    private Map<String, Focus> _friendFocuses = new HashMap<String, Focus>(20);
    private String _selfFocusId;
    private AreaRef _focusArea = new AreaRef(0, 0, 0, 0);
    private AreaRefWithType _selectionArea = new AreaRefWithType(0, 0, 0, 0, CellSelectionType.CELL);
    private AreaRef _visibleArea = new AreaRef();
    private AreaRef _highlightArea = null;
    private AreaRef _cssArea = new AreaRef();
    private WidgetHandler _widgetHandler;
    private List<WidgetLoader> _widgetLoaders;
    private BookCleaner _bookCleaner;
    private int _defaultRowHeight = 20;
    private int _cssVersion = 0;
    private int _leftheadWidth = 36;
    private int _topheadHeight = 20;
    private int _cellpadding = 2;
    private Map _columnTitles;
    private Map _rowTitles;
    private ModelEventListener _modelEventListener = new InnerModelEventDispatcher();
    private InnerVariableResolver _variableResolver = new InnerVariableResolver();
    private InnerFunctionMapper _functionMapper = new InnerFunctionMapper();
    private SequenceId _custColId = new SequenceId(-1, 2);
    private SequenceId _custRowId = new SequenceId(-1, 2);
    private SequenceId _updateCellId = new SequenceId(0, 1);
    private SequenceId _updateRangeId = new SequenceId(0, 1);
    private SequenceId _focusId = new SequenceId(0, 1);
    private String _userName;
    private boolean _clientCacheDisabled = Spreadsheet.isDefaultClientCacheDisabled();
    private static Boolean _defClientCache;
    private int _maxRenderedCellSize = Spreadsheet.getDefaultMaxRenderedCellSize();
    private static Integer _defMaxRenderedCellSize;
    private Set<AuxAction> _actionDisabled = new HashSet<AuxAction>();
    private UndoableActionManager _undoableActionManager = null;
    private CellDisplayLoader _cellDisplayLoader = null;
    private DataValidationHandler _dataValidationHandler = null;
    private FreezeInfoLoader _freezeInfoLoader = null;
    private boolean _keepCellSelection = !"false".equalsIgnoreCase(Library.getProperty((String)"io.keikai.ui.keepCellSelection", (String)"true"));
    private boolean _ignoreAutoHeight = false;
    private Set<String> _lastUAEvents;
    private boolean _ctrlKeysSet;
    private EventListener _uAEventDispatcher;
    private Focus _selfEditorFocus;
    private static final String FRIEND_FOCUS_KEY = "keikai.FirendFocus";
    private EventListener<Event> _focusListener = null;
    private UserActionManagerCtrl _actionManagerCtrl;
    private boolean _showContextMenu;
    static final int IE9_SELECTOR_LIMIT = 4080;
    static final int IE9_IMPORT_LIMIT = 31;
    static final int IE9_NEST_LIMIT = 4;
    static final int DIGIT_0_MAX = 30;
    static final int DIGIT_1_MAX = 960;
    static final int DIGIT_2_MAX = 29790;
    private boolean forceStopEditing0 = false;
    private static final String _ZSS_DEFER_OP_MAP = "_ZSS_DEFER_OP_MAP";
    private static final int _DEFER_OPERATOR_PRIORITY = -20000;
    private static final String _ON_PROCESS_DEFER_OPERATIONS = "onProcessDeferOperations";

    public Spreadsheet() {
        this.addEventListener("onStartEditingImpl", (EventListener)new SerializableEventListener(){
            private static final long serialVersionUID = 2401696322103957589L;

            public void onEvent(Event event) throws Exception {
                Object[] data = (Object[])event.getData();
                Spreadsheet.this.processStartEditing((String)data[0], (StartEditingEvent)((Object)data[1]), (String)data[2]);
            }
        });
        this.addEventListener("onStopEditingImpl", (EventListener)new SerializableEventListener(){
            private static final long serialVersionUID = 2412586322103952998L;

            public void onEvent(Event event) throws Exception {
                Object[] data = (Object[])event.getData();
                Spreadsheet.this.processStopEditing((String)data[0], (StopEditingEvent)((Object)data[1]), (String)data[2]);
            }
        });
        this.addEventListener(_ON_PROCESS_DEFER_OPERATIONS, (EventListener)new SerializableEventListener(){
            private static final long serialVersionUID = 2401758232103952998L;

            public void onEvent(Event event) throws Exception {
                Map map = (Map)event.getData();
                Spreadsheet.this.processDeferOperations(map);
            }
        });
        this.initComponentActionHandler();
    }

    public UserActionManager getUserActionManager() {
        UserActionManagerCtrl uamc = this.getUserActionManagerCtrl();
        if (uamc instanceof UserActionManager) {
            return (UserActionManager)((Object)uamc);
        }
        return null;
    }

    private void initComponentActionHandler() {
        String string;
        if (this._uAEventDispatcher != null && this._lastUAEvents != null) {
            for (String string2 : this._lastUAEvents) {
                this.removeEventListener(string2, this._uAEventDispatcher);
            }
        }
        UserActionManagerCtrl ua = this.getUserActionManagerCtrl();
        this._lastUAEvents = ua.getInterestedEvents();
        if (this._lastUAEvents != null && this._lastUAEvents.size() > 0) {
            this._uAEventDispatcher = new SerializableEventListener(){
                private static final long serialVersionUID = 2401696159873652998L;

                public void onEvent(Event event) throws Exception {
                    UserActionManagerCtrl ua = Spreadsheet.this.getUserActionManagerCtrl();
                    if (ua instanceof EventListener) {
                        ua.onEvent(event);
                    }
                }
            };
            for (String evt : this._lastUAEvents) {
                this.addEventListener(evt, this._uAEventDispatcher);
            }
        } else {
            this._lastUAEvents = null;
            this._uAEventDispatcher = null;
        }
        if (!this._ctrlKeysSet && (string = ua.getCtrlKeys()) != null) {
            super.setCtrlKeys(string);
        }
    }

    private void setUserActionManagerCtrl(UserActionManagerCtrl actionManagerCtrl) {
        if (!Objects.equals((Object)this._actionManagerCtrl, (Object)actionManagerCtrl)) {
            this._actionManagerCtrl = actionManagerCtrl;
            this._actionManagerCtrl.bind(this);
            this.initComponentActionHandler();
        }
    }

    private UserActionManagerCtrl getUserActionManagerCtrl() {
        if (this._actionManagerCtrl == null) {
            String cls = (String)this.getAttribute(USER_ACTION_MANAGER_CTRL_CLS, true);
            if (cls == null) {
                cls = Library.getProperty((String)USER_ACTION_MANAGER_CTRL_CLS);
            }
            if (cls != null) {
                try {
                    this._actionManagerCtrl = (UserActionManagerCtrl)Spreadsheet.newInstance(cls);
                }
                catch (Exception x) {
                    throw new UiException((Throwable)x);
                }
            } else {
                this._actionManagerCtrl = new DefaultUserActionManagerCtrl();
            }
            this._actionManagerCtrl.bind(this);
        }
        return this._actionManagerCtrl;
    }

    public void setCtrlKeys(String ctrlKeys) {
        if (!this._ctrlKeysSet && !Objects.equals((Object)this.getCtrlKeys(), (Object)ctrlKeys)) {
            this._ctrlKeysSet = true;
        }
        super.setCtrlKeys(ctrlKeys);
    }

    private static boolean isDefaultClientCacheDisabled() {
        if (_defClientCache == null) {
            _defClientCache = Boolean.valueOf(Library.getProperty((String)"io.keikai.spreadsheet.clientcache.disabed", (String)"false"));
        }
        return _defClientCache;
    }

    private static int getDefaultMaxRenderedCellSize() {
        if (_defMaxRenderedCellSize == null) {
            _defMaxRenderedCellSize = Integer.valueOf(Library.getProperty((String)"io.keikai.spreadsheet.maxRenderedCellSize", (String)"8000"));
        }
        return _defMaxRenderedCellSize;
    }

    public void setMaxRenderedCellSize(int maxRenderedCellSize) {
        if (this._maxRenderedCellSize != maxRenderedCellSize) {
            this._maxRenderedCellSize = maxRenderedCellSize;
            this.smartUpdate("maxRenderedCellSize", maxRenderedCellSize);
        }
    }

    public int getMaxRenderedCellSize() {
        return this._maxRenderedCellSize;
    }

    public boolean isClientCacheDisabled() {
        return this._clientCacheDisabled;
    }

    public void setClientCacheDisabled(boolean clientCacheDisabled) {
        if (this._clientCacheDisabled != clientCacheDisabled) {
            this._clientCacheDisabled = clientCacheDisabled;
            this.smartUpdate("clientCacheDisabled", this._clientCacheDisabled);
        }
    }

    public void setDraggable(String draggable) {
        throw new UnsupportedOperationException("doesn't support to be draggable");
    }

    public SBook getXBook() {
        return this.getSBook();
    }

    public SBook getSBook() {
        if (this._book == null) {
            if (this._src == null) {
                return null;
            }
            try {
                File f;
                SImporter importer = this._importer;
                if (importer == null) {
                    importer = SImporters.getImporter();
                }
                SBook book = null;
                URL url = null;
                if (this._src.startsWith("/")) {
                    WebApp wapp = Executions.getCurrent().getDesktop().getWebApp();
                    String path = wapp.getRealPath(this._src);
                    if (path != null) {
                        File file = new File(path);
                        if (file.exists()) {
                            url = file.toURI().toURL();
                        }
                    } else {
                        url = wapp.getResource(this._src);
                    }
                }
                if (url == null) {
                    url = new ClassLocator().getResource(this._src);
                }
                if (url == null && (f = new File(this._src)).exists()) {
                    url = f.toURI().toURL();
                }
                if (url == null) {
                    throw new UiException("resource for " + this._src + " not found.");
                }
                String bookName = url.getFile();
                int i = bookName.lastIndexOf(47);
                if (i >= 0) {
                    bookName = bookName.substring(i + 1, bookName.length());
                }
                book = importer.imports(url, bookName);
                this.initBook(book);
            }
            catch (Exception ex) {
                throw UiException.Aide.wrap((Throwable)ex);
            }
        }
        return this._book;
    }

    public void setXBook(SBook book) {
        this.setSBook(book);
    }

    public void setSBook(SBook book) {
        if (!Objects.equals((Object)book, (Object)this._book)) {
            this.initBook0(book);
            this.invalidate();
        }
    }

    private void initBook(SBook book) {
        if (!Objects.equals((Object)book, (Object)this._book)) {
            this.initBook0(book);
        }
    }

    private FriendFocusHelper getFriendFocusHelper() {
        FriendFocusHelper helper = null;
        if (this._book != null) {
            this._book.getBookSeries().getLock().writeLock().lock();
            try {
                helper = (FriendFocusHelper)this._book.getAttribute(FRIEND_FOCUS_KEY);
                if (helper == null) {
                    helper = new FriendFocusHelper();
                    this._book.setAttribute(FRIEND_FOCUS_KEY, (Object)helper);
                }
            }
            finally {
                this._book.getBookSeries().getLock().writeLock().unlock();
            }
        }
        return helper;
    }

    private void deleteSelfEditorFocus() {
        if (this._selectedSheet != null && this.getSBook().getSheetIndex(this._selectedSheet) != -1 && this._selfEditorFocus != null) {
            SRange rng = SRanges.range((SSheet)this._selectedSheet);
            this.getFriendFocusHelper().removeFocus(this._selfEditorFocus);
            rng.notifyCustomEvent("onFriendFocusDelete", (Object)this._selfEditorFocus, true);
            this._selfEditorFocus = null;
        }
    }

    private void moveSelfEditorFocus(String sheetId, int row, int column) {
        if (this._selectedSheet != null) {
            if (this._selfEditorFocus == null) {
                this._selfEditorFocus = this.newSelfFocus(sheetId, row, column);
                this.getFriendFocusHelper().addFocus(this._selfEditorFocus);
            } else {
                this._selfEditorFocus.setSheetId(sheetId);
                this._selfEditorFocus.setPosition(row, column);
            }
            SRange rng = SRanges.range((SSheet)this._selectedSheet);
            rng.notifyCustomEvent("onFriendFocusMove", (Object)this._selfEditorFocus, true);
        }
        this.syncFriendFocus();
    }

    private void doMoveSelfFocus(CellEvent event) {
        this.moveSelfEditorFocus(this.getSelectedSheetId(), event.getRow(), event.getColumn());
    }

    private void releaseBook() {
        if (this._book != null) {
            this._book.getBookSeries().getLock().writeLock().lock();
            try {
                this._book.removeEventListener(this._modelEventListener);
                if (this.isBelowDesktopScope(this._book) && this._book instanceof EvaluationContributorContainer && ((EvaluationContributorContainer)this._book).getEvaluationContributor() instanceof ComponentEvaluationContributor) {
                    ((EvaluationContributorContainer)this._book).setEvaluationContributor(null);
                }
                this.deleteSelfEditorFocus();
            }
            finally {
                this._book.getBookSeries().getLock().writeLock().unlock();
            }
            this._book = null;
        }
    }

    private boolean isBelowDesktopScope(SBook book) {
        String scope = this._book.getShareScope();
        return scope == null || "desktop".equals(scope);
    }

    private void initBook0(SBook book) {
        if (this._book != null) {
            this._book.getBookSeries().getLock().writeLock().lock();
            try {
                this._book.removeEventListener(this._modelEventListener);
                if (this.isBelowDesktopScope(this._book) && this._book instanceof EvaluationContributorContainer && ((EvaluationContributorContainer)this._book).getEvaluationContributor() instanceof ComponentEvaluationContributor) {
                    ((EvaluationContributorContainer)this._book).setEvaluationContributor(null);
                }
            }
            finally {
                this._book.getBookSeries().getLock().writeLock().unlock();
            }
            if (this._focusListener != null) {
                this.removeEventListener("onCellFocus", this._focusListener);
                this._focusListener = null;
            }
            this.deleteSelfEditorFocus();
        }
        this.cleanSelectedSheet();
        this.removeAttribute(MERGE_MATRIX_KEY);
        this.clearHeaderSizeHelper(true, true);
        this.removeAttribute(ACTIVE_RANGE_KEY);
        this._custColId = new SequenceId(-1, 2);
        this._custRowId = new SequenceId(-1, 2);
        this.clearUndoableActionManager();
        this._sheetMaxRowsCols = new HashMap<String, int[]>();
        this._book = book;
        if (this._book != null) {
            this._book.getBookSeries().getLock().writeLock().lock();
            try {
                this._book.addEventListener(this._modelEventListener);
                if (this.isBelowDesktopScope(this._book) && this._book instanceof EvaluationContributorContainer && ((EvaluationContributorContainer)this._book).getEvaluationContributor() == null) {
                    ((EvaluationContributorContainer)this._book).setEvaluationContributor((EvaluationContributor)new ComponentEvaluationContributor((Component)this));
                }
            }
            finally {
                this._book.getBookSeries().getLock().writeLock().unlock();
            }
            if (!Strings.isEmpty((String)this._book.getShareScope())) {
                this._focusListener = new SerializableEventListener(){
                    private static final long serialVersionUID = 2716358947569822998L;

                    public void onEvent(Event event) throws Exception {
                        Spreadsheet.this.doMoveSelfFocus((CellEvent)event);
                    }
                };
                this.addEventListener("onCellFocus", (EventListener)this._focusListener);
            }
        }
        this._selfFocusId = null;
        this.refreshToolbarDisabled();
        this.getUserActionManagerCtrl().doAfterLoadBook(this.getBook());
    }

    private Focus newSelfFocus(String sheetId, int row, int column) {
        String focusName = this._userName == null ? "" : this._userName;
        this._selfFocusId = this._selfFocusId == null ? this.getFriendFocusHelper().nextFocusId() : this._selfFocusId;
        Focus focus = new Focus(this._selfFocusId, focusName, "#000", sheetId, row, column, this);
        return focus;
    }

    public SSheet getSelectedXSheet() {
        return this.getSelectedSSheet();
    }

    public SSheet getSelectedSSheet() {
        SBook book = this.getSBook();
        if (book == null) {
            return null;
        }
        if (this._selectedSheet == null) {
            if (book.getNumOfSheet() == 0) {
                throw new UiException("sheet size of given book is zero");
            }
            this._selectedSheet = book.getSheet(0);
            this.afterSheetSelected();
        }
        return this._selectedSheet;
    }

    private String getSelectedSheetId() {
        SSheet sheet = this.getSelectedSSheet();
        return sheet == null ? null : sheet.getId();
    }

    public String getSrc() {
        return this._src;
    }

    public void setSrc(String src) {
        if (!Objects.equals((Object)this._src, (Object)src)) {
            this._src = src;
            this.setBook(null);
            this.invalidate();
        }
    }

    public SImporter getSImporter() {
        return this._importer;
    }

    public void setSImporter(SImporter importer) {
        if (!Objects.equals((Object)importer, (Object)this._importer)) {
            this._importer = importer;
            this.setBook(null);
        }
    }

    public void setSelectedSheet(String name) {
        boolean update = this.setSelectedSheet0(name);
        if (update) {
            this.afterSheetSelected();
            this.invalidate();
        }
    }

    private boolean setSelectedSheet0(String name) {
        SBook book = this.getSBook();
        if (book == null) {
            return false;
        }
        boolean update = false;
        if (this._selectedSheet != null && book.getSheetIndex(this._selectedSheet) == -1) {
            this.cleanSelectedSheet();
            update = true;
        }
        if (this._selectedSheet == null || !this._selectedSheet.getSheetName().equals(name)) {
            SSheet sheet = book.getSheetByName(name);
            if (sheet == null) {
                throw new UiException("No such sheet : " + name);
            }
            this.cleanSelectedSheet();
            this._selectedSheet = sheet;
            update = true;
        }
        if (Spreadsheet.isIE9() && update) {
            this._cssArea = new AreaRef();
        }
        return update;
    }

    private void setSelectedSheetDirectly(String name, boolean cacheInClient, int row, int col, int left, int top, int right, int bottom) {
        boolean update = this.setSelectedSheet0(name);
        if (row >= 0 && col >= 0) {
            this.setCellFocusDirectly(new CellRef(row, col));
        } else {
            this.setCellFocusDirectly(new CellRef(0, 0));
        }
        if (top >= 0 && right >= 0 && bottom >= 0 && left >= 0) {
            this.setSelectionDirectly(new AreaRef(top, left, bottom, right));
        } else {
            this.setSelectionDirectly(new AreaRef(0, 0, 0, 0));
        }
        if (update) {
            this.afterSheetSelected();
        }
        this.updateSheetAttributes(cacheInClient);
        this.syncFriendFocus(true);
    }

    private void updateSheetAttributes(boolean cacheInClient) {
        SSheet sheet = this._selectedSheet;
        String css = Spreadsheet.getDynamicMediaURI((AbstractComponent)this, this._cssVersion++, "ss_" + this.getUuid() + "_" + this.getSelectedSheetId(), "css");
        this.smartUpdate("scss", css);
        if (!cacheInClient) {
            this.smartUpdate("rowFreeze", this.getSelectedSheetRowfreeze());
            this.smartUpdate("columnFreeze", this.getSelectedSheetColumnfreeze());
            Map afmap = this.convertAutoFilterToJSON(sheet.getAutoFilter());
            if (afmap != null) {
                this.smartUpdate("autoFilter", afmap);
            } else {
                this.smartUpdate("autoFilter", null);
            }
            Map<String, Map> tbafsmap = this.convertTableFiltersToJSON(sheet);
            this.smartUpdate("tableFilters", tbafsmap);
            this.smartUpdate("rowHeight", this.getRowheight());
            this.smartUpdate("columnWidth", this.getColumnwidth());
            this.smartUpdate("displayGridlines", !this._hideGridlines);
            this.refreshAllowedOptions();
            this.updateUnlockInfo();
            this.smartUpdate("protect", this._protectSheet);
            HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
            HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
            this.smartUpdate("csc", Spreadsheet.getSizeHelperStr(colHelper));
            this.smartUpdate("csr", Spreadsheet.getSizeHelperStr(rowHelper));
            MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
            Iterator<MergedRect> iter = mmhelper.getRanges().iterator();
            StringBuffer merr = new StringBuffer();
            while (iter.hasNext()) {
                MergedRect block = iter.next();
                int left = block.getColumn();
                int top = block.getRow();
                int right = block.getLastColumn();
                int bottom = block.getLastRow();
                int id = block.getId();
                merr.append(left).append(",").append(top).append(",").append(right).append(",").append(bottom).append(",").append(id);
                if (!iter.hasNext()) continue;
                merr.append(";");
            }
            this.smartUpdate("mergeRange", merr.toString());
            SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this.getExtraCtrl();
            JSONObject activeRange = this.createActiveRange(spreadsheetCtrl, sheet, this.getInitColumnSize(), this.getInitRowSize());
            this.smartUpdate("activeRange", activeRange);
            List<Map<String, Object>> dvs = this.getDataValidationHandler().loadDataValidtionJASON(this.getSelectedSheet());
            if (dvs != null) {
                this.smartUpdate("dataValidations", dvs);
            } else {
                this.smartUpdate("dataValidations", null);
            }
        }
        this.smartUpdate("sheetId", this.getSelectedSheetId());
    }

    public int getMaxrows() {
        return this.getMaxVisibleRows();
    }

    public void setMaxrows(int maxrows) {
        this.setMaxVisibleRows(maxrows);
    }

    public void setPreloadRowSize(int size) {
        if (this._preloadRowSize != size) {
            this._preloadRowSize = size <= 0 ? 0 : size;
            this.smartUpdate("preloadRowSize", this._preloadRowSize);
        }
    }

    public int getPreloadRowSize() {
        return this._preloadRowSize;
    }

    private int getInitRowSize() {
        AreaRef vArea = this._visibleArea;
        int rowSize = vArea.getLastRow() < 0 ? 50 : vArea.getLastRow();
        int preloadRowSize = this.getPreloadRowSize();
        rowSize = preloadRowSize < 0 ? Math.min(rowSize, this.getCurrentMaxVisibleRows() - 1) : Math.min(rowSize + preloadRowSize, this.getCurrentMaxVisibleRows() - 1);
        return rowSize;
    }

    public int getMaxcolumns() {
        return this.getMaxVisibleColumns();
    }

    public void setMaxcolumns(int maxcols) {
        this.setMaxVisibleColumns(maxcols);
    }

    public void setPreloadColumnSize(int size) {
        if (this._preloadColumnSize != size) {
            this._preloadColumnSize = size < 0 ? 0 : size;
            this.smartUpdate("preloadColumnSize", this._preloadColumnSize);
        }
    }

    public int getPreloadColumnSize() {
        return this._preloadColumnSize;
    }

    private int getInitColumnSize() {
        AreaRef vArea = this._visibleArea;
        int colSize = vArea.getLastColumn() < 0 ? 40 : vArea.getLastColumn();
        int preloadColSize = this.getPreloadColumnSize();
        colSize = preloadColSize < 0 ? Math.min(colSize, this.getCurrentMaxVisibleColumns() - 1) : Math.min(colSize + preloadColSize, this.getCurrentMaxVisibleColumns() - 1);
        return colSize;
    }

    public int getRowfreeze() {
        return -1;
    }

    public void setRowfreeze(int rowfreeze) {
    }

    public int getColumnfreeze() {
        return -1;
    }

    public void setColumnfreeze(int colfreeze) {
    }

    private final int getSelectedSheetRowfreeze() {
        return this.getFreezeInfoLoader().getRowFreeze(this.getSelectedSheet());
    }

    private final int getSelectedSheetColumnfreeze() {
        return this.getFreezeInfoLoader().getColumnFreeze(this.getSelectedSheet());
    }

    public boolean isHiderowhead() {
        return this._hideRowhead;
    }

    public void setHiderowhead(boolean hide) {
        if (this._hideRowhead != hide) {
            this._hideRowhead = hide;
            this.invalidate();
        }
    }

    public boolean isHidecolumnhead() {
        return this._hideColhead;
    }

    public void setHidecolumnhead(boolean hide) {
        if (this._hideColhead != hide) {
            this._hideColhead = hide;
            this.invalidate();
        }
    }

    public void setColumntitles(Map titles) {
        if (!Objects.equals((Object)titles, (Object)this._columnTitles)) {
            this._columnTitles = titles;
            this.invalidate();
        }
    }

    public Map getColumntitles() {
        return this._columnTitles;
    }

    public void setColumntitles(String titles) {
        String[] names = titles.split(",");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= 0) continue;
            map.put(i, names[i]);
        }
        if (map.size() > 0) {
            this.setColumntitles(map);
        }
    }

    public void setRowtitles(Map titles) {
        if (!Objects.equals((Object)titles, (Object)this._rowTitles)) {
            this._rowTitles = titles;
            this.invalidate();
        }
    }

    public Map getRowtitles() {
        return this._rowTitles;
    }

    public void setRowtitles(String titles) {
        String[] names = titles.split(",");
        HashMap<Integer, String> map = new HashMap<Integer, String>();
        for (int i = 0; i < names.length; ++i) {
            if (names[i].length() <= 0) continue;
            map.put(i, names[i]);
        }
        if (map.size() > 0) {
            this.setRowtitles(map);
        }
    }

    public int getRowheight() {
        SSheet sheet = this.getSelectedSSheet();
        int rowHeight = sheet != null ? sheet.getDefaultRowHeight() : -1;
        return rowHeight <= 0 ? this._defaultRowHeight : rowHeight;
    }

    public void setRowheight(int rowHeight) {
        SSheet sheet = this.getSelectedSSheet();
        int dh = sheet.getDefaultRowHeight();
        if (dh != rowHeight) {
            sheet.setDefaultRowHeight(rowHeight);
            this.invalidate();
        }
    }

    public int getColumnwidth() {
        SSheet sheet = this.getSelectedSSheet();
        return sheet.getDefaultColumnWidth();
    }

    public void setColumnwidth(int columnWidth) {
        SSheet sheet = this.getSelectedSSheet();
        int dw = sheet.getDefaultColumnWidth();
        if (dw != columnWidth) {
            sheet.setDefaultColumnWidth(columnWidth);
            this.invalidate();
        }
    }

    public int getLeftheadwidth() {
        return this._leftheadWidth;
    }

    public void setLeftheadwidth(int leftWidth) {
        if (this._leftheadWidth != leftWidth) {
            this._leftheadWidth = leftWidth;
            this.invalidate();
        }
    }

    public int getTopheadheight() {
        return this._topheadHeight;
    }

    public void setTopheadheight(int topHeight) {
        if (this._topheadHeight != topHeight) {
            this._topheadHeight = topHeight;
            this.invalidate();
        }
    }

    public void setShowToolbar(boolean showToolbar) {
        if (this._showToolbar != showToolbar) {
            this._showToolbar = showToolbar;
            this.smartUpdate("showToolbar", this._showToolbar);
        }
    }

    public boolean isShowToolbar() {
        return this._showToolbar;
    }

    public void setShowFormulabar(boolean showFormulabar) {
        if (this._showFormulabar != showFormulabar) {
            this._showFormulabar = showFormulabar;
            this.smartUpdate("showFormulabar", this._showFormulabar);
        }
    }

    public boolean isShowFormulabar() {
        return this._showFormulabar;
    }

    public void setShowSheetbar(boolean showSheetbar) {
        if (this._showSheetbar != showSheetbar) {
            this._showSheetbar = showSheetbar;
            this.smartUpdate("showSheetbar", this._showSheetbar);
        }
    }

    public boolean isShowSheetbar() {
        return this._showSheetbar;
    }

    public void setShowContextMenu(boolean showContextMenu) {
        if (this._showContextMenu != showContextMenu) {
            this._showContextMenu = showContextMenu;
            this.smartUpdate("showContextMenu", this._showContextMenu);
        }
    }

    public boolean isShowContextMenu() {
        return this._showContextMenu;
    }

    private Map convertAutoFilterToJSON(SAutoFilter af) {
        if (af != null) {
            ArrayList fcsary;
            CellRegion addr = af.getRegion();
            if (addr == null) {
                return null;
            }
            HashMap<String, Integer> addrmap = new HashMap<String, Integer>();
            int left = addr.getColumn();
            int right = addr.getLastColumn();
            int top = addr.getRow();
            SSheet sheet = this.getSelectedSSheet();
            addrmap.put("left", left);
            addrmap.put("top", top);
            addrmap.put("right", right);
            addrmap.put("bottom", addr.getLastRow());
            Collection fcs = af.getFilterColumns();
            ArrayList arrayList = fcsary = fcs != null ? new ArrayList(fcs.size()) : null;
            if (fcsary != null) {
                List filters = null;
                boolean on = true;
                int field = 0;
                for (int col = left; col <= right; ++col) {
                    SAutoFilter.NFilterColumn fc = af.getFilterColumn(col - left, false);
                    if (fc == null) {
                        on = true;
                        continue;
                    }
                    boolean byFontColor = false;
                    String pattern = null;
                    String fgColor = null;
                    String bgColor = null;
                    boolean isAnd = false;
                    SCustomFilter f1 = null;
                    SCustomFilter f2 = null;
                    boolean dynaf = false;
                    boolean isAbove = false;
                    Double avgVal = null;
                    boolean isTop = false;
                    boolean isPercent = false;
                    Double filterVal = null;
                    int countVal = 0;
                    if (on) {
                        STop10Filter top10Filter;
                        SDynamicFilter dynaFilter;
                        SCustomFilters cusFilters;
                        filters = fc.getFilters();
                        on = fc.isShowButton();
                        field = col - left + 1;
                        SColorFilter cfilter = fc.getColorFilter();
                        if (cfilter != null) {
                            SFill fill = cfilter.getExtraStyle().getFill();
                            pattern = fill.getFillPattern().name();
                            fgColor = fill.getFillColor().getHtmlColor();
                            bgColor = fill.getBackColor().getHtmlColor();
                            byFontColor = cfilter.isByFontColor();
                        }
                        if ((cusFilters = fc.getCustomFilters()) != null) {
                            isAnd = cusFilters.isAnd();
                            f1 = cusFilters.getCustomFilter1();
                            f2 = cusFilters.getCustomFilter2();
                        }
                        if ((dynaFilter = fc.getDynamicFilter()) != null) {
                            dynaf = true;
                            isAbove = "aboveAverage".equals(dynaFilter.getType());
                            avgVal = dynaFilter.getValue();
                        }
                        if ((top10Filter = fc.getTop10Filter()) != null) {
                            isTop = top10Filter.isTop();
                            isPercent = top10Filter.isPercent();
                            filterVal = top10Filter.getFilterValue();
                            countVal = (int)top10Filter.getValue();
                        }
                    }
                    HashMap<String, Object> fcmap = new HashMap<String, Object>();
                    fcmap.put("col", col);
                    fcmap.put("filter", filters);
                    fcmap.put("on", on);
                    fcmap.put("field", field);
                    if ("SOLID".equals(pattern) && !byFontColor) {
                        String tmp = fgColor;
                        fgColor = bgColor;
                        bgColor = tmp;
                    }
                    fcmap.put("colorpat", pattern);
                    fcmap.put("colorfg", fgColor);
                    fcmap.put("colorbg", bgColor);
                    fcmap.put("fontColor", byFontColor);
                    if (f1 != null) {
                        fcmap.put("and", isAnd);
                        HashMap<String, String> f1map = new HashMap<String, String>();
                        fcmap.put("f1", f1map);
                        f1map.put("val", f1.getValue());
                        f1map.put("op", f1.getOperator().name());
                        if (f2 != null) {
                            HashMap<String, String> f2map = new HashMap<String, String>();
                            fcmap.put("f2", f2map);
                            f2map.put("val", f2.getValue());
                            f2map.put("op", f2.getOperator().name());
                        }
                    }
                    if (dynaf) {
                        fcmap.put("dynaf", dynaf);
                        if (avgVal != null) {
                            fcmap.put("avgVal", avgVal);
                            fcmap.put("isAbove", isAbove);
                        }
                    }
                    if (filterVal != null) {
                        fcmap.put("filterVal", filterVal);
                        fcmap.put("isTop", isTop);
                        fcmap.put("isPercent", isPercent);
                        fcmap.put("countVal", countVal);
                    }
                    fcsary.add(fcmap);
                }
            }
            HashMap<String, Cloneable> afmap = new HashMap<String, Cloneable>();
            afmap.put("range", addrmap);
            afmap.put("filterColumns", fcsary);
            return afmap;
        }
        return null;
    }

    private Map<String, Map> convertATableFilterToJSON(STable table) {
        AbstractBookAdv book = (AbstractBookAdv)table.getAllRegion().getSheet().getBook();
        HashMap<String, Map> tbmap = new HashMap<String, Map>();
        Map tafmap = table instanceof TableImpl.DummyTable || book.getTable(table.getName()) == null ? null : this.convertAutoFilterToJSON(table.getAutoFilter());
        tbmap.put(table.getName(), tafmap);
        return tbmap;
    }

    private Map<String, Map> convertTableFiltersToJSON(SSheet sheet) {
        AbstractBookAdv book = (AbstractBookAdv)sheet.getBook();
        HashMap<String, Map> tbmap = new HashMap<String, Map>();
        for (STable table : sheet.getTables()) {
            Map tafmap = book.getTable(table.getName()) == null ? null : this.convertAutoFilterToJSON(table.getAutoFilter());
            tbmap.put(table.getName(), tafmap);
        }
        return tbmap.isEmpty() ? null : tbmap;
    }

    private boolean getLinkToNewTab() {
        String linkToNewTab = Library.getProperty((String)"io.keikai.ui.Spreadsheet.linkToNewTab", (String)"true");
        return Boolean.valueOf(linkToNewTab);
    }

    private List<LinkedHashMap<String, String>> getSheetLabels() {
        int len = this._book.getNumOfSheet();
        ArrayList<LinkedHashMap<String, String>> ary = new ArrayList<LinkedHashMap<String, String>>(len);
        for (int i = 0; i < len; ++i) {
            LinkedHashMap<String, String> sheetLabels = new LinkedHashMap<String, String>();
            SSheet sheet = this._book.getSheet(i);
            if (sheet.getSheetVisible() != SSheet.SheetVisible.VISIBLE) continue;
            sheetLabels.put("id", sheet.getId());
            sheetLabels.put("name", sheet.getSheetName());
            if (sheet == this._selectedSheet) {
                sheetLabels.put("sel", "t");
            }
            ary.add(sheetLabels);
        }
        return ary.size() == 0 ? null : ary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderProperties(ContentRenderer renderer) throws IOException {
        SBook book = this.getSBook();
        if (book == null) {
            this.renderProperties0(renderer);
        } else {
            ReadWriteLock lock = book.getBookSeries().getLock();
            lock.writeLock().lock();
            try {
                this.renderProperties0(renderer);
            }
            finally {
                lock.writeLock().unlock();
            }
        }
    }

    protected void renderProperties0(ContentRenderer renderer) throws IOException {
        int colFreeze;
        Map afmap;
        List<LinkedHashMap<String, String>> sheetLabels;
        super.renderProperties(renderer);
        renderer.render("colorPickerExUsed", (Object)this.isColorPickerExUsed());
        if (this._showToolbar || this._showContextMenu || this._showSheetbar) {
            renderer.render("actionDisabled", this.convertToDisabledActionJSON(this.getUserActionManagerCtrl().getSupportedUserAction(this.getSelectedSheet())));
            renderer.render("showToolbar", this._showToolbar);
        }
        renderer.render("showFormulabar", this._showFormulabar);
        SSheet sheet = this.getSelectedSSheet();
        if (sheet == null) {
            return;
        }
        if (this._showContextMenu) {
            renderer.render("showContextMenu", this._showContextMenu);
        }
        if (this._clientCacheDisabled) {
            renderer.render("clientCacheDisabled", this._clientCacheDisabled);
        }
        if (this._maxRenderedCellSize != 8000) {
            renderer.render("maxRenderedCellSize", this._maxRenderedCellSize);
        }
        if ((sheetLabels = this.getSheetLabels()) != null) {
            renderer.render("sheetLabels", sheetLabels);
        }
        if (this._showSheetbar) {
            renderer.render("showSheetbar", this._showSheetbar);
        }
        if (this._showAddRow) {
            renderer.render("showAddRow", this._showAddRow);
        }
        if (this._showAddColumn) {
            renderer.render("showAddColumn", this._showAddColumn);
        }
        if (!this.getLinkToNewTab()) {
            renderer.render("_linkToNewTab", false);
        }
        if ((afmap = this.convertAutoFilterToJSON(sheet.getAutoFilter())) != null) {
            renderer.render("autoFilter", (Object)afmap);
        } else {
            renderer.render("autoFilter", (String)null);
        }
        Map<String, Map> tbafsmap = this.convertTableFiltersToJSON(sheet);
        renderer.render("tableFilters", tbafsmap);
        int rowHeight = this.getRowheight();
        if (rowHeight != 20) {
            renderer.render("rowHeight", this.getRowheight());
        }
        renderer.render("columnWidth", this.getColumnwidth());
        if (this._hideGridlines) {
            renderer.render("displayGridlines", !this._hideGridlines);
        }
        if (this._protectSheet) {
            SheetProtection sheetProtection = Ranges.range(this.getSelectedSheet()).getSheetProtection();
            renderer.render("allowSelectLockedCells", sheetProtection.isSelectLockedCellsAllowed());
            renderer.render("allowSelectUnlockedCells", sheetProtection.isSelectUnlockedCellsAllowed());
            renderer.render("allowFormatCells", sheetProtection.isFormatCellsAllowed());
            renderer.render("allowFormatColumns", sheetProtection.isFormatColumnsAllowed());
            renderer.render("allowFormatRows", sheetProtection.isFormatRowsAllowed());
            renderer.render("allowAutoFilter", sheetProtection.isAutoFilterAllowed());
            renderer.render("objectEditable", sheetProtection.isObjectsEditable());
            if (!sheetProtection.isSelectLockedCellsAllowed() && sheetProtection.isSelectUnlockedCellsAllowed()) {
                JSONObject unlockInfo = this.createUnlockInfo(this.getSelectedSheet());
                renderer.render("unlockInfo", (Object)unlockInfo);
            }
            renderer.render("protect", this._protectSheet);
        }
        renderer.render("topPanelHeight", this.isHidecolumnhead() ? 0 : this.getTopheadheight());
        renderer.render("leftPanelWidth", this.isHiderowhead() ? 1 : this.getLeftheadwidth());
        if (this._cellpadding != 2) {
            renderer.render("cellPadding", this._cellpadding);
        }
        String sheetId = this.getSelectedSheetId();
        String css = Spreadsheet.getDynamicMediaURI((AbstractComponent)this, this._cssVersion++, "ss_" + this.getUuid() + "_" + sheetId, "css");
        renderer.render("loadcss", (Object)new JavaScriptValue("zk.loadCSS('" + css + "', '" + this.getUuid() + "-sheet')"));
        renderer.render("scss", css);
        int maxRows = this.getCurrentMaxVisibleRows();
        renderer.render("maxRows", maxRows);
        int maxCols = this.getCurrentMaxVisibleColumns();
        renderer.render("maxColumns", maxCols);
        int rowFreeze = this.getSelectedSheetRowfreeze();
        if (rowFreeze > -1) {
            renderer.render("rowFreeze", rowFreeze);
        }
        if ((colFreeze = this.getSelectedSheetColumnfreeze()) > -1) {
            renderer.render("columnFreeze", colFreeze);
        }
        renderer.render("sheetId", this.getSelectedSheetId());
        renderer.render("focusRect", Spreadsheet.getRectStr(this._focusArea));
        renderer.render("selectionRect", Spreadsheet.getRectStr(this._selectionArea));
        renderer.render("selType", Spreadsheet.getSelTypeStr(this._selectionArea));
        if (this._highlightArea != null) {
            renderer.render("highLightRect", Spreadsheet.getRectStr(this._highlightArea));
        }
        HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
        HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
        renderer.render("csc", Spreadsheet.getSizeHelperStr(colHelper));
        renderer.render("csr", Spreadsheet.getSizeHelperStr(rowHelper));
        MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
        Iterator<MergedRect> iter = mmhelper.getRanges().iterator();
        StringBuffer merr = new StringBuffer();
        while (iter.hasNext()) {
            MergedRect block = iter.next();
            int left = block.getColumn();
            int top = block.getRow();
            int right = block.getLastColumn();
            int bottom = block.getLastRow();
            int id = block.getId();
            merr.append(left).append(",").append(top).append(",").append(right).append(",").append(bottom).append(",").append(id);
            if (!iter.hasNext()) continue;
            merr.append(";");
        }
        renderer.render("mergeRange", merr.toString());
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this.getExtraCtrl();
        int initColSize = this.getInitColumnSize();
        int initRowSize = this.getInitRowSize();
        JSONObject activeRange = this.createActiveRange(spreadsheetCtrl, sheet, initColSize, initRowSize);
        renderer.render("activeRange", (Object)activeRange);
        renderer.render("preloadRowSize", this.getPreloadRowSize());
        renderer.render("preloadColumnSize", this.getPreloadColumnSize());
        renderer.render("initRowSize", initRowSize);
        renderer.render("initColumnSize", initColSize);
        renderer.render("columnHeadHidden", this._hideColhead);
        renderer.render("rowHeadHidden", this._hideRowhead);
        renderer.render("keepCellSelection", this._keepCellSelection);
        List<Map<String, Object>> dvs = this.getDataValidationHandler().loadDataValidtionJASON(this.getSelectedSheet());
        if (dvs != null) {
            renderer.render("dataValidations", dvs);
        } else {
            renderer.render("dataValidations", (String)null);
        }
        if (this._ignoreAutoHeight) {
            renderer.render("ignoreAutoHeight", this._ignoreAutoHeight);
        }
    }

    private Boolean isColorPickerExUsed() {
        Object value = this.getAttribute(COLOR_PICKER_EX_USED_KEY, true);
        if (value == null) {
            value = Library.getProperty((String)COLOR_PICKER_EX_USED_KEY, (String)"false");
        }
        if (value != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    private JSONObject createActiveRange(SpreadsheetCtrl spreadsheetCtrl, SSheet sheet, int columnCount, int rowCount) {
        JSONObject activeRange = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, 0, columnCount, rowCount);
        int rowFreeze = this.getFreezeInfoLoader().getRowFreeze(sheet);
        int colFreeze = this.getFreezeInfoLoader().getColumnFreeze(sheet);
        if (rowFreeze >= 0) {
            activeRange.put((Object)"topFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, 0, columnCount, rowFreeze));
        }
        if (colFreeze >= 0) {
            activeRange.put((Object)"leftFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, 0, colFreeze, rowCount));
        }
        if (rowFreeze >= 0 && colFreeze >= 0) {
            activeRange.put((Object)"cornerFrozen", (Object)spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.BOTH, SpreadsheetCtrl.CellAttribute.ALL, 0, 0, colFreeze, rowFreeze));
        }
        return activeRange;
    }

    public String getColumntitle(int index) {
        String cname;
        if (XUtils.isTitleIndexMode(this)) {
            return Integer.toString(index);
        }
        if (this._columnTitles != null && (cname = (String)this._columnTitles.get(index)) != null) {
            return cname;
        }
        return CellReference.convertNumToColString((int)index);
    }

    public String getRowtitle(int index) {
        String rname = null;
        if (XUtils.isTitleIndexMode(this)) {
            return Integer.toString(index);
        }
        if (this._rowTitles != null && (rname = (String)this._rowTitles.get(index)) != null) {
            return rname;
        }
        return "" + (index + 1);
    }

    public AreaRef getSelection() {
        return (AreaRef)this._selectionArea.cloneSelf();
    }

    public void setSelection(AreaRef sel) {
        if (!Objects.equals((Object)this._selectionArea, (Object)sel)) {
            if (sel.getColumn() < 0 || sel.getRow() < 0 || sel.getLastColumn() > this._book.getMaxColumnIndex() || sel.getLastRow() > this._book.getMaxRowIndex() || sel.getColumn() > sel.getLastColumn() || sel.getRow() > sel.getLastRow()) {
                throw new UiException("illegal selection : " + sel.toString());
            }
            this.setSelectionDirectly(sel);
        }
    }

    private void setSelectionDirectly(AreaRef sel) {
        this._selectionArea.setArea(sel.getRow(), sel.getColumn(), sel.getLastRow(), sel.getLastColumn());
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("type", "move");
        args.put("left", sel.getColumn());
        args.put("top", sel.getRow());
        args.put("right", sel.getLastColumn());
        args.put("bottom", sel.getLastRow());
        this.response("selection" + this.getUuid(), new AuSelection((Component)this, args));
    }

    public AreaRef getHighlight() {
        if (this._highlightArea == null) {
            return null;
        }
        return (AreaRef)this._highlightArea.cloneSelf();
    }

    public void setHighlight(AreaRef highlight) {
        if (!Objects.equals((Object)this._highlightArea, (Object)highlight)) {
            this.setHighlightDirectly(highlight);
        }
    }

    private void setHighlightDirectly(AreaRef highlight) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        if (highlight == null) {
            this._highlightArea = null;
            args.put("type", "hide");
        } else {
            int left = Math.max(highlight.getColumn(), 0);
            int right = Math.min(highlight.getLastColumn(), this.getCurrentMaxVisibleColumns() - 1);
            int top = Math.max(highlight.getRow(), 0);
            int bottom = Math.min(highlight.getLastRow(), this.getCurrentMaxVisibleRows() - 1);
            if (left > right || top > bottom) {
                this._highlightArea = null;
                args.put("type", "hide");
            } else {
                this._highlightArea = new AreaRef(top, left, bottom, right);
                args.put("type", "show");
                args.put("left", left);
                args.put("top", top);
                args.put("right", right);
                args.put("bottom", bottom);
            }
        }
        this.response("selectionHighlight", new AuHighlight((Component)this, args));
    }

    private void setDisplayGridlines(boolean show) {
        if (this._hideGridlines == show) {
            this._hideGridlines = !show;
            this.smartUpdate("displayGridlines", show);
        }
    }

    private void updateAutoFilter(SSheet sheet, STable table, Integer affectedRowCount) {
        SAutoFilter filter;
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        if (this.isInvalidated()) {
            return;
        }
        SAutoFilter sAutoFilter = filter = table != null ? table.getAutoFilter() : sheet.getAutoFilter();
        if (affectedRowCount != null) {
            if (affectedRowCount > 500) {
                this.invalidate();
                return;
            }
            if (affectedRowCount <= 0) {
                return;
            }
        }
        if (table == null) {
            this.smartUpdate("autoFilter", this.convertAutoFilterToJSON(filter));
        } else {
            String json = JSONObject.toJSONString(this.convertATableFilterToJSON(table));
            this.response((AuResponse)new AuInvoke((Component)this, "setATableFilter", (Object)json));
        }
    }

    private void setProtectSheet(boolean protect) {
        if (this._protectSheet != protect) {
            this._protectSheet = protect;
            if (protect) {
                this.refreshAllowedOptions();
                this.updateUnlockInfo();
            }
            this.smartUpdate("protect", protect);
            this.refreshToolbarDisabled();
        }
    }

    public CellRef getCellFocus() {
        return new CellRef(this._focusArea.getRow(), this._focusArea.getColumn());
    }

    public void setCellFocus(CellRef focus) {
        if (this._focusArea.getColumn() != focus.getColumn() || this._focusArea.getRow() != focus.getRow()) {
            if (focus.getColumn() < 0 || focus.getRow() < 0 || focus.getColumn() >= this.getCurrentMaxVisibleColumns() || focus.getRow() >= this.getCurrentMaxVisibleRows()) {
                throw new UiException("illegal position : " + focus.toString());
            }
            this.setCellFocusDirectly(focus);
        }
    }

    private void setCellFocusDirectly(CellRef focus) {
        this._focusArea.setArea(focus.getRow(), focus.getColumn(), focus.getRow(), focus.getColumn());
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("type", "move");
        args.put("row", focus.getRow());
        args.put("column", focus.getColumn());
        this.response("cellFocus" + this.getUuid(), new AuCellFocus((Component)this, args));
    }

    private void releaseClientCache(String sheetUuid) {
        if (this.getSelectedSheetId().equals(sheetUuid)) {
            return;
        }
        this.response((AuResponse)new AuInvoke((Component)this, "_releaseClientCache", (Object)sheetUuid));
    }

    private void updateColWidth(SSheet sheet, int col) {
        int width = sheet.getColumn(col).getWidth();
        boolean newHidden = sheet.getColumn(col).isHidden();
        HeaderPositionHelper posHelper = this.getColumnPositionHelper(sheet);
        HeaderPositionHelper.HeaderPositionInfo info = posHelper.getInfo(col);
        if (info == null && (width != posHelper.getDefaultSize() || newHidden) || info != null && (info.size != width || info.hidden != newHidden)) {
            int id = info == null ? this._custColId.next() : info.id;
            posHelper.setInfoValues(col, width, id, newHidden, true);
            ((ExtraCtrl)this.getExtraCtrl()).setColumnWidth(sheet, col, width, id, newHidden);
        }
    }

    private void updateRowHeight(SSheet sheet, int row) {
        SRow rowobj = sheet.getRow(row);
        int height = rowobj.getHeight();
        boolean newHidden = rowobj.isHidden();
        HeaderPositionHelper posHelper = this.getRowPositionHelper(sheet);
        HeaderPositionHelper.HeaderPositionInfo info = posHelper.getInfo(row);
        if (info == null && (height != posHelper.getDefaultSize() || newHidden) || info != null && (info.size != height || info.hidden != newHidden)) {
            int id = info == null ? this._custRowId.next() : info.id;
            posHelper.setInfoValues(row, height, id, newHidden, rowobj.isCustomHeight());
            ((ExtraCtrl)this.getExtraCtrl()).setRowHeight(sheet, row, height, id, newHidden, rowobj.isCustomHeight());
        }
    }

    private ActiveRangeHelper getActiveRangeHelper() {
        ActiveRangeHelper activeRangeHelper = (ActiveRangeHelper)this.getAttribute(ACTIVE_RANGE_KEY);
        if (activeRangeHelper == null) {
            activeRangeHelper = new ActiveRangeHelper();
            this.setAttribute(ACTIVE_RANGE_KEY, activeRangeHelper);
            return activeRangeHelper;
        }
        return activeRangeHelper;
    }

    private MergeMatrixHelper getMergeMatrixHelper(SSheet sheet) {
        HelperContainer<MergeMatrixHelper> helpers = (HelperContainer<MergeMatrixHelper>)this.getAttribute(MERGE_MATRIX_KEY);
        if (helpers == null) {
            helpers = new HelperContainer<MergeMatrixHelper>();
            this.setAttribute(MERGE_MATRIX_KEY, helpers);
        }
        String sheetId = sheet.getId();
        MergeMatrixHelper mmhelper = (MergeMatrixHelper)helpers.getHelper(sheetId);
        int fzr = this.getSelectedSheetRowfreeze();
        int fzc = this.getSelectedSheetColumnfreeze();
        if (mmhelper == null) {
            int sz = sheet.getNumOfMergedRegion();
            ArrayList<int[]> mergeRanges = new ArrayList<int[]>(sz);
            for (int j = sz - 1; j >= 0; --j) {
                CellRegion addr = sheet.getMergedRegion(j);
                mergeRanges.add(new int[]{addr.column, addr.row, addr.lastColumn, addr.lastRow});
            }
            mmhelper = new MergeMatrixHelper(mergeRanges, fzr, fzc);
            helpers.putHelper(sheetId, mmhelper);
        } else {
            mmhelper.update(fzr, fzc);
        }
        return mmhelper;
    }

    private void removeMergeMatrixHelper(SSheet sheet) {
        HelperContainer helpers = (HelperContainer)this.getAttribute(MERGE_MATRIX_KEY);
        if (helpers == null) {
            return;
        }
        String sheetId = sheet.getId();
        helpers.removeHelper(sheetId);
        this.releaseClientCache(sheetId);
    }

    private HeaderPositionHelper getRowPositionHelper(SSheet sheet) {
        HeaderPositionHelper[] helper = this.getPositionHelpers(sheet);
        return helper != null ? helper[0] : null;
    }

    private HeaderPositionHelper getColumnPositionHelper(SSheet sheet) {
        HeaderPositionHelper[] helper = this.getPositionHelpers(sheet);
        return helper != null ? helper[1] : null;
    }

    private HeaderPositionHelper[] getPositionHelpers(SSheet sheet) {
        String sheetId;
        HeaderPositionHelper helper;
        if (sheet == null) {
            return null;
        }
        HelperContainer<HeaderPositionHelper> helpers = (HelperContainer<HeaderPositionHelper>)this.getAttribute(ROW_SIZE_HELPER_KEY);
        if (helpers == null) {
            helpers = new HelperContainer<HeaderPositionHelper>();
            this.setAttribute(ROW_SIZE_HELPER_KEY, helpers);
        }
        if ((helper = (HeaderPositionHelper)helpers.getHelper(sheetId = sheet.getId())) == null) {
            int defaultSize = this.getRowheight();
            ArrayList<HeaderPositionHelper.HeaderPositionInfo> infos = new ArrayList<HeaderPositionHelper.HeaderPositionInfo>();
            Iterator iter = sheet.getRowIterator();
            while (iter.hasNext()) {
                SRow row = (SRow)iter.next();
                boolean hidden = row.isHidden();
                int height = row.getHeight();
                boolean customHeight = row.isCustomHeight();
                if (height == defaultSize && !hidden && !customHeight) continue;
                infos.add(new HeaderPositionHelper.HeaderPositionInfo(row.getIndex(), height, this._custRowId.next(), hidden, row.isCustomHeight()));
            }
            helper = new HeaderPositionHelper(defaultSize, infos);
            helpers.putHelper(sheetId, helper);
        }
        return new HeaderPositionHelper[]{helper, this.myGetColumnPositionHelper(sheet)};
    }

    @Deprecated
    void updateCell(int left, int top, int right, int bottom) {
        this.updateCell(this.getSelectedSSheet(), left, top, right, bottom, SpreadsheetCtrl.CellAttribute.ALL);
    }

    void updateCell(int left, int top, int right, int bottom, SpreadsheetCtrl.CellAttribute cellAttr) {
        this.updateCell(this.getSelectedSSheet(), left, top, right, bottom, cellAttr);
    }

    private void updateWidget(SSheet sheet, String objId) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        if (this.isInvalidated()) {
            return;
        }
        this.getWidgetHandler().updateWidget(sheet, objId);
    }

    private void updateDataValidation(SSheet sheet, String objId) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        if (this.isInvalidated()) {
            return;
        }
        List<Map<String, Object>> dvs = this.getDataValidationHandler().loadDataValidtionJASON(this.getSelectedSheet());
        if (dvs != null) {
            this.smartUpdate("dataValidations", dvs);
        } else {
            this.smartUpdate("dataValidations", null);
        }
    }

    private void updateCell(SSheet sheet, int left, int top, int right, int bottom, SpreadsheetCtrl.CellAttribute cellAttr) {
        if (this.isInvalidated()) {
            return;
        }
        String sheetId = sheet.getId();
        if (!this.getActiveRangeHelper().containsSheet(sheet)) {
            return;
        }
        if (cellAttr == SpreadsheetCtrl.CellAttribute.ALL || cellAttr == SpreadsheetCtrl.CellAttribute.STYLE) {
            left = left > 0 ? left - 1 : 0;
            top = top > 0 ? top - 1 : 0;
            ++right;
            ++bottom;
        }
        AreaRef rect = this.getActiveRangeHelper().getArea(sheet);
        int loadLeft = rect.getColumn();
        int loadTop = rect.getRow();
        int loadRight = rect.getLastColumn();
        int loadBottom = rect.getLastRow();
        FreezeInfoLoader fil = this.getFreezeInfoLoader();
        int frRow = fil.getRowFreeze(sheet);
        int frCol = fil.getColumnFreeze(sheet);
        int frTop = top <= frRow ? top : -1;
        int frBottom = frRow;
        int frLeft = left <= frCol ? left : -1;
        int frRight = frCol;
        if (loadLeft > left) {
            left = loadLeft;
        }
        if (loadRight < right) {
            right = loadRight;
        }
        if (loadTop > top) {
            top = loadTop;
        }
        if (loadBottom < bottom) {
            bottom = loadBottom;
        }
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this.getExtraCtrl();
        JSONObject activeRange = null;
        if (top >= 0 && top <= bottom && left >= 0 && left <= right) {
            activeRange = this.responseUpdateCell(sheet, sheetId, left, top, right, bottom, cellAttr);
        }
        if (frTop >= 0 && frTop <= frBottom && left >= 0 && left <= right) {
            if (activeRange == null) {
                activeRange = this.responseUpdateCell(sheet, sheetId, loadLeft, loadTop, loadLeft, loadTop, cellAttr);
            }
            activeRange.put((Object)"topFrozen", (Object)this.responseUpdateCell(sheet, sheetId, left, frTop, right, frBottom, cellAttr));
        }
        if (frLeft >= 0 && frLeft <= frRight && top >= 0 && top <= bottom) {
            if (activeRange == null) {
                activeRange = this.responseUpdateCell(sheet, sheetId, loadLeft, loadTop, loadLeft, loadTop, cellAttr);
            }
            activeRange.put((Object)"leftFrozen", (Object)this.responseUpdateCell(sheet, sheetId, frLeft, top, frRight, bottom, cellAttr));
        }
        if (frTop >= 0 && frTop <= frBottom && frLeft >= 0 && frLeft <= frRight) {
            if (activeRange == null) {
                activeRange = this.responseUpdateCell(sheet, sheetId, loadLeft, loadTop, loadLeft, loadTop, cellAttr);
            }
            activeRange.put((Object)"cornerFrozen", (Object)this.responseUpdateCell(sheet, sheetId, frLeft, frTop, frRight, frBottom, cellAttr));
        }
        if (activeRange != null) {
            this.response(top + "_" + left + "_" + this._updateCellId.next(), new AuDataUpdate((Component)this, "", sheetId, activeRange));
        }
    }

    private JSONObject responseUpdateCell(SSheet sheet, String sheetId, int left, int top, int right, int bottom, SpreadsheetCtrl.CellAttribute cellAttr) {
        SpreadsheetCtrl spreadsheetCtrl = (SpreadsheetCtrl)this.getExtraCtrl();
        JSONObject result = spreadsheetCtrl.getRangeAttrs(sheet, SpreadsheetCtrl.Header.NONE, cellAttr, left, top, right, bottom);
        result.put((Object)"type", (Object)"udcell");
        return result;
    }

    private HeaderPositionHelper myGetColumnPositionHelper(SSheet sheet) {
        String sheetId;
        HeaderPositionHelper helper;
        HelperContainer<HeaderPositionHelper> helpers = (HelperContainer<HeaderPositionHelper>)this.getAttribute(COLUMN_SIZE_HELPER_KEY);
        if (helpers == null) {
            helpers = new HelperContainer<HeaderPositionHelper>();
            this.setAttribute(COLUMN_SIZE_HELPER_KEY, helpers);
        }
        if ((helper = (HeaderPositionHelper)helpers.getHelper(sheetId = sheet.getId())) == null) {
            int defaultColSize = sheet.getDefaultColumnWidth();
            ArrayList<HeaderPositionHelper.HeaderPositionInfo> infos = new ArrayList<HeaderPositionHelper.HeaderPositionInfo>();
            Iterator iter = sheet.getColumnArrayIterator();
            while (iter.hasNext()) {
                SColumnArray columnArray = (SColumnArray)iter.next();
                boolean hidden = columnArray.isHidden();
                int columnWidth = columnArray.getWidth();
                if (!columnArray.isCustomWidth() && !hidden) continue;
                for (int i = columnArray.getIndex(); i <= columnArray.getLastIndex(); ++i) {
                    infos.add(new HeaderPositionHelper.HeaderPositionInfo(i, columnWidth, this._custColId.next(), hidden, true));
                }
            }
            helper = new HeaderPositionHelper(defaultColSize, infos);
            helpers.putHelper(sheetId, helper);
        }
        return helper;
    }

    public Object getExtraCtrl() {
        return this.newExtraCtrl();
    }

    protected Object newExtraCtrl() {
        return new ExtraCtrl();
    }

    public void invalidate() {
        super.invalidate();
        this.doInvalidate();
    }

    public void focus() {
        JSONObj result = new JSONObj();
        result.setData("type", "retrive");
        this.response("retrieveFocus" + this.getUuid(), new AuRetrieveFocus((Component)this, result.toString()));
    }

    public void focusTo(int row, int column) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("row", row);
        args.put("column", column);
        args.put("type", "moveto");
        this.response("cellFocusTo" + this.getUuid(), new AuCellFocusTo((Component)this, args));
        this._focusArea.setColumn(column);
        this._focusArea.setLastColumn(column);
        this._focusArea.setRow(row);
        this._focusArea.setLastRow(row);
        this._selectionArea.setColumn(column);
        this._selectionArea.setLastColumn(column);
        this._selectionArea.setRow(row);
        this._selectionArea.setLastRow(row);
        this._selectionArea.setSelType(CellSelectionType.CELL);
    }

    private String getIE9SheetDefaultRules() {
        StringBuilder sb = new StringBuilder();
        String importcss0 = this.getImportStyleSheetUrl("basic", ".x");
        sb.append("@import url(" + importcss0 + ");");
        String importcss2 = this.getImportStyleSheetUrl("colheader", ".x");
        sb.append("@import url(" + importcss2 + ");");
        String importcss1 = this.getImportStyleSheetUrl("rowheader", ".x");
        sb.append("@import url(" + importcss1 + ");");
        String importcss3 = this.getImportStyleSheetUrl("merge", ".x");
        sb.append("@import url(" + importcss3 + ");");
        String importcss4 = this.getImportStyleSheetUrl("other", ".x");
        sb.append("@import url(" + importcss4 + ");");
        return sb.toString();
    }

    private String getIE9BasicStyleSheet() {
        StringBuilder sb = new StringBuilder();
        this.prepareBasicStyleSheet(sb);
        return sb.toString();
    }

    private void prepareBasicStyleSheet(StringBuilder sb) {
        int leftw;
        int toph;
        SSheet sheet = this.getSelectedSSheet();
        HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
        HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
        MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
        boolean hiderow = this.isHiderowhead();
        boolean hidecol = this.isHidecolumnhead();
        boolean showgrid = sheet.getViewInfo().isDisplayGridlines();
        int th = hidecol ? 0 : this.getTopheadheight();
        int lw = hiderow ? 1 : this.getLeftheadwidth();
        int cp = this._cellpadding;
        int rh = this.getRowheight();
        int cw = this.getColumnwidth();
        int lh = 20;
        if (lh > rh) {
            lh = rh;
        }
        String sheetPrefix = " .s" + this.getSelectedSheetId();
        String name = "#" + this.getUuid();
        Execution exe = Executions.getCurrent();
        int cellwidth = cw;
        int cellheight = rh;
        int celltextwidth = cw - 2 * cp;
        sb.append(name).append(" .zsdata{");
        sb.append("padding-top:").append(th + 1).append("px;");
        sb.append("padding-left:").append(lw).append("px;");
        sb.append("}");
        sb.append(name).append(" .zsrow{");
        sb.append("height:").append(rh).append("px;");
        sb.append("}");
        sb.append(name).append(" .zscell{");
        sb.append("padding:").append("0px " + cp + "px 0px " + cp + "px;");
        sb.append("height:").append(cellheight).append("px;");
        sb.append("width:").append(cellwidth).append("px;");
        if (!showgrid) {
            sb.append("border-bottom:1px solid #FFFFFF;").append("border-right:1px solid #FFFFFF;");
        }
        sb.append("}");
        sb.append(name).append(" .zscelltxt{");
        sb.append("width:").append(celltextwidth).append("px;");
        sb.append("height:").append(cellheight).append("px;");
        sb.append("}");
        int topheadh = toph = th;
        int cornertoph = th;
        int fzr = this.getSelectedSheetRowfreeze();
        int fzc = this.getSelectedSheetColumnfreeze();
        if (fzr > -1) {
            toph += rowHelper.getStartPixel(fzr + 1);
        }
        sb.append(name).append(" .zstop{");
        sb.append("left:").append(lw).append("px;");
        sb.append("height:").append(fzr > -1 ? toph - 1 : toph).append("px;");
        sb.append("}");
        sb.append(name).append(" .zstopi{");
        sb.append("height:").append(toph).append("px;");
        sb.append("}");
        sb.append(name).append(" .zstophead{");
        sb.append("height:").append(topheadh).append("px;");
        sb.append("}");
        sb.append(name).append(" .zscornertop{");
        sb.append("left:").append(lw).append("px;");
        sb.append("height:").append(cornertoph).append("px;");
        sb.append("}");
        sb.append(name).append(" .zstopcell{");
        sb.append("padding:").append("0px " + cp + "px 0px " + cp + "px;");
        sb.append("height:").append(topheadh).append("px;");
        sb.append("width:").append(cellwidth).append("px;");
        sb.append("line-height:").append(topheadh).append("px;");
        sb.append("}");
        sb.append(name).append(" .zstopcelltxt{");
        sb.append("width:").append(celltextwidth).append("px;");
        sb.append("}");
        int leftheadw = leftw = lw - 1;
        int leftblockleft = leftw;
        if (fzc > -1) {
            leftw += colHelper.getStartPixel(fzc + 1);
        }
        sb.append(name).append(" .zsleft{");
        sb.append("top:").append(th + 1).append("px;");
        sb.append("width:").append(fzc > -1 ? leftw - 1 : leftw).append("px;");
        sb.append("}");
        sb.append(name).append(" .zslefti{");
        sb.append("width:").append(leftw).append("px;");
        sb.append("}");
        sb.append(name).append(" .zslefthead{");
        sb.append("width:").append(leftheadw).append("px;");
        sb.append("}");
        sb.append(name).append(" .zsleftblock{");
        sb.append("left:").append(leftblockleft).append("px;");
        sb.append("}");
        sb.append(name).append(" .zscornerleft{");
        sb.append("top:").append(th + 1).append("px;");
        sb.append("width:").append(leftheadw).append("px;");
        sb.append("}");
        sb.append(name).append(" .zsleftcell{");
        sb.append("height:").append(rh).append("px;");
        sb.append("line-height:").append(rh).append("px;");
        sb.append("}");
        sb.append(name).append(" .zscorner{");
        sb.append("width:").append(fzc > -1 ? leftw : leftw + 1).append("px;");
        sb.append("height:").append(fzr > -1 ? toph : toph + 1).append("px;");
        sb.append("}");
        sb.append(name).append(" .zscorneri{");
        sb.append("width:").append(lw - 2).append("px;");
        sb.append("height:").append(th - 1).append("px;");
        sb.append("}");
        sb.append(name).append(" .zscornerblock{");
        sb.append("left:").append(lw).append("px;");
        sb.append("top:").append(th + 1).append("px;");
        sb.append("}");
        sb.append(name).append(" .zshboun{");
        sb.append("height:").append(th).append("px;");
        sb.append("}");
        sb.append(name).append(" .zshbouni{");
        sb.append("height:").append(th).append("px;");
        sb.append("}");
        sb.append(name).append(" .zsfztop{");
        sb.append("border-bottom-style:").append(fzr > -1 ? "solid" : "none").append(";");
        sb.append("}");
        sb.append(name).append(" .zsfztop .zswidgetpanel{");
        sb.append("left:").append(-lw).append("px;");
        sb.append("}");
        sb.append(name).append(" .zsfzcorner{");
        sb.append("border-bottom-style:").append(fzr > -1 ? "solid" : "none").append(";");
        sb.append("}");
        sb.append(name).append(" .zsfzcorner .zswidgetpanel{");
        sb.append("left:1px;");
        sb.append("top:1px;");
        sb.append("}");
        sb.append(name).append(" .zsfzleft{");
        sb.append("border-right-style:").append(fzc > -1 ? "solid" : "none").append(";");
        sb.append("}");
        sb.append(name).append(" .zsfzleft .zswidgetpanel{");
        sb.append("top:").append(-th).append("px;");
        sb.append("}");
        sb.append(name).append(" .zsfzcorner{");
        sb.append("border-right-style:").append(fzc > -1 ? "solid" : "none").append(";");
        sb.append("}");
        boolean transparentBorder = false;
        if (transparentBorder) {
            sb.append(name).append(" .zscell {");
            sb.append("border-right-color: transparent;");
            sb.append("border-bottom-color: transparent;");
            sb.append("}");
        }
    }

    private void prepareColHeaderStyleSheet(StringBuilder sb) {
        String name = "#" + this.getUuid();
        SSheet sheet = this.getSelectedSSheet();
        HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
        int cp = this._cellpadding;
        List<HeaderPositionHelper.HeaderPositionInfo> infos = colHelper.getInfos();
        for (HeaderPositionHelper.HeaderPositionInfo info : infos) {
            boolean hidden = info.hidden;
            int index = info.index;
            int width = hidden ? 0 : info.size;
            int cid = info.id;
            int celltextwidth = width - 2 * cp;
            if (celltextwidth < 0) {
                celltextwidth = 0;
            }
            int cellwidth = width;
            if (width <= 0) {
                sb.append(name).append(" .zsw").append(cid).append("{");
                sb.append("display:none;");
                sb.append("}");
                continue;
            }
            sb.append(name).append(" .zsw").append(cid).append("{");
            sb.append("width:").append(cellwidth).append("px;");
            sb.append("}");
            sb.append(name).append(" .zswi").append(cid).append("{");
            sb.append("width:").append(celltextwidth).append("px;");
            sb.append("}");
        }
    }

    private void prepareRowHeaderStyleSheet(StringBuilder sb) {
        String name = "#" + this.getUuid();
        SSheet sheet = this.getSelectedSSheet();
        HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
        List<HeaderPositionHelper.HeaderPositionInfo> infos = rowHelper.getInfos();
        for (HeaderPositionHelper.HeaderPositionInfo info : infos) {
            boolean hidden = info.hidden;
            int index = info.index;
            int height = hidden ? 0 : info.size;
            int cid = info.id;
            int cellheight = height;
            if (height <= 0) {
                sb.append(name).append(" .zsh").append(cid).append("{");
                sb.append("height:0px;");
                sb.append("}");
                sb.append(name).append(" .zshi").append(cid).append("{");
                sb.append("height:0px;");
                sb.append("border-bottom-width:0px;");
                sb.append("overflow:hidden;");
                sb.append("}");
                sb.append(name).append(" .zslh").append(cid).append("{");
                sb.append("height:0px;");
                sb.append("line-height:0px;");
                sb.append("border-bottom-width:0px;");
                sb.append("}");
                sb.append(name).append(" .zshr").append(cid).append("{");
                sb.append("max-height:0px;");
                sb.append("}");
                continue;
            }
            sb.append(name).append(" .zsh").append(cid).append("{");
            sb.append("height:").append(height).append("px;");
            sb.append("}");
            sb.append(name).append(" .zshi").append(cid).append("{");
            sb.append("height:").append(cellheight).append("px;");
            sb.append("border-bottom-width:1px;");
            sb.append("}");
            sb.append(name).append(" .zslh").append(cid).append("{");
            sb.append("height:").append(height).append("px;");
            sb.append("line-height:").append(height).append("px;");
            sb.append("border-bottom-width:1px;");
            sb.append("}");
            sb.append(name).append(" .zshr").append(cid).append("{");
            sb.append("max-height:").append(height).append("px;");
            sb.append("}");
        }
        sb.append(".zs_header{}");
    }

    private void prepareMergeStyleSheet(StringBuilder sb) {
        String name = "#" + this.getUuid();
        SSheet sheet = this.getSelectedSSheet();
        HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
        HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
        MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
        int cp = this._cellpadding;
        List<MergedRect> ranges = mmhelper.getRanges();
        Iterator<MergedRect> iter = ranges.iterator();
        int defaultSize = colHelper.getDefaultSize();
        int defaultRowSize = rowHelper.getDefaultSize();
        while (iter.hasNext()) {
            MergedRect block = iter.next();
            int left = block.getColumn();
            int right = block.getLastColumn();
            int width = 0;
            for (int i = left; i <= right; ++i) {
                HeaderPositionHelper.HeaderPositionInfo info = colHelper.getInfo(i);
                if (info != null) {
                    boolean hidden = info.hidden;
                    int colSize = hidden ? 0 : info.size;
                    width += colSize;
                    continue;
                }
                width += defaultSize;
            }
            int top = block.getRow();
            int bottom = block.getLastRow();
            int height = 0;
            for (int i = top; i <= bottom; ++i) {
                HeaderPositionHelper.HeaderPositionInfo info = rowHelper.getInfo(i);
                if (info != null) {
                    boolean hidden = info.hidden;
                    int rowSize = hidden ? 0 : info.size;
                    height += rowSize;
                    continue;
                }
                height += defaultRowSize;
            }
            if (width <= 0 || height <= 0) {
                sb.append(name).append(" .zsmerge").append(block.getId()).append("{");
                sb.append("display:none;");
                sb.append("}");
                sb.append(name).append(" .zsmerge").append(block.getId());
                sb.append(" .zscelltxt").append("{");
                sb.append("display:none;");
                sb.append("}");
                continue;
            }
            int celltextwidth = width - 2 * cp;
            int celltextheight = height;
            int cellwidth = width;
            int cellheight = height;
            sb.append(name).append(" .zsmerge").append(block.getId()).append("{");
            sb.append("width:").append(cellwidth).append("px;");
            sb.append("height:").append(cellheight).append("px;");
            sb.append("display:inline-block;");
            sb.append("border-bottom-width: 1px;");
            sb.append("}");
            sb.append(name).append(" .zsmerge").append(block.getId());
            sb.append(" .zscelltxt").append("{");
            sb.append("width:").append(celltextwidth).append("px;");
            sb.append("height:").append(celltextheight).append("px;");
            sb.append("}");
        }
    }

    private String getIE9OtherStyleSheet() {
        StringBuilder sb = new StringBuilder();
        this.prepareOtherStyleSheet(sb);
        return sb.toString();
    }

    private void prepareOtherStyleSheet(StringBuilder sb) {
        String name = "#" + this.getUuid();
        sb.append(name).append(" .zs_indicator_" + this.getSelectedSheetId() + "{}");
        if (Package.getPackage("org.zkoss.addons.bootstrap") != null) {
            sb.append(name).append(" *[class^=zs]{box-sizing: content-box;-moz-box-sizing: content-box;}").append(name).append(".zssheet{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zscell{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zstopcell{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zsleftcell{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zsfocmark{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zsselect{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zsselchg{box-sizing:border-box;-moz-box-sizing: border-box;}").append(name).append(" .zshighlight{box-sizing:border-box;-moz-box-sizing: border-box;}").append("li[class^=zsmenu-] a:hover, li[class^=zsmenuitem-] a:hover{text-decoration: none;}").append(name).append(" .cleditorMain * {-moz-box-sizing:content-box; -webkit-box-sizing:content-box; box-sizing:content-box}");
        }
    }

    private String getSheetDefaultRules() {
        return Spreadsheet.isIE9() ? this.getIE9SheetDefaultRules() : this.getSheetDefaultRules0();
    }

    private String getSheetDefaultRules0() {
        StringBuilder sb = new StringBuilder();
        this.prepareBasicStyleSheet(sb);
        this.prepareColHeaderStyleSheet(sb);
        this.prepareRowHeaderStyleSheet(sb);
        this.prepareMergeStyleSheet(sb);
        this.prepareOtherStyleSheet(sb);
        return sb.toString();
    }

    public static boolean isIE9() {
        Execution exec = Executions.getCurrent();
        Double ver = exec != null ? exec.getBrowser("ie") : null;
        return ver != null && ver < 10.0 && ver >= 9.0;
    }

    private int dotIndexToNumIndex(String dotIndex) {
        String[] index = dotIndex.split("\\.");
        int result = 0;
        for (String x : index) {
            int j = Integer.valueOf("x".equals(x) ? "0" : x);
            result *= 31;
            result += j;
        }
        return result;
    }

    private String numIndexToDotIndex(int index) {
        ArrayList<CallSite> reverse = new ArrayList<CallSite>(4);
        while (index > 0) {
            int j = index % 31;
            reverse.add((CallSite)((Object)("" + j)));
            index /= 31;
        }
        StringBuilder sb = new StringBuilder();
        int j = reverse.size();
        while (--j >= 0) {
            sb.append(".").append((String)reverse.get(j));
        }
        return sb.toString();
    }

    private int dotIndexToNumIndex(String dotIndex, int extraDigits) {
        int result = this.dotIndexToNumIndex(dotIndex);
        for (int k = 0; k < extraDigits; ++k) {
            result *= 31;
        }
        return result;
    }

    private int numOfDigits(int num) {
        if (num <= 30) {
            return 1;
        }
        if (num <= 960) {
            return 2;
        }
        if (num <= 29790) {
            return 3;
        }
        return 4;
    }

    private String getIE9ColHeaderStyleSheet(String dotIndex) {
        SSheet sheet = this.getSelectedSSheet();
        HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
        int cp = this._cellpadding;
        String name = "#" + this.getUuid();
        List<HeaderPositionHelper.HeaderPositionInfo> infos = colHelper.getInfos();
        int len = infos.size();
        if (len == 0) {
            return "";
        }
        int infoPerPage = 2040;
        String imports = this.prepareIE9ImportStyleSheet(2040, dotIndex, len, "colheader");
        if (imports != null) {
            return imports;
        }
        StringBuilder sb = new StringBuilder();
        int cssPageIndex = this.dotIndexToNumIndex(dotIndex);
        int infoStart = cssPageIndex * 2040;
        int infoEnd = infoStart + 2040;
        int right = this._cssArea.getLastColumn();
        int bottom = this._cssArea.getLastRow();
        int left = this._cssArea.getColumn();
        int top = this._cssArea.getRow();
        if (right < 0) {
            right = this.getInitColumnSize();
            bottom = this.getInitRowSize();
            left = 0;
            top = 0;
            this._cssArea.setArea(top, left, bottom, right);
        }
        int fbottom = this.getSelectedSheetRowfreeze();
        int fright = this.getSelectedSheetColumnfreeze();
        for (int j = infoStart; j < len && j < infoEnd; ++j) {
            HeaderPositionHelper.HeaderPositionInfo info = infos.get(j);
            if (info.index < left && info.index > fright) continue;
            if (info.index > right) break;
            boolean hidden = info.hidden;
            int index = info.index;
            int width = hidden ? 0 : info.size;
            int cid = info.id;
            int celltextwidth = width - 2 * cp;
            if (celltextwidth < 0) {
                celltextwidth = 0;
            }
            int cellwidth = width;
            if (width <= 0) {
                sb.append(name).append(" .zsw").append(cid).append("{");
                sb.append("display:none;");
                sb.append("}");
                continue;
            }
            sb.append(name).append(" .zsw").append(cid).append("{");
            sb.append("width:").append(cellwidth).append("px;");
            sb.append("}");
            sb.append(name).append(" .zswi").append(cid).append("{");
            sb.append("width:").append(celltextwidth).append("px;");
            sb.append("}");
        }
        return sb.toString();
    }

    private String getIE9RowHeaderStyleSheet(String dotIndex) {
        SSheet sheet = this.getSelectedSSheet();
        HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
        String name = "#" + this.getUuid();
        List<HeaderPositionHelper.HeaderPositionInfo> infos = rowHelper.getInfos();
        int len = infos.size();
        if (len == 0) {
            return "";
        }
        int infoPerPage = 1020;
        String imports = this.prepareIE9ImportStyleSheet(1020, dotIndex, len, "rowheader");
        if (imports != null) {
            return imports;
        }
        StringBuilder sb = new StringBuilder();
        int cssPageIndex = this.dotIndexToNumIndex(dotIndex);
        int infoStart = cssPageIndex * 1020;
        int infoEnd = infoStart + 1020;
        int right = this._cssArea.getLastColumn();
        int bottom = this._cssArea.getLastRow();
        int left = this._cssArea.getColumn();
        int top = this._cssArea.getRow();
        if (right < 0) {
            right = this.getInitColumnSize();
            bottom = this.getInitRowSize();
            left = 0;
            top = 0;
            this._cssArea.setArea(top, left, bottom, right);
        }
        int fbottom = this.getSelectedSheetRowfreeze();
        int fright = this.getSelectedSheetColumnfreeze();
        for (int j = infoStart; j < len && j < infoEnd; ++j) {
            HeaderPositionHelper.HeaderPositionInfo info = infos.get(j);
            if (info.index < top && info.index > fbottom) continue;
            if (info.index > bottom) break;
            boolean hidden = info.hidden;
            int index = info.index;
            int height = hidden ? 0 : info.size;
            int cid = info.id;
            int cellheight = height;
            if (height <= 0) {
                sb.append(name).append(" .zsh").append(cid).append("{");
                sb.append("height:0px;");
                sb.append("}");
                sb.append(name).append(" .zshi").append(cid).append("{");
                sb.append("height:0px;");
                sb.append("border-bottom-width:0px;");
                sb.append("overflow:hidden;");
                sb.append("}");
                sb.append(name).append(" .zslh").append(cid).append("{");
                sb.append("height:0px;");
                sb.append("line-height:0px;");
                sb.append("border-bottom-width:0px;");
                sb.append("}");
                sb.append(name).append(" .zshr").append(cid).append("{");
                sb.append("max-height:0px;");
                sb.append("}");
                continue;
            }
            sb.append(name).append(" .zsh").append(cid).append("{");
            sb.append("height:").append(height).append("px;");
            sb.append("}");
            sb.append(name).append(" .zshi").append(cid).append("{");
            sb.append("height:").append(cellheight).append("px;");
            sb.append("border-bottom-width:1px;");
            sb.append("}");
            sb.append(name).append(" .zslh").append(cid).append("{");
            sb.append("height:").append(height).append("px;");
            sb.append("line-height:").append(height).append("px;");
            sb.append("border-bottom-width:1px;");
            sb.append("}");
            sb.append(name).append(" .zshr").append(cid).append("{");
            sb.append("max-height:").append(height).append("px;");
            sb.append("}");
        }
        return sb.toString();
    }

    private String getImportStyleSheetUrl(String type, String dotIndex) {
        String sheetId = this.getSelectedSheetId();
        return Spreadsheet.getDynamicMediaURI((AbstractComponent)this, this._cssVersion - 1, "ss_" + this.getUuid() + "_" + sheetId + "." + type + dotIndex, "css");
    }

    private String prepareIE9ImportStyleSheet(int infoPerPage, String dotIndex, int len, String fileType) {
        int endPageIndex = (len - 1) / infoPerPage;
        int numDigits = this.numOfDigits(endPageIndex);
        String[] digits = dotIndex.split("\\.");
        int diff = numDigits - digits.length;
        int startPageIndex = this.dotIndexToNumIndex(dotIndex, diff);
        int pages = endPageIndex - startPageIndex;
        if (dotIndex.endsWith("x") && pages > 0) {
            String dotIndex0;
            int nextInfoStart;
            StringBuilder sb = new StringBuilder();
            String postfix = diff > 0 ? ".x" : "";
            String prefix = dotIndex.substring(0, dotIndex.length() - 1);
            for (int k = 0; k < 31 && (nextInfoStart = this.dotIndexToNumIndex(dotIndex0 = prefix + k + postfix, diff) * infoPerPage) < len; ++k) {
                String importcss = this.getImportStyleSheetUrl(fileType, "." + dotIndex0);
                sb.append("@import url(" + importcss + ");");
            }
            return sb.toString();
        }
        return null;
    }

    private String getIE9MergeStyleSheet(String dotIndex) {
        SSheet sheet = this.getSelectedSSheet();
        MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
        int cp = this._cellpadding;
        String name = "#" + this.getUuid();
        int start = this.dotIndexToNumIndex(dotIndex);
        HeaderPositionHelper colHelper = this.getColumnPositionHelper(sheet);
        HeaderPositionHelper rowHelper = this.getRowPositionHelper(sheet);
        List<MergedRect> ranges = mmhelper.getRanges();
        int len = ranges.size();
        if (len == 0) {
            return "";
        }
        int infoPerPage = 2040;
        String imports = this.prepareIE9ImportStyleSheet(2040, dotIndex, len, "merge");
        if (imports != null) {
            return imports;
        }
        StringBuilder sb = new StringBuilder();
        int cssPageIndex = this.dotIndexToNumIndex(dotIndex);
        int infoStart = cssPageIndex * 2040;
        int infoEnd = infoStart + 2040;
        int defaultSize = colHelper.getDefaultSize();
        int defaultRowSize = rowHelper.getDefaultSize();
        for (int j = infoStart; j < len && j < infoEnd; ++j) {
            MergedRect block = ranges.get(j);
            int left = block.getColumn();
            int right = block.getLastColumn();
            int width = 0;
            for (int i = left; i <= right; ++i) {
                HeaderPositionHelper.HeaderPositionInfo info = colHelper.getInfo(i);
                if (info != null) {
                    boolean hidden = info.hidden;
                    int colSize = hidden ? 0 : info.size;
                    width += colSize;
                    continue;
                }
                width += defaultSize;
            }
            int top = block.getRow();
            int bottom = block.getLastRow();
            int height = 0;
            for (int i = top; i <= bottom; ++i) {
                HeaderPositionHelper.HeaderPositionInfo info = rowHelper.getInfo(i);
                if (info != null) {
                    boolean hidden = info.hidden;
                    int rowSize = hidden ? 0 : info.size;
                    height += rowSize;
                    continue;
                }
                height += defaultRowSize;
            }
            if (width <= 0 || height <= 0) {
                sb.append(name).append(" .zsmerge").append(block.getId()).append("{");
                sb.append("display:none;");
                sb.append("}");
                sb.append(name).append(" .zsmerge").append(block.getId());
                sb.append(" .zscelltxt").append("{");
                sb.append("display:none;");
                sb.append("}");
                continue;
            }
            int celltextwidth = width - 2 * cp;
            int celltextheight = height;
            int cellwidth = width;
            int cellheight = height;
            sb.append(name).append(" .zsmerge").append(block.getId()).append("{");
            sb.append("width:").append(cellwidth).append("px;");
            sb.append("height:").append(cellheight).append("px;");
            sb.append("display:inline-block;");
            sb.append("border-bottom-width: 1px;");
            sb.append("}");
            sb.append(name).append(" .zsmerge").append(block.getId());
            sb.append(" .zscelltxt").append("{");
            sb.append("width:").append(celltextwidth).append("px;");
            sb.append("height:").append(celltextheight).append("px;");
            sb.append("}");
        }
        return sb.toString();
    }

    private static String getDynamicMediaURI(AbstractComponent comp, int version, String name, String format) {
        Desktop desktop = comp.getDesktop();
        if (desktop == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer(64).append('/');
        Strings.encode((StringBuffer)sb, (int)version);
        if (name != null || format != null) {
            sb.append('/');
            boolean bExtRequired = true;
            if (name != null && name.length() != 0) {
                sb.append(name.replace('\\', '/'));
                bExtRequired = name.lastIndexOf(46) < 0;
            } else {
                sb.append(comp.getUuid());
            }
            if (bExtRequired && format != null) {
                sb.append('.').append(format);
            }
        }
        return desktop.getDynamicMediaURI((Component)comp, sb.toString());
    }

    private void cleanSelectedSheet() {
        if (this._selectedSheet == null) {
            return;
        }
        this.deleteSelfEditorFocus();
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).onSheetClean(this._selectedSheet);
        }
        this._selectionArea.setArea(0, 0, 0, 0);
        this._selectionArea.setSelType(CellSelectionType.CELL);
        this._focusArea.setArea(0, 0, 0, 0);
        this._selectedSheet = null;
    }

    private void afterSheetSelected() {
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).onSheetSelected(this._selectedSheet);
        }
        this.setDisplayGridlines(this._selectedSheet.getViewInfo().isDisplayGridlines());
        this.setProtectSheet(this._selectedSheet.isProtected());
        CellRef cf = this.getCellFocus();
        this.moveSelfEditorFocus(this.getSelectedSheetId(), cf.getRow(), cf.getColumn());
        this.refreshToolbarDisabled();
        this.refreshAllowedOptions();
        this.updateUnlockInfo();
        this.smartUpdate("maxRows", this.getCurrentMaxVisibleRows());
        this.smartUpdate("maxColumns", this.getCurrentMaxVisibleColumns());
    }

    public String getSelectedSheetName() {
        SSheet sheet = this.getSelectedSSheet();
        return sheet == null ? null : sheet.getSheetName();
    }

    private void addChartWidget(SSheet sheet, SChart chart) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).addChartWidget(sheet, chart);
        }
    }

    private void addPictureWidget(SSheet sheet, SPicture picture) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).addPictureWidget(sheet, picture);
        }
    }

    private void deletePictureWidget(SSheet sheet, String pictureId) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).deletePictureWidget(sheet, pictureId);
        }
    }

    private void updatePictureWidget(SSheet sheet, SPicture picture) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).updatePictureWidget(sheet, picture);
        }
    }

    private void deleteChartWidget(SSheet sheet, String chartId) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).deleteChartWidget(sheet, chartId);
        }
    }

    private void updateChartWidget(SSheet sheet, SChart chart) {
        if (!this.getSelectedSSheet().equals(sheet)) {
            this.releaseClientCache(sheet.getId());
            return;
        }
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).updateChartWidget(sheet, chart);
        }
    }

    private void clearHeaderSizeHelper(boolean row, boolean col) {
        if (row) {
            this.removeAttribute(ROW_SIZE_HELPER_KEY);
        }
        if (col) {
            this.removeAttribute(COLUMN_SIZE_HELPER_KEY);
        }
    }

    private static String getSizeHelperStr(HeaderPositionHelper helper) {
        List<HeaderPositionHelper.HeaderPositionInfo> infos = helper.getInfos();
        StringBuffer csc = new StringBuffer();
        for (HeaderPositionHelper.HeaderPositionInfo info : infos) {
            if (csc.length() > 0) {
                csc.append(",");
            }
            csc.append(info.index).append(",").append(info.size).append(",").append(info.id).append(",").append(info.hidden).append(",").append(info.isCustom());
        }
        return csc.toString();
    }

    private static String getRectStr(AreaRef rect) {
        StringBuffer sb = new StringBuffer();
        sb.append(rect.getColumn()).append(",").append(rect.getRow()).append(",").append(rect.getLastColumn()).append(",").append(rect.getLastRow());
        return sb.toString();
    }

    private static String getSelTypeStr(AreaRefWithType area) {
        CellSelectionType type = area.getSelType();
        switch (type) {
            case ALL: {
                return "all";
            }
            case COLUMN: {
                return "col";
            }
            case ROW: {
                return "row";
            }
        }
        return "cell";
    }

    private void doInvalidate() {
        SSheet sheet = this.getSelectedSSheet();
        this.clearHeaderSizeHelper(true, true);
        this._custColId = new SequenceId(-1, 2);
        this._custRowId = new SequenceId(-1, 2);
        this.getWidgetHandler().invaliate();
        List<WidgetLoader> list = this.loadWidgetLoaders();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            list.get(i).invalidate();
        }
    }

    List<WidgetLoader> loadWidgetLoaders() {
        if (this._widgetLoaders != null) {
            return this._widgetLoaders;
        }
        this._widgetLoaders = new ArrayList<WidgetLoader>();
        String loaderclzs = Library.getProperty((String)WIDGET_LOADERS);
        if (loaderclzs != null) {
            try {
                String[] clzs = loaderclzs.split(",");
                for (int i = 0; i < clzs.length; ++i) {
                    clzs[i] = clzs[i].trim();
                    if ("".equals(clzs[i])) continue;
                    WidgetLoader wl = (WidgetLoader)Spreadsheet.newInstance(clzs[i]);
                    wl.init(this);
                    this._widgetLoaders.add(wl);
                }
            }
            catch (Exception x) {
                throw new UiException((Throwable)x);
            }
        }
        return this._widgetLoaders;
    }

    public void disableUserAction(AuxAction action, boolean disabled) {
        boolean changed = false;
        if (disabled && !this._actionDisabled.contains((Object)action)) {
            this._actionDisabled.add(action);
            changed = true;
        } else if (!disabled && this._actionDisabled.contains((Object)action)) {
            this._actionDisabled.remove((Object)action);
            changed = true;
        }
        if (changed) {
            this.refreshToolbarDisabled();
        }
    }

    private List<String> convertToDisabledActionJSON(Set<String> supported) {
        ArrayList<String> disd = new ArrayList<String>();
        for (AuxAction ua : AuxAction.values()) {
            String act = ua.toString();
            if (!this._actionDisabled.contains((Object)ua) && supported != null && supported.contains(act)) continue;
            disd.add(act);
        }
        return disd;
    }

    private WidgetHandler getWidgetHandler() {
        if (this._widgetHandler == null) {
            this._widgetHandler = this.newWidgetHandler();
        }
        return this._widgetHandler;
    }

    private WidgetHandler newWidgetHandler() {
        String handlerclz = Library.getProperty((String)WIDGET_HANDLER_CLS);
        if (handlerclz != null) {
            try {
                this._widgetHandler = (WidgetHandler)Spreadsheet.newInstance(handlerclz);
                this._widgetHandler.init(this);
            }
            catch (Exception x) {
                throw new UiException((Throwable)x);
            }
        } else {
            this._widgetHandler = new VoidWidgetHandler();
            this._widgetHandler.init(this);
        }
        return this._widgetHandler;
    }

    private boolean addWidget(Widget widget) {
        return this.getWidgetHandler().addWidget(widget);
    }

    private boolean removeWidget(Widget widget) {
        return this.getWidgetHandler().removeWidget(widget);
    }

    private void processStartEditing(String token, StartEditingEvent event, String editingType) {
        if (!event.isCancel()) {
            boolean useEditValue = event.isEditingSet();
            Object val = useEditValue ? event.getEditingValue() : event.getClientValue();
            this.processStartEditing0(token, event.getSheet(), event.getRow(), event.getColumn(), val, useEditValue, editingType);
        } else {
            this.processCancelEditing0(token, event.getSheet(), event.getRow(), event.getColumn(), false, editingType);
        }
    }

    private void processStopEditing(String token, StopEditingEvent event, String editingType) {
        if (!event.isCancel()) {
            this.processStopEditing0(token, event.getSheet(), event.getRow(), event.getColumn(), event.getEditingValue(), editingType);
        } else {
            this.processCancelEditing0(token, event.getSheet(), event.getRow(), event.getColumn(), false, editingType);
        }
    }

    private void showFormulaErrorThenRetry(IllegalFormulaException ex, final String token, final Sheet sheet, final int rowIdx, final int colIdx, final Object value, final String editingType) {
        String title = Labels.getLabel((String)"zss.msg.warn_title");
        String msg = Labels.getLabel((String)"zss.msg.formula_error", (Object[])new Object[]{ex.getMessage()});
        Messagebox.show((String)msg, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-exclamation", (EventListener)new EventListener(){

            public void onEvent(Event evt) {
                Spreadsheet.this.processRetryEditing0(token, sheet, rowIdx, colIdx, value, editingType);
            }
        });
    }

    private void showInvalidateModelOpErrorThenRetry(InvalidModelOpException ex, final String token, final Sheet sheet, final int rowIdx, final int colIdx, final Object value, final String editingType) {
        String title = Labels.getLabel((String)"zss.msg.warn_title");
        String msg = Labels.getLabel((String)"zss.msg.invalidate_model_op_error", (Object[])new Object[]{ex.getMessage()});
        Messagebox.show((String)msg, (String)title, (int)1, (String)"z-messagebox-icon z-messagebox-exclamation", (EventListener)new EventListener(){

            public void onEvent(Event evt) {
                Spreadsheet.this.processRetryEditing0(token, sheet, rowIdx, colIdx, value, editingType);
            }
        });
    }

    private void processStopEditing0(final String token, final Sheet sheet, final int rowIdx, final int colIdx, final Object value, final String editingType) {
        try {
            String editText;
            String string = editText = value == null ? "" : value.toString();
            if (!this.forceStopEditing0 && !this.getDataValidationHandler().validate(sheet, rowIdx, colIdx, editText, new EventListener(){

                public void onEvent(Event event) throws Exception {
                    String eventname = event.getName();
                    if ("onCancel".equals(eventname)) {
                        Spreadsheet.this.processCancelEditing0(token, sheet, rowIdx, colIdx, true, editingType);
                    } else if ("onOK".equals(eventname)) {
                        try {
                            Spreadsheet.this.forceStopEditing0 = true;
                            Spreadsheet.this.processStopEditing0(token, sheet, rowIdx, colIdx, value, editingType);
                        }
                        finally {
                            Spreadsheet.this.forceStopEditing0 = false;
                        }
                    } else {
                        Spreadsheet.this.processRetryEditing0(token, sheet, rowIdx, colIdx, value, editingType);
                    }
                }
            })) {
                return;
            }
            UndoableActionManager uam = this.getUndoableActionManager();
            uam.doAction(new CellEditTextAction(Labels.getLabel((String)"zss.undo.editText"), sheet, rowIdx, colIdx, rowIdx, colIdx, editText));
            JSONObject result = new JSONObject();
            result.put((Object)"r", (Object)rowIdx);
            result.put((Object)"c", (Object)colIdx);
            result.put((Object)"type", (Object)"stopedit");
            result.put((Object)"val", (Object)"");
            result.put((Object)"et", (Object)editingType);
            this.smartUpdate("dataUpdateStop", new Object[]{token, Spreadsheet.getSheetUuid(sheet), result});
        }
        catch (RuntimeException x) {
            if (x instanceof IllegalFormulaException) {
                this.showFormulaErrorThenRetry((IllegalFormulaException)((Object)x), token, sheet, rowIdx, colIdx, value, editingType);
            }
            if (x instanceof InvalidModelOpException) {
                this.showInvalidateModelOpErrorThenRetry((InvalidModelOpException)((Object)x), token, sheet, rowIdx, colIdx, value, editingType);
            }
            this.processCancelEditing0(token, sheet, rowIdx, colIdx, false, editingType);
            throw x;
        }
    }

    private static String getSheetUuid(Sheet sheet) {
        return sheet.getInternalSheet().getId();
    }

    private void processStartEditing0(String token, Sheet sheet, int row, int col, Object value, boolean useEditValue, String editingType) {
        try {
            JSONObject result = new JSONObject();
            result.put((Object)"r", (Object)row);
            result.put((Object)"c", (Object)col);
            result.put((Object)"type", (Object)"startedit");
            result.put((Object)"val", (Object)(value == null ? "" : value.toString()));
            result.put((Object)"et", (Object)editingType);
            if (useEditValue) {
                result.put((Object)"server", (Object)true);
            }
            this.smartUpdate("dataUpdateStart", new Object[]{token, Spreadsheet.getSheetUuid(sheet), result});
        }
        catch (RuntimeException x) {
            this.processCancelEditing0(token, sheet, row, col, false, editingType);
            throw x;
        }
    }

    private void processCancelEditing0(String token, Sheet sheet, int row, int col, boolean skipMove, String editingType) {
        JSONObject result = new JSONObject();
        result.put((Object)"r", (Object)row);
        result.put((Object)"c", (Object)col);
        result.put((Object)"type", (Object)"canceledit");
        result.put((Object)"val", (Object)"");
        result.put((Object)"sk", (Object)skipMove);
        result.put((Object)"et", (Object)editingType);
        this.smartUpdate("dataUpdateCancel", new Object[]{token, Spreadsheet.getSheetUuid(sheet), result});
    }

    private void processRetryEditing0(String token, Sheet sheet, int row, int col, Object value, String editingType) {
        try {
            this.processCancelEditing0(token, sheet, row, col, true, editingType);
            JSONObject result = new JSONObject();
            result.put((Object)"r", (Object)row);
            result.put((Object)"c", (Object)col);
            result.put((Object)"type", (Object)"retryedit");
            result.put((Object)"val", value);
            result.put((Object)"et", (Object)editingType);
            this.smartUpdate("dataUpdateRetry", new Object[]{"", Spreadsheet.getSheetUuid(sheet), result});
        }
        catch (RuntimeException x) {
            this.processCancelEditing0(token, sheet, row, col, false, editingType);
            throw x;
        }
    }

    public boolean insertBefore(Component newChild, Component refChild) {
        if (newChild.getAttribute("kkchildren") != null) {
            return super.insertBefore(newChild, refChild);
        }
        throw new UiException("Unsupported child for Spreadsheet: " + newChild);
    }

    public void removeEditorFocus(String id) {
        this.response("removeEditorFocus" + this._focusId.next(), (AuResponse)new AuInvoke((Component)this, "removeEditorFocus", (Object)id));
        this._editorFocuses.remove(id);
    }

    private void removeFriendFocus(String id) {
        if (this._friendFocuses.remove(id) != null) {
            this.response("removeEditorFocus" + this._focusId.next(), (AuResponse)new AuInvoke((Component)this, "removeEditorFocus", (Object)id));
        }
    }

    public void moveEditorFocus(String id, String name, String color, int row, int col) {
        if (this._selfEditorFocus != null && !this._selfEditorFocus.getId().equals(id)) {
            this.response("moveEditorFocus" + this._focusId.next(), (AuResponse)new AuInvoke((Component)this, "moveEditorFocus", new String[]{id, name, color, "" + row, "" + col}));
            this._editorFocuses.put(id, new Focus(id, name, color, this.getSelectedSheetName(), row, col, null));
        }
    }

    private void addOrMoveFriendFocus(String id, String name, String color, String sheetId, int row, int col) {
        if (this._selfEditorFocus != null && !this._selfEditorFocus.getId().equals(id) && this.getSelectedSSheet() != null) {
            if (sheetId != null && sheetId.equals(this.getSelectedSheetId())) {
                this.response("moveEditorFocus" + this._focusId.next(), (AuResponse)new AuInvoke((Component)this, "moveEditorFocus", new String[]{id, name, color, "" + row, "" + col}));
                this._friendFocuses.put(id, new FriendFocus(id, name, color, sheetId, row, col));
            } else {
                this.removeFriendFocus(id);
            }
        }
    }

    private void syncFriendFocus() {
        this.syncFriendFocus(false);
    }

    private void syncFriendFocus(boolean always) {
        if (this._book != null) {
            HashSet<String> keep = new HashSet<String>();
            HashSet<String> inbook = new HashSet<String>();
            ArrayList<Focus> inSheetFocus = new ArrayList<Focus>();
            ArrayList<Focus> inBookFocus = new ArrayList<Focus>();
            Set<Object> bookFocuses = this.getFriendFocusHelper().getAllFocus();
            String sheetid = this.getSelectedSheetId();
            for (Object f : bookFocuses) {
                if (!(f instanceof Focus) || f.equals(this._selfEditorFocus)) continue;
                Focus focus = (Focus)f;
                String id = focus.getId();
                inbook.add(id);
                inBookFocus.add(focus);
                if (focus.getSheetId().equals(sheetid)) {
                    if (!this._friendFocuses.containsKey(id) || always) {
                        this.addOrMoveFriendFocus(id, focus.getName(), focus.getColor(), focus.getSheetId(), focus.getRow(), focus.getColumn());
                    }
                    keep.add(id);
                    inSheetFocus.add(focus);
                    continue;
                }
                if (!this._friendFocuses.containsKey(id)) continue;
                this.removeFriendFocus(id);
            }
            for (String fid : new HashSet<String>(this._friendFocuses.keySet())) {
                if (keep.contains(fid)) continue;
                this.removeFriendFocus(fid);
            }
            Sheet sheet = this.getSelectedSheet();
            Events.postEvent((Event)new SyncFriendFocusEvent("onSyncFriendFocus", (Component)this, sheet, inBookFocus, inSheetFocus));
        }
    }

    public void setUserName(String name) {
        if (!Objects.equals((Object)this._userName, (Object)name)) {
            this._userName = name;
            if (this._selfEditorFocus != null) {
                this._selfEditorFocus.setName(name);
                this.moveSelfEditorFocus(this._selfEditorFocus.getSheetId(), this._selfEditorFocus.getRow(), this._selfEditorFocus.getColumn());
            }
        }
    }

    private void syncFriendFocusPosition(int left, int top, int right, int bottom) {
        int row = -1;
        int col = -1;
        for (Focus focus : new ArrayList<Focus>(this._friendFocuses.values())) {
            row = focus.getRow();
            col = focus.getColumn();
            if (col < left || col > right || row < top || row > bottom) continue;
            this.addOrMoveFriendFocus(focus.getId(), focus.getName(), focus.getColor(), focus.getSheetId(), row, col);
        }
    }

    public void service(AuRequest request, boolean everError) {
        String cmd = request.getCommand();
        if ("onCellHyperlink".equals(cmd)) {
            CellHyperlinkEvent evt = CellHyperlinkEvent.getHyperlinkEvent(request);
            if (evt != null) {
                if (evt.getType() == Hyperlink.HyperlinkType.DOCUMENT) {
                    String addr = evt.getAddress();
                    Object[] objs = Spreadsheet.parseLinkAddress(this.getBook(), addr);
                    SName name = (SName)objs[0];
                    String sheetScopeName = (String)objs[1];
                    if (name != null) {
                        CellRegion rgn = name.getRefersToCellRegion();
                        String sheetname = name.getRefersToSheetName();
                        Sheet sheet = this.getBook().getSheet(sheetname);
                        if (sheet == null) {
                            Messagebox.show((String)Labels.getLabel((String)"zssex.dlg.hyperlink.ref_not_valid"));
                            return;
                        }
                        if (!sheet.isHidden()) {
                            int top;
                            int left = rgn.getColumn();
                            int row = top = rgn.getRow();
                            int col = left;
                            int right = rgn.getLastColumn();
                            int bottom = rgn.getLastRow();
                            boolean cacheInClient = false;
                            this.setSelectedSheetDirectly(sheetname, false, row, col, left, top, right, bottom);
                        }
                    } else if (!Strings.isBlank((String)addr)) {
                        try {
                            AreaReference area = new AreaReference(addr);
                            CellReference cell1 = area.getFirstCell();
                            String sheetname = cell1.getSheetName();
                            Sheet sheet = this.getBook().getSheet(sheetname);
                            if (sheet == null) {
                                Messagebox.show((String)Labels.getLabel((String)"zssex.dlg.hyperlink.ref_not_valid"));
                                return;
                            }
                            if (!sheet.isHidden()) {
                                int top;
                                short left = cell1.getCol();
                                int row = top = cell1.getRow();
                                short col = left;
                                CellReference cell2 = area.isSingleCell() ? null : area.getLastCell();
                                short right = cell2 == null ? left : cell2.getCol();
                                int bottom = cell2 == null ? top : cell2.getRow();
                                boolean cacheInClient = false;
                                this.setSelectedSheetDirectly(sheetname, false, row, col, left, top, right, bottom);
                            }
                        }
                        catch (Exception ex) {
                            Messagebox.show((String)Labels.getLabel((String)"zssex.dlg.hyperlink.ref_not_valid"));
                            return;
                        }
                    }
                }
                Events.postEvent((Event)evt);
            }
            return;
        }
        Command command = InnerEvts.getCommand(cmd);
        if (command != null) {
            command.process(request);
            return;
        }
        super.service(request, everError);
    }

    public void smartUpdate(String attr, Object value) {
        super.smartUpdate(attr, value);
    }

    public void smartUpdate(String attr, Object value, boolean append) {
        super.smartUpdate(attr, value, append);
    }

    public void response(String key, AuResponse response) {
        super.response(key, response);
    }

    public void afterCompose() {
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        String uuid = this.getUuid();
        Desktop desktop = Executions.getCurrent().getDesktop();
        if (this._bookCleaner == null) {
            this._bookCleaner = new BookCleaner(uuid);
            desktop.addListener((Object)this._bookCleaner);
        }
    }

    public void onPageDetached(Page page) {
        super.onPageDetached(page);
        Book book = this.getBook();
        if (book != null) {
            String scope = book.getShareScope();
            if (this.isCleanBookAutomatically() && !Strings.isEmpty((String)scope)) {
                this.setBook(null);
            }
        }
        Desktop desktop = Executions.getCurrent().getDesktop();
        if (this._bookCleaner != null) {
            desktop.removeListener((Object)this._bookCleaner);
            this._bookCleaner = null;
        }
    }

    protected boolean isCleanBookAutomatically() {
        return true;
    }

    public Book getBook() {
        SBook book = this.getSBook();
        return book == null ? null : new BookImpl(new SimpleRef<SBook>(book));
    }

    public void setBook(Book book) {
        this.setSBook(book == null ? null : ((BookImpl)book).getNative());
    }

    public Sheet getSelectedSheet() {
        SSheet sheet = this.getSelectedSSheet();
        return sheet == null ? null : new SheetImpl(new SimpleRef<SBook>(sheet.getBook()), new SimpleRef<SSheet>(sheet));
    }

    public int getMaxVisibleColumns() {
        return this._maxColumns;
    }

    public int getMaxVisibleRows() {
        return this._maxRows;
    }

    public int getCurrentMaxVisibleColumns() {
        return this.getSheetMaxVisibleColumns(this.getSelectedSSheet());
    }

    public int getCurrentMaxVisibleRows() {
        return this.getSheetMaxVisibleRows(this.getSelectedSSheet());
    }

    public void setMaxVisibleColumns(int maxcols) {
        if (maxcols < 1) {
            throw new UiException("maxcolumn must be greater than 0: " + maxcols);
        }
        if (this._maxColumns != maxcols) {
            this._maxColumns = maxcols;
            this.refreshMaxVisibleColumns();
        }
    }

    public void setMaxVisibleRows(int maxrows) {
        if (maxrows < 1) {
            throw new UiException("maxrow must be greater than 0: " + maxrows);
        }
        if (this._maxRows != maxrows) {
            this._maxRows = maxrows;
            this.refreshMaxVisibleRows();
        }
    }

    private void refreshMaxVisibleColumns() {
        this.smartUpdate("maxColumns", this.getCurrentMaxVisibleColumns());
        if (this.getSelectedSheet() != null) {
            this.updateUnlockInfo();
        }
    }

    private void refreshMaxVisibleRows() {
        this.smartUpdate("maxRows", this.getCurrentMaxVisibleRows());
        if (this.getSelectedSheet() != null) {
            this.updateUnlockInfo();
        }
    }

    public Importer getImporter() {
        return this.getSImporter() == null ? null : new ImporterImpl(this.getSImporter());
    }

    public void setImporter(Importer importer) {
        this.setSImporter(importer == null ? null : ((ImporterImpl)importer).getNative());
    }

    public void clearClientCache(SSheet sheet) {
        ActiveRangeHelper helper;
        if (sheet == null) {
            return;
        }
        if (!this.getSBook().equals(sheet.getBook())) {
            return;
        }
        SSheet currentSheet = this.getSelectedSSheet();
        if (sheet != null && !sheet.equals(this.getSelectedSSheet()) && (helper = this.getActiveRangeHelper()).removeActiveRange(sheet) != null) {
            this.releaseClientCache(sheet.getId());
        }
    }

    private void refreshToolbarDisabled() {
        if (!this.isInvalidated()) {
            this.smartUpdate("actionDisabled", this.convertToDisabledActionJSON(this.getUserActionManagerCtrl().getSupportedUserAction(this.getSelectedSheet())));
        }
    }

    private void refreshAllowedOptions() {
        SheetProtection sheetProtection = Ranges.range(this.getSelectedSheet()).getSheetProtection();
        this.smartUpdate("allowSelectLockedCells", sheetProtection.isSelectLockedCellsAllowed());
        this.smartUpdate("allowSelectUnlockedCells", sheetProtection.isSelectUnlockedCellsAllowed());
        this.smartUpdate("allowFormatCells", sheetProtection.isFormatCellsAllowed());
        this.smartUpdate("allowFormatColumns", sheetProtection.isFormatColumnsAllowed());
        this.smartUpdate("allowFormatRows", sheetProtection.isFormatRowsAllowed());
        this.smartUpdate("allowAutoFilter", sheetProtection.isAutoFilterAllowed());
        this.smartUpdate("objectEditable", sheetProtection.isObjectsEditable());
    }

    private void updateUnlockInfo() {
        if (!this.hasDeferOperation("unlockInfo")) {
            this.addDeferOperation("unlockInfo", new DeferOperation(){

                @Override
                public void process() {
                    Spreadsheet.this.updateUnlockInfo0();
                }
            });
        }
    }

    private void updateUnlockInfo0() {
        SheetProtection sheetProtection;
        Sheet sht = this.getSelectedSheet();
        if (sht != null && !(sheetProtection = Ranges.range(sht).getSheetProtection()).isSelectLockedCellsAllowed() && sheetProtection.isSelectUnlockedCellsAllowed()) {
            JSONObject unlockInfo = this.createUnlockInfo(sht);
            this.smartUpdate("unlockInfo", unlockInfo);
        }
    }

    private JSONObject createUnlockInfo(Sheet sheet) {
        SCellStyle style;
        Iterator it;
        SSheet ssheet = sheet.getInternalSheet();
        int startColumn = ssheet.getStartColumnIndex();
        int endColumn = this.getCurrentMaxVisibleColumns();
        int startRow = ssheet.getStartRowIndex();
        int endRow = this.getCurrentMaxVisibleRows();
        JSONObject attrs = new JSONObject();
        JSONArray rows = new JSONArray();
        JSONArray columns = new JSONArray();
        JSONArray cells = new JSONArray();
        SSheet sht = sheet.getInternalSheet();
        if (startColumn != -1) {
            it = sht.getColumnArrayIterator();
            while (it.hasNext()) {
                SColumnArray ca = (SColumnArray)it.next();
                if (ca.getLastIndex() < startColumn) continue;
                if (ca.getIndex() > endColumn) break;
                style = ca.getCellStyle(true);
                if (style == null || style.isLocked()) continue;
                int start = Math.max(startColumn, ca.getIndex());
                int end = Math.min(endColumn, ca.getLastIndex());
                columns.add((Object)this.createUnlockGroup(start, end));
            }
        }
        if (startRow != -1) {
            it = sht.getRowIterator();
            while (it.hasNext()) {
                Iterator itc;
                SRow srow = (SRow)it.next();
                style = srow.getCellStyle(true);
                if (srow.getIndex() > endRow) break;
                int rowIdx = srow.getIndex();
                if (style != null && !style.isLocked()) {
                    rows.add((Object)rowIdx);
                }
                if (!(itc = srow.getCellIterator()).hasNext()) continue;
                int lockStart = -1;
                int lockPrev = -1;
                JSONArray lockData = new JSONArray();
                int start = -1;
                int prev = -1;
                JSONObject row = new JSONObject();
                JSONArray data = new JSONArray();
                row.put((Object)"i", (Object)rowIdx);
                while (itc.hasNext()) {
                    SCell cell = (SCell)itc.next();
                    int cellIdx = cell.getColumnIndex();
                    SCellStyle stylec = cell.getCellStyle(true);
                    if (stylec.isLocked()) {
                        if (lockStart == -1) {
                            lockStart = cellIdx;
                        } else if (lockPrev != cellIdx - 1) {
                            lockData.add((Object)this.createLockGroup(lockStart, lockPrev));
                            lockStart = cellIdx;
                        }
                        lockPrev = cellIdx;
                        if (start == -1) continue;
                        data.add((Object)this.createUnlockGroup(start, prev));
                        start = -1;
                        prev = -1;
                        continue;
                    }
                    if (start == -1) {
                        start = cellIdx;
                    } else if (prev != cellIdx - 1) {
                        data.add((Object)this.createUnlockGroup(start, prev));
                        start = cellIdx;
                    }
                    prev = cellIdx;
                    if (lockStart == -1) continue;
                    lockData.add((Object)this.createLockGroup(lockStart, lockPrev));
                    lockStart = -1;
                    lockPrev = -1;
                }
                if (start != -1) {
                    data.add((Object)this.createUnlockGroup(start, prev));
                }
                if (lockStart != -1) {
                    lockData.add((Object)this.createLockGroup(lockStart, lockPrev));
                }
                row.put((Object)"data", (Object)data);
                row.put((Object)"lockData", (Object)lockData);
                cells.add((Object)row);
            }
        }
        attrs.put((Object)"chs", (Object)columns);
        attrs.put((Object)"rhs", (Object)rows);
        attrs.put((Object)"cs", (Object)cells);
        return attrs;
    }

    private boolean hasDeferOperation(String name) {
        Execution exec = Executions.getCurrent();
        Map map = (Map)exec.getAttribute(_ZSS_DEFER_OP_MAP, false);
        return map != null && map.containsKey(name);
    }

    private void addDeferOperation(String name, DeferOperation op) {
        Execution exec = Executions.getCurrent();
        LinkedHashMap<String, DeferOperation> map = (LinkedHashMap<String, DeferOperation>)exec.getAttribute(_ZSS_DEFER_OP_MAP, false);
        if (map == null) {
            map = new LinkedHashMap<String, DeferOperation>();
            exec.setAttribute(_ZSS_DEFER_OP_MAP, map, false);
            Events.postEvent((int)-20000, (String)_ON_PROCESS_DEFER_OPERATIONS, (Component)this, map);
        }
        map.put(name, op);
    }

    private void processDeferOperations(Map<String, DeferOperation> map) {
        if (map != null) {
            for (DeferOperation op : map.values()) {
                op.process();
            }
        }
    }

    private JSONObject createUnlockGroup(int start, int end) {
        JSONObject group = new JSONObject();
        group.put((Object)"start", (Object)start);
        group.put((Object)"end", (Object)end);
        return group;
    }

    private JSONObject createLockGroup(int start, int end) {
        return this.createUnlockGroup(start, end);
    }

    private CellDisplayLoader getCellDisplayLoader() {
        if (this._cellDisplayLoader == null) {
            String cls = Library.getProperty((String)CELL_DISPLAY_LOADER_CLS);
            if (cls != null) {
                try {
                    this._cellDisplayLoader = (CellDisplayLoader)Spreadsheet.newInstance(cls);
                }
                catch (Exception x) {
                    throw new UiException((Throwable)x);
                }
            } else {
                this._cellDisplayLoader = new SimpleCellDisplayLoader();
            }
        }
        return this._cellDisplayLoader;
    }

    private DataValidationHandler getDataValidationHandler() {
        if (this._dataValidationHandler == null) {
            String cls = Library.getProperty((String)DATA_VALIDATION_HANDLER_CLS);
            if (cls != null) {
                try {
                    this._dataValidationHandler = (DataValidationHandler)Spreadsheet.newInstance(cls);
                }
                catch (Exception x) {
                    throw new UiException((Throwable)x);
                }
            } else {
                this._dataValidationHandler = new DummyDataValidationHandler();
            }
        }
        return this._dataValidationHandler;
    }

    private FreezeInfoLoader getFreezeInfoLoader() {
        if (this._freezeInfoLoader == null) {
            String cls = Library.getProperty((String)FREEZE_INFO_LOCADER_CLS);
            if (cls != null) {
                try {
                    this._freezeInfoLoader = (FreezeInfoLoader)Spreadsheet.newInstance(cls);
                }
                catch (Exception x) {
                    throw new UiException((Throwable)x);
                }
            } else {
                this._freezeInfoLoader = new DummyFreezeInfoLoader();
            }
        }
        return this._freezeInfoLoader;
    }

    public UndoableActionManager getUndoableActionManager() {
        if (this._undoableActionManager == null) {
            String cls = (String)this.getAttribute(UNDOABLE_ACTION_MANAGER_CLS, true);
            if (cls == null) {
                cls = Library.getProperty((String)UNDOABLE_ACTION_MANAGER_CLS);
            }
            if (cls != null) {
                try {
                    this._undoableActionManager = (UndoableActionManager)Spreadsheet.newInstance(cls);
                }
                catch (Exception x) {
                    throw new UiException((Throwable)x);
                }
            } else {
                this._undoableActionManager = new DummyUndoableActionManager();
            }
            this._undoableActionManager.bind(this);
        }
        return this._undoableActionManager;
    }

    private void clearUndoableActionManager() {
        if (this._undoableActionManager != null) {
            this._undoableActionManager.clear();
        }
    }

    public boolean isKeepCellSelection() {
        return this._keepCellSelection;
    }

    public void setKeepCellSelection(boolean keep) {
        if (this._keepCellSelection != keep) {
            this._keepCellSelection = keep;
            this.smartUpdate("keepCellSelection", this._keepCellSelection);
        }
    }

    public int getSheetMaxVisibleRows(SSheet sheet) {
        if (sheet == null) {
            return this._maxRows > 0 ? this._maxRows : 200;
        }
        String sheetId = sheet.getId();
        int[] maxRowsCols = this._sheetMaxRowsCols.get(sheetId);
        if (this._maxRows <= 0 && maxRowsCols == null) {
            maxRowsCols = new int[2];
            this.initSheetMaxRowsCols(sheet, maxRowsCols);
        }
        return this._maxRows > 0 ? this._maxRows : maxRowsCols[0];
    }

    public int getSheetMaxVisibleColumns(SSheet sheet) {
        if (sheet == null) {
            return this._maxColumns > 0 ? this._maxColumns : 40;
        }
        String sheetId = sheet.getId();
        int[] maxRowsCols = this._sheetMaxRowsCols.get(sheetId);
        if (this._maxColumns <= 0 && maxRowsCols == null) {
            maxRowsCols = new int[2];
            this.initSheetMaxRowsCols(sheet, maxRowsCols);
        }
        return this._maxColumns > 0 ? this._maxColumns : maxRowsCols[1];
    }

    private void initSheetMaxRowsCols(SSheet sheet, int[] maxRowsCols) {
        CellRegion region = sheet.getDataRegion();
        if (region != null) {
            int maxRows = region.lastRow + 2;
            int maxCols = region.lastColumn + 2;
            if (maxRows > SpreadsheetVersion.EXCEL2007.getMaxRows()) {
                maxRows = SpreadsheetVersion.EXCEL2007.getMaxRows();
            } else if (maxRows < 200) {
                maxRows = 200;
            }
            if (maxCols > SpreadsheetVersion.EXCEL2007.getMaxColumns()) {
                maxCols = SpreadsheetVersion.EXCEL2007.getMaxColumns();
            } else if (maxCols < 40) {
                maxCols = 40;
            }
            maxRowsCols[0] = maxRows;
            maxRowsCols[1] = maxCols;
        } else {
            maxRowsCols[0] = 200;
            maxRowsCols[1] = 40;
        }
        this._sheetMaxRowsCols.put(sheet.getId(), maxRowsCols);
    }

    public void setSheetMaxVisibleRows(SSheet sheet, int maxRows) {
        if (sheet == null) {
            return;
        }
        if (this._maxRows > 0) {
            if (maxRows <= SpreadsheetVersion.EXCEL2007.getLastRowIndex() && this._maxRows != maxRows) {
                this._maxRows = maxRows;
                this.refreshMaxVisibleRows();
            }
        } else {
            String sheetId = sheet.getId();
            int[] maxRowsCols = this._sheetMaxRowsCols.get(sheetId);
            if (maxRowsCols[0] < SpreadsheetVersion.EXCEL2007.getLastRowIndex() && maxRowsCols[0] != maxRows) {
                maxRowsCols[0] = maxRows;
                this.refreshMaxVisibleRows();
            }
        }
    }

    public void setSheetMaxVisibleColumns(SSheet sheet, int maxColumns) {
        if (sheet == null) {
            return;
        }
        if (this._maxColumns > 0) {
            if (maxColumns <= SpreadsheetVersion.EXCEL2007.getLastRowIndex() && this._maxColumns != maxColumns) {
                this._maxColumns = maxColumns;
                this.refreshMaxVisibleColumns();
            }
        } else {
            String sheetId = sheet.getId();
            int[] maxRowsCols = this._sheetMaxRowsCols.get(sheetId);
            if (maxRowsCols[1] < SpreadsheetVersion.EXCEL2007.getLastColumnIndex() && maxRowsCols[1] != maxColumns) {
                maxRowsCols[1] = maxColumns;
                this.refreshMaxVisibleColumns();
            }
        }
    }

    public void setShowAddRow(boolean showAddRow) {
        if (this._showAddRow != showAddRow) {
            this._showAddRow = showAddRow;
            this.smartUpdate("showAddRow", this._showAddRow);
        }
    }

    public boolean isShowAddRow() {
        return this._showAddRow;
    }

    public void setShowAddColumn(boolean showAddColumn) {
        if (this._showAddColumn != showAddColumn) {
            this._showAddColumn = showAddColumn;
            this.smartUpdate("showAddColumn", this._showAddColumn);
        }
    }

    public boolean isShowAddColumn() {
        return this._showAddColumn;
    }

    public static Object[] parseLinkAddress(Book book, String linkAddress) {
        String[] split = linkAddress.split("!");
        String sheetScope = split.length == 1 ? null : split[0];
        String ref = split.length > 1 ? split[1] : split[0];
        String rawSheetName = sheetScope == null ? null : SheetNameFormatter.unformat((String)sheetScope);
        SName docSelectedName = book.getInternalBook().getNameByName(ref, rawSheetName);
        return new Object[]{docSelectedName, sheetScope, ref};
    }

    public void notifyLoadedAreaChange() {
        SpreadsheetCtrl ssctrl = (SpreadsheetCtrl)this.getExtraCtrl();
        this.notifyAreaChange(ssctrl.getLoadedArea());
    }

    public void notifyVisibleAreaChange() {
        SSheet currentSheet = this.getSelectedSSheet();
        this.response((AuResponse)new AuInvoke((Component)this, "_releaseSelectedCache", (Object)currentSheet.getId()));
        SpreadsheetCtrl ssctrl = (SpreadsheetCtrl)this.getExtraCtrl();
        this.notifyAreaChange(ssctrl.getVisibleArea());
    }

    private void notifyAreaChange(AreaRef area) {
        int l = area.getColumn();
        int t = area.getRow();
        int r = area.getLastColumn();
        int b = area.getLastRow();
        SpreadsheetCtrl ssctrl = (SpreadsheetCtrl)this.getExtraCtrl();
        FreezeInfoLoader freezeInfo = ssctrl.getFreezeInfoLoader();
        Sheet sheet = this.getSelectedSheet();
        Ranges.range(sheet, area).notifyChange();
        int col = freezeInfo.getColumnFreeze(sheet);
        int row = freezeInfo.getRowFreeze(sheet);
        if (row >= 0 && col >= 0 && t != 0 && l != 0) {
            Ranges.range(sheet, 0, 0, row, col).notifyChange();
        }
        if (row >= 0 && t != 0) {
            Ranges.range(sheet, 0, l, row, r).notifyChange();
        }
        if (col >= 0 && l != 0) {
            Ranges.range(sheet, t, 0, b, col).notifyChange();
        }
    }

    public void setIgnoreAutoHeight(boolean b) {
        if (this._ignoreAutoHeight != b) {
            this._ignoreAutoHeight = b;
            if (!b) {
                this.invalidate();
            } else {
                this.smartUpdate("ignoreAutoHeight", b);
            }
        }
    }

    private static final Object newInstance(String clsName) throws NoSuchMethodException, InstantiationException, InvocationTargetException, ClassNotFoundException, IllegalAccessException {
        return Classes.newInstance(Class.forName(clsName), null, null);
    }

    static {
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellSelection", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellSelectionUpdate", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellFocus", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onHeaderUpdate", (int)3);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onSheetSelect", (int)8195);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellClick", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellRightClick", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellDoubleClick", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onHeaderClick", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onHeaderRightClick", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onHeaderDoubleClick", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onEditboxEditing", (int)0);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onStartEditing", (int)3);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onStopEditing", (int)3);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellHyperlink", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellFilter", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCellValidator", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onCtrlKey", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onAuxAction", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onWidgetCtrlKey", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onWidgetUpdate", (int)8192);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onZSSCellMouse", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onZSSHeaderMouse", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onZSSCellFetch", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onZSSFetchActiveRange", (int)8193);
        Spreadsheet.addClientEvent(Spreadsheet.class, (String)"onZSSSyncBlock", (int)8193);
    }

    private static interface DeferOperation
    extends Serializable {
        public void process();
    }

    private static class BookCleaner
    implements DesktopCleanup,
    Serializable {
        private String _ssid;

        public BookCleaner(String ssid) {
            this._ssid = ssid;
        }

        public void cleanup(Desktop desktop) throws Exception {
            Component comp = desktop.getComponentByUuid(this._ssid);
            if (comp instanceof Spreadsheet) {
                try {
                    ((Spreadsheet)comp).releaseBook();
                    ((Spreadsheet)comp).setSrc(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public class HelperContainer<T> {
        HashMap<String, T> helpers = new HashMap();

        public T getHelper(String sheetId) {
            return this.helpers.get(sheetId);
        }

        public void putHelper(String sheetId, T helper) {
            this.helpers.put(sheetId, helper);
        }

        public void removeHelper(String sheetId) {
            this.helpers.remove(sheetId);
        }
    }

    private static class FriendFocus
    extends Focus {
        public FriendFocus(String id, String name, String color, String sheetId, int row, int col) {
            super(id, name, color, sheetId, row, col, null);
        }
    }

    private class ExtraCtrl
    implements SpreadsheetCtrl,
    SpreadsheetInCtrl,
    SpreadsheetOutCtrl,
    DynamicMedia {
        private ExtraCtrl() {
        }

        @Override
        public void setUserActionManagerCtrl(UserActionManagerCtrl actionHandler) {
            Spreadsheet.this.setUserActionManagerCtrl(actionHandler);
        }

        @Override
        public UserActionManagerCtrl getUserActionManagerCtrl() {
            return Spreadsheet.this.getUserActionManagerCtrl();
        }

        public Media getMedia(String pathInfo) {
            if (Spreadsheet.isIE9()) {
                int bj = pathInfo.indexOf(".basic.x");
                if (bj > 0) {
                    return new AMedia("css", "css", "text/css;charset=UTF-8", Spreadsheet.this.getIE9BasicStyleSheet());
                }
                int hj = pathInfo.indexOf(".colheader.");
                if (hj > 0) {
                    String dotIndex = pathInfo.substring(hj + 11);
                    return new AMedia("css", "css", "text/css;charset=UTF-8", Spreadsheet.this.getIE9ColHeaderStyleSheet(dotIndex));
                }
                int rj = pathInfo.indexOf(".rowheader.");
                if (rj > 0) {
                    String dotIndex = pathInfo.substring(rj + 11);
                    return new AMedia("css", "css", "text/css;charset=UTF-8", Spreadsheet.this.getIE9RowHeaderStyleSheet(dotIndex));
                }
                int mj = pathInfo.indexOf(".merge.");
                if (mj > 0) {
                    String dotIndex = pathInfo.substring(mj + 7);
                    return new AMedia("css", "css", "text/css;charset=UTF-8", Spreadsheet.this.getIE9MergeStyleSheet(dotIndex));
                }
                int oj = pathInfo.indexOf(".other.x");
                if (oj > 0) {
                    return new AMedia("css", "css", "text/css;charset=UTF-8", Spreadsheet.this.getIE9OtherStyleSheet());
                }
            }
            return new AMedia("css", "css", "text/css;charset=UTF-8", Spreadsheet.this.getSheetDefaultRules());
        }

        @Override
        public void setColumnSize(String sheetId, int column, int newsize, int id, boolean hidden) {
            SSheet xsheet = Spreadsheet.this.getSelectedSheetId().equals(sheetId) ? Spreadsheet.this.getSelectedSSheet() : Spreadsheet.this._book.getSheetById(sheetId);
            HeaderPositionHelper helper = Spreadsheet.this.getColumnPositionHelper(xsheet);
            helper.setInfoValues(column, newsize, id, hidden, true);
            SheetImpl sheet = new SheetImpl(new SimpleRef<SBook>(xsheet.getBook()), new SimpleRef<SSheet>(xsheet));
            if (sheet.isProtected() && !xsheet.getSheetProtection().isFormatColumns()) {
                return;
            }
            UndoableActionManager uam = Spreadsheet.this.getUndoableActionManager();
            if (hidden) {
                uam.doAction(new HideHeaderAction(Labels.getLabel((String)"zss.undo.hideColumn"), (Sheet)sheet, 0, column, 0, column, HideHeaderAction.Type.COLUMN, hidden));
            } else {
                uam.doAction(new AggregatedAction(Labels.getLabel((String)"zss.undo.columnSize"), new UndoableAction[]{new HideHeaderAction(null, (Sheet)sheet, 0, column, 0, column, HideHeaderAction.Type.COLUMN, hidden), new ResizeHeaderAction(null, sheet, 0, column, 0, column, ResizeHeaderAction.Type.COLUMN, newsize, true)}));
            }
        }

        @Override
        public void setRowSize(String sheetId, int row, int newsize, int id, boolean hidden, boolean isCustom) {
            SSheet xsheet = Spreadsheet.this.getSelectedSheetId().equals(sheetId) ? Spreadsheet.this.getSelectedSSheet() : Spreadsheet.this._book.getSheetById(sheetId);
            HeaderPositionHelper helper = Spreadsheet.this.getRowPositionHelper(xsheet);
            helper.setInfoValues(row, newsize, id, hidden, isCustom);
            SheetImpl sheet = new SheetImpl(new SimpleRef<SBook>(xsheet.getBook()), new SimpleRef<SSheet>(xsheet));
            if (sheet.isProtected()) {
                return;
            }
            UndoableActionManager uam = Spreadsheet.this.getUndoableActionManager();
            if (hidden) {
                uam.doAction(new HideHeaderAction(Labels.getLabel((String)"zss.undo.hideRow"), (Sheet)sheet, row, 0, row, 0, HideHeaderAction.Type.ROW, hidden));
            } else if (isCustom) {
                uam.doAction(new AggregatedAction(Labels.getLabel((String)"zss.undo.rowSize"), new UndoableAction[]{new HideHeaderAction(null, (Sheet)sheet, row, 0, row, 0, HideHeaderAction.Type.ROW, hidden), new ResizeHeaderAction(null, sheet, row, 0, row, 0, ResizeHeaderAction.Type.ROW, newsize, isCustom)}));
            } else {
                CellOperationUtil.setRowHeight(Ranges.range(sheet, row, 0, row, 0).toRowRange(), newsize, isCustom);
            }
        }

        @Override
        public HeaderPositionHelper getColumnPositionHelper(String sheetId) {
            SSheet sheet = Spreadsheet.this.getSelectedSheetId().equals(sheetId) ? Spreadsheet.this.getSelectedSSheet() : Spreadsheet.this._book.getSheetById(sheetId);
            HeaderPositionHelper helper = Spreadsheet.this.getColumnPositionHelper(sheet);
            return helper;
        }

        @Override
        public HeaderPositionHelper getRowPositionHelper(String sheetId) {
            SSheet sheet = Spreadsheet.this.getSelectedSheetId().equals(sheetId) ? Spreadsheet.this.getSelectedSSheet() : Spreadsheet.this._book.getSheetById(sheetId);
            HeaderPositionHelper helper = Spreadsheet.this.getRowPositionHelper(sheet);
            return helper;
        }

        @Override
        public MergeMatrixHelper getMergeMatrixHelper(SSheet sheet) {
            return Spreadsheet.this.getMergeMatrixHelper(sheet);
        }

        @Override
        public AreaRef getSelectionArea() {
            return (AreaRef)Spreadsheet.this._selectionArea.cloneSelf();
        }

        @Override
        public AreaRef getFocusArea() {
            return (AreaRef)Spreadsheet.this._focusArea.cloneSelf();
        }

        @Override
        public void setSelectionRect(int left, int top, int right, int bottom) {
            Spreadsheet.this._selectionArea.setArea(top, left, bottom, right);
        }

        @Override
        public void setFocusRect(int left, int top, int right, int bottom) {
            Spreadsheet.this._focusArea.setArea(top, left, bottom, right);
        }

        @Override
        public AreaRef getLoadedArea() {
            AreaRef rect = Spreadsheet.this.getActiveRangeHelper().getArea(Spreadsheet.this._selectedSheet);
            if (rect == null) {
                return null;
            }
            return (AreaRef)rect.cloneSelf();
        }

        @Override
        public void setLoadedRect(int left, int top, int right, int bottom) {
            Spreadsheet.this.getActiveRangeHelper().setActiveRange(Spreadsheet.this._selectedSheet, top, left, bottom, right);
            this.getWidgetHandler().onLoadOnDemand(Spreadsheet.this.getSelectedSSheet(), left, top, right, bottom);
        }

        @Override
        public void setVisibleRect(int left, int top, int right, int bottom) {
            this.updateIE9StyleSheet(left, top, right, bottom);
            Spreadsheet.this._visibleArea.setArea(top, left, bottom, right);
            this.getWidgetHandler().onLoadOnDemand(Spreadsheet.this.getSelectedSSheet(), left, top, right, bottom);
        }

        private void updateIE9StyleSheet(int left, int top, int right, int bottom) {
            if (Spreadsheet.isIE9()) {
                int vright = Spreadsheet.this._cssArea.getLastColumn();
                int vbottom = Spreadsheet.this._cssArea.getLastRow();
                int vleft = Spreadsheet.this._cssArea.getColumn();
                int vtop = Spreadsheet.this._cssArea.getRow();
                if (vright < 0) {
                    vright = Spreadsheet.this.getInitColumnSize();
                    vbottom = Spreadsheet.this.getInitRowSize();
                    left = 0;
                    vtop = 0;
                    Spreadsheet.this._cssArea.setArea(vtop, vleft, vbottom, vright);
                    return;
                }
                if (vright < right || vbottom < bottom || vleft > left || vtop > top) {
                    Spreadsheet.this._cssArea.setArea(top, left, bottom, right);
                    SSheet sheet = Spreadsheet.this._selectedSheet;
                    String css = Spreadsheet.getDynamicMediaURI((AbstractComponent)Spreadsheet.this, Spreadsheet.this._cssVersion++, "ss_" + Spreadsheet.this.getUuid() + "_" + Spreadsheet.this.getSelectedSheetId(), "css");
                    Spreadsheet.this.smartUpdate("scss", css);
                }
            }
        }

        @Override
        public AreaRef getVisibleArea() {
            return (AreaRef)Spreadsheet.this._visibleArea.cloneSelf();
        }

        @Override
        public boolean addWidget(Widget widget) {
            return Spreadsheet.this.addWidget(widget);
        }

        @Override
        public boolean removeWidget(Widget widget) {
            return Spreadsheet.this.removeWidget(widget);
        }

        @Override
        public WidgetHandler getWidgetHandler() {
            return Spreadsheet.this.getWidgetHandler();
        }

        @Override
        public JSONObject getRowHeaderAttrs(SSheet sheet, int rowStart, int rowEnd) {
            return this.getHeaderAttrs(sheet, true, rowStart, rowEnd);
        }

        @Override
        public JSONObject getColumnHeaderAttrs(SSheet sheet, int colStart, int colEnd) {
            return this.getHeaderAttrs(sheet, false, colStart, colEnd);
        }

        private JSONObject getHeaderAttrs(SSheet sheet, boolean isRow, int start, int end) {
            JSONObject attrs = new JSONObject();
            attrs.put((Object)"s", (Object)start);
            attrs.put((Object)"e", (Object)end);
            JSONArray headers = new JSONArray();
            attrs.put((Object)"hs", (Object)headers);
            if (isRow) {
                attrs.put((Object)"t", (Object)"r");
                for (int row = start; row <= end; ++row) {
                    headers.add((Object)this.getRowHeaderAttrs(sheet, row));
                }
            } else {
                attrs.put((Object)"t", (Object)"c");
                for (int col = start; col <= end; ++col) {
                    headers.add((Object)this.getColumnHeaderAttrs(sheet, col));
                }
            }
            return attrs;
        }

        private JSONObject getColumnHeaderAttrs(SSheet sheet, int col) {
            JSONObject attrs = new JSONObject();
            attrs.put((Object)"t", (Object)Spreadsheet.this.getColumntitle(col));
            HeaderPositionHelper colHelper = Spreadsheet.this.getColumnPositionHelper(sheet);
            HeaderPositionHelper.HeaderPositionInfo info = colHelper.getInfo(col);
            if (info != null) {
                attrs.put((Object)"p", (Object)info.id);
            }
            return attrs;
        }

        private JSONObject getRowHeaderAttrs(SSheet sheet, int row) {
            JSONObject attrs = new JSONObject();
            attrs.put((Object)"t", (Object)Spreadsheet.this.getRowtitle(row));
            HeaderPositionHelper rowHelper = Spreadsheet.this.getRowPositionHelper(sheet);
            HeaderPositionHelper.HeaderPositionInfo info = rowHelper.getInfo(row);
            if (info != null) {
                attrs.put((Object)"p", (Object)info.id);
            }
            return attrs;
        }

        @Override
        @Deprecated
        public JSONObject getRangeAttrs(SSheet sheet, SpreadsheetCtrl.Header containsHeader, int left, int top, int right, int bottom) {
            return this.getRangeAttrs(sheet, containsHeader, SpreadsheetCtrl.CellAttribute.ALL, left, top, right, bottom);
        }

        @Override
        public JSONObject getRangeAttrs(SSheet sheet, SpreadsheetCtrl.Header containsHeader, SpreadsheetCtrl.CellAttribute type, int left, int top, int right, int bottom) {
            boolean addColumnHeader;
            JSONObject attrs = new JSONObject();
            attrs.put((Object)"id", (Object)sheet.getId());
            attrs.put((Object)"l", (Object)left);
            attrs.put((Object)"t", (Object)top);
            attrs.put((Object)"r", (Object)right);
            attrs.put((Object)"b", (Object)bottom);
            attrs.put((Object)"at", (Object)type);
            JSONArray rows = new JSONArray();
            attrs.put((Object)"rs", (Object)rows);
            StringAggregation styleAggregation = new StringAggregation();
            StringAggregation textAggregation = new StringAggregation();
            MergeAggregation mergeAggregation = new MergeAggregation(this.getMergeMatrixHelper(sheet));
            for (int row = top; row <= bottom; ++row) {
                JSONObject r = this.getRowAttrs(row);
                rows.add((Object)r);
                JSONArray cells = new JSONArray();
                r.put((Object)"cs", (Object)cells);
                for (int col = left; col <= right; ++col) {
                    cells.add((Object)this.getCellAttr(sheet, type, row, col, styleAggregation, textAggregation, mergeAggregation));
                }
            }
            attrs.put((Object)"s", (Object)textAggregation.getJSONArray());
            attrs.put((Object)"st", (Object)styleAggregation.getJSONArray());
            attrs.put((Object)"m", (Object)mergeAggregation.getJSONObject());
            boolean addRowColumnHeader = true;
            boolean addRowHeader = addRowColumnHeader || containsHeader == SpreadsheetCtrl.Header.ROW;
            boolean bl = addColumnHeader = addRowColumnHeader || containsHeader == SpreadsheetCtrl.Header.COLUMN;
            if (addRowHeader) {
                attrs.put((Object)"rhs", (Object)this.getRowHeaderAttrs(sheet, top, bottom));
            }
            if (addColumnHeader) {
                attrs.put((Object)"chs", (Object)this.getColumnHeaderAttrs(sheet, left, right));
            }
            return attrs;
        }

        public JSONObject getRowAttrs(int row) {
            SSheet sheet = Spreadsheet.this.getSelectedSSheet();
            HeaderPositionHelper helper = Spreadsheet.this.getRowPositionHelper(sheet);
            JSONObject attrs = new JSONObject();
            attrs.put((Object)"r", (Object)row);
            HeaderPositionHelper.HeaderPositionInfo info = helper.getInfo(row);
            if (info != null) {
                attrs.put((Object)"h", (Object)info.id);
                if (info.hidden) {
                    attrs.put((Object)"hd", (Object)"t");
                }
            }
            return attrs;
        }

        public JSONObject getCellAttr(SSheet sheet, SpreadsheetCtrl.CellAttribute type, int row, int col, StringAggregation styleAggregation, StringAggregation textAggregation, MergeAggregation mergeAggregation) {
            int textwidth;
            SComment comment;
            SCellStyle tbCellStyle;
            boolean updateAll = type == SpreadsheetCtrl.CellAttribute.ALL;
            boolean updateText = updateAll || type == SpreadsheetCtrl.CellAttribute.TEXT;
            boolean updateStyle = updateAll || type == SpreadsheetCtrl.CellAttribute.STYLE;
            boolean updateSize = updateAll || type == SpreadsheetCtrl.CellAttribute.SIZE;
            boolean updateMerge = updateAll || type == SpreadsheetCtrl.CellAttribute.MERGE;
            boolean updateComment = updateAll || type == SpreadsheetCtrl.CellAttribute.COMMENT;
            SCell cell = sheet.getCell(row, col);
            JSONObject attrs = new JSONObject();
            MergeAggregation.MergeIndex mergeIndex = mergeAggregation.add(row, col);
            if (updateMerge && mergeIndex != null) {
                attrs.put((Object)"mi", (Object)mergeIndex.getMergeId());
                attrs.put((Object)"mc", (Object)mergeIndex.getMergeCSSId());
            }
            if (updateSize && cell != null) {
                SCellStyle cellStyle = cell.getCellStyle();
                if (cell.getType() == SCell.CellType.STRING && mergeIndex == null && !cellStyle.isWrapText()) {
                    int overflowOptions = 1;
                    SCell sibling = null;
                    if (CellFormatHelper.getRealAlignment(cell) == SCellStyle.Alignment.LEFT) {
                        sibling = sheet.getCell(row, col + 1);
                    } else if (CellFormatHelper.getRealAlignment(cell) == SCellStyle.Alignment.RIGHT) {
                        sibling = sheet.getCell(row, col - 1);
                    }
                    if (sibling != null && sibling.getType() != SCell.CellType.BLANK) {
                        overflowOptions |= 2;
                    }
                    attrs.put((Object)"ovf", (Object)overflowOptions);
                } else {
                    ((AbstractCellAdv)cell).setTextWidth(-1);
                }
            }
            ConditionalStyleImpl cdCellStyle = ((AbstractSheetAdv)sheet).getConditionalFormattingStyle(row, col);
            SCellStyle cellStyle = sheet.getCell(row, col).getCellStyle();
            CellFormatHelper cfh = new CellFormatHelper(sheet, row, col, this.getMergeMatrixHelper(sheet), (SConditionalStyle)cdCellStyle);
            StringBuffer doubleBorder = new StringBuffer(8);
            FormatResult ft = updateStyle || updateText ? cfh.getFormatResult() : null;
            STable table = ((AbstractSheetAdv)sheet).getTableByRowCol(row, col);
            SCellStyle sCellStyle = tbCellStyle = table != null ? ((AbstractTableAdv)table).getCellStyle(row, col) : null;
            if (updateStyle) {
                boolean dbar;
                String af;
                String db;
                boolean locked;
                String fontStyle;
                String innerStyle;
                String style = cfh.getHtmlStyle(doubleBorder, table, tbCellStyle);
                if (!Strings.isEmpty((String)style)) {
                    int idx = styleAggregation.add(style);
                    attrs.put((Object)"s", (Object)idx);
                }
                if (!Strings.isEmpty((String)(innerStyle = cfh.getInnerHtmlStyle()))) {
                    int idx = styleAggregation.add(innerStyle);
                    attrs.put((Object)"is", (Object)idx);
                }
                if (!Strings.isEmpty((String)(fontStyle = cfh.getRealHtmlStyle(ft, tbCellStyle)))) {
                    int idx = styleAggregation.add(fontStyle);
                    attrs.put((Object)"os", (Object)idx);
                }
                if (cfh.hasRightBorder(table, tbCellStyle)) {
                    attrs.put((Object)"rb", (Object)1);
                }
                if (!(locked = cellStyle.isLocked())) {
                    attrs.put((Object)"l", (Object)"f");
                }
                if (!"____".equals(db = doubleBorder.toString())) {
                    attrs.put((Object)"db", (Object)db);
                }
                if (!"____".equals(af = cfh.getAutoFilterBorder())) {
                    attrs.put((Object)"af", (Object)("af" + af));
                }
                if (dbar = cfh.withDataBarBorder()) {
                    attrs.put((Object)"dbar", (Object)true);
                }
            }
            if (updateComment && (comment = cell.getComment()) != null) {
                SRichText rstr = comment.getRichText();
                String html = RichTextHelper.getCellRichTextHtml((SCell)cell, (SRichText)rstr, (boolean)true);
                boolean visible = comment.isVisible();
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("t", html);
                map.put("v", visible);
                attrs.put((Object)"cmt", map);
            }
            if (!cell.isNull()) {
                SCell.CellType cellType = cell.getType();
                if (cellType != SCell.CellType.BLANK) {
                    attrs.put((Object)"ct", (Object)cellType.value());
                }
                if (updateText && (cellType != SCell.CellType.BLANK || cell.getHyperlink() != null)) {
                    String cellText = Spreadsheet.this.getCellDisplayLoader().getCellHtmlText(sheet, row, col, ft, tbCellStyle, (SConditionalStyle)cdCellStyle);
                    String editText = cfh.getCellEditText();
                    String formatText = cfh.getCellFormattedText(ft);
                    if (Objects.equals((Object)cellText, (Object)editText) && Objects.equals((Object)editText, (Object)formatText)) {
                        attrs.put((Object)"meft", (Object)textAggregation.add(cellText));
                    } else {
                        attrs.put((Object)"t", (Object)textAggregation.add(cellText));
                        attrs.put((Object)"et", (Object)textAggregation.add(editText));
                        attrs.put((Object)"ft", (Object)textAggregation.add(formatText));
                    }
                }
                if (updateStyle) {
                    SFont.Underline fontUnderline;
                    boolean isUnderline;
                    int indention;
                    boolean wrap = cellStyle.isWrapText();
                    if (wrap) {
                        attrs.put((Object)"wp", (Object)1);
                    }
                    if ((indention = cellStyle.getIndention()) > 0) {
                        attrs.put((Object)"ind", (Object)indention);
                    }
                    SCellStyle.Alignment horizontalAlignment = CellFormatHelper.getRealAlignment(cell);
                    switch (horizontalAlignment) {
                        case CENTER: 
                        case CENTER_SELECTION: {
                            attrs.put((Object)"ha", (Object)"c");
                            break;
                        }
                        case RIGHT: {
                            attrs.put((Object)"ha", (Object)"r");
                            break;
                        }
                    }
                    SCellStyle.VerticalAlignment verticalAlignment = cellStyle.getVerticalAlignment();
                    switch (verticalAlignment) {
                        case TOP: {
                            attrs.put((Object)"va", (Object)"t");
                            break;
                        }
                        case CENTER: {
                            attrs.put((Object)"va", (Object)"c");
                        }
                    }
                    SFont font = StyleUtil.getFontStyle((SBook)sheet.getBook(), (SCellStyle)cellStyle, (SCellStyle)tbCellStyle, (SConditionalStyle)cdCellStyle);
                    int fontSize = font.getHeightPoints();
                    attrs.put((Object)"fs", (Object)fontSize);
                    int ff = 0;
                    if (font.isItalic()) {
                        ff |= 2;
                    }
                    if (font.isStrikeout()) {
                        ff |= 8;
                    }
                    boolean bl = isUnderline = (fontUnderline = font.getUnderline()) == SFont.Underline.SINGLE || fontUnderline == SFont.Underline.SINGLE_ACCOUNTING;
                    if (isUnderline) {
                        ff |= 4;
                    }
                    if (font.getBoldweight() == SFont.Boldweight.BOLD) {
                        ff |= 1;
                    }
                    attrs.put((Object)"ff", (Object)ff);
                    int rotate = cellStyle.getRotation();
                    attrs.put((Object)"rot", (Object)rotate);
                }
            }
            if (((AbstractCellAdv)cell).isCalcAutoHeight()) {
                attrs.put((Object)"_cah", (Object)true);
            }
            if ((textwidth = ((AbstractCellAdv)cell).getTextWidth()) >= 0) {
                attrs.put((Object)"wd", (Object)textwidth);
            }
            return attrs;
        }

        @Override
        public void insertColumns(SSheet sheet, int col, int size) {
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            if (size <= 0) {
                throw new UiException("size must > 0 : " + size);
            }
            int maxCols = Spreadsheet.this.getSheetMaxVisibleColumns(sheet);
            if (col > maxCols) {
                return;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("type", "column");
            result.put("col", col);
            result.put("size", size);
            AreaRef rect = Spreadsheet.this.getActiveRangeHelper().getArea(Spreadsheet.this._selectedSheet);
            if (rect == null) {
                return;
            }
            int right = size + rect.getLastColumn();
            HeaderPositionHelper colHelper = Spreadsheet.this.getColumnPositionHelper(sheet);
            colHelper.shiftMeta(col, size);
            result.put("hs", this.getColumnHeaderAttrs(Spreadsheet.this._selectedSheet, col, right));
            result.put("maxcol", maxCols);
            result.put("colfreeze", Spreadsheet.this.getSelectedSheetColumnfreeze());
            Spreadsheet.this.response("insertRowColumn" + XUtils.nextUpdateId(), new AuInsertRowColumn((Component)Spreadsheet.this, "", sheet.getId(), result));
            rect.setLastColumn(right);
            int left = col;
            right = left + size - 1;
            right = right >= maxCols - 1 ? maxCols - 1 : right;
            int top = rect.getRow();
            int bottom = rect.getLastRow();
            if (log.isLoggable(Level.INFO)) {
                log.info("update cells when insert column " + col + ",size:" + size + ":" + left + "," + top + "," + right + "," + bottom);
            }
            Spreadsheet.this.updateCell(sheet, left, top, right, bottom, SpreadsheetCtrl.CellAttribute.ALL);
            int rowFreeze = Spreadsheet.this.getSelectedSheetRowfreeze();
            if (rowFreeze >= 0) {
                Spreadsheet.this.updateCell(sheet, left, 0, right, rowFreeze, SpreadsheetCtrl.CellAttribute.ALL);
            }
            this.updateColWidths(sheet, col, size);
        }

        private void updateRowHeights(SSheet sheet, int row, int n) {
            for (int r = 0; r < n; ++r) {
                Spreadsheet.this.updateRowHeight(sheet, r + row);
            }
        }

        private void updateColWidths(SSheet sheet, int col, int n) {
            for (int r = 0; r < n; ++r) {
                Spreadsheet.this.updateColWidth(sheet, r + col);
            }
        }

        @Override
        public void insertRows(SSheet sheet, int row, int size) {
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            if (size <= 0) {
                throw new UiException("size must > 0 : " + size);
            }
            int maxRows = Spreadsheet.this.getSheetMaxVisibleRows(sheet);
            if (row > maxRows) {
                return;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("type", "row");
            result.put("row", row);
            result.put("size", size);
            AreaRef rect = Spreadsheet.this.getActiveRangeHelper().getArea(Spreadsheet.this._selectedSheet);
            if (rect == null) {
                return;
            }
            int bottom = size + rect.getLastRow();
            HeaderPositionHelper rowHelper = Spreadsheet.this.getRowPositionHelper(sheet);
            rowHelper.shiftMeta(row, size);
            result.put("hs", this.getRowHeaderAttrs(Spreadsheet.this._selectedSheet, row, bottom));
            result.put("maxrow", maxRows);
            result.put("rowfreeze", Spreadsheet.this.getSelectedSheetRowfreeze());
            Spreadsheet.this.response("insertRowColumn" + XUtils.nextUpdateId(), new AuInsertRowColumn((Component)Spreadsheet.this, "", sheet.getId(), result));
            rect.setLastRow(bottom);
            int top = row;
            bottom = top + size - 1;
            bottom = bottom >= maxRows - 1 ? maxRows - 1 : bottom;
            int left = rect.getColumn();
            int right = rect.getLastColumn();
            log.info("update cells when insert row " + row + ",size:" + size + ":" + left + "," + top + "," + right + "," + bottom);
            Spreadsheet.this.updateCell(sheet, left, top, right, bottom, SpreadsheetCtrl.CellAttribute.ALL);
            int colFreeze = Spreadsheet.this.getSelectedSheetColumnfreeze();
            if (colFreeze >= 0) {
                Spreadsheet.this.updateCell(sheet, 0, top, colFreeze, bottom, SpreadsheetCtrl.CellAttribute.ALL);
            }
            this.updateRowHeights(sheet, row, size);
        }

        @Override
        public void removeColumns(SSheet sheet, int col, int size) {
            int left;
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            if (size <= 0) {
                throw new UiException("size must > 0 : " + size);
            }
            if (col < 0) {
                throw new UiException("column must >= 0 : " + col);
            }
            int maxCols = Spreadsheet.this.getSheetMaxVisibleColumns(sheet);
            if (col >= maxCols) {
                return;
            }
            if (col + size > maxCols) {
                size = maxCols - col;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("type", "column");
            result.put("col", col);
            result.put("size", size);
            AreaRef rect = Spreadsheet.this.getActiveRangeHelper().getArea(Spreadsheet.this._selectedSheet);
            if (rect == null) {
                return;
            }
            int right = rect.getLastColumn() - size;
            if (right < col) {
                right = col - 1;
            }
            HeaderPositionHelper colHelper = Spreadsheet.this.getColumnPositionHelper(sheet);
            colHelper.unshiftMeta(col, size);
            result.put("hs", this.getColumnHeaderAttrs(Spreadsheet.this._selectedSheet, col, right));
            result.put("maxcol", maxCols);
            result.put("colfreeze", Spreadsheet.this.getSelectedSheetColumnfreeze());
            Spreadsheet.this.response("removeRowColumn" + XUtils.nextUpdateId(), new AuRemoveRowColumn((Component)Spreadsheet.this, "", sheet.getId(), result));
            rect.setLastColumn(right);
            right = left = col;
            Spreadsheet.this.updateCell(sheet, left, rect.getRow(), right, rect.getLastRow(), SpreadsheetCtrl.CellAttribute.ALL);
        }

        @Override
        public void removeRows(SSheet sheet, int row, int size) {
            int top;
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            if (size <= 0) {
                throw new UiException("size must > 0 : " + size);
            }
            if (row < 0) {
                throw new UiException("row must >= 0 : " + row);
            }
            int maxRows = Spreadsheet.this.getSheetMaxVisibleRows(sheet);
            if (row >= maxRows) {
                return;
            }
            if (row + size > maxRows) {
                size = maxRows - row;
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("type", "row");
            result.put("row", row);
            result.put("size", size);
            AreaRef rect = Spreadsheet.this.getActiveRangeHelper().getArea(Spreadsheet.this._selectedSheet);
            if (rect == null) {
                return;
            }
            int bottom = rect.getLastRow() - size;
            if (bottom < row) {
                bottom = row - 1;
            }
            HeaderPositionHelper rowHelper = Spreadsheet.this.getRowPositionHelper(sheet);
            rowHelper.unshiftMeta(row, size);
            result.put("hs", this.getRowHeaderAttrs(Spreadsheet.this._selectedSheet, row, bottom));
            result.put("maxrow", maxRows);
            result.put("rowfreeze", Spreadsheet.this.getSelectedSheetRowfreeze());
            Spreadsheet.this.response("removeRowColumn" + XUtils.nextUpdateId(), new AuRemoveRowColumn((Component)Spreadsheet.this, "", sheet.getId(), result));
            rect.setLastRow(bottom);
            bottom = top = row;
            Spreadsheet.this.updateCell(sheet, rect.getColumn(), top, rect.getLastColumn(), bottom, SpreadsheetCtrl.CellAttribute.ALL);
        }

        @Override
        public void updateMergeCell(SSheet sheet, int left, int top, int right, int bottom, int oleft, int otop, int oright, int obottom) {
            this.deleteMergeCell(sheet, oleft, otop, oright, obottom);
            this.addMergeCell(sheet, left, top, right, bottom);
        }

        @Override
        public void deleteMergeCell(SSheet sheet, int left, int top, int right, int bottom) {
            MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
            HashSet torem = new HashSet();
            mmhelper.deleteMergeRange(left, top, right, bottom, torem);
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            for (MergedRect rect : torem) {
                this.updateMergeCell0(sheet, rect, "remove");
            }
            Spreadsheet.this.updateCell(sheet, left, top, right, bottom, SpreadsheetCtrl.CellAttribute.ALL);
        }

        public void syncMergeCells(SSheet sheet) {
            Spreadsheet.this.removeMergeMatrixHelper(sheet);
            if (Spreadsheet.this.isInvalidated()) {
                return;
            }
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
            JSONObj results = new JSONObj();
            results.setData("type", "sync");
            JSONArray jarray = new JSONArray();
            results.setData("rects", (List)jarray);
            for (MergedRect block : mmhelper.getRanges()) {
                JSONObj result = new JSONObj();
                this.prepareMergeCell0(sheet, block, result);
                jarray.add((Object)result);
            }
            Spreadsheet.this.response("mergeCell" + XUtils.nextUpdateId(), new AuMergeCell((Component)Spreadsheet.this, "", sheet.getId(), results.toString()));
        }

        private void updateMergeCell0(SSheet sheet, MergedRect block, String type) {
            JSONObj result = new JSONObj();
            result.setData("type", type);
            this.prepareMergeCell0(sheet, block, result);
            Spreadsheet.this.response("mergeCell" + XUtils.nextUpdateId(), new AuMergeCell((Component)Spreadsheet.this, "", sheet.getId(), result.toString()));
        }

        private void prepareMergeCell0(SSheet sheet, MergedRect block, JSONObj result) {
            result.setData("id", block.getId());
            int left = block.getColumn();
            int top = block.getRow();
            int right = block.getLastColumn();
            int bottom = block.getLastRow();
            result.setData("left", left);
            result.setData("top", top);
            result.setData("right", right);
            result.setData("bottom", bottom);
            HeaderPositionHelper helper = Spreadsheet.this.getColumnPositionHelper(sheet);
            int w = helper.getStartPixel(block.getLastColumn() + 1) - helper.getStartPixel(block.getColumn());
            result.setData("width", w);
            HeaderPositionHelper rhelper = Spreadsheet.this.getRowPositionHelper(sheet);
            int h = rhelper.getStartPixel(block.getLastRow() + 1) - rhelper.getStartPixel(block.getRow());
            result.setData("height", h);
        }

        @Override
        public void addMergeCell(SSheet sheet, int left, int top, int right, int bottom) {
            MergeMatrixHelper mmhelper = this.getMergeMatrixHelper(sheet);
            HashSet toadd = new HashSet();
            HashSet torem = new HashSet();
            mmhelper.addMergeRange(left, top, right, bottom, toadd, torem);
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            for (MergedRect rect : torem) {
                log.info("(A)remove merge:" + rect);
                this.updateMergeCell0(sheet, rect, "remove");
            }
            for (MergedRect rect : toadd) {
                log.info("add merge:" + rect);
                this.updateMergeCell0(sheet, rect, "add");
            }
            Spreadsheet.this.updateCell(sheet, left, top, right, bottom, SpreadsheetCtrl.CellAttribute.ALL);
        }

        @Override
        public void setColumnWidth(SSheet sheet, int col, int width, int id, boolean hidden) {
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            JSONObject result = new JSONObject();
            result.put((Object)"type", (Object)"column");
            result.put((Object)"column", (Object)col);
            result.put((Object)"width", (Object)width);
            result.put((Object)"id", (Object)id);
            result.put((Object)"hidden", (Object)hidden);
            Spreadsheet.this.smartUpdate("columnSize", new Object[]{"", sheet.getId(), result}, true);
        }

        @Override
        public void setRowHeight(SSheet sheet, int row, int height, int id, boolean hidden, boolean isCustom) {
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            JSONObject result = new JSONObject();
            result.put((Object)"type", (Object)"row");
            result.put((Object)"row", (Object)row);
            result.put((Object)"height", (Object)height);
            result.put((Object)"id", (Object)id);
            result.put((Object)"hidden", (Object)hidden);
            result.put((Object)"custom", (Object)isCustom);
            Spreadsheet.this.smartUpdate("rowSize", new Object[]{"", sheet.getId(), result}, true);
        }

        @Override
        public Boolean getLeftHeaderHiddens(int row) {
            SSheet sheet = Spreadsheet.this.getSelectedSSheet();
            HeaderPositionHelper rowHelper = Spreadsheet.this.getRowPositionHelper(sheet);
            HeaderPositionHelper.HeaderPositionInfo info = rowHelper.getInfo(row);
            return info == null ? Boolean.FALSE : Boolean.valueOf(info.hidden);
        }

        @Override
        public Boolean getTopHeaderHiddens(int col) {
            SSheet sheet = Spreadsheet.this.getSelectedSSheet();
            HeaderPositionHelper colHelper = Spreadsheet.this.getColumnPositionHelper(sheet);
            HeaderPositionHelper.HeaderPositionInfo info = colHelper.getInfo(col);
            return info == null ? Boolean.FALSE : Boolean.valueOf(info.hidden);
        }

        @Override
        public void setSelectedSheetDirectly(String name, boolean cacheInClient, int row, int col, int left, int top, int right, int bottom, int highlightLeft, int highlightTop, int highlightRight, int highlightBottom, int rowfreeze, int colfreeze) {
            Spreadsheet.this.setSelectedSheetDirectly(name, cacheInClient, row, col, left, top, right, bottom);
        }

        @Override
        public FreezeInfoLoader getFreezeInfoLoader() {
            return Spreadsheet.this.getFreezeInfoLoader();
        }

        @Override
        public void setSelType(CellSelectionType type) {
            Spreadsheet.this._selectionArea.setSelType(type);
        }

        @Override
        public CellSelectionType getSelType() {
            return Spreadsheet.this._selectionArea.getSelType();
        }
    }

    private class InnerModelEventDispatcher
    extends ModelEventDispatcher {
        private static final long serialVersionUID = 20100330164021L;

        public InnerModelEventDispatcher() {
            this.addEventListener("onSheetOrderChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onSheetOrderChange(event);
                }
            });
            this.addEventListener("onSheetNameChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onSheetNameChange(event);
                }
            });
            this.addEventListener("onSheetCreate", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onSheetCreate(event);
                }
            });
            this.addEventListener("onSheetDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onSheetDelete(event);
                }
            });
            this.addEventListener("onSheetVisibleChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onSheetVisibleChange(event);
                }
            });
            this.addEventListener("onFriendFocusMove", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onFriendFocusMove(event);
                }
            });
            this.addEventListener("onFriendFocusDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onFriendFocusDelete(event);
                }
            });
            this.addEventListener("onCellChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onCellContentChange(event);
                }
            });
            this.addEventListener("onChartContentChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onChartContentChange(event);
                }
            });
            this.addEventListener("onDataValidationContentChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onDataValidationContentChange(event);
                }
            });
            this.addEventListener("onRowInsert", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onRowColumnInsertDelete(event);
                }
            });
            this.addEventListener("onRowDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onRowColumnInsertDelete(event);
                }
            });
            this.addEventListener("onColumnInsert", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onRowColumnInsertDelete(event);
                }
            });
            this.addEventListener("onColumnDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onRowColumnInsertDelete(event);
                }
            });
            this.addEventListener("onRowColumnSizeChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onRowColumnSizeChange(event);
                }
            });
            this.addEventListener("onAutoFilterChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onAutoFilterChange(event);
                }
            });
            this.addEventListener("onMergeAdd", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onMergeAdd(event);
                }
            });
            this.addEventListener("onMergeDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onMergeDelete(event);
                }
            });
            this.addEventListener("onMergeSync", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onMergeSync(event);
                }
            });
            this.addEventListener("onDisplayGridlinesChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onDisplayGridlines(event);
                }
            });
            this.addEventListener("onProtectSheetChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onProtectSheet(event);
                }
            });
            this.addEventListener("onChartAdd", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onChartAdd(event);
                }
            });
            this.addEventListener("onChartDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onChartDelete(event);
                }
            });
            this.addEventListener("onChartUpdate", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onChartUpdate(event);
                }
            });
            this.addEventListener("onPictureAdd", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onPictureAdd(event);
                }
            });
            this.addEventListener("onPictureDelete", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onPictureDelete(event);
                }
            });
            this.addEventListener("onPictureUpdate", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onPictureUpdate(event);
                }
            });
            this.addEventListener("onFreezeChange", new ModelEventListener(){

                public void onEvent(ModelEvent event) {
                    InnerModelEventDispatcher.this.onSheetFreeze(event);
                }
            });
        }

        private void onSheetOrderChange(ModelEvent event) {
            Spreadsheet.this.smartUpdate("sheetLabels", Spreadsheet.this.getSheetLabels());
            Sheet sheet = Spreadsheet.this.getBook().getSheet(event.getSheet().getSheetName());
            Events.postEvent((Event)new SheetEvent("onAfterSheetOrderChange", (Component)Spreadsheet.this, sheet));
        }

        private void onSheetNameChange(ModelEvent event) {
            Spreadsheet.this.smartUpdate("sheetLabels", Spreadsheet.this.getSheetLabels());
            Sheet sheet = Spreadsheet.this.getBook().getSheet(event.getSheet().getSheetName());
            Events.postEvent((Event)new SheetEvent("onAfterSheetNameChange", (Component)Spreadsheet.this, sheet));
        }

        private void onSheetVisibleChange(ModelEvent event) {
            Spreadsheet.this.smartUpdate("sheetLabels", Spreadsheet.this.getSheetLabels());
            Sheet sheet = Spreadsheet.this.getBook().getSheet(event.getSheet().getSheetName());
            Events.postEvent((Event)new SheetEvent("onAfterSheetVisibleChange", (Component)Spreadsheet.this, sheet));
        }

        private void onSheetCreate(ModelEvent event) {
            Spreadsheet.this.smartUpdate("sheetLabels", Spreadsheet.this.getSheetLabels());
            Sheet sheet = Spreadsheet.this.getBook().getSheet(event.getSheet().getSheetName());
            Spreadsheet.this.refreshToolbarDisabled();
            Events.postEvent((Event)new SheetEvent("onAfterSheetCreate", (Component)Spreadsheet.this, sheet));
        }

        private void onSheetDelete(ModelEvent event) {
            SBook book = Spreadsheet.this.getSBook();
            SSheet delSheet = event.getSheet();
            if (delSheet == Spreadsheet.this.getSelectedSSheet()) {
                int delIndex = (Integer)event.getData("index");
                if (delIndex >= book.getNumOfSheet() - 1) {
                    delIndex = book.getNumOfSheet() - 1;
                }
                Spreadsheet.this.setSelectedSheet(book.getSheet(delIndex).getSheetName());
            } else {
                Spreadsheet.this.smartUpdate("sheetLabels", Spreadsheet.this.getSheetLabels());
            }
            Events.postEvent((Event)new SheetDeleteEvent("onAfterSheetDelete", (Component)Spreadsheet.this, delSheet.getSheetName()));
        }

        private void onFriendFocusMove(ModelEvent event) {
            SSheet sheet = event.getSheet();
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.syncFriendFocus();
                return;
            }
            Focus focus = (Focus)event.getCustomData();
            String id = focus.getId();
            if (Spreadsheet.this._selfEditorFocus != null && !id.equals(Spreadsheet.this._selfEditorFocus.getId())) {
                Spreadsheet.this.addOrMoveFriendFocus(id, focus.getName(), focus.getColor(), focus.getSheetId(), focus.getRow(), focus.getColumn());
                Spreadsheet.this.syncFriendFocus();
            }
        }

        private void onFriendFocusDelete(ModelEvent event) {
            SSheet sheet = event.getSheet();
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.syncFriendFocus();
                return;
            }
            Focus focus = (Focus)event.getCustomData();
            String id = focus.getId();
            if (Spreadsheet.this._selfEditorFocus != null && !id.equals(Spreadsheet.this._selfEditorFocus.getId())) {
                Spreadsheet.this.removeFriendFocus(focus.getId());
                Spreadsheet.this.syncFriendFocus();
            }
        }

        private void onChartAdd(ModelEvent event) {
            SSheet sheet = event.getSheet();
            SChart chart = sheet.getChart(event.getObjectId());
            if (chart != null) {
                Spreadsheet.this.addChartWidget(sheet, chart);
            }
        }

        private void onChartDelete(ModelEvent event) {
            SSheet sheet = event.getSheet();
            Spreadsheet.this.deleteChartWidget(sheet, event.getObjectId());
        }

        private void onChartUpdate(ModelEvent event) {
            SSheet sheet = event.getSheet();
            SChart chart = sheet.getChart(event.getObjectId());
            if (chart != null) {
                Spreadsheet.this.updateChartWidget(sheet, chart);
            }
        }

        private void onPictureAdd(ModelEvent event) {
            String objid;
            SSheet sheet = event.getSheet();
            SPicture picture = sheet.getPicture(objid = event.getObjectId());
            if (picture != null) {
                Spreadsheet.this.addPictureWidget(event.getSheet(), picture);
            }
        }

        private void onPictureDelete(ModelEvent event) {
            Spreadsheet.this.deletePictureWidget(event.getSheet(), event.getObjectId());
        }

        private void onPictureUpdate(ModelEvent event) {
            String objid;
            SSheet sheet = event.getSheet();
            SPicture picture = sheet.getPicture(objid = event.getObjectId());
            if (picture != null) {
                Spreadsheet.this.updatePictureWidget(event.getSheet(), picture);
            }
        }

        private void onCellContentChange(ModelEvent event) {
            SSheet sheet = event.getSheet();
            CellRegion region = event.getRegion();
            int left = region.getColumn();
            int top = region.getRow();
            int right = region.getLastColumn();
            int bottom = region.getLastRow();
            Integer cellAttrVal = (Integer)event.getData("cellAttr");
            SpreadsheetCtrl.CellAttribute cellAttr = cellAttrVal == null ? SpreadsheetCtrl.CellAttribute.ALL : SpreadsheetCtrl.CellAttribute.values()[cellAttrVal - 1];
            Spreadsheet.this.updateCell(sheet, left, top, right, bottom, cellAttr);
            Spreadsheet.this.updateUnlockInfo();
            Events.postEvent((Event)new CellAreaEvent("onAfterCellChange", (Component)Spreadsheet.this, new SheetImpl(new SimpleRef<SBook>(sheet.getBook()), new SimpleRef<SSheet>(sheet)), top, left, bottom, right));
            SBook book = event.getBook();
            if (left <= 0 && right >= book.getMaxColumnIndex() && top <= 0 && bottom >= book.getMaxRowIndex()) {
                Spreadsheet.this.invalidate();
            }
        }

        private void onChartContentChange(ModelEvent event) {
            String objid;
            SSheet sheet = event.getSheet();
            SChart chart = sheet.getChart(objid = event.getObjectId());
            if (chart != null) {
                Spreadsheet.this.updateWidget(sheet, objid);
            }
        }

        private void onDataValidationContentChange(ModelEvent event) {
            SSheet sheet = event.getSheet();
            String objid = event.getObjectId();
            Spreadsheet.this.updateDataValidation(sheet, objid);
        }

        private void onRowColumnInsertDelete(ModelEvent event) {
            boolean inserted = "onRowInsert".equals(event.getName()) || "onColumnInsert".equals(event.getName());
            boolean isRow = "onRowInsert".equals(event.getName()) || "onRowDelete".equals(event.getName());
            Spreadsheet.this._updateCellId.next();
            SSheet sheet = event.getSheet();
            CellRegion region = event.getRegion();
            if (isRow) {
                int row = region.getRow();
                int lastRow = region.getLastRow();
                int count = region.getRowCount();
                if (inserted) {
                    ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).insertRows(sheet, row, count);
                } else {
                    ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).removeRows(sheet, row, count);
                }
                int widgetTop = row;
                int widgetBottom = inserted ? lastRow + count - 1 : lastRow;
                List<WidgetLoader> list = Spreadsheet.this.loadWidgetLoaders();
                for (WidgetLoader loader : list) {
                    loader.onRowChange(sheet, widgetTop, widgetBottom);
                }
            } else {
                int col = region.getColumn();
                int lastCol = region.getLastColumn();
                int count = region.getColumnCount();
                if (inserted) {
                    ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).insertColumns(sheet, col, count);
                } else {
                    ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).removeColumns(sheet, col, count);
                }
                int widgetLeft = col;
                int widgetRight = inserted ? lastCol + count - 1 : lastCol;
                List<WidgetLoader> list = Spreadsheet.this.loadWidgetLoaders();
                for (WidgetLoader loader : list) {
                    loader.onColumnChange(sheet, widgetLeft, widgetRight);
                }
            }
            Spreadsheet.this.updateUnlockInfo();
        }

        private void onMergeAdd(ModelEvent event) {
            SSheet sheet = event.getSheet();
            CellRegion region = event.getRegion();
            ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).addMergeCell(sheet, region.getColumn(), region.getRow(), region.getLastColumn(), region.getLastRow());
        }

        private void onMergeDelete(ModelEvent event) {
            SSheet sheet = event.getSheet();
            CellRegion region = event.getRegion();
            ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).deleteMergeCell(sheet, region.getColumn(), region.getRow(), region.getLastColumn(), region.getLastRow());
        }

        private void onMergeSync(ModelEvent event) {
            SSheet sheet = event.getSheet();
            ((ExtraCtrl)Spreadsheet.this.getExtraCtrl()).syncMergeCells(sheet);
        }

        private void onRowColumnSizeChange(ModelEvent event) {
            SSheet sheet = event.getSheet();
            CellRegion region = event.getRegion();
            if (event.isWholeColumn()) {
                int left = region.column;
                int right = region.lastColumn;
                for (int c = left; c <= right; ++c) {
                    Spreadsheet.this.updateColWidth(sheet, c);
                }
                List<WidgetLoader> list = Spreadsheet.this.loadWidgetLoaders();
                for (WidgetLoader loader : list) {
                    loader.onColumnChange(sheet, left, right);
                }
                AreaRef rect = ((SpreadsheetCtrl)Spreadsheet.this.getExtraCtrl()).getVisibleArea();
                Spreadsheet.this.syncFriendFocusPosition(left, rect.getRow(), rect.getLastColumn(), rect.getLastRow());
            } else if (event.isWholeRow()) {
                int top = region.row;
                int bottom = region.lastRow;
                for (int r = top; r <= bottom; ++r) {
                    Spreadsheet.this.updateRowHeight(sheet, r);
                }
                List<WidgetLoader> list = Spreadsheet.this.loadWidgetLoaders();
                for (WidgetLoader loader : list) {
                    loader.onRowChange(sheet, top, bottom);
                }
                AreaRef rect = ((SpreadsheetCtrl)Spreadsheet.this.getExtraCtrl()).getVisibleArea();
                Spreadsheet.this.syncFriendFocusPosition(rect.getColumn(), top, rect.getLastColumn(), rect.getLastRow());
            }
        }

        private void onAutoFilterChange(ModelEvent event) {
            SSheet sheet = event.getSheet();
            STable table = (STable)event.getData("TABLE");
            String key = (table == null ? sheet.getId() : table.getName()) + "_KK_AFFECTED_ROWS";
            Integer affectedRowCount = (Integer)event.getData(key);
            Spreadsheet.this.updateAutoFilter(sheet, table, affectedRowCount);
        }

        private void onDisplayGridlines(ModelEvent event) {
            SSheet sheet = event.getSheet();
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            Spreadsheet.this.setDisplayGridlines((Boolean)event.getData("enabled"));
        }

        private void onProtectSheet(ModelEvent event) {
            SSheet sheet = event.getSheet();
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            Spreadsheet.this.setProtectSheet((Boolean)event.getData("enabled"));
        }

        private void onSheetFreeze(ModelEvent event) {
            SSheet sheet = event.getSheet();
            if (!Spreadsheet.this.getSelectedSSheet().equals(sheet)) {
                Spreadsheet.this.releaseClientCache(sheet.getId());
                return;
            }
            Spreadsheet.this.invalidate();
            List<WidgetLoader> list = Spreadsheet.this.loadWidgetLoaders();
            for (WidgetLoader loader : list) {
                loader.onSheetFreeze(sheet);
            }
        }
    }

    private class InnerFunctionMapper
    implements FunctionMapper,
    Serializable {
        private static final long serialVersionUID = 1L;

        private InnerFunctionMapper() {
        }

        public Collection getClassNames() {
            FunctionMapper mapper;
            Page page = Spreadsheet.this.getPage();
            if (page != null && (mapper = page.getFunctionMapper()) != null) {
                return new ArrayList(0);
            }
            return null;
        }

        public Class resolveClass(String name) throws XelException {
            FunctionMapper mapper;
            Page page = Spreadsheet.this.getPage();
            if (page != null && (mapper = page.getFunctionMapper()) != null) {
                return null;
            }
            return null;
        }

        public Function resolveFunction(String prefix, String name) throws XelException {
            FunctionMapper mapper;
            Page page = Spreadsheet.this.getPage();
            if (page != null && (mapper = page.getFunctionMapper()) != null) {
                return mapper.resolveFunction(prefix, name);
            }
            return null;
        }
    }

    private class InnerVariableResolver
    implements VariableResolver,
    Serializable {
        private static final long serialVersionUID = 1L;

        private InnerVariableResolver() {
        }

        public Object resolveVariable(String name) throws XelException {
            Page page = Spreadsheet.this.getPage();
            Object result = null;
            if (page != null) {
                result = page.getZScriptVariable((Component)Spreadsheet.this, name);
            }
            if (result == null) {
                result = Spreadsheet.this.getAttributeOrFellow(name, true);
            }
            if (result == null && page != null) {
                result = page.getXelVariable(null, null, (Object)name, true);
            }
            return result;
        }
    }
}

