/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl.sys;

import io.keikai.model.SCell;
import io.keikai.model.impl.sys.DateInputMask;
import io.keikai.model.impl.sys.InputResultImpl;
import io.keikai.model.impl.sys.NumberInputMaskImpl;
import io.keikai.model.sys.input.InputEngine;
import io.keikai.model.sys.input.InputParseContext;
import io.keikai.model.sys.input.InputResult;
import io.keikai.model.sys.input.NumberInputMask;
import java.util.Locale;

public class InputEngineImpl
implements InputEngine {
    public static DateInputMask _dateInputMask = new DateInputMask();
    public static NumberInputMask _numberInputMask = new NumberInputMaskImpl();

    @Override
    public InputResult parseInput(String editText, String formatPattern, InputParseContext context) {
        InputResultImpl result = null;
        if (editText != null) {
            result = new InputResultImpl();
            if ("".equals(editText)) {
                result.setType(SCell.CellType.BLANK);
                result.setValue(null);
            } else {
                Object[] convertedResult = this.editTextToValue(editText, formatPattern, context.getLocale());
                result.setType((SCell.CellType)((Object)convertedResult[0]));
                result.setValue(convertedResult[1]);
                if (convertedResult.length > 2) {
                    result.setFormat((String)convertedResult[2]);
                }
            }
        }
        return result;
    }

    private Object[] editTextToValue(String txt, String formatPattern, Locale locale) {
        if (txt != null) {
            if (formatPattern != null && this.isStringFormat(formatPattern)) {
                return new Object[]{SCell.CellType.STRING, txt};
            }
            if (txt.startsWith("=")) {
                if (txt.trim().length() > 1) {
                    return new Object[]{SCell.CellType.FORMULA, txt.substring(1)};
                }
                return new Object[]{SCell.CellType.STRING, txt};
            }
            if ("true".equalsIgnoreCase(txt) || "false".equalsIgnoreCase(txt)) {
                return new Object[]{SCell.CellType.BOOLEAN, Boolean.valueOf(txt)};
            }
            if (txt.startsWith("#")) {
                Object[] objectArray;
                byte err = this.getErrorCode(txt);
                if (err < 0) {
                    Object[] objectArray2 = new Object[2];
                    objectArray2[0] = SCell.CellType.STRING;
                    objectArray = objectArray2;
                    objectArray2[1] = txt;
                } else {
                    Object[] objectArray3 = new Object[2];
                    objectArray3[0] = SCell.CellType.ERROR;
                    objectArray = objectArray3;
                    objectArray3[1] = new Byte(err);
                }
                return objectArray;
            }
            return this.parseEditTextToDoubleDateOrString(txt, locale);
        }
        return null;
    }

    private Object[] parseEditTextToDoubleDateOrString(String txt, Locale locale) {
        Object[] results = _numberInputMask.parseNumberInput(txt, locale);
        if (results[0] instanceof String) {
            return this.parseEditTextToDateOrString(txt, locale);
        }
        return results;
    }

    private Object[] parseEditTextToDateOrString(String txt, Locale locale) {
        Object[] results = _dateInputMask.parseDateInput(txt, locale);
        if (results[0] instanceof String) {
            return new Object[]{SCell.CellType.STRING, results[0]};
        }
        return new Object[]{SCell.CellType.NUMBER, results[0], results[1]};
    }

    private byte getErrorCode(String errString) {
        if ("#NULL!".equals(errString)) {
            return 0;
        }
        if ("#DIV/0!".equals(errString)) {
            return 7;
        }
        if ("#VALUE!".equals(errString)) {
            return 15;
        }
        if ("#REF!".equals(errString)) {
            return 23;
        }
        if ("#NAME?".equals(errString)) {
            return 29;
        }
        if ("#NUM!".equals(errString)) {
            return 36;
        }
        if ("#N/A".equals(errString)) {
            return 42;
        }
        return -1;
    }

    private boolean isStringFormat(String formatStr) {
        return "@".equals(formatStr);
    }
}

