/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.extensions;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STHorizontalAlignment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STVerticalAlignment;
import org.zkoss.poi.ss.usermodel.HorizontalAlignment;
import org.zkoss.poi.ss.usermodel.VerticalAlignment;
import org.zkoss.poi.util.Internal;

public class XSSFCellAlignment {
    private CTCellAlignment cellAlignement;

    public XSSFCellAlignment(CTCellAlignment cellAlignment) {
        this.cellAlignement = cellAlignment;
    }

    public VerticalAlignment getVertical() {
        STVerticalAlignment.Enum align = this.cellAlignement.getVertical();
        if (align == null) {
            align = STVerticalAlignment.BOTTOM;
        }
        return VerticalAlignment.values()[align.intValue() - 1];
    }

    public void setVertical(VerticalAlignment align) {
        this.cellAlignement.setVertical(STVerticalAlignment.Enum.forInt((int)(align.ordinal() + 1)));
    }

    public HorizontalAlignment getHorizontal() {
        STHorizontalAlignment.Enum align = this.cellAlignement.getHorizontal();
        if (align == null) {
            align = STHorizontalAlignment.GENERAL;
        }
        return HorizontalAlignment.values()[align.intValue() - 1];
    }

    public void setHorizontal(HorizontalAlignment align) {
        this.cellAlignement.setHorizontal(STHorizontalAlignment.Enum.forInt((int)(align.ordinal() + 1)));
    }

    public long getIndent() {
        return this.cellAlignement.getIndent();
    }

    public void setIndent(long indent) {
        this.cellAlignement.setIndent(indent);
    }

    public long getTextRotation() {
        long rotation = this.cellAlignement.getTextRotation();
        if (rotation == 255L) {
            return rotation;
        }
        if (rotation > 90L) {
            rotation = 90L - rotation;
        }
        return rotation;
    }

    public void setTextRotation(long rotation) {
        if (rotation != 255L) {
            if (rotation < 0L && rotation >= -90L) {
                rotation = (short)(90L - rotation);
            } else if (rotation < -90L || rotation > 90L) {
                rotation = 0L;
            }
        }
        this.cellAlignement.setTextRotation(rotation);
    }

    public boolean getWrapText() {
        return this.cellAlignement.getWrapText();
    }

    public void setWrapText(boolean wrapped) {
        this.cellAlignement.setWrapText(wrapped);
    }

    @Internal
    public CTCellAlignment getCTCellAlignment() {
        return this.cellAlignement;
    }
}

