/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel.charts;

import java.util.ArrayList;
import java.util.List;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarChart;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarDir;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarGrouping;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTBarSer;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTOverlap;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTPlotArea;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.zkoss.poi.ss.usermodel.Chart;
import org.zkoss.poi.ss.usermodel.charts.AbstractCategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.CategoryData;
import org.zkoss.poi.ss.usermodel.charts.CategoryDataSerie;
import org.zkoss.poi.ss.usermodel.charts.ChartAxis;
import org.zkoss.poi.ss.usermodel.charts.ChartDataSource;
import org.zkoss.poi.ss.usermodel.charts.ChartDirection;
import org.zkoss.poi.ss.usermodel.charts.ChartGrouping;
import org.zkoss.poi.ss.usermodel.charts.ChartTextSource;
import org.zkoss.poi.xssf.usermodel.XSSFChart;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartAxDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartNumDataSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartTextSource;
import org.zkoss.poi.xssf.usermodel.charts.XSSFChartUtil;

public class XSSFBarChartData
implements CategoryData {
    private ChartGrouping _chartGrouping;
    private ChartDirection _chartDirection;
    private CTBarChart ctBarChart;
    private int _overlap;
    private List<CategoryDataSerie> series = new ArrayList<CategoryDataSerie>();

    public XSSFBarChartData() {
        this.setBarDirection(ChartDirection.HORIZONTAL);
    }

    public XSSFBarChartData(XSSFChart chart) {
        this();
        CTPlotArea plotArea = chart.getCTChart().getPlotArea();
        CTBarChart[] plotCharts = plotArea.getBarChartArray();
        if (plotCharts != null && plotCharts.length > 0) {
            this.ctBarChart = plotCharts[0];
        }
        if (this.ctBarChart != null) {
            CTBarSer[] bsers = this.ctBarChart.getSerArray();
            for (int j = 0; j < bsers.length; ++j) {
                CTBarSer ser = bsers[j];
                CTSerTx serTx = ser.getTx();
                XSSFChartTextSource title = serTx == null ? null : new XSSFChartTextSource(serTx);
                XSSFChartAxDataSource cats = new XSSFChartAxDataSource(ser.getCat());
                XSSFChartNumDataSource vals = new XSSFChartNumDataSource(ser.getVal());
                this.addSerie(title, cats, vals);
            }
        }
    }

    public ChartGrouping getGrouping() {
        if (this.ctBarChart != null) {
            this._chartGrouping = XSSFChartUtil.toChartGroupingForBar(this.ctBarChart.getGrouping());
        }
        return this._chartGrouping;
    }

    public void setGrouping(ChartGrouping grouping) {
        this._chartGrouping = grouping;
        if (this.ctBarChart != null) {
            CTBarGrouping ctgr = this.ctBarChart.getGrouping();
            if (ctgr == null) {
                ctgr = this.ctBarChart.addNewGrouping();
            }
            ctgr.setVal(XSSFChartUtil.fromChartGroupingForBar(grouping));
        }
    }

    public ChartDirection getBarDirection() {
        if (this.ctBarChart != null) {
            this._chartDirection = XSSFChartUtil.toBarDirection(this.ctBarChart.getBarDir());
        }
        return this._chartDirection;
    }

    public void setBarDirection(ChartDirection barDir) {
        this._chartDirection = barDir;
        if (this.ctBarChart != null) {
            CTBarDir dir = this.ctBarChart.getBarDir();
            if (dir == null) {
                dir = this.ctBarChart.addNewBarDir();
            }
            dir.setVal(XSSFChartUtil.fromBarDirection(barDir));
        }
    }

    @Override
    public CategoryDataSerie addSerie(ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
        if (!vals.isNumeric()) {
            throw new IllegalArgumentException("Bar data source must be numeric.");
        }
        int numOfSeries = this.series.size();
        Serie newSerie = new Serie(numOfSeries, numOfSeries, title, cats, vals);
        this.series.add(newSerie);
        return newSerie;
    }

    @Override
    public void fillChart(Chart chart, ChartAxis ... axis) {
        if (!(chart instanceof XSSFChart)) {
            throw new IllegalArgumentException("Chart must be instance of XSSFChart");
        }
        if (this.ctBarChart == null) {
            XSSFChart xssfChart = (XSSFChart)chart;
            CTPlotArea plotArea = xssfChart.getCTChart().getPlotArea();
            this.ctBarChart = plotArea.addNewBarChart();
            this.ctBarChart.addNewVaryColors().setVal(true);
            this.setBarDirection(this._chartDirection);
            this.setGrouping(this._chartGrouping);
            this.setBarOverlap(this._overlap);
            for (CategoryDataSerie s : this.series) {
                ((Serie)s).addToChart(this.ctBarChart);
            }
        }
        for (ChartAxis a : axis) {
            this.ctBarChart.addNewAxId().setVal(a.getId());
        }
    }

    @Override
    public List<? extends CategoryDataSerie> getSeries() {
        return this.series;
    }

    public int getBarOverlap() {
        return this._overlap;
    }

    public void setBarOverlap(int overlap) {
        this._overlap = overlap;
        if (this.ctBarChart != null) {
            CTOverlap ov = this.ctBarChart.getOverlap();
            if (ov == null) {
                ov = this.ctBarChart.addNewOverlap();
            }
            ov.setVal((byte)overlap);
        }
    }

    static class Serie
    extends AbstractCategoryDataSerie {
        protected Serie(int id, int order, ChartTextSource title, ChartDataSource<?> cats, ChartDataSource<? extends Number> vals) {
            super(id, order, title, cats, vals);
        }

        protected void addToChart(CTBarChart ctBarChart) {
            CTBarSer barSer = ctBarChart.addNewSer();
            barSer.addNewIdx().setVal((long)this.id);
            barSer.addNewOrder().setVal((long)this.order);
            if (this.title != null) {
                CTSerTx tx = barSer.addNewTx();
                XSSFChartUtil.buildSerTx(tx, this.title);
            }
            if (this.categories != null && this.categories.getPointCount() > 0) {
                CTAxDataSource cats = barSer.addNewCat();
                XSSFChartUtil.buildAxDataSource(cats, this.categories);
            }
            CTNumDataSource vals = barSer.addNewVal();
            XSSFChartUtil.buildNumDataSource(vals, this.values);
        }
    }
}

