/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.usermodel;

import org.zkoss.poi.ss.usermodel.CreationHelper;
import org.zkoss.poi.xssf.usermodel.XSSFClientAnchor;
import org.zkoss.poi.xssf.usermodel.XSSFDataFormat;
import org.zkoss.poi.xssf.usermodel.XSSFFormulaEvaluator;
import org.zkoss.poi.xssf.usermodel.XSSFHyperlink;
import org.zkoss.poi.xssf.usermodel.XSSFRichTextString;
import org.zkoss.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFCreationHelper
implements CreationHelper {
    private XSSFWorkbook workbook;

    XSSFCreationHelper(XSSFWorkbook wb) {
        this.workbook = wb;
    }

    @Override
    public XSSFRichTextString createRichTextString(String text) {
        XSSFRichTextString rt = new XSSFRichTextString(text);
        rt.setStylesTableReference(this.workbook.getStylesSource());
        return rt;
    }

    @Override
    public XSSFDataFormat createDataFormat() {
        return this.workbook.createDataFormat();
    }

    @Override
    public XSSFHyperlink createHyperlink(int type) {
        return new XSSFHyperlink(type);
    }

    @Override
    public XSSFFormulaEvaluator createFormulaEvaluator() {
        return new XSSFFormulaEvaluator(this.workbook);
    }

    @Override
    public XSSFClientAnchor createClientAnchor() {
        return new XSSFClientAnchor();
    }
}

