/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xssf.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTAuthors;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComment;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCommentList;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTComments;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CommentsDocument;
import org.zkoss.poi.POIXMLDocumentPart;
import org.zkoss.poi.openxml4j.opc.PackagePart;
import org.zkoss.poi.openxml4j.opc.PackageRelationship;
import org.zkoss.poi.xssf.usermodel.XSSFComment;

public class CommentsTable
extends POIXMLDocumentPart {
    private CTComments comments;
    private Map<String, CTComment> commentRefs;

    public CommentsTable() {
        this.comments = CTComments.Factory.newInstance();
        this.comments.addNewCommentList();
        this.comments.addNewAuthors().addAuthor("");
    }

    public CommentsTable(PackagePart part, PackageRelationship rel) throws IOException {
        super(part, rel);
        this.readFrom(part.getInputStream());
    }

    public void readFrom(InputStream is) throws IOException {
        try {
            CommentsDocument doc = CommentsDocument.Factory.parse((InputStream)is);
            this.comments = doc.getComments();
        }
        catch (XmlException e) {
            throw new IOException(e.getLocalizedMessage());
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        CommentsDocument doc = CommentsDocument.Factory.newInstance();
        doc.setComments(this.comments);
        doc.save(out, DEFAULT_XML_OPTIONS);
    }

    @Override
    protected void commit() throws IOException {
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.writeTo(out);
        out.close();
    }

    public void referenceUpdated(String oldReference, CTComment comment) {
        if (this.commentRefs != null) {
            this.commentRefs.remove(oldReference);
            this.commentRefs.put(comment.getRef(), comment);
        }
    }

    public int getNumberOfComments() {
        return this.comments.getCommentList().sizeOfCommentArray();
    }

    public int getNumberOfAuthors() {
        return this.comments.getAuthors().sizeOfAuthorArray();
    }

    public String getAuthor(long authorId) {
        return this.comments.getAuthors().getAuthorArray((int)authorId);
    }

    public int findAuthor(String author) {
        CTAuthors authors = this.comments.getAuthors();
        if (authors != null) {
            int len = authors.sizeOfAuthorArray();
            for (int i = 0; i < len; ++i) {
                String author0 = authors.getAuthorArray(i);
                if (author0 == null || !author0.equals(author)) continue;
                return i;
            }
        }
        return this.addNewAuthor(author);
    }

    public XSSFComment findCellComment(String cellRef) {
        CTComment ct = this.getCTComment(cellRef);
        return ct == null ? null : new XSSFComment(this, ct, null);
    }

    public CTComment getCTComment(String cellRef) {
        if (this.commentRefs == null) {
            this.commentRefs = new HashMap<String, CTComment>();
            for (CTComment comment : this.comments.getCommentList().getCommentArray()) {
                this.commentRefs.put(comment.getRef(), comment);
            }
        }
        return this.commentRefs.get(cellRef);
    }

    public CTComment newComment() {
        CTComment ct = this.comments.getCommentList().addNewComment();
        ct.setRef("A1");
        ct.setAuthorId(0L);
        if (this.commentRefs != null) {
            this.commentRefs.put(ct.getRef(), ct);
        }
        return ct;
    }

    public boolean removeComment(String cellRef) {
        CTCommentList lst = this.comments.getCommentList();
        if (lst != null) {
            for (int i = 0; i < lst.sizeOfCommentArray(); ++i) {
                CTComment comment = lst.getCommentArray(i);
                if (!cellRef.equals(comment.getRef())) continue;
                lst.removeComment(i);
                if (this.commentRefs != null) {
                    this.commentRefs.remove(cellRef);
                }
                return true;
            }
        }
        return false;
    }

    private int addNewAuthor(String author) {
        int index = this.comments.getAuthors().sizeOfAuthorArray();
        this.comments.getAuthors().insertAuthor(index, author);
        return index;
    }

    public CTComments getCTComments() {
        return this.comments;
    }
}

