/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.xslf.model.geom;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.poi.xslf.model.geom.Context;

public abstract class Formula {
    static Map<String, Formula> builtInFormulas = new HashMap<String, Formula>();

    String getName() {
        return null;
    }

    abstract double evaluate(Context var1);

    static {
        builtInFormulas.put("3cd4", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 1.62E7;
            }
        });
        builtInFormulas.put("3cd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 8100000.0;
            }
        });
        builtInFormulas.put("5cd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 1.62E7;
            }
        });
        builtInFormulas.put("7cd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 1.62E7;
            }
        });
        builtInFormulas.put("b", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getY() + anchor.getHeight();
            }
        });
        builtInFormulas.put("cd2", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 1.08E7;
            }
        });
        builtInFormulas.put("cd4", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 5400000.0;
            }
        });
        builtInFormulas.put("cd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return 2700000.0;
            }
        });
        builtInFormulas.put("hc", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getX() + anchor.getWidth() / 2.0;
            }
        });
        builtInFormulas.put("h", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight();
            }
        });
        builtInFormulas.put("hd2", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight() / 2.0;
            }
        });
        builtInFormulas.put("hd3", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight() / 3.0;
            }
        });
        builtInFormulas.put("hd4", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight() / 4.0;
            }
        });
        builtInFormulas.put("hd5", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight() / 5.0;
            }
        });
        builtInFormulas.put("hd6", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight() / 6.0;
            }
        });
        builtInFormulas.put("hd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getHeight() / 8.0;
            }
        });
        builtInFormulas.put("l", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getX();
            }
        });
        builtInFormulas.put("ls", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return Math.max(anchor.getWidth(), anchor.getHeight());
            }
        });
        builtInFormulas.put("r", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getX() + anchor.getWidth();
            }
        });
        builtInFormulas.put("ss", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return Math.min(anchor.getWidth(), anchor.getHeight());
            }
        });
        builtInFormulas.put("ssd2", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                double ss = Math.min(anchor.getWidth(), anchor.getHeight());
                return ss / 2.0;
            }
        });
        builtInFormulas.put("ssd4", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                double ss = Math.min(anchor.getWidth(), anchor.getHeight());
                return ss / 4.0;
            }
        });
        builtInFormulas.put("ssd6", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                double ss = Math.min(anchor.getWidth(), anchor.getHeight());
                return ss / 6.0;
            }
        });
        builtInFormulas.put("ssd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                double ss = Math.min(anchor.getWidth(), anchor.getHeight());
                return ss / 8.0;
            }
        });
        builtInFormulas.put("ssd16", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                double ss = Math.min(anchor.getWidth(), anchor.getHeight());
                return ss / 16.0;
            }
        });
        builtInFormulas.put("ssd32", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                double ss = Math.min(anchor.getWidth(), anchor.getHeight());
                return ss / 32.0;
            }
        });
        builtInFormulas.put("t", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getY();
            }
        });
        builtInFormulas.put("vc", new Formula(){

            @Override
            double evaluate(Context ctx) {
                Rectangle2D anchor = ctx.getShapeAnchor();
                return anchor.getY() + anchor.getHeight() / 2.0;
            }
        });
        builtInFormulas.put("w", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth();
            }
        });
        builtInFormulas.put("wd2", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 2.0;
            }
        });
        builtInFormulas.put("wd3", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 3.0;
            }
        });
        builtInFormulas.put("wd4", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 4.0;
            }
        });
        builtInFormulas.put("wd5", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 5.0;
            }
        });
        builtInFormulas.put("wd6", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 6.0;
            }
        });
        builtInFormulas.put("wd8", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 8.0;
            }
        });
        builtInFormulas.put("wd10", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 10.0;
            }
        });
        builtInFormulas.put("wd32", new Formula(){

            @Override
            double evaluate(Context ctx) {
                return ctx.getShapeAnchor().getWidth() / 32.0;
            }
        });
    }
}

