/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.formula.ptg.RefPtgBase;
import org.zkoss.poi.ss.util.CellReference;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

abstract class Ref2DPtgBase
extends RefPtgBase {
    private static final int SIZE = 5;

    protected Ref2DPtgBase(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    protected Ref2DPtgBase(LittleEndianInput in) {
        this.readCoordinates(in);
    }

    protected Ref2DPtgBase(CellReference cr) {
        super(cr);
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(this.getSid() + this.getPtgClass());
        this.writeCoordinates(out);
    }

    @Override
    public final String toFormulaString() {
        return this.formatReferenceAsString();
    }

    protected abstract byte getSid();

    @Override
    public final int getSize() {
        return 5;
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getClass().getName());
        sb.append(" [");
        sb.append(this.formatReferenceAsString());
        sb.append("]");
        return sb.toString();
    }
}

