/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.ptg;

import org.zkoss.poi.ss.formula.ptg.ControlPtg;
import org.zkoss.poi.util.LittleEndianInput;
import org.zkoss.poi.util.LittleEndianOutput;

public final class Parenthesis2Ptg
extends ControlPtg {
    private static final int SIZE = 3;
    public static final byte sid = 26;
    private final int _numOperands;

    public Parenthesis2Ptg(LittleEndianInput in) {
        this._numOperands = in.readUShort();
    }

    public Parenthesis2Ptg(int operands) {
        this._numOperands = operands;
    }

    @Override
    public void write(LittleEndianOutput out) {
        out.writeByte(26 + this.getPtgClass());
        out.writeShort(this._numOperands);
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public String toFormulaString() {
        return "()";
    }

    public String toFormulaString(String[] operands) {
        StringBuffer sb = new StringBuffer().append("(").append(operands[0]);
        for (int j = 1; j < operands.length; ++j) {
            sb.append(",").append(operands[j]);
        }
        sb.append(")");
        return sb.toString();
    }

    public int getNumberOfOperands() {
        return this._numOperands;
    }
}

