/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.OperandResolver;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.AggregateFunction;
import org.zkoss.poi.ss.formula.functions.Count;
import org.zkoss.poi.ss.formula.functions.Counta;
import org.zkoss.poi.ss.formula.functions.Function;

public class Subtotal
implements Function {
    private static Function findFunction(int functionCode) throws EvaluationException {
        switch (functionCode) {
            case 1: {
                return AggregateFunction.subtotalInstance(AggregateFunction.AVERAGE);
            }
            case 2: {
                return Count.subtotalInstance();
            }
            case 3: {
                return Counta.subtotalInstance();
            }
            case 4: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MAX);
            }
            case 5: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MIN);
            }
            case 6: {
                return AggregateFunction.subtotalInstance(AggregateFunction.PRODUCT);
            }
            case 7: {
                return AggregateFunction.subtotalInstance(AggregateFunction.STDEV);
            }
            case 8: {
                return AggregateFunction.subtotalInstance(AggregateFunction.STDEVP);
            }
            case 9: {
                return AggregateFunction.subtotalInstance(AggregateFunction.SUM);
            }
            case 10: {
                return AggregateFunction.subtotalInstance(AggregateFunction.VAR);
            }
            case 11: {
                return AggregateFunction.subtotalInstance(AggregateFunction.VARP);
            }
            case 101: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.AVERAGE);
            }
            case 102: {
                return Count.subtotalIgnoreHiddenInstance();
            }
            case 103: {
                return Counta.subtotalIgnoreHiddenInstance();
            }
            case 104: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.MAX);
            }
            case 105: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.MIN);
            }
            case 106: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.PRODUCT);
            }
            case 107: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.STDEV);
            }
            case 108: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.STDEVP);
            }
            case 109: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.SUM);
            }
            case 110: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.VAR);
            }
            case 111: {
                return AggregateFunction.subtotalIgnoreHiddenInstance(AggregateFunction.VARP);
            }
        }
        throw EvaluationException.invalidValue();
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        Function innerFunc;
        int nInnerArgs = args.length - 1;
        if (nInnerArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(args[0], srcRowIndex, srcColumnIndex);
            int functionCode = OperandResolver.coerceValueToInt(ve);
            innerFunc = Subtotal.findFunction(functionCode);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        ValueEval[] innerArgs = new ValueEval[nInnerArgs];
        System.arraycopy(args, 1, innerArgs, 0, nInnerArgs);
        return innerFunc.evaluate(innerArgs, srcRowIndex, srcColumnIndex);
    }
}

