/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import org.zkoss.poi.ss.formula.eval.BlankEval;
import org.zkoss.poi.ss.formula.eval.BoolEval;
import org.zkoss.poi.ss.formula.eval.ErrorEval;
import org.zkoss.poi.ss.formula.eval.EvaluationException;
import org.zkoss.poi.ss.formula.eval.HyperlinkEval;
import org.zkoss.poi.ss.formula.eval.NumberEval;
import org.zkoss.poi.ss.formula.eval.OperandResolver;
import org.zkoss.poi.ss.formula.eval.StringEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.functions.Var1or2ArgFunction;

public final class Hyperlink
extends Var1or2ArgFunction {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        if (arg0 instanceof HyperlinkEval) {
            ((HyperlinkEval)((Object)arg0)).setHyperlink(new EvalHyperlink(srcRowIndex, srcColumnIndex, arg0, arg0));
        }
        return arg0;
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        if (arg1 instanceof HyperlinkEval) {
            ((HyperlinkEval)((Object)arg1)).setHyperlink(new EvalHyperlink(srcRowIndex, srcColumnIndex, arg0, arg1));
        }
        return arg1;
    }

    private static class EvalHyperlink
    implements org.zkoss.poi.ss.usermodel.Hyperlink {
        private int _row;
        private int _col;
        private String _address;
        private String _label;
        private int _type;

        private EvalHyperlink(int row, int col, ValueEval addrEval, ValueEval labelEval) {
            this._address = (String)this.evaluateToString(addrEval, row, col);
            this._label = (String)this.evaluateToString(labelEval, row, col);
            String addr = this._address.toLowerCase();
            this._type = addr.startsWith("http://") || addr.startsWith("https://") ? 1 : (addr.startsWith("mailto://") ? 3 : (addr.indexOf(33) > 0 ? 2 : 4));
            this._row = row;
            this._col = col;
        }

        @Override
        public int getFirstColumn() {
            return this._col;
        }

        @Override
        public int getFirstRow() {
            return this._row;
        }

        @Override
        public int getLastColumn() {
            return this._col;
        }

        @Override
        public int getLastRow() {
            return this._row;
        }

        @Override
        public void setFirstColumn(int col) {
            this._col = col;
        }

        @Override
        public void setFirstRow(int row) {
            this._row = row;
        }

        @Override
        public void setLastColumn(int col) {
            this.setFirstColumn(col);
        }

        @Override
        public void setLastRow(int row) {
            this.setFirstRow(row);
        }

        @Override
        public String getAddress() {
            return this._address;
        }

        @Override
        public String getLabel() {
            return this._label;
        }

        @Override
        public int getType() {
            return this._type;
        }

        @Override
        public void setAddress(String address) {
            this._address = address;
        }

        @Override
        public void setLabel(String label) {
            this._label = label;
        }

        private ValueEval dereferenceResult(ValueEval eval, int srcRowNum, int srcColNum) {
            ValueEval value;
            try {
                value = OperandResolver.getSingleValue(eval, srcRowNum, srcColNum);
            }
            catch (EvaluationException e) {
                return e.getErrorEval();
            }
            if (value == BlankEval.instance) {
                return NumberEval.ZERO;
            }
            return value;
        }

        private Object evaluateToString(ValueEval eval, int row, int col) {
            ValueEval eval0 = this.dereferenceResult(eval, row, col);
            if (eval0 instanceof NumberEval) {
                NumberEval ne = (NumberEval)eval0;
                return ne.getStringValue();
            }
            if (eval0 instanceof BoolEval) {
                BoolEval be = (BoolEval)eval0;
                return be.getStringValue();
            }
            if (eval0 instanceof StringEval) {
                StringEval ne = (StringEval)eval0;
                return ne.getStringValue();
            }
            if (eval0 instanceof ErrorEval) {
                return ErrorEval.getText(((ErrorEval)eval0).getErrorCode());
            }
            throw new RuntimeException("Unexpected eval class (" + eval0.getClass().getName() + ")");
        }
    }
}

