/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.functions;

import org.zkoss.poi.ss.formula.TwoDEval;
import org.zkoss.poi.ss.formula.eval.RefEval;
import org.zkoss.poi.ss.formula.eval.ValueEval;

final class CountUtils {
    private CountUtils() {
    }

    public static int countMatchingCellsInArea(TwoDEval areaEval, I_MatchPredicate criteriaPredicate) {
        int result = 0;
        int height = areaEval.getHeight();
        int width = areaEval.getWidth();
        for (int rrIx = 0; rrIx < height; ++rrIx) {
            for (int rcIx = 0; rcIx < width; ++rcIx) {
                I_MatchAreaPredicate areaPredicate;
                ValueEval ve = areaEval.getValue(rrIx, rcIx);
                if (criteriaPredicate instanceof I_MatchAreaPredicate && !(areaPredicate = (I_MatchAreaPredicate)criteriaPredicate).matches(areaEval, rrIx, rcIx) || !criteriaPredicate.matches(ve)) continue;
                ++result;
            }
        }
        return result;
    }

    public static int countMatchingCell(RefEval refEval, I_MatchPredicate criteriaPredicate) {
        if (criteriaPredicate.matches(refEval.getInnerValueEval())) {
            return 1;
        }
        return 0;
    }

    public static int countArg(ValueEval eval, I_MatchPredicate criteriaPredicate) {
        if (eval == null) {
            throw new IllegalArgumentException("eval must not be null");
        }
        if (eval instanceof TwoDEval) {
            return CountUtils.countMatchingCellsInArea((TwoDEval)eval, criteriaPredicate);
        }
        if (eval instanceof RefEval) {
            return CountUtils.countMatchingCell((RefEval)eval, criteriaPredicate);
        }
        return criteriaPredicate.matches(eval) ? 1 : 0;
    }

    public static interface I_MatchAreaPredicate
    extends I_MatchPredicate {
        public boolean matches(TwoDEval var1, int var2, int var3);
    }

    public static interface I_MatchPredicate {
        public boolean matches(ValueEval var1);
    }
}

