/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula.eval;

import org.zkoss.poi.ss.formula.eval.HyperlinkEval;
import org.zkoss.poi.ss.formula.eval.NumericValueEval;
import org.zkoss.poi.ss.formula.eval.StringValueEval;
import org.zkoss.poi.ss.formula.ptg.IntPtg;
import org.zkoss.poi.ss.formula.ptg.NumberPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;
import org.zkoss.poi.ss.usermodel.Hyperlink;
import org.zkoss.poi.ss.util.NumberToTextConverter;

public final class NumberEval
implements NumericValueEval,
StringValueEval,
HyperlinkEval {
    public static final NumberEval ZERO = new NumberEval(0.0);
    private final double _value;
    private String _stringValue;
    private Hyperlink _hyperlink;

    public NumberEval(Ptg ptg) {
        if (ptg == null) {
            throw new IllegalArgumentException("ptg must not be null");
        }
        if (ptg instanceof IntPtg) {
            this._value = ((IntPtg)ptg).getValue();
        } else if (ptg instanceof NumberPtg) {
            this._value = ((NumberPtg)ptg).getValue();
        } else {
            throw new IllegalArgumentException("bad argument type (" + ptg.getClass().getName() + ")");
        }
    }

    public NumberEval(double value) {
        this._value = value;
    }

    @Override
    public double getNumberValue() {
        return this._value;
    }

    @Override
    public String getStringValue() {
        if (this._stringValue == null) {
            this._stringValue = NumberToTextConverter.toText(this._value);
        }
        return this._stringValue;
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.getStringValue());
        sb.append("]");
        return sb.toString();
    }

    @Override
    public void setHyperlink(Hyperlink hyperlink) {
        this._hyperlink = hyperlink;
    }

    @Override
    public Hyperlink getHyperlink() {
        return this._hyperlink;
    }
}

