/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.ss.formula;

import org.zkoss.poi.ss.formula.CollaboratingWorkbooksEnvironment;
import org.zkoss.poi.ss.formula.EvaluationCell;
import org.zkoss.poi.ss.formula.EvaluationSheet;
import org.zkoss.poi.ss.formula.EvaluationTracker;
import org.zkoss.poi.ss.formula.EvaluationWorkbook;
import org.zkoss.poi.ss.formula.WorkbookEvaluator;
import org.zkoss.poi.ss.formula.eval.ValueEval;
import org.zkoss.poi.ss.formula.ptg.FuncVarPtg;
import org.zkoss.poi.ss.formula.ptg.Ptg;

public final class SheetRefEvaluator {
    private final WorkbookEvaluator _bookEvaluator;
    private final EvaluationTracker _tracker;
    private final int _sheetIndex;
    private final int _lastSheetIndex;
    private EvaluationSheet _sheet;

    public SheetRefEvaluator(WorkbookEvaluator bookEvaluator, EvaluationTracker tracker, int sheetIndex, int lastSheetIndex) {
        this._bookEvaluator = bookEvaluator;
        this._tracker = tracker;
        this._sheetIndex = sheetIndex;
        this._lastSheetIndex = lastSheetIndex;
    }

    public String getSheetName() {
        return this._sheetIndex < 0 ? "#REF" : this._bookEvaluator.getSheetName(this._sheetIndex);
    }

    public String getLastSheetName() {
        return this._lastSheetIndex < 0 ? "#REF" : this._bookEvaluator.getSheetName(this._lastSheetIndex);
    }

    public ValueEval getEvalForCell(int rowIndex, int columnIndex) {
        return this._bookEvaluator.evaluateReference(this.getSheetName(), this.getLastSheetName(), rowIndex, columnIndex, this._tracker);
    }

    public String getBookName() {
        CollaboratingWorkbooksEnvironment env = this._bookEvaluator.getEnvironment();
        return env.getBookName(this._bookEvaluator);
    }

    private EvaluationSheet getSheet() {
        if (this._sheet == null) {
            this._sheet = this._bookEvaluator.getSheet(this._sheetIndex);
        }
        return this._sheet;
    }

    public boolean isSubTotal(int rowIndex, int columnIndex) {
        boolean subtotal = false;
        EvaluationCell cell = this.getSheet().getCell(rowIndex, columnIndex);
        if (cell != null && cell.getCellType() == 2) {
            EvaluationWorkbook wb = this._bookEvaluator.getWorkbook();
            for (Ptg ptg : wb.getFormulaTokens(cell)) {
                FuncVarPtg f;
                if (!(ptg instanceof FuncVarPtg) || !"SUBTOTAL".equals((f = (FuncVarPtg)ptg).getName())) continue;
                subtotal = true;
                break;
            }
        }
        return subtotal;
    }

    public int getSheetCount() {
        if (this._sheetIndex > 0 && this._lastSheetIndex > 0) {
            return this._lastSheetIndex - this._sheetIndex + 1;
        }
        if (this._sheetIndex < 0 && this._lastSheetIndex < 0) {
            return 0;
        }
        return 1;
    }

    public int getSheetIndex() {
        return this._sheetIndex;
    }

    public int getLastSheetIndex() {
        return this._lastSheetIndex;
    }

    public boolean isHidden(int sheetIdx, int rowIndex, int columnIndex) {
        EvaluationSheet sheet = this._bookEvaluator.getSheet(this._sheetIndex);
        return sheet.isHidden(rowIndex, columnIndex);
    }
}

