/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.poi.hdgf.chunks;

import java.util.ArrayList;
import org.zkoss.poi.hdgf.chunks.ChunkFactory;
import org.zkoss.poi.hdgf.chunks.ChunkHeader;
import org.zkoss.poi.hdgf.chunks.ChunkSeparator;
import org.zkoss.poi.hdgf.chunks.ChunkTrailer;
import org.zkoss.poi.util.LittleEndian;
import org.zkoss.poi.util.POILogFactory;
import org.zkoss.poi.util.POILogger;

public final class Chunk {
    private byte[] contents;
    private ChunkHeader header;
    private ChunkTrailer trailer;
    private ChunkSeparator separator;
    protected ChunkFactory.CommandDefinition[] commandDefinitions;
    private Command[] commands;
    private String name;
    private POILogger logger = POILogFactory.getLogger(Chunk.class);

    public Chunk(ChunkHeader header, ChunkTrailer trailer, ChunkSeparator separator, byte[] contents) {
        this.header = header;
        this.trailer = trailer;
        this.separator = separator;
        this.contents = contents;
    }

    public byte[] _getContents() {
        return this.contents;
    }

    public ChunkHeader getHeader() {
        return this.header;
    }

    public ChunkSeparator getSeparator() {
        return this.separator;
    }

    public ChunkTrailer getTrailer() {
        return this.trailer;
    }

    public ChunkFactory.CommandDefinition[] getCommandDefinitions() {
        return this.commandDefinitions;
    }

    public Command[] getCommands() {
        return this.commands;
    }

    public String getName() {
        return this.name;
    }

    public int getOnDiskSize() {
        int size = this.header.getSizeInBytes() + this.contents.length;
        if (this.trailer != null) {
            size += this.trailer.trailerData.length;
        }
        if (this.separator != null) {
            size += this.separator.separatorData.length;
        }
        return size;
    }

    protected void processCommands() {
        if (this.commandDefinitions == null) {
            throw new IllegalStateException("You must supply the command definitions before calling processCommands!");
        }
        ArrayList<BlockOffsetCommand> commands = new ArrayList<BlockOffsetCommand>();
        for (int i = 0; i < this.commandDefinitions.length; ++i) {
            int type = this.commandDefinitions[i].getType();
            int offset = this.commandDefinitions[i].getOffset();
            if (type == 10) {
                this.name = this.commandDefinitions[i].getName();
                continue;
            }
            if (type == 18) continue;
            Command command = type == 11 || type == 21 ? new BlockOffsetCommand(this.commandDefinitions[i]) : new Command(this.commandDefinitions[i]);
            switch (type) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 11: 
                case 12: 
                case 16: 
                case 17: 
                case 18: 
                case 21: 
                case 28: 
                case 29: {
                    break;
                }
                default: {
                    if (offset < 19) break;
                    offset -= 19;
                }
            }
            if (offset >= this.contents.length) {
                this.logger.log(5, "Command offset " + offset + " past end of data at " + this.contents.length);
                continue;
            }
            try {
                switch (type) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        int val = this.contents[offset] & 1 << type;
                        command.value = val > 0;
                        break;
                    }
                    case 8: {
                        command.value = this.contents[offset];
                        break;
                    }
                    case 9: {
                        command.value = new Double(LittleEndian.getDouble(this.contents, offset));
                        break;
                    }
                    case 12: {
                        int startsAt;
                        if (this.contents.length < 8) {
                            command.value = "";
                            break;
                        }
                        int endsAt = startsAt = 8;
                        for (int j = startsAt; j < this.contents.length - 1 && endsAt == startsAt; ++j) {
                            if (this.contents[j] != 0 || this.contents[j + 1] != 0) continue;
                            endsAt = j;
                        }
                        if (endsAt == startsAt) {
                            endsAt = this.contents.length;
                        }
                        int strLen = endsAt - startsAt;
                        command.value = new String(this.contents, startsAt, strLen, this.header.getChunkCharset().name());
                        break;
                    }
                    case 25: {
                        command.value = LittleEndian.getShort(this.contents, offset);
                        break;
                    }
                    case 26: {
                        command.value = LittleEndian.getInt(this.contents, offset);
                        break;
                    }
                    case 11: 
                    case 21: {
                        if (offset < this.contents.length - 3) {
                            int bOffset = (int)LittleEndian.getUInt(this.contents, offset);
                            Command bcmd = command;
                            ((BlockOffsetCommand)bcmd).setOffset(bOffset);
                        }
                        break;
                    }
                    default: {
                        this.logger.log(3, "Command of type " + type + " not processed!");
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.logger.log(7, (Object)("Unexpected error processing command, ignoring and continuing. Command: " + command), e);
            }
            commands.add((BlockOffsetCommand)command);
        }
        this.commands = commands.toArray(new Command[commands.size()]);
    }

    public static class BlockOffsetCommand
    extends Command {
        private int offset;

        private BlockOffsetCommand(ChunkFactory.CommandDefinition definition) {
            super(definition, null);
        }

        private void setOffset(int offset) {
            this.offset = offset;
            this.value = offset;
        }
    }

    public static class Command {
        protected Object value;
        private ChunkFactory.CommandDefinition definition;

        private Command(ChunkFactory.CommandDefinition definition, Object value) {
            this.definition = definition;
            this.value = value;
        }

        private Command(ChunkFactory.CommandDefinition definition) {
            this(definition, (Object)null);
        }

        public ChunkFactory.CommandDefinition getDefinition() {
            return this.definition;
        }

        public Object getValue() {
            return this.value;
        }
    }
}

