/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.model.impl;

import io.keikai.model.impl.AbstractChartAdv;
import io.keikai.model.impl.AbstractDataValidationAdv;
import io.keikai.model.impl.RefImpl;
import io.keikai.model.sys.dependency.ObjectRef;
import io.keikai.model.sys.dependency.Ref;
import java.util.Arrays;

public class ObjectRefImpl
extends RefImpl
implements ObjectRef {
    private static final long serialVersionUID = 1L;
    private final String[] _objectIdPath;
    private final ObjectRef.ObjectType _objType;

    public ObjectRefImpl(AbstractChartAdv chart, String[] objectIdPath) {
        super(Ref.RefType.OBJECT, chart.getSheet().getBook().getBookName(), chart.getSheet().getSheetName(), null, -1, -1, -1, -1);
        this._objectIdPath = objectIdPath;
        this._objType = ObjectRef.ObjectType.CHART;
    }

    public ObjectRefImpl(AbstractChartAdv chart, String objectId) {
        this(chart.getSheet().getBook().getBookName(), chart.getSheet().getSheetName(), objectId, ObjectRef.ObjectType.CHART);
    }

    public ObjectRefImpl(AbstractDataValidationAdv validation, String objectId) {
        this(validation.getSheet().getBook().getBookName(), validation.getSheet().getSheetName(), objectId, ObjectRef.ObjectType.DATA_VALIDATION);
    }

    public ObjectRefImpl(String bookName, String sheetName, String objectId, ObjectRef.ObjectType type) {
        super(Ref.RefType.OBJECT, bookName, sheetName, null, -1, -1, -1, -1);
        this._objectIdPath = new String[]{objectId};
        this._objType = type;
    }

    @Override
    public String getObjectId() {
        return this._objectIdPath[this._objectIdPath.length - 1];
    }

    @Override
    public String[] getObjectIdPath() {
        return this._objectIdPath;
    }

    @Override
    public ObjectRef.ObjectType getObjectType() {
        return this._objType;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bookName == null ? 0 : this.bookName.hashCode());
        result = 31 * result + (this.sheetName == null ? 0 : this.sheetName.hashCode());
        result = 31 * result + (this._objType == null ? 0 : this._objType.hashCode());
        result = 31 * result + Arrays.hashCode(this._objectIdPath);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ObjectRefImpl other = (ObjectRefImpl)obj;
        if (this.bookName == null ? other.bookName != null : !this.bookName.equals(other.bookName)) {
            return false;
        }
        if (this.sheetName == null ? other.sheetName != null : !this.sheetName.equals(other.sheetName)) {
            return false;
        }
        if (this._objType != other._objType) {
            return false;
        }
        return Arrays.equals(this._objectIdPath, other._objectIdPath);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append((Object)this._objType);
        for (String id : this._objectIdPath) {
            sb.append(":").append(id);
        }
        return sb.toString();
    }
}

