/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.impl.ua;

import io.keikai.api.AreaRefWithType;
import io.keikai.api.impl.RangeImpl;
import io.keikai.api.model.Sheet;
import io.keikai.range.SRange;
import io.keikai.range.impl.PasteRangeImpl;
import io.keikai.ui.CellSelectionType;
import io.keikai.ui.UserActionContext;
import io.keikai.ui.impl.ua.AbstractHandler;
import io.keikai.ui.impl.undo.CutCellAction;
import io.keikai.ui.impl.undo.PasteCellAction;
import io.keikai.ui.sys.UndoableActionManager;
import org.zkoss.util.resource.Labels;

public class PasteHandler
extends AbstractHandler {
    private static final long serialVersionUID = -6262315007795949652L;

    @Override
    protected boolean processAction(UserActionContext ctx) {
        int dstLastCol;
        UserActionContext.Clipboard cb = ctx.getClipboard();
        if (cb == null) {
            return false;
        }
        Sheet destSheet = ctx.getSheet();
        Sheet srcSheet = cb.getSheet();
        if (srcSheet == null) {
            this.showInfoMessage(Labels.getLabel((String)"zss.actionhandler.msg.cant_find_sheet_to_paste"));
            ctx.clearClipboard();
            return true;
        }
        AreaRefWithType src = cb.getSelectionWithType();
        AreaRefWithType dst = ctx.getSelectionWithType();
        CellSelectionType srcType = src.getSelType();
        CellSelectionType dstType = dst.getSelType();
        boolean srcWholeRow = srcType == CellSelectionType.ALL || srcType == CellSelectionType.ROW;
        boolean srcWholeColumn = srcType == CellSelectionType.ALL || srcType == CellSelectionType.COLUMN;
        boolean dstWholeRow = dstType == CellSelectionType.ALL || dstType == CellSelectionType.ROW;
        boolean dstWholeColumn = dstType == CellSelectionType.ALL || dstType == CellSelectionType.COLUMN;
        int srcLastRow = srcWholeColumn ? Math.max(cb.getSheetMaxVisibleRows() - 1, src.getLastRow()) : src.getLastRow();
        int srcLastCol = srcWholeRow ? Math.max(cb.getSheetMaxVisibleColumns() - 1, src.getLastColumn()) : src.getLastColumn();
        int dstLastRow = dstWholeColumn ? Math.max(ctx.getSheetMaxVisibleRows() - 1, dst.getLastRow()) : dst.getLastRow();
        int n = dstLastCol = dstWholeRow ? Math.max(ctx.getSheetMaxVisibleColumns() - 1, dst.getLastColumn()) : dst.getLastColumn();
        if (srcWholeColumn && dstWholeColumn && srcLastRow != dstLastRow) {
            dstLastRow = srcLastRow = Math.max(dstLastRow, srcLastRow);
        }
        if (srcWholeRow && dstWholeRow && srcLastCol != dstLastCol) {
            dstLastCol = srcLastCol = Math.max(dstLastCol, srcLastCol);
        }
        RangeImpl srcRange = new RangeImpl((SRange)new PasteRangeImpl(srcSheet.getInternalSheet(), src.getRow(), src.getColumn(), srcLastRow, srcLastCol, srcWholeRow, srcWholeColumn), srcSheet);
        RangeImpl destRange = new RangeImpl((SRange)new PasteRangeImpl(destSheet.getInternalSheet(), dst.getRow(), dst.getColumn(), dstLastRow, dstLastCol, dstWholeRow, dstWholeColumn), destSheet);
        if (destRange.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        if (cb.isCutMode() && srcRange.isProtected()) {
            this.showProtectMessage();
            return true;
        }
        UndoableActionManager uam = ctx.getSpreadsheet().getUndoableActionManager();
        if (cb.isCutMode()) {
            uam.doAction(new CutCellAction(Labels.getLabel((String)"zss.undo.cut"), srcSheet, srcRange.getRow(), srcRange.getColumn(), srcRange.getLastRow(), srcRange.getLastColumn(), srcRange.isWholeColumn(), srcRange.isWholeRow(), destSheet, destRange.getRow(), destRange.getColumn(), destRange.getLastRow(), destRange.getLastColumn(), destRange.isWholeColumn(), destRange.isWholeRow()));
            ctx.clearClipboard();
        } else {
            uam.doAction(new PasteCellAction(Labels.getLabel((String)"zss.undo.paste"), srcSheet, srcRange.getRow(), srcRange.getColumn(), srcRange.getLastRow(), srcRange.getLastColumn(), srcRange.isWholeColumn(), srcRange.isWholeRow(), destSheet, destRange.getRow(), destRange.getColumn(), destRange.getLastRow(), destRange.getLastColumn(), destRange.isWholeColumn(), destRange.isWholeRow()));
            if (srcSheet.equals(destSheet) && src.overlap(dst)) {
                ctx.clearClipboard();
            }
        }
        return true;
    }
}

