/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.ui.au.in;

import io.keikai.api.AreaRef;
import io.keikai.api.model.Sheet;
import io.keikai.ui.Spreadsheet;
import io.keikai.ui.au.in.AbstractCommand;
import io.keikai.ui.au.in.AuDataUtil;
import io.keikai.ui.au.in.AutoFilterDefaultHandler;
import io.keikai.ui.au.in.Command;
import io.keikai.ui.au.in.Commands;
import io.keikai.ui.event.CellFilterEvent;
import io.keikai.ui.event.CellMouseEvent;
import java.util.Map;
import org.zkoss.lang.Objects;
import org.zkoss.zk.au.AuRequest;
import org.zkoss.zk.mesg.MZk;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.UiException;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.Events;

public class CellMouseCommand
extends AbstractCommand
implements Command {
    @Override
    public void process(AuRequest request) {
        Component comp = request.getComponent();
        if (comp == null) {
            throw new UiException(MZk.ILLEGAL_REQUEST_COMPONENT_REQUIRED, (Object)this);
        }
        Map data = request.getData();
        String type = (String)data.get("type");
        if (data == null || !"af".equals(type) && data.size() != 9 || "af".equals(type) && data.size() != 10) {
            throw new UiException(MZk.ILLEGAL_REQUEST_WRONG_DATA, new Object[]{Objects.toString((Object)data), this});
        }
        int shx = (Integer)data.get("shx");
        int shy = (Integer)data.get("shy");
        int key = Commands.parseKeys((String)data.get("key"));
        String sheetId = (String)data.get("sheetId");
        int row = (Integer)data.get("row");
        int col = (Integer)data.get("col");
        int mx = AuDataUtil.getInt(data, "mx");
        int my = AuDataUtil.getInt(data, "my");
        Spreadsheet spreadsheet = (Spreadsheet)comp;
        Sheet sheet = ((Spreadsheet)comp).getSelectedSheet();
        if (!CellMouseCommand.getSheetUuid(sheet).equals(sheetId)) {
            return;
        }
        if ("lc".equals(type)) {
            type = "onCellClick";
        } else if ("rc".equals(type)) {
            type = "onCellRightClick";
        } else if ("dbc".equals(type)) {
            type = "onCellDoubleClick";
        } else if ("af".equals(type)) {
            type = "onCellFilter";
        } else if ("dv".equals(type)) {
            type = "onCellValidator";
        } else {
            throw new UiException("unknow type : " + type);
        }
        if ("onCellFilter".equals(type)) {
            int field = (Integer)data.get("field");
            AreaRef filterArea = new AutoFilterDefaultHandler().processFilter(spreadsheet, sheet, row, col, field);
            Events.postEvent((Event)new CellFilterEvent(type, comp, sheet, row, col, filterArea, field, shx, shy, key, mx, my));
        } else if ("onCellValidator".equals(type)) {
            Events.postEvent((Event)new CellMouseEvent(type, comp, sheet, row, col, shx, shy, key, mx, my));
        } else {
            Events.postEvent((Event)new CellMouseEvent(type, comp, sheet, row, col, shx, shy, key, mx, my));
        }
    }
}

