/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.theme;

import io.keikai.theme.SpreadsheetStandardTheme;
import io.keikai.theme.SpreadsheetThemeFns;
import io.keikai.theme.SpreadsheetThemeRegistry;
import io.keikai.theme.SpreadsheetThemeResolver;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.web.theme.Theme;
import org.zkoss.zk.ui.Execution;

public class SpreadsheetThemes {
    private static final String THEME_FOLDER_ROOT = "io.keikai.theme.folder.root";

    public static void setTheme(Execution exe, String themeName) {
        SpreadsheetThemeResolver themeResolver = SpreadsheetThemeFns.getThemeResolver();
        themeResolver.setTheme((HttpServletRequest)exe.getNativeRequest(), (HttpServletResponse)exe.getNativeResponse(), themeName);
    }

    public static String getTheme(Execution exe) {
        SpreadsheetThemeResolver themeResolver = SpreadsheetThemeFns.getThemeResolver();
        return themeResolver.getTheme((HttpServletRequest)exe.getNativeRequest());
    }

    public static String getCurrentTheme() {
        return SpreadsheetThemeFns.getCurrentTheme();
    }

    public static boolean hasTheme(String themeName) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        return themeRegistry.hasTheme(themeName);
    }

    public static String[] getThemes() {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        Theme[] themes = themeRegistry.getThemes();
        String[] themeNames = new String[themes.length];
        for (int i = 0; i < themes.length; ++i) {
            themeNames[i] = themes[i].getName();
        }
        return themeNames;
    }

    public static void register(String themeName) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        themeRegistry.register(new SpreadsheetStandardTheme(themeName));
    }

    public static void register(String themeName, SpreadsheetStandardTheme.ThemeOrigin origin) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        themeRegistry.register(new SpreadsheetStandardTheme(themeName, origin));
    }

    public static void register(String themeName, String displayName, int priority) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        themeRegistry.register(new SpreadsheetStandardTheme(themeName, displayName, priority));
    }

    public static void register(String themeName, String displayName, int priority, SpreadsheetStandardTheme.ThemeOrigin origin) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        themeRegistry.register(new SpreadsheetStandardTheme(themeName, displayName, priority, origin));
    }

    public static void setDisplayName(String themeName, String displayName) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        if (theme instanceof SpreadsheetStandardTheme) {
            ((SpreadsheetStandardTheme)theme).setDisplayName(displayName);
        }
    }

    public static String getDisplayName(String themeName) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        String displayName = "";
        if (theme instanceof SpreadsheetStandardTheme) {
            displayName = ((SpreadsheetStandardTheme)theme).getDisplayName();
        }
        return Strings.isEmpty((String)displayName) ? SpreadsheetThemes.capitalize(themeName) : displayName;
    }

    public static void setPriority(String themeName, int priority) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        if (theme instanceof SpreadsheetStandardTheme) {
            ((SpreadsheetStandardTheme)theme).setPriority(priority);
        }
    }

    public static int getPriority(String themeName) {
        SpreadsheetThemeRegistry themeRegistry = SpreadsheetThemeFns.getThemeRegistry();
        Theme theme = themeRegistry.getTheme(themeName);
        if (theme instanceof SpreadsheetStandardTheme) {
            return ((SpreadsheetStandardTheme)theme).getPriority();
        }
        return Integer.MAX_VALUE;
    }

    private static String capitalize(String str) {
        if (Strings.isEmpty((String)str)) {
            return str;
        }
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    public static final String resolveThemeURL(String url) {
        if (url == null) {
            return null;
        }
        String themeName = SpreadsheetThemeFns.getCurrentTheme();
        String prefix = Library.getProperty((String)THEME_FOLDER_ROOT, (String)"theme");
        String resolved = null;
        if (Strings.isBlank((String)themeName) || "default".equals(themeName)) {
            resolved = url;
        } else {
            Theme theme = SpreadsheetThemeFns.getThemeRegistry().getTheme(themeName);
            if (theme instanceof SpreadsheetStandardTheme) {
                resolved = ((SpreadsheetStandardTheme)theme).getOrigin() == SpreadsheetStandardTheme.ThemeOrigin.JAR ? url.replaceFirst("~./", "~./" + themeName + "/") : url.replaceFirst("~./", "/" + prefix + "/" + themeName + "/");
            }
        }
        return resolved;
    }
}

