/*
 * Decompiled with CFR 0.152.
 */
package io.keikai.api;

import io.keikai.api.CellVisitor;
import io.keikai.api.RangeRunner;
import io.keikai.api.SheetAnchor;
import io.keikai.api.model.Book;
import io.keikai.api.model.CellData;
import io.keikai.api.model.CellStyle;
import io.keikai.api.model.Chart;
import io.keikai.api.model.Color;
import io.keikai.api.model.EditableCellStyle;
import io.keikai.api.model.EditableFont;
import io.keikai.api.model.Font;
import io.keikai.api.model.Hyperlink;
import io.keikai.api.model.Picture;
import io.keikai.api.model.Sheet;
import io.keikai.api.model.SheetProtection;
import io.keikai.api.model.Validation;
import io.keikai.model.CellRegion;
import io.keikai.range.SRange;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;

public interface Range {
    public void setSyncLevel(SyncLevel var1);

    public ReadWriteLock getLock();

    public Book getBook();

    public Sheet getSheet();

    public int getColumn();

    public int getRow();

    public int getLastColumn();

    public int getLastRow();

    public int getRowCount();

    public int getColumnCount();

    public CellStyleHelper getCellStyleHelper();

    public void sync(RangeRunner var1);

    public void visit(CellVisitor var1);

    public Range toShiftedRange(int var1, int var2);

    public Range toCellRange(int var1, int var2);

    public Range toRowRange();

    public Range toColumnRange();

    public boolean isWholeColumn();

    public boolean isWholeRow();

    public boolean isWholeSheet();

    public void clearContents();

    public void clearStyles();

    public void clearAll();

    public Range paste(Range var1);

    public Range paste(Range var1, boolean var2);

    public Range pasteSpecial(Range var1, PasteType var2, PasteOperation var3, boolean var4, boolean var5);

    public void applyBorders(ApplyBorderType var1, CellStyle.BorderType var2, String var3);

    public boolean hasMergedCell();

    public boolean isMergedCell();

    public void merge(boolean var1);

    public void unmerge();

    public void insert(InsertShift var1, InsertCopyOrigin var2);

    public void delete(DeleteShift var1);

    public void sort(boolean var1);

    public void sort(boolean var1, boolean var2, boolean var3, boolean var4, SortDataOption var5);

    public void sort(Range var1, boolean var2, SortDataOption var3, Range var4, boolean var5, SortDataOption var6, Range var7, boolean var8, SortDataOption var9, boolean var10, boolean var11, boolean var12);

    public void autoFill(Range var1, AutoFillType var2);

    public void fillDown();

    public void fillLeft();

    public void fillUp();

    public void fillRight();

    public void shift(int var1, int var2);

    public void setColumnWidth(int var1);

    public void setRowHeight(int var1);

    public void setRowHeight(int var1, boolean var2);

    public void setCellStyle(CellStyle var1);

    public void setCellEditText(String var1);

    public void setCellValue(Object var1);

    public void setCellHyperlink(Hyperlink.HyperlinkType var1, String var2, String var3);

    public Hyperlink getCellHyperlink();

    public CellStyle getCellStyle();

    public CellData getCellData();

    public String getCellEditText();

    public String getCellFormatText();

    public String getCellDataFormat();

    public Object getCellValue();

    public void protectSheet(String var1);

    public void setDisplaySheetGridlines(boolean var1);

    public boolean isDisplaySheetGridlines();

    public void setHidden(boolean var1);

    public void setSheetName(String var1);

    public String getSheetName();

    public void setSheetOrder(int var1);

    public int getSheetOrder();

    public boolean isProtected();

    public boolean isAutoFilterEnabled();

    public Range findAutoFilterRange();

    public void enableAutoFilter(boolean var1);

    public void enableAutoFilter(int var1, AutoFilterOperation var2, Object var3, Object var4, Boolean var5);

    public void resetAutoFilter();

    public void applyAutoFilter();

    public Picture addPicture(SheetAnchor var1, byte[] var2, Picture.Format var3);

    public void deletePicture(Picture var1);

    public void movePicture(SheetAnchor var1, Picture var2);

    public Chart addChart(SheetAnchor var1, Chart.Type var2, Chart.Grouping var3, Chart.LegendPosition var4);

    public void deleteChart(Chart var1);

    public void moveChart(SheetAnchor var1, Chart var2);

    public Sheet createSheet(String var1);

    public Sheet cloneSheet(String var1);

    public void setFreezePanel(int var1, int var2);

    public void deleteSheet();

    public void notifyChange();

    public void notifyChange(String[] var1);

    public String asString();

    public void updateChart(Chart var1);

    public SRange getInternalRange();

    public void createName(String var1);

    public boolean isSheetProtected();

    public void protectSheet(String var1, boolean var2, boolean var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, boolean var12, boolean var13, boolean var14, boolean var15, boolean var16);

    public boolean unprotectSheet(String var1);

    public SheetProtection getSheetProtection();

    public Validation validate(String var1);

    public void setValidation(Validation.ValidationType var1, boolean var2, Validation.OperatorType var3, boolean var4, String var5, String var6, boolean var7, String var8, String var9, boolean var10, Validation.AlertStyle var11, String var12, String var13);

    public List<Validation> getValidations();

    public void deleteValidation();

    public void setCellRichText(String var1);

    public String getCellRichText();

    public Font getOrCreateFont(Font.Boldweight var1, Color var2, int var3, String var4, boolean var5, boolean var6, Font.TypeOffset var7, Font.Underline var8);

    public void refresh(boolean var1);

    public boolean setAutoRefresh(boolean var1);

    public void refresh(boolean var1, boolean var2, boolean var3);

    public void setSheetVisible(SheetVisible var1);

    public String getCommentRichText();

    public void setCommentRichText(String var1);

    public void setCommentVisible(boolean var1);

    public boolean isCommentVisible();

    public void notifyChange(CellAttribute var1);

    public void setNameName(String var1, String var2);

    public void setStringValue(String var1);

    public CellRegion getMergedRegion();

    public CellRegion getDataRegion();

    public Sheet cloneSheetFrom(String var1, Sheet var2);

    public static interface CellStyleHelper {
        public EditableCellStyle createCellStyle(CellStyle var1);

        public EditableFont createFont(Font var1);

        public Color createColorFromHtmlColor(String var1);

        public Font findFont(Font.Boldweight var1, Color var2, int var3, String var4, boolean var5, boolean var6, Font.TypeOffset var7, Font.Underline var8);

        public boolean isAvailable(CellStyle var1);
    }

    public static enum CellAttribute {
        ALL,
        TEXT,
        STYLE,
        SIZE,
        MERGE,
        COMMENT;

    }

    public static enum SheetVisible {
        VISIBLE,
        HIDDEN,
        VERY_HIDDEN;

    }

    public static enum AutoFillType {
        COPY,
        DAYS,
        DEFAULT,
        FORMATS,
        MONTHS,
        SERIES,
        VALUES,
        WEEKDAYS,
        YEARS,
        GROWTH_TREND,
        LINER_TREND;

    }

    public static enum AutoFilterOperation {
        AND,
        BOTTOM10,
        BOTTOM10PERCENT,
        OR,
        TOP10,
        TOP10PERCENT,
        VALUES;

    }

    public static enum SortDataOption {
        NORMAL_DEFAULT,
        TEXT_AS_NUMBERS;

    }

    public static enum DeleteShift {
        DEFAULT,
        LEFT,
        UP;

    }

    public static enum InsertCopyOrigin {
        FORMAT_NONE,
        FORMAT_LEFT_ABOVE,
        FORMAT_RIGHT_BELOW;

    }

    public static enum InsertShift {
        DEFAULT,
        RIGHT,
        DOWN;

    }

    public static enum ApplyBorderType {
        FULL,
        EDGE_BOTTOM,
        EDGE_RIGHT,
        EDGE_TOP,
        EDGE_LEFT,
        OUTLINE,
        INSIDE,
        INSIDE_HORIZONTAL,
        INSIDE_VERTICAL,
        DIAGONAL,
        DIAGONAL_DOWN,
        DIAGONAL_UP;

    }

    public static enum PasteOperation {
        ADD,
        SUB,
        MUL,
        DIV,
        NONE;

    }

    public static enum PasteType {
        ALL,
        ALL_EXCEPT_BORDERS,
        COLUMN_WIDTHS,
        COMMENTS,
        FORMATS,
        FORMULAS,
        FORMULAS_AND_NUMBER_FORMATS,
        VALIDATAION,
        VALUES,
        VALUES_AND_NUMBER_FORMATS;

    }

    public static enum SyncLevel {
        BOOK,
        NONE;

    }
}

