/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql;

import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlStatement;
import javax.annotation.Nonnull;

public interface SqlService {
    @Nonnull
    default public SqlResult execute(@Nonnull String sql, Object ... arguments) {
        SqlStatement statement = new SqlStatement(sql);
        if (arguments != null) {
            for (Object arg : arguments) {
                statement.addParameter(arg);
            }
        }
        return this.execute(statement);
    }

    default public long executeUpdate(@Nonnull String sql, Object ... arguments) {
        try (SqlResult result = this.execute(sql, arguments);){
            if (!1.$assertionsDisabled && result.isRowSet()) {
                throw new AssertionError((Object)"Result should not contain rowSet when called from executeUpdate");
            }
            long l = result.updateCount();
            return l;
        }
    }

    @Nonnull
    public SqlResult execute(@Nonnull SqlStatement var1);

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

