/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.locksupport.operations;

import com.hazelcast.client.impl.ClientEngine;
import com.hazelcast.internal.locksupport.LockStoreImpl;
import com.hazelcast.internal.locksupport.operations.AbstractLockOperation;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.services.ObjectNamespace;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.impl.operationservice.BackupOperation;
import java.io.IOException;
import java.util.UUID;

public class LockBackupOperation
extends AbstractLockOperation
implements BackupOperation {
    private UUID originalCallerUuid;

    public LockBackupOperation() {
    }

    public LockBackupOperation(ObjectNamespace namespace, Data key, long threadId, long leaseTime, UUID originalCallerUuid, boolean isClient) {
        super(namespace, key, threadId);
        this.leaseTime = leaseTime;
        this.originalCallerUuid = originalCallerUuid;
        this.isClient = isClient;
    }

    @Override
    public void run() throws Exception {
        if (this.isClient) {
            ClientEngine clientEngine = (ClientEngine)this.getNodeEngine().getService("hz:core:clientEngine");
            clientEngine.onClientAcquiredResource(this.originalCallerUuid);
        }
        this.interceptLockOperation();
        LockStoreImpl lockStore = this.getLockStore();
        this.response = lockStore.lock(this.key, this.originalCallerUuid, this.threadId, this.getReferenceCallId(), this.leaseTime);
    }

    @Override
    public int getClassId() {
        return 10;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        UUIDSerializationUtil.writeUUID(out, this.originalCallerUuid);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.originalCallerUuid = UUIDSerializationUtil.readUUID(in);
    }
}

