/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.query.impl.getters;

import com.hazelcast.config.AttributeConfig;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.Logger;
import com.hazelcast.query.extractor.ValueExtractor;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public final class ExtractorHelper {
    private ExtractorHelper() {
    }

    static Map<String, ValueExtractor> instantiateExtractors(List<AttributeConfig> attributeConfigs, ClassLoader classLoader) {
        Map<String, ValueExtractor> extractors = MapUtil.createHashMap(attributeConfigs.size());
        for (AttributeConfig config : attributeConfigs) {
            if (extractors.containsKey(config.getName())) {
                throw new IllegalArgumentException("Could not add " + config + ". Extractor for this attribute name already added.");
            }
            extractors.put(config.getName(), ExtractorHelper.instantiateExtractor(config, classLoader));
        }
        return extractors;
    }

    static ValueExtractor instantiateExtractor(AttributeConfig config, ClassLoader classLoader) {
        ValueExtractor extractor = null;
        if (classLoader != null) {
            try {
                extractor = ExtractorHelper.instantiateExtractorWithConfigClassLoader(config, classLoader);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(ExtractorHelper.class).warning("Could not instantiate extractor with the config class loader", ex);
            }
        }
        if (extractor == null) {
            extractor = ExtractorHelper.instantiateExtractorWithClassForName(config);
        }
        return extractor;
    }

    private static ValueExtractor instantiateExtractorWithConfigClassLoader(AttributeConfig config, ClassLoader classLoader) {
        try {
            Class<?> clazz = classLoader.loadClass(config.getExtractorClassName());
            Object extractor = clazz.newInstance();
            if (extractor instanceof ValueExtractor) {
                return (ValueExtractor)extractor;
            }
            throw new IllegalArgumentException("Extractor does not extend ValueExtractor class " + config);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
    }

    private static ValueExtractor instantiateExtractorWithClassForName(AttributeConfig config) {
        try {
            Class<?> clazz = Class.forName(config.getExtractorClassName());
            Object extractor = clazz.newInstance();
            if (extractor instanceof ValueExtractor) {
                return (ValueExtractor)extractor;
            }
            throw new IllegalArgumentException("Extractor does not extend ValueExtractor class " + config);
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IllegalArgumentException("Could not initialize extractor " + config, ex);
        }
    }

    public static String extractAttributeNameNameWithoutArguments(String attributeNameWithArguments) {
        int start = StringUtil.lastIndexOf(attributeNameWithArguments, '[');
        int end = StringUtil.lastIndexOf(attributeNameWithArguments, ']');
        if (start > 0 && end > 0 && end > start) {
            return attributeNameWithArguments.substring(0, start);
        }
        if (start < 0 && end < 0) {
            return attributeNameWithArguments;
        }
        throw new IllegalArgumentException("Wrong argument input passed " + attributeNameWithArguments);
    }

    public static String extractArgumentsFromAttributeName(String attributeNameWithArguments) {
        int start = StringUtil.lastIndexOf(attributeNameWithArguments, '[');
        int end = StringUtil.lastIndexOf(attributeNameWithArguments, ']');
        if (start > 0 && end > 0 && end > start) {
            return attributeNameWithArguments.substring(start + 1, end);
        }
        if (start < 0 && end < 0) {
            return null;
        }
        throw new IllegalArgumentException("Wrong argument input passed " + attributeNameWithArguments);
    }

    public static boolean reducePrimitiveArrayInto(Consumer add, Object primitiveArray) {
        if (primitiveArray instanceof long[]) {
            long[] array = (long[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (long value : array) {
                add.accept(value);
            }
        } else if (primitiveArray instanceof int[]) {
            int[] array = (int[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (int value : array) {
                add.accept(value);
            }
        } else if (primitiveArray instanceof short[]) {
            short[] array = (short[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (short value : array) {
                add.accept(value);
            }
        } else if (primitiveArray instanceof byte[]) {
            byte[] array = (byte[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (byte value : array) {
                add.accept(value);
            }
        } else if (primitiveArray instanceof char[]) {
            char[] array = (char[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (char value : array) {
                add.accept(Character.valueOf(value));
            }
        } else if (primitiveArray instanceof boolean[]) {
            boolean[] array = (boolean[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (boolean value : array) {
                add.accept(value);
            }
        } else if (primitiveArray instanceof double[]) {
            double[] array = (double[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (double value : array) {
                add.accept(value);
            }
        } else if (primitiveArray instanceof float[]) {
            float[] array = (float[])primitiveArray;
            if (array.length == 0) {
                return false;
            }
            for (float value : array) {
                add.accept(Float.valueOf(value));
            }
        } else {
            throw new IllegalArgumentException("unexpected primitive array: " + primitiveArray);
        }
        return true;
    }
}

