/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.function.Function;
import org.compiere.minigrid.IMiniTable;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.eevolution.model.MPPProductBOM;
import org.eevolution.model.MPPProductBOMLine;

public class TreeBOM<T> {
    public static final CLogger log = CLogger.getCLogger(TreeBOM.class);
    protected Vector<Vector<Object>> dataBOM = new Vector();
    protected int m_selectedId = 0;

    public Properties getCtx() {
        return Env.getCtx();
    }

    public String productSummary(MProduct product, boolean isLeaf) {
        MUOM uom = MUOM.get((Properties)this.getCtx(), (int)product.getC_UOM_ID());
        String value = product.getValue();
        String name = product.get_Translation("Name");
        StringBuilder sb = new StringBuilder(value);
        if (name != null && !value.equals(name)) {
            sb.append("_").append(product.getName());
        }
        sb.append(" [").append(uom.get_Translation("UOMSymbol")).append("]");
        return sb.toString();
    }

    public String productSummary(MPPProductBOM bom) {
        String value = bom.getValue();
        String name = bom.get_Translation("Name");
        StringBuilder sb = new StringBuilder(value);
        if (name != null && !name.equals(value)) {
            sb.append("_").append(name);
        }
        return sb.toString();
    }

    public void setColumnClass(IMiniTable table) {
        table.setColumnClass(0, Boolean.class, true);
        table.setColumnClass(1, String.class, true);
        table.setColumnClass(2, KeyNamePair.class, true);
        table.setColumnClass(3, KeyNamePair.class, true);
        table.setColumnClass(4, BigDecimal.class, true);
    }

    public Vector<String> getColumnNames() {
        Vector<String> columnNames = new Vector<String>();
        columnNames.add(Msg.translate((Properties)Env.getCtx(), (String)"IsActive"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"Line"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"M_Product_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"C_UOM_ID"));
        columnNames.add(Msg.getElement((Properties)Env.getCtx(), (String)"QtyBOM"));
        return columnNames;
    }

    protected Vector<Object> newProductLine(MProduct product, int lineNo, BigDecimal qty) {
        Vector<Object> line = new Vector<Object>(5);
        line.add(product.isActive());
        line.add(Integer.valueOf(lineNo).toString());
        KeyNamePair pp = new KeyNamePair(product.getM_Product_ID(), product.getValue().concat("_").concat(product.getName()));
        line.add(pp);
        MUOM u = new MUOM(product.getCtx(), product.getC_UOM_ID(), product.get_TrxName());
        KeyNamePair uom = new KeyNamePair(u.get_ID(), u.getUOMSymbol());
        line.add(uom);
        line.add(qty.setScale(4, RoundingMode.HALF_UP).stripTrailingZeros());
        return line;
    }

    public void loadBOM(MProduct product, T parent, Function<NewNodeArguments<T>, T> createNewNodeFunction, boolean implosion, boolean reload) {
        int M_Product_ID;
        this.m_selectedId = M_Product_ID = product.getM_Product_ID();
        this.dataBOM.clear();
        if (implosion) {
            for (MPPProductBOMLine bomline : MPPProductBOMLine.getByProduct((MProduct)product)) {
                this.addParent(bomline, parent, createNewNodeFunction, reload);
            }
        } else {
            MPPProductBOMLine[] mPPProductBOMLineArray = MPPProductBOMLine.getBOMLines((MProduct)product);
            int n = mPPProductBOMLineArray.length;
            int n2 = 0;
            while (n2 < n) {
                MPPProductBOMLine bom = mPPProductBOMLineArray[n2];
                this.addChild(bom, parent, createNewNodeFunction, reload);
                ++n2;
            }
        }
    }

    protected void addParent(MPPProductBOMLine bomline, T parent, Function<NewNodeArguments<T>, T> createNewNodeFunction, boolean reload) {
        MPPProductBOM bom = new MPPProductBOM(this.getCtx(), bomline.getPP_Product_BOM_ID(), null);
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)bom.getM_Product_ID());
        Vector<Object> line = this.newProductLine(product, bomline.getLine(), bomline.getQtyBOM() != null ? bomline.getQtyBOM() : Env.ZERO);
        if (this.m_selectedId == bomline.getM_Product_ID()) {
            this.dataBOM.add(line);
        }
        T child = null;
        if (!reload) {
            List bomLines = MPPProductBOMLine.getByProduct((MProduct)product);
            child = createNewNodeFunction.apply(new NewNodeArguments<T>(line, parent, bomLines.isEmpty()));
            for (MPPProductBOMLine bl : bomLines) {
                this.addParent(bl, child, createNewNodeFunction, reload);
            }
        } else {
            return;
        }
    }

    protected void addChild(MPPProductBOMLine bomline, T parent, Function<NewNodeArguments<T>, T> createNewNodeFunction, boolean reload) {
        MProduct product = MProduct.get((Properties)this.getCtx(), (int)bomline.getM_Product_ID());
        Vector<Object> line = this.newProductLine(product, bomline.getLine(), bomline.getQtyBOM() != null ? bomline.getQtyBOM() : Env.ZERO);
        if (this.m_selectedId == bomline.getParent().getM_Product_ID()) {
            this.dataBOM.add(line);
        }
        T child = null;
        if (!reload) {
            MPPProductBOMLine[] bomLines = MPPProductBOMLine.getBOMLines((MProduct)product);
            child = createNewNodeFunction.apply(new NewNodeArguments<T>(line, parent, bomLines.length == 0));
            MPPProductBOMLine[] mPPProductBOMLineArray = bomLines;
            int n = bomLines.length;
            int n2 = 0;
            while (n2 < n) {
                MPPProductBOMLine bom = mPPProductBOMLineArray[n2];
                this.addChild(bom, child, createNewNodeFunction, reload);
                ++n2;
            }
        } else {
            return;
        }
    }

    public List<Vector<Object>> getDataBOM() {
        return Collections.unmodifiableList(this.dataBOM);
    }

    public record NewNodeArguments<T>(List<Object> dataLine, T parentNode, boolean isLeafNode) {
    }
}

