/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.apps;

import java.util.Properties;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.apps.LabelsSearchController;
import org.adempiere.webui.component.Bandbox;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.Page;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.InputEvent;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zul.Bandpopup;
import org.zkoss.zul.Div;

public class LabelsSearch
extends Div
implements EventListener<Event> {
    private static final long serialVersionUID = -8793878697269469837L;
    private static final String ON_ENTER_KEY_EVENT = "onEnterKey";
    private static final String ON_CREATE_ECHO_EVENT = "onCreateEcho";
    private static final String ON_SEARCH_EVENT = "onSearch";
    private static final String LAST_ONCHANGING_ATTR = "last.onchanging";
    private Bandbox bandbox;
    private LabelsSearchController controller;

    public LabelsSearch(LabelsSearchController controller) {
        this.controller = controller;
        this.init();
    }

    private void init() {
        this.bandbox = new Bandbox();
        this.appendChild((Component)this.bandbox);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.bandbox, "100%");
        this.bandbox.setAutodrop(true);
        this.bandbox.setId("labelsSearchBox");
        this.bandbox.addEventListener("onChanging", this);
        this.bandbox.addEventListener("onChange", this);
        this.bandbox.setCtrlKeys("#up#down");
        this.bandbox.addEventListener("onCtrlKey", this);
        this.bandbox.setPlaceholder(Msg.getMsg((Properties)Env.getCtx(), (String)"TypeToSearchOrCreate"));
        Bandpopup popup = new Bandpopup();
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)popup, 100);
        ZKUpdateUtil.setWindowWidthX((HtmlBasedComponent)popup, 176);
        this.bandbox.appendChild((Component)popup);
        this.controller.create((Component)popup);
        this.addEventListener(ON_SEARCH_EVENT, this);
        this.addEventListener(ON_CREATE_ECHO_EVENT, this);
        this.addEventListener("onPostSelectLabelitem", this);
        this.bandbox.addEventListener(ON_ENTER_KEY_EVENT, this);
    }

    public void onEvent(Event event) throws Exception {
        if ("onChanging".equals(event.getName())) {
            InputEvent inputEvent = (InputEvent)event;
            String value = inputEvent.getValue();
            this.bandbox.setAttribute(LAST_ONCHANGING_ATTR, value);
            Events.postEvent((String)ON_SEARCH_EVENT, (Component)this, (Object)value);
        } else if ("onChange".equals(event.getName())) {
            this.bandbox.removeAttribute(LAST_ONCHANGING_ATTR);
        } else if ("onCtrlKey".equals(event.getName())) {
            LabelsSearchController.LabelItem selected;
            KeyEvent ke = (KeyEvent)event;
            if (ke.getKeyCode() == 38) {
                LabelsSearchController.LabelItem selected2;
                if (this.bandbox.getFirstChild().isVisible() && (selected2 = this.controller.selectPrior()) != null) {
                    this.bandbox.setText(selected2.getLabel());
                }
            } else if (ke.getKeyCode() == 40 && this.bandbox.getFirstChild().isVisible() && (selected = this.controller.selectNext()) != null) {
                this.bandbox.setText(selected.getLabel());
            }
        } else if (event.getName().equals(ON_SEARCH_EVENT)) {
            String value = (String)event.getData();
            this.controller.search(value);
            this.bandbox.focus();
        } else if (event.getName().equals(ON_CREATE_ECHO_EVENT)) {
            StringBuilder script = new StringBuilder("jq('#").append(this.bandbox.getUuid()).append("').bind('keydown', function(e) {var code=e.keyCode||e.which;if(code==13){").append("var widget=zk.Widget.$(this);").append("var event=new zk.Event(widget,'").append(ON_ENTER_KEY_EVENT).append("',{},{toServer:true});").append("zAu.send(event);").append("}});");
            Clients.evalJavaScript((String)script.toString());
        } else if (event.getName().equals(ON_ENTER_KEY_EVENT)) {
            if (event.getTarget() instanceof Bandbox) {
                this.controller.onSelect(this.controller.getSelectedItem());
            }
        } else if (event.getName().equals("onSelect")) {
            String value = (String)this.bandbox.getAttribute(LAST_ONCHANGING_ATTR);
            if (value == null) {
                value = this.bandbox.getValue();
            }
            Events.postEvent((String)ON_SEARCH_EVENT, (Component)this, (Object)value);
        }
        if (event.getName().equals("onPostSelectLabelitem")) {
            this.closePopup();
            this.bandbox.focus();
            this.bandbox.setText(null);
            this.bandbox.setValue(null);
        }
    }

    public void onPageAttached(Page newpage, Page oldpage) {
        super.onPageAttached(newpage, oldpage);
        Events.echoEvent((String)ON_CREATE_ECHO_EVENT, (Component)this, null);
    }

    public void closePopup() {
        if (this.bandbox != null) {
            this.bandbox.close();
        }
    }

    public void onClientInfo() {
        ZKUpdateUtil.setWindowHeightX((HtmlBasedComponent)this.bandbox.getDropdown(), ClientInfo.get().desktopHeight - 50);
    }
}

