/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.window;

import org.adempiere.webui.component.ConfirmPanel;
import org.adempiere.webui.component.Urlbox;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.editor.WImageURLEditor;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zul.Vlayout;

public class WImageURLDialog
extends Window {
    private static final long serialVersionUID = 5623154038308907944L;
    private Urlbox url;
    private WImageURLEditor editor;
    private boolean cancel = true;
    private ConfirmPanel confirmPanel;

    public WImageURLDialog(WImageURLEditor editor) {
        this.editor = editor;
        this.layout();
    }

    private void layout() {
        Vlayout layout = new Vlayout();
        layout.setWidth("100%");
        layout.setVflex("min");
        this.url = new Urlbox();
        this.url.setText(this.editor.getDisplay());
        this.url.setHflex("1");
        this.url.setVflex("min");
        layout.appendChild((Component)this.url);
        this.confirmPanel = new ConfirmPanel(true);
        layout.appendChild((Component)this.confirmPanel);
        this.confirmPanel.addActionListener(e -> this.onConfirmPanelAction(e));
        this.confirmPanel.setHflex("1");
        this.confirmPanel.setVflex("min");
        this.addEventListener("onCancel", e -> this.onCancel());
        this.addEventListener("onOK", e -> this.onOk());
        this.appendChild((Component)layout);
    }

    private void onCancel() {
        this.cancel = true;
        this.onOk();
    }

    private void onConfirmPanelAction(Event e) {
        if (e.getTarget() == this.confirmPanel.getButton("Cancel")) {
            this.onCancel();
        } else if (e.getTarget() == this.confirmPanel.getButton("Ok")) {
            this.onOk();
        }
    }

    private void onOk() {
        this.cancel = false;
        this.dispose();
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public String getValue() {
        return this.url.getText();
    }

    public void focus() {
        super.focus();
        this.url.focus();
    }
}

