/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Properties;
import org.adempiere.util.Callback;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.Menupopup;
import org.adempiere.webui.component.Messagebox;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.FeedbackManager;
import org.adempiere.webui.window.Dialog;
import org.adempiere.webui.window.WPreference;
import org.compiere.model.MClient;
import org.compiere.model.MOrg;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.MWarehouse;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zk.ui.util.Clients;
import org.zkoss.zk.ui.util.Composer;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Popup;
import org.zkoss.zul.Space;
import org.zkoss.zul.Vlayout;
import org.zkoss.zul.Window;
import org.zkoss.zul.impl.LabelImageElement;

public class UserPanel
implements EventListener<Event>,
Composer<Component> {
    protected Properties ctx;
    protected LabelImageElement logout;
    protected LabelImageElement changeRole;
    protected LabelImageElement preference;
    protected LabelImageElement feedback;
    protected Label lblUserNameValue = new Label();
    protected WPreference preferencePopup;
    protected Menupopup feedbackMenu;
    protected Component component;
    protected Component userPanelLinksContainer;
    private Popup popup;
    private static final String ON_DEFER_CHANGE_ROLE = "onDeferChangeRole";
    private static final String ON_DEFER_LOGOUT = "onDeferLogout";

    public UserPanel() {
        this.ctx = Env.getCtx();
    }

    protected void onCreate() {
        String s = Msg.getMsg((Properties)Env.getCtx(), (String)"CloseTabFromBrowser?").replace("\n", "<br>");
        Clients.confirmClose((String)s);
        this.lblUserNameValue = (Label)this.component.getFellowIfAny("loginUserAndRole", true);
        if (this.isMobile()) {
            this.lblUserNameValue.setValue(this.getUserName());
            LayoutUtils.addSclass("mobile", (HtmlBasedComponent)this.component);
        } else {
            this.lblUserNameValue.setValue(this.getUserName() + "@" + this.getClientName() + "." + this.getOrgName() + "/" + this.getRoleName());
        }
        this.lblUserNameValue.addEventListener("onClick", this);
        this.feedback = (LabelImageElement)this.component.getFellowIfAny("feedback", true);
        this.feedback.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Feedback"));
        this.feedback.addEventListener("onClick", (EventListener)this);
        this.preference = (LabelImageElement)this.component.getFellowIfAny("preference", true);
        this.preference.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Preference"));
        this.preference.addEventListener("onClick", (EventListener)this);
        this.changeRole = (LabelImageElement)this.component.getFellowIfAny("changeRole", true);
        this.changeRole.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"changeRole"));
        this.changeRole.addEventListener("onClick", (EventListener)this);
        this.logout = (LabelImageElement)this.component.getFellowIfAny("logout", true);
        this.logout.setLabel(Msg.getMsg((Properties)Env.getCtx(), (String)"Logout"));
        this.logout.addEventListener("onClick", (EventListener)this);
        this.feedbackMenu = new Menupopup();
        Menuitem mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"RequestNew"));
        mi.setIconSclass("z-icon-comment");
        mi.setId("CreateRequest");
        this.feedbackMenu.appendChild((Component)mi);
        mi.addEventListener("onClick", (EventListener)this);
        mi = new Menuitem(Msg.getMsg((Properties)Env.getCtx(), (String)"EMailSupport"));
        mi.setIconSclass("z-icon-envelope");
        mi.setId("EmailSupport");
        mi.addEventListener("onClick", (EventListener)this);
        this.feedbackMenu.appendChild((Component)mi);
        SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", this);
        this.component.addEventListener("onEmailSupport", (EventListener)this);
        this.component.addEventListener(ON_DEFER_LOGOUT, (EventListener)this);
        this.component.addEventListener(ON_DEFER_CHANGE_ROLE, (EventListener)this);
        this.userPanelLinksContainer = this.component.getFellowIfAny("userPanelLinksContainer", true);
        if (this.isMobile() && this.userPanelLinksContainer != null) {
            this.userPanelLinksContainer.detach();
        }
    }

    private boolean isMobile() {
        return ClientInfo.isMobile();
    }

    private String getUserName() {
        MUser user = MUser.get((Properties)this.ctx);
        return user.getName();
    }

    private String getRoleName() {
        MRole role = MRole.getDefault((Properties)this.ctx, (boolean)false);
        return role.getName();
    }

    private String getClientName() {
        MClient client = MClient.get((Properties)this.ctx);
        return client.getName();
    }

    private String getOrgName() {
        int orgId = Env.getAD_Org_ID((Properties)this.ctx);
        if (orgId > 0) {
            MOrg org = MOrg.get((Properties)this.ctx, (int)orgId);
            return org.getName();
        }
        return "*";
    }

    public void onEvent(Event event) throws Exception {
        if (event == null) {
            return;
        }
        if (this.logout == event.getTarget()) {
            if (SessionManager.getAppDesktop().isPendingWindow()) {
                Dialog.ask(0, "ProceedWithTask?", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            Events.echoEvent((String)UserPanel.ON_DEFER_LOGOUT, (Component)UserPanel.this.component, null);
                        }
                    }
                });
            } else {
                Events.echoEvent((String)ON_DEFER_LOGOUT, (Component)this.component, null);
            }
        } else if (this.lblUserNameValue == event.getTarget()) {
            if (this.isMobile()) {
                this.openMobileUserPanelPopup();
            } else {
                String roleInfo = MRole.getDefault().toStringX(Env.getCtx());
                roleInfo = roleInfo.replace(Env.NL, "<br>");
                Messagebox.showDialog(roleInfo, Msg.getMsg((Properties)this.ctx, (String)"RoleInfo"), 1, "~./zul/img/msgbox/info-btn.png");
            }
        } else if (this.changeRole == event.getTarget()) {
            if (SessionManager.getAppDesktop().isPendingWindow()) {
                Dialog.ask(0, "ProceedWithTask?", new Callback<Boolean>(){

                    public void onCallback(Boolean result) {
                        if (result.booleanValue()) {
                            Events.postEvent((String)UserPanel.ON_DEFER_CHANGE_ROLE, (Component)UserPanel.this.component, null);
                        }
                    }
                });
            } else {
                Events.postEvent((String)ON_DEFER_CHANGE_ROLE, (Component)this.component, null);
            }
        } else if (this.preference == event.getTarget()) {
            if (this.preferencePopup != null) {
                this.preferencePopup.detach();
            }
            this.preferencePopup = new WPreference();
            this.preferencePopup.setPage(this.component.getPage());
            LayoutUtils.openPopupWindow((Component)this.preference, (Window)this.preferencePopup, "after_start");
        } else if (this.feedback == event.getTarget()) {
            if (this.isMobile() && this.userPanelLinksContainer != null) {
                this.userPanelLinksContainer.appendChild((Component)this.feedbackMenu);
            } else if (this.feedbackMenu.getPage() == null) {
                this.component.appendChild((Component)this.feedbackMenu);
            }
            this.feedbackMenu.open((Component)this.feedback, "after_start");
        } else if (event.getTarget() instanceof Menuitem) {
            Menuitem mi = (Menuitem)event.getTarget();
            if ("CreateRequest".equals(mi.getId())) {
                FeedbackManager.createNewRequest();
            } else if ("EmailSupport".equals(mi.getId())) {
                FeedbackManager.emailSupport(false);
            }
        } else if (event instanceof KeyEvent) {
            KeyEvent ke = (KeyEvent)event;
            if (ke.getKeyCode() == 85) {
                if (ke.isAltKey()) {
                    FeedbackManager.emailSupport(false);
                } else if (ke.isCtrlKey()) {
                    FeedbackManager.createNewRequest();
                }
            }
        } else if (ON_DEFER_LOGOUT.equals(event.getName())) {
            Clients.confirmClose(null);
            SessionManager.logoutSession();
        } else if (ON_DEFER_CHANGE_ROLE.equals(event.getName())) {
            MUser user = MUser.get((Properties)this.ctx);
            Clients.confirmClose(null);
            SessionManager.changeRole(user);
        }
    }

    protected void openMobileUserPanelPopup() {
        if (this.popup != null) {
            Object value = this.popup.removeAttribute(this.popup.getUuid());
            if (value != null && value instanceof Long) {
                long ts = (Long)value;
                long since = System.currentTimeMillis() - ts;
                if (since < 500L) {
                    this.popup.detach();
                    this.popup = null;
                    return;
                }
            }
            this.popup.detach();
        }
        this.popup = new Popup();
        this.popup.setSclass("user-panel-popup");
        Vlayout layout = new Vlayout();
        String email = this.getUserEmail();
        if (!Util.isEmpty((String)email)) {
            layout.appendChild((Component)new Label(this.getUserName() + " <" + email + ">"));
        } else {
            layout.appendChild((Component)new Label(this.getUserName()));
        }
        layout.appendChild((Component)new Label(this.getRoleName()));
        layout.appendChild((Component)new Label(this.getClientName() + "." + this.getOrgName()));
        String warehouse = this.getWarehouseName();
        if (!Util.isEmpty((String)warehouse)) {
            layout.appendChild((Component)new Label(warehouse));
        }
        layout.appendChild((Component)new Space());
        layout.appendChild(this.userPanelLinksContainer);
        this.popup.appendChild((Component)layout);
        this.popup.setPage(this.component.getPage());
        this.popup.setVflex("min");
        this.popup.setHflex("min");
        this.popup.setStyle("max-width: " + ClientInfo.get().desktopWidth + "px");
        this.popup.addEventListener("onOpen", oe -> {
            if (!oe.isOpen()) {
                this.popup.setAttribute(this.popup.getUuid(), (Object)System.currentTimeMillis());
            }
        });
        this.popup.open((Component)this.lblUserNameValue, "after_start");
    }

    private String getUserEmail() {
        MUser user = MUser.get((Properties)this.ctx);
        return user.getEMail();
    }

    private String getWarehouseName() {
        int id = Env.getContextAsInt((Properties)Env.getCtx(), (String)"#M_Warehouse_ID");
        if (id > 0) {
            return MWarehouse.get((Properties)Env.getCtx(), (int)id).getName();
        }
        return null;
    }

    public void doAfterCompose(Component comp) throws Exception {
        this.component = comp;
        this.onCreate();
    }
}

