/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.panel;

import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.webui.Extensions;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.component.Window;
import org.adempiere.webui.desktop.IDesktop;
import org.adempiere.webui.exception.ApplicationException;
import org.adempiere.webui.panel.IFormController;
import org.adempiere.webui.panel.IHelpContext;
import org.adempiere.webui.session.SessionManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.compiere.model.GridTab;
import org.compiere.model.MForm;
import org.compiere.model.MSysConfig;
import org.compiere.process.ProcessInfo;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zk.ui.event.Events;
import org.zkoss.zk.ui.event.KeyEvent;
import org.zkoss.zul.Window;

public abstract class ADForm
extends Window
implements EventListener<Event>,
IHelpContext {
    private static final long serialVersionUID = -5381283117636286759L;
    protected static final CLogger logger = CLogger.getCLogger(ADForm.class);
    private int m_adFormId;
    protected int m_WindowNo;
    private String m_name;
    private ProcessInfo m_pi;
    private IFormController m_customForm;
    private boolean isUseEscForTabClosing = MSysConfig.getBooleanValue((String)"USE_ESC_FOR_TAB_CLOSING", (boolean)false, (int)Env.getAD_Client_ID((Properties)Env.getCtx()));
    private GridTab gridTab;

    protected ADForm() {
        this.m_WindowNo = SessionManager.getAppDesktop().registerWindow(this);
        ZKUpdateUtil.setWidth((HtmlBasedComponent)this, "100%");
        ZKUpdateUtil.setHeight((HtmlBasedComponent)this, "99%");
        this.setStyle("position:relative");
        this.setContentSclass("adform-content");
    }

    public int getWindowNo() {
        return this.m_WindowNo;
    }

    protected int getAdFormId() {
        return this.m_adFormId;
    }

    protected void init(int adFormId, String name) {
        if (adFormId <= 0) {
            throw new IllegalArgumentException("Form Id is invalid");
        }
        this.m_adFormId = adFormId;
        this.setTitle(name);
        this.m_name = name;
        this.initForm();
        this.addEventListener("onWindowContainerSelectionChanged", this);
    }

    protected abstract void initForm();

    public String getFormName() {
        return this.m_name;
    }

    public static ADForm openForm(int adFormID) {
        return ADForm.openForm(adFormID, null, null, null, false);
    }

    public static ADForm openForm(int formId, String predefinedContextVariables) {
        return ADForm.openForm(formId, null, null, predefinedContextVariables, false);
    }

    public static ADForm openForm(int adFormID, GridTab gridTab) {
        return ADForm.openForm(adFormID, gridTab, null, null, false);
    }

    public static ADForm openForm(int adFormID, GridTab gridTab, ProcessInfo pi) {
        return ADForm.openForm(adFormID, gridTab, pi, null, false);
    }

    public static ADForm openForm(int adFormID, GridTab gridTab, ProcessInfo pi, String predefinedContextVariables, boolean isSOTrx) {
        ADForm form;
        MForm mform = MForm.get((int)adFormID);
        String formName = mform.getClassname();
        String name = mform.get_Translation("Name");
        if (mform.get_ID() == 0 || formName == null) {
            throw new ApplicationException("There is no form associated with the specified form ID");
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("AD_Form_ID=" + adFormID + " - Class=" + formName);
        }
        if ((form = Extensions.getForm(formName)) != null) {
            form.gridTab = gridTab;
            form.setProcessInfo(pi);
            Env.setPredefinedVariables((Properties)Env.getCtx(), (int)form.getWindowNo(), (String)predefinedContextVariables);
            Env.setContext((Properties)Env.getCtx(), (int)form.getWindowNo(), (String)"IsSOTrx", (boolean)isSOTrx);
            form.init(adFormID, name);
            form.setAttribute("desktop.windowno", form.getWindowNo());
            SessionManager.getSessionApplication().getKeylistener().addEventListener("onCtrlKey", form);
            form.addEventListener("onCloseWindowShortcut", form);
            return form;
        }
        throw new ApplicationException("Failed to open " + formName);
    }

    public void onEvent(Event event) throws Exception {
        if (event.getName().equals("onWindowContainerSelectionChanged")) {
            SessionManager.getAppDesktop().updateHelpContext("F", this.getAdFormId());
        } else if (event.getName().equals("onCtrlKey")) {
            KeyEvent keyEvent = (KeyEvent)event;
            if (LayoutUtils.isReallyVisible((Component)this)) {
                this.onCtrlKeyEvent(keyEvent);
            }
        } else if ("onCloseWindowShortcut".equals(event.getName())) {
            IDesktop desktop = SessionManager.getAppDesktop();
            if (this.m_WindowNo > 0 && desktop.isCloseTabWithShortcut()) {
                desktop.closeWindow(this.m_WindowNo);
            } else {
                desktop.setCloseTabWithShortcut(true);
            }
        }
    }

    public void setProcessInfo(ProcessInfo pi) {
        this.m_pi = pi;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public void setICustomForm(IFormController customForm) {
        this.m_customForm = customForm;
    }

    public IFormController getICustomForm() {
        return this.m_customForm;
    }

    public Window.Mode getWindowMode() {
        return Window.Mode.EMBEDDED;
    }

    public GridTab getGridTab() {
        return this.gridTab;
    }

    private void onCtrlKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.isAltKey() && keyEvent.getKeyCode() == 88 || keyEvent.getKeyCode() == 27 && this.isUseEscForTabClosing) {
            keyEvent.stopPropagation();
            Events.echoEvent((Event)new Event("onCloseWindowShortcut", (Component)this));
        }
    }
}

