/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.webui.editor;

import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.adempiere.util.GridRowCtx;
import org.adempiere.webui.ClientInfo;
import org.adempiere.webui.LayoutUtils;
import org.adempiere.webui.adwindow.ADWindow;
import org.adempiere.webui.adwindow.IFieldEditorContainer;
import org.adempiere.webui.component.Bandbox;
import org.adempiere.webui.component.Button;
import org.adempiere.webui.component.ComboEditorBox;
import org.adempiere.webui.component.Datebox;
import org.adempiere.webui.component.DatetimeBox;
import org.adempiere.webui.component.EditorBox;
import org.adempiere.webui.component.Label;
import org.adempiere.webui.component.NumberBox;
import org.adempiere.webui.component.Paymentbox;
import org.adempiere.webui.editor.IEditorConfiguration;
import org.adempiere.webui.editor.IInputValidator;
import org.adempiere.webui.editor.IZoomableEditor;
import org.adempiere.webui.editor.WEditorPopupMenu;
import org.adempiere.webui.event.ContextMenuListener;
import org.adempiere.webui.event.ValueChangeEvent;
import org.adempiere.webui.event.ValueChangeListener;
import org.adempiere.webui.theme.ThemeManager;
import org.adempiere.webui.util.ZKUpdateUtil;
import org.adempiere.webui.window.WFieldRecordInfo;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MRole;
import org.compiere.model.MStyle;
import org.compiere.util.Env;
import org.compiere.util.Evaluatee;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.zkoss.zk.ui.Component;
import org.zkoss.zk.ui.Desktop;
import org.zkoss.zk.ui.Executions;
import org.zkoss.zk.ui.HtmlBasedComponent;
import org.zkoss.zk.ui.event.Event;
import org.zkoss.zk.ui.event.EventListener;
import org.zkoss.zul.Combobox;
import org.zkoss.zul.Menuitem;
import org.zkoss.zul.Textbox;
import org.zkoss.zul.Timebox;
import org.zkoss.zul.impl.InputElement;
import org.zkoss.zul.impl.XulElement;

public abstract class WEditor
implements EventListener<Event>,
PropertyChangeListener,
IInputValidator {
    public static final String IDEMPIERE_EDITOR_ATTR = "idempiere.editor";
    private static final String[] lISTENER_EVENTS = new String[0];
    public static final int MAX_DISPLAY_LENGTH = 35;
    public static final String INIT_EDIT_EVENT = "onInitEdit";
    protected GridField gridField;
    protected GridTab gridTab;
    protected Label label;
    protected Component component;
    protected boolean mandatory;
    protected ArrayList<ValueChangeListener> listeners = new ArrayList();
    private String strLabel;
    private String description;
    protected boolean readOnly;
    private String columnName;
    protected WEditorPopupMenu popupMenu;
    protected boolean tableEditor;
    private boolean isProcessParameter;
    private String sValidInput;
    private final List<DynamicDisplayListener> dynamicDisplayListeners = new ArrayList<DynamicDisplayListener>();
    private static final String CLASS_MANDATORY_FIELD = "idempiere-mandatory";
    private static final String CLASS_ZOOMABLE_LABEL = "idempiere-zoomable-label";
    private static final String CLASS_NORMAL_LABEL = "idempiere-label";
    private static final String CLASS_EMPTY_MANDATORY_LABEL = "idempiere-mandatory-label";
    private static final String STYLE_MOBILE_ZOOMABLE = "cursor: pointer;";

    public void showMenu() {
        if (this.popupMenu == null) {
            return;
        }
        if (ContextMenuListener.class.isInstance(this)) {
            this.popupMenu.addMenuListener((ContextMenuListener)((Object)this));
        }
        this.component.getParent().appendChild((Component)this.popupMenu);
        if (!this.readOnly) {
            if (ClientInfo.isMobile()) {
                this.label.addEventListener("onClick", evt -> this.popupMenu.open((Component)this.label, "after_end"));
            } else {
                if (this.popupMenu.isZoomEnabled() && this instanceof IZoomableEditor) {
                    this.label.addEventListener("onClick", (EventListener)new EventListener<Event>(){

                        public void onEvent(Event event) throws Exception {
                            if ("onClick".equals(event.getName())) {
                                ((IZoomableEditor)((Object)WEditor.this)).actionZoom();
                            }
                        }
                    });
                }
                this.popupMenu.addContextElement((XulElement)this.label);
                if (this.component instanceof XulElement) {
                    this.popupMenu.addContextElement((XulElement)this.component);
                }
            }
        }
    }

    public WEditor(Component comp, GridField gridField) {
        this(comp, gridField, -1);
    }

    public WEditor(Component comp, GridField gridField, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        this(comp, gridField, -1, tableEditor, editorConfiguration);
    }

    public WEditor(Component comp, GridField gridField, int rowIndex) {
        this(comp, gridField, rowIndex, false, null);
    }

    public WEditor(Component comp, GridField gridField, int rowIndex, boolean tableEditor, IEditorConfiguration editorConfiguration) {
        if (comp == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        if (gridField == null) {
            throw new IllegalArgumentException("Grid field cannot be null");
        }
        this.setComponent(comp);
        this.gridField = gridField;
        if (gridField.getGridTab() != null) {
            comp.setClientAttribute("instanceName", gridField.getGridTab().getTableName() + "0" + gridField.getColumnName());
            this.gridTab = gridField.getGridTab();
        } else {
            comp.setClientAttribute("instanceName", gridField.getColumnName());
        }
        if (editorConfiguration != null && editorConfiguration.getMandatory() != null) {
            this.setMandatory(editorConfiguration.getMandatory());
        } else {
            this.setMandatory(gridField.isMandatory(true));
        }
        this.tableEditor = tableEditor;
        this.readOnly = editorConfiguration != null && editorConfiguration.getReadonly() != null ? editorConfiguration.getReadonly().booleanValue() : gridField.isReadOnly();
        this.description = gridField.getDescription();
        this.columnName = gridField.getColumnName();
        this.strLabel = gridField.getHeader();
        this.init();
    }

    public void setChangeEventWhenEditing(boolean isChangeEventWhenEditing) {
        this.component.setWidgetOverride("isChangeEventWhenEditing", String.valueOf(isChangeEventWhenEditing));
    }

    public String getDescription() {
        return this.description;
    }

    public WEditor(Component comp, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        this(comp, null, label, description, mandatory, readonly, updateable);
    }

    public WEditor(Component comp, String columnName, String label, String description, boolean mandatory, boolean readonly, boolean updateable) {
        if (comp == null) {
            throw new IllegalArgumentException("Component cannot be null");
        }
        this.setComponent(comp);
        this.setMandatory(mandatory);
        this.readOnly = readonly;
        this.description = description;
        this.strLabel = label;
        this.columnName = columnName;
        this.init();
    }

    protected void setComponent(Component comp) {
        this.component = comp;
    }

    private void init() {
        this.label = new Label("");
        this.label.setValue(this.strLabel);
        this.label.setTooltiptext(this.description);
        this.label.setMandatory(this.mandatory);
        this.setMandatory(this.mandatory);
        this.setReadWrite(!this.readOnly);
        ((HtmlBasedComponent)this.component).setTooltiptext(this.description);
        this.label.setTooltiptext(this.description);
        String[] stringArray = this.getEvents();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String event = stringArray[n2];
            this.component.addEventListener(event, (EventListener)this);
            ++n2;
        }
        this.component.addEventListener(INIT_EDIT_EVENT, (EventListener)this);
        this.component.setAttribute(IDEMPIERE_EDITOR_ATTR, (Object)this);
        this.component.addEventListener("onFocus", e -> {
            ADWindow adwindow = ADWindow.findADWindow(this.component);
            if (adwindow != null) {
                adwindow.getADWindowContent().setLastFocusEditor(this.component);
            }
        });
    }

    public GridField getGridField() {
        return this.gridField;
    }

    public String getColumnName() {
        return this.columnName;
    }

    protected String cleanColumnName(String originalColumnName) {
        String cleanColumnName = originalColumnName.replaceAll(".*\\.", "");
        return cleanColumnName;
    }

    protected void setColumnName(String columnName) {
        String cleanColumnName;
        this.columnName = cleanColumnName = this.cleanColumnName(columnName);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setGridTab(GridTab gridTab) {
        this.gridTab = gridTab;
    }

    public WEditorPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("FieldValue")) {
            if (Executions.getCurrent() == null) {
                Executions.schedule((Desktop)this.getComponent().getDesktop(), (EventListener)new EventListener<Event>(){

                    public void onEvent(Event event) throws Exception {
                        WEditor.this.setValue(evt.getNewValue());
                    }
                }, (Event)new Event("onPropertyChange"));
            } else {
                this.setValue(evt.getNewValue());
            }
        }
    }

    public void addValueChangeListener(ValueChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public boolean removeValuechangeListener(ValueChangeListener listener) {
        return this.listeners.remove(listener);
    }

    public void fireValueChange(ValueChangeEvent event) {
        ValueChangeListener[] vcl = new ValueChangeListener[this.listeners.size()];
        this.listeners.toArray(vcl);
        ValueChangeListener[] valueChangeListenerArray = vcl;
        int n = vcl.length;
        int n2 = 0;
        while (n2 < n) {
            ValueChangeListener listener = valueChangeListenerArray[n2];
            listener.valueChange(event);
            ++n2;
        }
    }

    public Label getLabel() {
        return this.label;
    }

    public abstract void setReadWrite(boolean var1);

    public abstract boolean isReadWrite();

    public void setVisible(boolean visible) {
        this.setVisible(visible, visible);
    }

    public void setVisible(boolean visible, boolean labelVisible) {
        this.label.setVisible(labelVisible);
        this.component.setVisible(visible);
    }

    public boolean isVisible() {
        return this.component.isVisible();
    }

    public void setBackground(boolean error) {
    }

    public void setBackground(Color color) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(30);
        sb.append(this.getClass().getName());
        sb.append("[").append(this.getColumnName());
        sb.append("=");
        sb.append(this.getValue()).append("]");
        return sb.toString();
    }

    public abstract void setValue(Object var1);

    public abstract Object getValue();

    public abstract String getDisplay();

    public String getDisplayTextForGridView(Object value) {
        return this.getDisplayTextForGridView(null, value);
    }

    public String getDisplayTextForGridView(GridRowCtx gridRowCtx, Object value) {
        this.setValue(value);
        String s = this.getDisplay();
        if ("<0>".equals(s)) {
            s = "";
        }
        return s;
    }

    public String[] getEvents() {
        return lISTENER_EVENTS;
    }

    public void setMandatory(boolean mandatory) {
        if (this.mandatory != mandatory) {
            this.mandatory = mandatory;
            if (this.label != null) {
                this.label.setMandatory(mandatory);
            }
        }
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void dynamicDisplay() {
        this.dynamicDisplay(this.gridField != null ? this.gridField.getVO().ctx : Env.getCtx());
    }

    public void dynamicDisplay(Properties ctx) {
        if (this.gridField != null) {
            this.updateStyle();
        }
        if (!this.dynamicDisplayListeners.isEmpty()) {
            this.dynamicDisplayListeners.stream().forEach(e -> e.onDynamicDisplay(ctx, this));
        }
    }

    public void updateStyle(boolean applyDictionaryStyle) {
        this.applyLabelStyles(applyDictionaryStyle);
        this.applyFieldStyles(applyDictionaryStyle);
    }

    public void updateStyle() {
        this.applyLabelStyles(true);
        this.applyFieldStyles(true);
    }

    protected void applyLabelStyles(boolean applyDictionaryStyle) {
        if (this.label != null) {
            boolean zoomable = this.isZoomable();
            LayoutUtils.addSclass(CLASS_NORMAL_LABEL, (HtmlBasedComponent)this.label);
            if (zoomable) {
                LayoutUtils.addSclass(CLASS_ZOOMABLE_LABEL, (HtmlBasedComponent)this.label);
            }
            if (this.isMandatoryStyle()) {
                LayoutUtils.addSclass(CLASS_EMPTY_MANDATORY_LABEL, (HtmlBasedComponent)this.label);
            } else {
                LayoutUtils.removeSclass(CLASS_EMPTY_MANDATORY_LABEL, (HtmlBasedComponent)this.label);
            }
            Object style = "";
            if (ClientInfo.isMobile() && !zoomable && this.popupMenu != null) {
                style = (String)style + STYLE_MOBILE_ZOOMABLE;
            }
            if (applyDictionaryStyle && this.gridField.getAD_LabelStyle_ID() > 0) {
                String s = this.buildStyle(this.gridField.getAD_LabelStyle_ID());
                if (!Util.isEmpty((String)s)) {
                    style = (String)style + s;
                }
                this.setLabelStyle((String)style);
            } else {
                this.setLabelStyle((String)style);
            }
        }
    }

    protected void setLabelStyle(String style) {
        if (this.label != null) {
            if (style != null && style.toLowerCase().startsWith("@sclass=")) {
                String sclass = style.substring("@sclass=".length());
                this.label.setSclass(sclass);
            } else if (style != null && style.toLowerCase().startsWith("@zclass=")) {
                String zclass = style.substring("@zclass=".length());
                this.label.setZclass(zclass);
            } else {
                this.label.setStyle(style);
            }
        }
    }

    protected void applyFieldStyles(boolean applyDictionaryStyle) {
        String style = null;
        if (applyDictionaryStyle && this.gridField.getAD_FieldStyle_ID() > 0) {
            style = this.buildStyle(this.gridField.getAD_FieldStyle_ID());
            this.setFieldStyle(style);
        }
        this.setFieldMandatoryStyle(applyDictionaryStyle);
    }

    private void setFieldMandatoryStyle(boolean applyStyle) {
        HtmlBasedComponent component = (HtmlBasedComponent)this.getComponent();
        if (component != null) {
            if (this.isMandatoryStyle() && applyStyle) {
                LayoutUtils.addSclass(CLASS_MANDATORY_FIELD, component);
            } else {
                LayoutUtils.removeSclass(CLASS_MANDATORY_FIELD, component);
            }
        }
    }

    protected void setFieldStyle(String style) {
        HtmlBasedComponent component = (HtmlBasedComponent)this.getComponent();
        if (style != null && style.startsWith("@sclass=")) {
            String sclass = style.substring("@sclass=".length());
            if (component instanceof EditorBox) {
                ((EditorBox)component).getTextbox().setSclass(sclass);
            } else if (component instanceof ComboEditorBox) {
                ((ComboEditorBox)component).getCombobox().setSclass(sclass);
            } else {
                component.setSclass(sclass);
            }
        } else if (style != null && style.startsWith("@zclass=")) {
            String zclass = style.substring("@zclass=".length());
            if (component instanceof EditorBox) {
                ((EditorBox)component).getTextbox().setZclass(zclass);
            } else if (component instanceof ComboEditorBox) {
                ((ComboEditorBox)component).getCombobox().setZclass(zclass);
            } else {
                component.setZclass(zclass);
            }
        } else if (component instanceof EditorBox) {
            ((EditorBox)component).getTextbox().setStyle(style);
        } else if (component instanceof ComboEditorBox) {
            ((ComboEditorBox)component).getCombobox().setStyle(style);
        } else {
            component.setStyle(style);
        }
    }

    public boolean isSearchable() {
        return true;
    }

    protected String buildStyle(int AD_Style_ID) {
        MStyle style = MStyle.get((Properties)Env.getCtx(), (int)AD_Style_ID);
        return style.buildStyle(ThemeManager.getTheme(), this.getStyleEvaluatee());
    }

    public void fillHorizontal() {
        if (!(!(this.getComponent() instanceof HtmlBasedComponent) || this.getComponent() instanceof Bandbox || this.getComponent() instanceof Datebox || this.getComponent() instanceof DatetimeBox || this.getComponent() instanceof Timebox)) {
            String width;
            String string = width = this.tableEditor ? "96%" : "100%";
            if (this.getComponent() instanceof Button) {
                if (!this.tableEditor) {
                    Button btn = (Button)this.getComponent();
                    String zclass = btn.getZclass();
                    if (this.gridField.getDisplayType() == 32) {
                        if (!zclass.contains("image-button-field ")) {
                            btn.setZclass("image-button-field " + zclass);
                        }
                    } else if (!zclass.contains("form-button ")) {
                        btn.setZclass("form-button " + zclass);
                    }
                }
            } else {
                Textbox textbox;
                if (!this.tableEditor) {
                    if (this.getComponent() instanceof InputElement) {
                        ZKUpdateUtil.setHflex((HtmlBasedComponent)((InputElement)this.getComponent()), "1");
                    } else {
                        ZKUpdateUtil.setWidth((HtmlBasedComponent)this.getComponent(), width);
                    }
                } else if (this.getComponent() instanceof Combobox) {
                    LayoutUtils.addSclass("grid-combobox-editor", (HtmlBasedComponent)this.getComponent());
                } else {
                    ZKUpdateUtil.setWidth((HtmlBasedComponent)this.getComponent(), width);
                }
                if (this.getComponent() instanceof Textbox && this.tableEditor && (textbox = (Textbox)this.getComponent()).isMultiline()) {
                    textbox.setRows(1);
                }
            }
        }
        if (this.gridField != null) {
            this.updateStyle();
        }
    }

    @Deprecated
    public void updateLabelStyle() {
        this.updateStyle();
    }

    public boolean isMandatoryStyle() {
        return this.mandatory && !this.readOnly && (this.isProcessParameter || this.getGridField().isEditable(true)) && this.isNullOrEmpty();
    }

    public boolean isNullOrEmpty() {
        Object value = this.getValue();
        return value == null || value.toString().length() == 0;
    }

    public boolean isZoomable() {
        WEditorPopupMenu menu = this.getPopupMenu();
        return menu != null && menu.isZoomEnabled() && this instanceof IZoomableEditor;
    }

    public void setTableEditor(boolean tableEditorMode) {
        this.tableEditor = tableEditorMode;
    }

    protected boolean isShowPreference() {
        return MRole.getDefault() != null && MRole.getDefault().isShowPreference() && this.gridField != null && !this.gridField.isEncrypted() && !this.gridField.isEncryptedColumn() && !this.gridField.isVirtualColumn();
    }

    protected void addChangeLogMenu(WEditorPopupMenu popupMenu) {
        if (popupMenu != null && this.gridField != null && this.gridField.getGridTab() != null && !this.gridField.isVirtualColumn()) {
            WFieldRecordInfo.addMenu(popupMenu);
        }
    }

    protected void addTextEditorMenu(WEditorPopupMenu popupMenu) {
        Menuitem editor = new Menuitem();
        editor.setAttribute("EVENT", (Object)"EDITOR");
        editor.setLabel(Util.cleanAmp((String)Msg.getMsg((Properties)Env.getCtx(), (String)"Editor")).intern());
        if (ThemeManager.isUseFontIconForImage()) {
            editor.setIconSclass("z-icon-Edit");
        } else {
            editor.setImage(ThemeManager.getThemeResource("images/Editor16.png"));
        }
        editor.addEventListener("onClick", (EventListener)popupMenu);
        popupMenu.appendChild((Component)editor);
    }

    public boolean isComponentOfEditor(Component comp) {
        if (comp == this.getComponent()) {
            return true;
        }
        if (this.getComponent() instanceof EditorBox) {
            EditorBox component = (EditorBox)this.getComponent();
            if (comp == component.getTextbox()) {
                return true;
            }
            if (comp == component.getButton()) {
                return true;
            }
        } else if (this.getComponent() instanceof DatetimeBox) {
            DatetimeBox component = (DatetimeBox)this.getComponent();
            if (comp == component.getDatebox()) {
                return true;
            }
            if (comp == component.getTimebox()) {
                return true;
            }
        } else if (this.getComponent() instanceof NumberBox) {
            NumberBox component = (NumberBox)this.getComponent();
            if (comp == component.getDecimalbox()) {
                return true;
            }
            if (comp == component.getButton()) {
                return true;
            }
        } else if (this.getComponent() instanceof Paymentbox) {
            Paymentbox component = (Paymentbox)this.getComponent();
            if (comp == component.getCombobox()) {
                return true;
            }
            if (comp == component.getButton()) {
                return true;
            }
        }
        return false;
    }

    public boolean isProcessParameter() {
        return this.isProcessParameter;
    }

    public void setProcessParameter(boolean isProcessParameter) {
        this.isProcessParameter = isProcessParameter;
    }

    public Component getDisplayComponent() {
        return null;
    }

    protected void focusNext() {
        Component comp = this.getComponent();
        Component parent = comp.getParent();
        while (parent != null) {
            if (parent instanceof IFieldEditorContainer) {
                ((IFieldEditorContainer)parent).focusToNextEditor(this);
                break;
            }
            parent = parent.getParent();
        }
    }

    protected Evaluatee getStyleEvaluatee() {
        return new EvaluateeWrapper(this, this.gridField, this.tableEditor);
    }

    @Override
    public String getValidInput() {
        return this.sValidInput;
    }

    @Override
    public void setValidInput(String validInput) {
        this.sValidInput = validInput;
    }

    @Override
    public boolean isValid(String input) {
        return Util.isEmpty((String)this.sValidInput) ? true : this.sValidInput.equals(input);
    }

    public void addDynamicDisplayListener(DynamicDisplayListener listener) {
        this.dynamicDisplayListeners.add(listener);
    }

    public boolean removeDynamicDisplayListener(DynamicDisplayListener listener) {
        return this.dynamicDisplayListeners.remove(listener);
    }

    public static interface DynamicDisplayListener {
        public void onDynamicDisplay(Properties var1, WEditor var2);
    }

    private static class EvaluateeWrapper
    implements Evaluatee {
        private GridField gridField;
        private boolean tableEditor;
        private WEditor editor;

        private EvaluateeWrapper(WEditor editor, GridField gridField, boolean tableEditor) {
            this.editor = editor;
            this.gridField = gridField;
            this.tableEditor = tableEditor;
        }

        public String get_ValueAsString(String variableName) {
            if ("_Editor_IsGridView".equals(variableName)) {
                return this.tableEditor ? "Y" : "N";
            }
            if ("_Editor_IsReadOnly".equals(variableName)) {
                return this.editor.isReadWrite() ? "N" : "Y";
            }
            if ("_Editor_IsZoomable".equals(variableName)) {
                return this.editor.isZoomable() ? "Y" : "N";
            }
            if ("_Editor_IsMandatory".equals(variableName)) {
                return this.editor.isMandatory() ? "Y" : "N";
            }
            return this.gridField.get_ValueAsString(variableName);
        }
    }
}

