/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.base;

import io.github.classgraph.AnnotationInfo;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfo;
import io.github.classgraph.ClassInfoList;
import io.github.classgraph.ScanResult;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.adempiere.base.AbstractModelFactory;
import org.adempiere.base.AnnotationBasedFactory;
import org.adempiere.base.IModelFactory;
import org.adempiere.base.Model;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;

@Component(immediate=true, service={IModelFactory.class}, property={"service.ranking:Integer=0"})
public class AnnotationBasedModelFactory
extends AnnotationBasedFactory
implements IModelFactory {
    private Map<String, Class<?>> classCache = new HashMap();
    private static final CLogger s_log = CLogger.getCLogger(AnnotationBasedModelFactory.class);
    private static final String[] CORE_PACKAGES = new String[]{"org.compiere.model", "compiere.model", "adempiere.model", "org.adempiere.model", "org.compiere.wf", "org.compiere.print", "org.compiere.impexp", "org.eevolution.model"};

    protected String[] getPackages() {
        return new String[0];
    }

    protected String[] getAcceptClassesPatterns() {
        String[] patterns = new String[]{"*.X_*", "*.M*"};
        return patterns;
    }

    @Activate
    public void activate(ComponentContext context) throws ClassNotFoundException {
        long start = System.currentTimeMillis();
        ClassLoader classLoader = ((BundleWiring)context.getBundleContext().getBundle().adapt(BundleWiring.class)).getClassLoader();
        ClassGraph graph = new ClassGraph().enableAnnotationInfo().overrideClassLoaders(new ClassLoader[]{classLoader}).disableNestedJarScanning().disableModuleScanning();
        String[] packages = null;
        packages = this.isAtCore() ? CORE_PACKAGES : this.getPackages();
        if (packages != null && packages.length > 0) {
            graph.acceptPackagesNonRecursive(packages);
        } else {
            String[] acceptClasses = this.getAcceptClassesPatterns();
            if (acceptClasses != null && acceptClasses.length > 0) {
                graph.acceptClasses(acceptClasses);
            }
        }
        ClassGraph.ScanResultProcessor scanResultProcessor = scanResult -> {
            try {
                this.processResults(classLoader, scanResult);
            }
            catch (Exception e) {
                s_log.severe("exception found while scanning classes" + e.getMessage());
                this.signalScanCompletion(false);
                return;
            }
            long end = System.currentTimeMillis();
            s_log.info(() -> this.getClass().getSimpleName() + " loaded " + this.classCache.size() + " classes in " + (float)(end - start) / 1000.0f + "s");
            this.signalScanCompletion(true);
        };
        graph.scanAsync(this.getExecutorService(), this.getMaxThreads(), scanResultProcessor, this.getScanFailureHandler());
    }

    private void processResults(ClassLoader classLoader, ScanResult scanResult) {
        BiConsumer<String, ClassNotFoundException> exceptionHandler = (className, exception) -> s_log.severe(String.format("exception while loading class %s - %s", className, exception.getMessage()));
        for (ClassInfo classInfo : scanResult.getClassesWithAnnotation(Model.class)) {
            String className2 = classInfo.getName();
            AnnotationInfo annotationInfo = classInfo.getAnnotationInfo(Model.class);
            String tableName = (String)annotationInfo.getParameterValues().getValue("table");
            Class<?> existing = this.classCache.get(tableName);
            if (existing == null && className2.substring(className2.lastIndexOf(".")).startsWith(".X")) {
                ClassInfoList subclasses = classInfo.getSubclasses().directOnly();
                while (!subclasses.isEmpty()) {
                    className2 = ((ClassInfo)subclasses.get(0)).getName();
                    subclasses = ((ClassInfo)subclasses.get(0)).getSubclasses().directOnly();
                }
            }
            if (existing == null) {
                try {
                    this.classCache.put(tableName, classLoader.loadClass(className2));
                }
                catch (ClassNotFoundException e) {
                    exceptionHandler.accept(className2, e);
                }
                continue;
            }
            if (!className2.substring(className2.lastIndexOf(".")).startsWith(".M")) continue;
            if (existing.getSimpleName().startsWith("X_")) {
                try {
                    this.classCache.put(tableName, classLoader.loadClass(className2));
                }
                catch (ClassNotFoundException e) {
                    exceptionHandler.accept(className2, e);
                }
                continue;
            }
            Class<?> found = null;
            try {
                found = classLoader.loadClass(className2);
            }
            catch (ClassNotFoundException e) {
                exceptionHandler.accept(className2, e);
            }
            if (found == null || !existing.isAssignableFrom(found)) continue;
            try {
                this.classCache.put(tableName, classLoader.loadClass(className2));
            }
            catch (ClassNotFoundException e) {
                exceptionHandler.accept(className2, e);
            }
        }
    }

    @Override
    public Class<?> getClass(String tableName) {
        this.blockWhileScanning();
        return this.classCache.get(tableName);
    }

    private boolean isAtCore() {
        return this.getClass().equals(AnnotationBasedModelFactory.class);
    }

    @Override
    public PO getPO(String tableName, int Record_ID, String trxName) {
        return AbstractModelFactory.getPO(this.getClass(tableName), tableName, Record_ID, trxName);
    }

    @Override
    public PO getPO(String tableName, String Record_UU, String trxName) {
        return AbstractModelFactory.getPO(this.getClass(tableName), tableName, Record_UU, trxName);
    }

    @Override
    public PO getPO(String tableName, ResultSet rs, String trxName) {
        return AbstractModelFactory.getPO(this.getClass(tableName), tableName, rs, trxName);
    }
}

