/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.print.renderer;

import com.google.common.net.MediaType;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import javax.print.DocFlavor;
import javax.print.StreamPrintService;
import javax.print.StreamPrintServiceFactory;
import javax.print.attribute.HashPrintRequestAttributeSet;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.print.ReportEngine;
import org.compiere.print.layout.LayoutEngine;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.idempiere.print.renderer.IReportRenderer;
import org.idempiere.print.renderer.PSReportRendererConfiguration;
import org.osgi.service.component.annotations.Component;

@Component(service={IReportRenderer.class}, immediate=true)
public class PSReportRenderer
implements IReportRenderer<PSReportRendererConfiguration> {
    private static final CLogger log = CLogger.getCLogger(PSReportRenderer.class);

    @Override
    public String getId() {
        return "PS";
    }

    @Override
    public String getName() {
        return Msg.getMsg(Env.getCtx(), "FilePS");
    }

    @Override
    public String getContentType() {
        return MediaType.POSTSCRIPT.toString();
    }

    @Override
    public String getFileExtension() {
        return "ps";
    }

    @Override
    public void renderReport(ReportEngine reportEngine, PSReportRendererConfiguration configuration) {
        try {
            OutputStream os = null;
            os = configuration.getOutputFile() != null ? new FileOutputStream(configuration.getOutputFile()) : configuration.getOutputStream();
            this.createPS(reportEngine, os);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "PDF", e);
            throw new AdempiereException(e);
        }
    }

    @Override
    public boolean isBinary() {
        return true;
    }

    private void createPS(ReportEngine reportEngine, OutputStream os) {
        try {
            String outputMimeType = DocFlavor.BYTE_ARRAY.POSTSCRIPT.getMimeType();
            DocFlavor.SERVICE_FORMATTED docFlavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;
            StreamPrintServiceFactory[] spsfactories = StreamPrintServiceFactory.lookupStreamPrintServiceFactories(docFlavor, outputMimeType);
            if (spsfactories.length == 0) {
                log.log(Level.SEVERE, "(fos) - No StreamPrintService");
                return;
            }
            StreamPrintService sps = spsfactories[0].getPrintService(os);
            LayoutEngine layout = reportEngine.getLayout();
            sps.createPrintJob().print(layout.getPageable(false), new HashPrintRequestAttributeSet());
            os.flush();
            if (os instanceof FileOutputStream) {
                ((FileOutputStream)os).close();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "(fos)", e);
        }
    }

    @Override
    public Class<PSReportRendererConfiguration> getConfigurationType() {
        return PSReportRendererConfiguration.class;
    }
}

