/*
 * Decompiled with CFR 0.152.
 */
package org.idempiere.broadcast;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.adempiere.base.event.EventManager;
import org.adempiere.exceptions.DBException;
import org.adempiere.model.MBroadcastMessage;
import org.compiere.Adempiere;
import org.compiere.model.MNote;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.WebUtil;
import org.idempiere.broadcast.BroadCastMsg;
import org.idempiere.broadcast.BroadCastUtil;
import org.idempiere.broadcast.IBroadcastMsgPopup;
import org.osgi.service.event.Event;

public class BroadcastMsgUtil {
    private static final CLogger logger = CLogger.getCLogger(BroadcastMsgUtil.class);

    public static void publishBroadcastMessage(int messageID, String trxName) {
        MBroadcastMessage mbMessage = new MBroadcastMessage(Env.getCtx(), messageID, trxName);
        String broadcastType = mbMessage.getBroadcastType();
        if ("L".equals(broadcastType) || "IL".equals(broadcastType)) {
            int AD_Client_ID = Env.getAD_Client_ID(Env.getCtx());
            if (mbMessage.getTarget() != null) {
                int[] userIDs;
                Object sql = "SELECT DISTINCT(AD_User_ID) FROM AD_User_Roles WHERE IsActive='Y'";
                if (mbMessage.getTarget().equals("R")) {
                    sql = (String)sql + " AND AD_Role_ID=" + mbMessage.getAD_Role_ID();
                    MRole role = MRole.get(Env.getCtx(), mbMessage.getAD_Role_ID());
                    AD_Client_ID = role.getAD_Client_ID();
                } else if (mbMessage.getTarget().equals("U")) {
                    sql = (String)sql + " AND AD_User_ID=" + mbMessage.getAD_User_ID();
                } else if (mbMessage.getTarget().equals("C")) {
                    sql = (String)sql + " AND AD_Client_ID = " + Env.getAD_Client_ID(Env.getCtx());
                }
                int[] nArray = userIDs = DB.getIDsEx(null, (String)sql, new Object[0]);
                int n = userIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    int userID = nArray[n2];
                    MUser user = MUser.get(Env.getCtx(), userID);
                    if (user.isActive()) {
                        if (mbMessage.getTarget().equals("U") || mbMessage.getTarget().equals("E")) {
                            AD_Client_ID = user.getAD_Client_ID();
                        }
                        MNote note = new MNote(Env.getCtx(), 0, trxName);
                        note.setClientOrg(AD_Client_ID, 0);
                        note.setAD_BroadcastMessage_ID(messageID);
                        note.setAD_User_ID(userID);
                        note.setAD_Message_ID(0);
                        note.saveEx();
                    }
                    ++n2;
                }
                mbMessage.setIsPublished(true);
                mbMessage.setProcessed(true);
                mbMessage.saveEx(trxName);
            }
        } else if ("I".equals(broadcastType)) {
            mbMessage.setProcessed(true);
            mbMessage.setIsPublished(true);
            mbMessage.saveEx(trxName);
        }
        if (!"L".equals(broadcastType)) {
            BroadCastMsg msg = new BroadCastMsg();
            msg.setIntData(messageID);
            msg.setEventId(1);
            BroadcastMsgUtil.pushToQueue(msg, false);
        }
    }

    public static void pushToQueue(final BroadCastMsg msg, boolean isLocalOnly) {
        boolean isPublished = false;
        if (!isLocalOnly) {
            msg.setSrc(WebUtil.getServerName());
            isPublished = BroadCastUtil.publish(msg);
        }
        if (!isPublished) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Event event = EventManager.newEvent("idempiere/broadcastMsg", msg, true);
                    EventManager.getInstance().postEvent(event);
                }
            };
            ScheduledThreadPoolExecutor executer = Adempiere.getThreadPoolExecutor();
            executer.schedule(runnable, 0L, TimeUnit.MILLISECONDS);
        }
    }

    public static void testBroadcastMessage(int messageID, int AD_Session_ID) {
        BroadCastMsg msg = new BroadCastMsg();
        msg.setIntData(messageID);
        msg.setEventId(2);
        msg.setTarget(Integer.toString(AD_Session_ID));
        BroadcastMsgUtil.pushToQueue(msg, true);
    }

    public static void showPendingMessage(int AD_User_ID, IBroadcastMsgPopup messageWindow) {
        String sql = "SELECT bm.AD_BroadcastMessage_ID FROM   AD_Note n        INNER JOIN AD_BroadcastMessage bm                ON ( bm.AD_BroadcastMessage_ID = n.AD_BroadcastMessage_ID ) WHERE  n.AD_User_ID = ?        AND n.AD_Client_ID = ?        AND ( bm.BroadcastType = 'IL' OR bm.BroadcastType = 'L' )        AND bm.isPublished = 'Y'        AND bm.IsActive = 'Y'        AND ( n.Processed = 'N' OR ( n.Processed = 'Y' AND bm.BroadcastFrequency = 'E' ) )        AND ( bm.Expired = 'N' AND ( bm.Expiration IS NULL OR bm.Expiration > getDate() ) ) ";
        ArrayList<MBroadcastMessage> mbMessages = new ArrayList<MBroadcastMessage>();
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, AD_User_ID);
                pstmt.setInt(2, Env.getAD_Client_ID(Env.getCtx()));
                rs = pstmt.executeQuery();
                while (rs.next()) {
                    mbMessages.add(MBroadcastMessage.get(Env.getCtx(), rs.getInt(1)));
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Broadcast messages could not be retrieved", e);
                throw new DBException(e);
            }
        }
        catch (Throwable throwable) {
            DB.close(rs, pstmt);
            throw throwable;
        }
        DB.close(rs, pstmt);
        if (mbMessages.size() > 0) {
            messageWindow.prepareMessage(mbMessages);
        }
    }
}

