/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.report.core;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.report.core.RColumn;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;

public class RModelData {
    public ArrayList<ArrayList<Object>> rows = new ArrayList();
    private ArrayList<ArrayList<Object>> m_rows = new ArrayList();
    public ArrayList<Object> rowsMeta = new ArrayList();
    public ArrayList<RColumn> cols = new ArrayList();
    private String m_TableName;
    public HashMap<Integer, String> functions = new HashMap();
    public ArrayList<Integer> groups = new ArrayList();
    private ArrayList<Integer> m_groupRows = new ArrayList();
    private ArrayList<Boolean> m_groupRowsIndicator = null;
    private static CLogger log = CLogger.getCLogger(RModelData.class);

    public RModelData(String TableName) {
        this.m_TableName = TableName;
    }

    public void dispose() {
        this.rows.clear();
        this.m_rows.clear();
        this.rowsMeta.clear();
        this.cols.clear();
    }

    public void query(Properties ctx, String whereClause, String orderClause) {
        block29: {
            RColumn rc = null;
            StringBuilder sql = new StringBuilder("SELECT ");
            int size = this.cols.size();
            int i2 = 0;
            while (i2 < size) {
                rc = this.cols.get(i2);
                if (i2 > 0) {
                    sql.append(",");
                }
                sql.append(rc.getColSQL());
                ++i2;
            }
            sql.append(" FROM ").append(this.m_TableName).append(" ").append("zz");
            if (whereClause != null && whereClause.length() > 0) {
                sql.append(" WHERE ").append(whereClause);
            }
            Object finalSQL = MRole.getDefault(ctx, false).addAccessSQL(sql.toString(), "zz", true, false);
            if (orderClause != null && orderClause.length() > 0) {
                finalSQL = (String)finalSQL + " ORDER BY " + orderClause;
            }
            log.fine((String)finalSQL);
            int index = 0;
            this.m_rows.clear();
            Statement stmt = null;
            ResultSet rs = null;
            try {
                try {
                    stmt = DB.createStatement();
                    rs = stmt.executeQuery((String)finalSQL);
                    while (rs.next()) {
                        ArrayList<Object> row = new ArrayList<Object>(size);
                        index = 1;
                        int i3 = 0;
                        while (i3 < size) {
                            rc = this.cols.get(i3);
                            if (rc.isIDcol()) {
                                row.add(new KeyNamePair(rs.getInt(index++), rs.getString(index++)));
                            } else if (rs.getObject(index) == null) {
                                ++index;
                                row.add(null);
                            } else if (rc.getColClass() == String.class) {
                                row.add(rs.getString(index++));
                            } else if (rc.getColClass() == BigDecimal.class) {
                                row.add(rs.getBigDecimal(index++));
                            } else if (rc.getColClass() == Double.class) {
                                row.add(rs.getDouble(index++));
                            } else if (rc.getColClass() == Integer.class) {
                                row.add(rs.getInt(index++));
                            } else if (rc.getColClass() == Timestamp.class) {
                                row.add(rs.getTimestamp(index++));
                            } else if (rc.getColClass() == Boolean.class) {
                                row.add("Y".equals(rs.getString(index++)));
                            } else {
                                row.add(rs.getString(index++));
                            }
                            ++i3;
                        }
                        this.m_rows.add(row);
                    }
                }
                catch (SQLException e) {
                    if (index == 0) {
                        log.log(Level.SEVERE, (String)finalSQL, e);
                    } else {
                        log.log(Level.SEVERE, "Index=" + index + "," + String.valueOf(rc), e);
                    }
                    e.printStackTrace();
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    break block29;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        this.process();
    }

    private void process() {
        int fc;
        if (log.isLoggable(Level.FINE)) {
            log.fine("Start Rows=" + this.m_rows.size());
        }
        int gSize = this.groups.size();
        int[] groupBys = new int[gSize];
        Object[] groupBysValue = new Object[gSize];
        Object INITVALUE = new Object();
        int i2 = 0;
        while (i2 < gSize) {
            groupBys[i2] = this.groups.get(i2);
            groupBysValue[i2] = INITVALUE;
            if (log.isLoggable(Level.FINE)) {
                log.fine("GroupBy level=" + i2 + " col=" + groupBys[i2]);
            }
            ++i2;
        }
        if (gSize > 0) {
            ArrayList<String> newRow = new ArrayList<String>();
            int c = 0;
            while (c < this.cols.size()) {
                newRow.add("");
                ++c;
            }
            this.m_rows.add(newRow);
        }
        int fSize = this.functions.size();
        int[] funcCols = new int[fSize];
        String[] funcFuns = new String[fSize];
        int index = 0;
        for (Integer key : this.functions.keySet()) {
            funcCols[index] = key;
            funcFuns[index] = this.functions.get(key).toString();
            if (log.isLoggable(Level.FINE)) {
                log.fine("Function " + funcFuns[index] + " col=" + funcCols[index]);
            }
            ++index;
        }
        BigDecimal[][] funcVals = new BigDecimal[fSize][gSize + 1];
        int totalIndex = gSize;
        if (log.isLoggable(Level.FINE)) {
            log.fine("FunctionValues = [ " + fSize + " * " + (gSize + 1) + " ]");
        }
        int f = 0;
        while (f < fSize) {
            int g = 0;
            while (g < gSize + 1) {
                funcVals[f][g] = Env.ZERO;
                ++g;
            }
            ++f;
        }
        this.rows.clear();
        int r = 0;
        while (r < this.m_rows.size()) {
            int idx;
            ArrayList<Object> row = this.m_rows.get(r);
            boolean[] haveBreak = new boolean[groupBys.length];
            int level = 0;
            while (level < groupBys.length) {
                idx = groupBys[level];
                haveBreak[level] = groupBysValue[level] == INITVALUE ? false : !groupBysValue[level].equals(row.get(idx));
                if (level > 0 && haveBreak[level - 1]) {
                    haveBreak[level] = true;
                }
                ++level;
            }
            level = groupBys.length - 1;
            while (level >= 0) {
                idx = groupBys[level];
                if (groupBysValue[level] == INITVALUE) {
                    groupBysValue[level] = row.get(idx);
                } else if (haveBreak[level]) {
                    ArrayList<Object> newRow = new ArrayList<Object>();
                    int c = 0;
                    while (c < this.cols.size()) {
                        if (c == idx) {
                            if (groupBysValue[c] == null || groupBysValue[c].toString().length() == 0) {
                                newRow.add("=");
                            } else {
                                newRow.add(groupBysValue[c]);
                            }
                        } else {
                            boolean found = false;
                            int fc2 = 0;
                            while (fc2 < funcCols.length) {
                                if (c == funcCols[fc2]) {
                                    newRow.add(funcVals[fc2][level]);
                                    funcVals[fc2][level] = Env.ZERO;
                                    found = true;
                                }
                                ++fc2;
                            }
                            if (!found) {
                                newRow.add(null);
                            }
                        }
                        ++c;
                    }
                    this.m_groupRows.add(this.rows.size());
                    this.rows.add(newRow);
                    groupBysValue[level] = row.get(idx);
                }
                --level;
            }
            fc = 0;
            while (fc < funcCols.length) {
                int col = funcCols[fc];
                Object value = row.get(col);
                BigDecimal bd = Env.ZERO;
                if (value != null) {
                    if (value instanceof BigDecimal) {
                        bd = (BigDecimal)value;
                    } else {
                        try {
                            bd = new BigDecimal(value.toString());
                        }
                        catch (Exception exception) {}
                    }
                }
                int level2 = 0;
                while (level2 < gSize + 1) {
                    if (funcFuns[fc].equals("Sum")) {
                        funcVals[fc][level2] = funcVals[fc][level2].add(bd);
                    } else if (funcFuns[fc].equals("Count")) {
                        funcVals[fc][level2] = funcVals[fc][level2].add(Env.ONE);
                    }
                    ++level2;
                }
                ++fc;
            }
            this.rows.add(row);
            ++r;
        }
        if (this.functions.size() > 0) {
            ArrayList<BigDecimal> newRow = new ArrayList<BigDecimal>();
            int c = 0;
            while (c < this.cols.size()) {
                boolean found = false;
                fc = 0;
                while (fc < funcCols.length) {
                    if (c == funcCols[fc]) {
                        newRow.add(funcVals[fc][totalIndex]);
                        found = true;
                    }
                    ++fc;
                }
                if (!found) {
                    newRow.add(null);
                }
                ++c;
            }
            if (gSize > 0) {
                this.rows.remove(this.rows.size() - 1);
            }
            this.m_groupRows.add(this.rows.size());
            this.rows.add(newRow);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine("End Rows=" + this.rows.size());
        }
        this.m_rows.clear();
    }

    public boolean isGroupRow(int row) {
        if (this.m_groupRowsIndicator == null) {
            this.m_groupRowsIndicator = new ArrayList(this.rows.size());
            int r = 0;
            while (r < this.rows.size()) {
                this.m_groupRowsIndicator.add(this.m_groupRows.contains(r));
                ++r;
            }
        }
        if (row < 0 || row >= this.m_groupRowsIndicator.size()) {
            return false;
        }
        return this.m_groupRowsIndicator.get(row);
    }

    public void moveRow(int from, int to) {
        if (from < 0 || to >= this.rows.size()) {
            throw new IllegalArgumentException("Row from invalid");
        }
        if (to < 0 || to >= this.rows.size()) {
            throw new IllegalArgumentException("Row to invalid");
        }
        ArrayList<Object> temp = this.rows.get(from);
        this.rows.remove(from);
        this.rows.add(to, temp);
        if (this.m_groupRowsIndicator != null) {
            Boolean tempB = this.m_groupRowsIndicator.get(from);
            this.m_groupRowsIndicator.remove(from);
            this.m_groupRowsIndicator.add(to, tempB);
        }
    }
}

