/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.process;

import org.adempiere.base.annotation.Process;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MColumn;
import org.compiere.model.MProcessPara;
import org.compiere.model.MTable;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

@Process
public class DatabaseColumnDrop
extends SvrProcess {
    private int p_AD_Column_ID = 0;
    private boolean p_AreYouSure;
    private boolean p_IsEvenWithData;

    @Override
    protected void prepare() {
        ProcessInfoParameter[] processInfoParameterArray = this.getParameter();
        int n = processInfoParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessInfoParameter para = processInfoParameterArray[n2];
            String name = para.getParameterName();
            if ("AreYouSure".equals(name)) {
                this.p_AreYouSure = para.getParameterAsBoolean();
            } else if ("IsEvenWithData".equals(name)) {
                this.p_IsEvenWithData = para.getParameterAsBoolean();
            } else {
                MProcessPara.validateUnknownParameter(this.getProcessInfo().getAD_Process_ID(), para);
            }
            ++n2;
        }
        this.p_AD_Column_ID = this.getRecord_ID();
    }

    @Override
    protected String doIt() throws Exception {
        int cnt;
        MColumn column = new MColumn(this.getCtx(), this.p_AD_Column_ID, this.get_TrxName());
        this.log.info(column.toString());
        MTable table2 = new MTable(this.getCtx(), column.getAD_Table_ID(), this.get_TrxName());
        if (!this.p_AreYouSure) {
            throw new AdempiereException(Util.cleanAmp(Msg.getMsg(this.getCtx(), "Cancel")));
        }
        if (!this.p_IsEvenWithData && (cnt = DB.getSQLValueEx(this.get_TrxName(), "SELECT COUNT(*) FROM " + table2.getTableName() + " WHERE " + column.getColumnName() + " IS NOT NULL", new Object[0])) > 0) {
            throw new AdempiereException(Util.cleanAmp(Msg.parseTranslation(this.getCtx(), "@Cancel@.  @Records@ = " + cnt)));
        }
        String sql = "ALTER TABLE " + table2.getTableName() + " DROP COLUMN " + column.getColumnName();
        int rvalue = DB.executeUpdateEx(sql, this.get_TrxName());
        return rvalue + " - " + sql;
    }
}

