/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.compiere.print.PrintDataFunction;

public class PrintDataGroup {
    public static final String DELIMITER = "~";
    public static final int TOTAL = -1;
    private static final Object NULL = new String();
    private ArrayList<Integer> m_groups = new ArrayList();
    private HashMap<Integer, Object> m_groupMap = new HashMap();
    private HashMap<Integer, List<Character>> m_functions = new HashMap();
    private HashMap<String, PrintDataFunction> m_groupFunction = new HashMap();

    public void addGroupColumn(int AD_PrintFormatItem_ID) {
        this.m_groups.add(AD_PrintFormatItem_ID);
    }

    public int getGroupColumnCount() {
        return this.m_groups.size();
    }

    public boolean isGroupColumn(int AD_PrintFormatItem_ID) {
        return this.m_groups.contains(AD_PrintFormatItem_ID);
    }

    public Object groupChange(int AD_PrintFormatItem_ID, Object value, boolean force) {
        if (!this.isGroupColumn(AD_PrintFormatItem_ID)) {
            return null;
        }
        Object newValue = value;
        if (newValue == null) {
            newValue = NULL;
        }
        if (this.m_groupMap.containsKey(AD_PrintFormatItem_ID)) {
            Object oldValue = this.m_groupMap.get(AD_PrintFormatItem_ID);
            if (newValue.equals(oldValue) && !force) {
                return null;
            }
            this.m_groupMap.put(AD_PrintFormatItem_ID, newValue);
            return oldValue;
        }
        this.m_groupMap.put(AD_PrintFormatItem_ID, newValue);
        return null;
    }

    public void addFunction(int AD_PrintFormatItem_ID, char function) {
        List<Character> list = this.m_functions.get(AD_PrintFormatItem_ID);
        if (list == null) {
            list = new ArrayList<Character>();
            this.m_functions.put(AD_PrintFormatItem_ID, list);
        }
        if (!list.contains(Character.valueOf(function))) {
            list.add(Character.valueOf(function));
        }
        if (!this.m_groups.contains(-1)) {
            this.m_groups.add(-1);
        }
    }

    public boolean isFunctionColumn(int AD_PrintFormatItem_ID) {
        return this.m_functions.containsKey(AD_PrintFormatItem_ID);
    }

    public char[] getFunctions(int groupId) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (String group_function : this.m_groupFunction.keySet()) {
            String functionColumn;
            List<Character> fs;
            if (!group_function.startsWith(Integer.toString(groupId)) || (fs = this.m_functions.get(Integer.parseInt(functionColumn = group_function.substring(group_function.lastIndexOf(DELIMITER) + 1)))) == null || fs.size() <= 0) continue;
            for (Character f : fs) {
                if (list.contains(f)) continue;
                list.add(f);
            }
        }
        char[] retValue = new char[list.size()];
        int i2 = 0;
        while (i2 < retValue.length) {
            retValue[i2] = ((Character)list.get(i2)).charValue();
            ++i2;
        }
        return retValue;
    }

    public boolean isFunctionColumn(int AD_PrintFormatItem_ID, char function) {
        if (this.m_functions.size() == 0) {
            return false;
        }
        List<Character> fs = this.m_functions.get(AD_PrintFormatItem_ID);
        if (fs != null && fs.size() > 0) {
            for (Character f : fs) {
                if (f.charValue() != function) continue;
                return true;
            }
        }
        return false;
    }

    public void addValue(int functionColumnId, Serializable functionValue) {
        if (!this.isFunctionColumn(functionColumnId)) {
            return;
        }
        int i2 = 0;
        while (i2 < this.m_groups.size()) {
            int groupId = this.m_groups.get(i2);
            String key = groupId + DELIMITER + functionColumnId;
            PrintDataFunction pdf = this.m_groupFunction.get(key);
            if (pdf == null) {
                pdf = new PrintDataFunction();
            }
            pdf.addValue(functionValue);
            this.m_groupFunction.put(key, pdf);
            ++i2;
        }
    }

    public Serializable getValue(int groupId, int functionColumnId, char function) {
        String key = groupId + DELIMITER + functionColumnId;
        PrintDataFunction pdf = this.m_groupFunction.get(key);
        if (pdf == null) {
            return null;
        }
        return pdf.getValue(function);
    }

    public void reset(int groupId, int functionColumnId) {
        String key = groupId + DELIMITER + functionColumnId;
        PrintDataFunction pdf = this.m_groupFunction.get(key);
        if (pdf != null) {
            pdf.reset();
        }
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean withData) {
        Object value;
        StringBuilder sb = new StringBuilder("PrintDataGroup[");
        sb.append("Groups=");
        int i2 = 0;
        while (i2 < this.m_groups.size()) {
            if (i2 != 0) {
                sb.append(",");
            }
            sb.append(this.m_groups.get(i2));
            ++i2;
        }
        if (withData) {
            for (Integer n : this.m_groupMap.keySet()) {
                value = this.m_groupMap.get(n);
                sb.append(":").append(n).append("=").append(value);
            }
        }
        sb.append(";Functions=");
        int i3 = 0;
        while (i3 < this.m_functions.size()) {
            if (i3 != 0) {
                sb.append(",");
            }
            sb.append(this.m_functions.get(i3));
            ++i3;
        }
        if (withData) {
            for (String string : this.m_groupFunction.keySet()) {
                value = this.m_groupFunction.get(string);
                sb.append(":").append((Object)string).append("=").append(value);
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

