/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.MCost;
import org.compiere.model.MProduct;
import org.compiere.model.MUOMConversion;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class ProductCost {
    private static CCache<String, Integer> s_valid_comb_cache = new CCache("ProductCost_ValidCombination", 40);
    private static CCache<String, Integer> s_default_valid_comb_cache = new CCache("ProductCost_DefaultValidCombination", 40);
    private int m_M_Product_ID = 0;
    private int m_M_AttributeSetInstance_ID = 0;
    private MProduct m_product = null;
    private String m_trxName = null;
    private int m_C_UOM_ID = 0;
    private BigDecimal m_qty = Env.ZERO;
    private static CLogger log = CLogger.getCLogger(ProductCost.class);
    public static final int ACCTTYPE_P_Revenue = 1;
    public static final int ACCTTYPE_P_Expense = 2;
    public static final int ACCTTYPE_P_Asset = 3;
    public static final int ACCTTYPE_P_Cogs = 4;
    public static final int ACCTTYPE_P_PPV = 5;
    public static final int ACCTTYPE_P_IPV = 6;
    public static final int ACCTTYPE_P_TDiscountRec = 7;
    public static final int ACCTTYPE_P_TDiscountGrant = 8;
    public static final int ACCTTYPE_P_CostAdjustment = 9;
    public static final int ACCTTYPE_P_InventoryClearing = 10;
    public static final int ACCTTYPE_P_WorkInProcess = 11;
    public static final int ACCTTYPE_P_MethodChangeVariance = 12;
    public static final int ACCTTYPE_P_UsageVariance = 13;
    public static final int ACCTTYPE_P_RateVariance = 14;
    public static final int ACCTTYPE_P_MixVariance = 15;
    public static final int ACCTTYPE_P_FloorStock = 16;
    public static final int ACCTTYPE_P_CostOfProduction = 17;
    public static final int ACCTTYPE_P_Labor = 18;
    public static final int ACCTTYPE_P_Burden = 19;
    public static final int ACCTTYPE_P_OutsideProcessing = 20;
    public static final int ACCTTYPE_P_Overhead = 21;
    public static final int ACCTTYPE_P_Scrap = 22;
    public static final int ACCTTYPE_P_AverageCostVariance = 23;
    public static final int ACCTTYPE_P_LandedCostClearing = 24;

    public ProductCost(Properties ctx, int M_Product_ID, int M_AttributeSetInstance_ID, String trxName) {
        this.m_M_Product_ID = M_Product_ID;
        if (this.m_M_Product_ID != 0) {
            this.m_product = MProduct.get(ctx, M_Product_ID);
        }
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
        this.m_trxName = trxName;
    }

    public MProduct getProduct() {
        return this.m_product;
    }

    public boolean isService() {
        if (this.m_product != null) {
            return this.m_product.isService();
        }
        return false;
    }

    public void setQty(BigDecimal qty) {
        this.m_qty = qty;
    }

    public void setQty(BigDecimal qty, int C_UOM_ID) {
        this.m_qty = MUOMConversion.convert(C_UOM_ID, this.m_C_UOM_ID, qty, true);
        if (qty != null && this.m_qty == null) {
            log.severe("Conversion error - set to " + String.valueOf(qty));
            this.m_qty = qty;
        } else {
            this.m_C_UOM_ID = C_UOM_ID;
        }
    }

    public BigDecimal getQty() {
        return this.m_qty;
    }

    public MAccount getAccount(int AcctType, MAcctSchema as) {
        if (AcctType < 1 || AcctType > 24) {
            return null;
        }
        if (this.m_M_Product_ID == 0) {
            return this.getAccountDefault(AcctType, as);
        }
        String key = this.m_M_Product_ID + "_" + as.getC_AcctSchema_ID() + "_" + AcctType;
        Integer validCombination_ID = s_valid_comb_cache.get(key);
        if (validCombination_ID == null || validCombination_ID == 0) {
            block11: {
                String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct,P_CostAdjustment_Acct, P_InventoryClearing_Acct,P_WIP_Acct,P_MethodChangeVariance_Acct,P_UsageVariance_Acct,P_RateVariance_Acct,P_MixVariance_Acct,P_FloorStock_Acct,P_CostOfProduction_Acct,P_Labor_Acct,P_Burden_Acct,P_OutsideProcessing_Acct,P_Overhead_Acct,P_Scrap_Acct,P_AverageCostVariance_Acct,P_LandedCostClearing_Acct FROM M_Product_Acct WHERE M_Product_ID=? AND C_AcctSchema_ID=?";
                validCombination_ID = 0;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.m_trxName);
                        pstmt.setInt(1, this.m_M_Product_ID);
                        pstmt.setInt(2, as.getC_AcctSchema_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            validCombination_ID = rs.getInt(AcctType);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block11;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (validCombination_ID != 0) {
                s_valid_comb_cache.put(key, validCombination_ID);
            }
        }
        if (validCombination_ID == 0) {
            return null;
        }
        return MAccount.get(as.getCtx(), validCombination_ID);
    }

    public MAccount getAccountDefault(int AcctType, MAcctSchema as) {
        if (AcctType < 1 || AcctType > 24) {
            return null;
        }
        String key = as.getC_AcctSchema_ID() + "_" + AcctType;
        Integer validCombination_ID = s_default_valid_comb_cache.get(key);
        if (validCombination_ID == null || validCombination_ID == 0) {
            block10: {
                String sql = "SELECT P_Revenue_Acct, P_Expense_Acct, P_Asset_Acct, P_Cogs_Acct, P_PurchasePriceVariance_Acct, P_InvoicePriceVariance_Acct, P_TradeDiscountRec_Acct, P_TradeDiscountGrant_Acct, P_CostAdjustment_Acct, P_InventoryClearing_Acct, P_WIP_Acct,P_MethodChangeVariance_Acct,P_UsageVariance_Acct,P_RateVariance_Acct,P_MixVariance_Acct,P_FloorStock_Acct,P_CostOfProduction_Acct,P_Labor_Acct,P_Burden_Acct,P_OutsideProcessing_Acct,P_Overhead_Acct,P_Scrap_Acct,P_AverageCostVariance_Acct,P_LandedCostClearing_Acct FROM M_Product_Category pc, M_Product_Category_Acct pca WHERE pc.M_Product_Category_ID=pca.M_Product_Category_ID AND pca.C_AcctSchema_ID=? ORDER BY pc.IsDefault DESC, pc.Created";
                validCombination_ID = 0;
                CPreparedStatement pstmt = null;
                ResultSet rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, this.m_trxName);
                        pstmt.setInt(1, as.getC_AcctSchema_ID());
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            validCombination_ID = rs.getInt(AcctType);
                        }
                    }
                    catch (SQLException e) {
                        log.log(Level.SEVERE, sql, e);
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (validCombination_ID != 0) {
                s_default_valid_comb_cache.put(key, validCombination_ID);
            }
        }
        if (validCombination_ID == 0) {
            return null;
        }
        return MAccount.get(as.getCtx(), validCombination_ID);
    }

    public BigDecimal getProductCosts(MAcctSchema as, int AD_Org_ID, String costingMethod, int C_OrderLine_ID, boolean zeroCostsOK) {
        if (this.m_qty == null) {
            log.fine("No Qty");
            return null;
        }
        if (this.m_product == null) {
            log.fine("No Product");
            return null;
        }
        BigDecimal cost = MCost.getCurrentCost(this.m_product, this.m_M_AttributeSetInstance_ID, as, AD_Org_ID, costingMethod, this.m_qty, C_OrderLine_ID, zeroCostsOK, this.m_trxName);
        if (cost == null) {
            log.fine("No Costs");
            return null;
        }
        return cost;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProductCost[");
        sb.append("M_Product_ID=").append(this.m_M_Product_ID).append(",M_AttributeSetInstance_ID").append(this.m_M_AttributeSetInstance_ID).append(",Qty=").append(this.m_qty).append("]");
        return sb.toString();
    }

    public void setM_M_AttributeSetInstance_ID(int M_AttributeSetInstance_ID) {
        this.m_M_AttributeSetInstance_ID = M_AttributeSetInstance_ID;
    }
}

