/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MRole;
import org.compiere.model.X_AD_ToolBarButtonRestrict;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MToolBarButtonRestrict
extends X_AD_ToolBarButtonRestrict {
    private static CCache<String, Boolean> cache_toolbarBtnRestriction = new CCache("ToolbarButtonRestricted", 50);
    private static final String GET_OF_WINDOW_SQL = "SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND (AD_Window_ID IS NULL OR (Action='W' AND AD_Window_ID=?)) AND AD_Tab_ID IS NULL AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Tab_ID IS NULL AND IsActive='Y' AND Action=?)";
    private static final String GET_OF_REPORT_SQL = "SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND (AD_Process_ID IS NULL OR (Action='R' AND AD_Process_ID=?)) AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Tab_ID IS NULL AND IsActive='Y' AND Action=?)";
    private static final String GET_PROCESS_BUTTON_OF_TAB_SQL = "SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND Action='W' AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Tab_ID=? AND AD_Process_ID IS NOT NULL AND IsActive='Y' AND Action='W')";
    private static final String GET_OF_TAB_SQL = "SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND AD_Window_ID=? AND AD_Tab_ID=? AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Process_ID IS NULL AND IsActive='Y')";
    public static final String SQL_IS_TOOLBAR_BTN_EXCLUDED = "SELECT tbr.IsExclude FROM AD_ToolBarButton tb \t\t\t\t\t\t\t\t\t\t\t\t\t\t INNER JOIN AD_ToolBarButtonRestrict tbr ON \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t  \t( tbr.AD_ToolBarButton_ID=tb.AD_ToolBarButton_ID AND tbr.AD_Client_ID IN (0,?) AND tbr.IsActive='Y' AND \t\t\t\t\t \t\t\t\t\t\t  tbr.Action='W' AND (tbr.AD_Role_ID IS NULL OR tbr.AD_Role_ID=?) AND (tbr.AD_Window_ID IS NULL OR tbr.AD_Window_ID=?))\t\t LEFT JOIN AD_Tab t ON \t( t.AD_Tab_ID=tbr.AD_Tab_ID AND t.IsActive='Y' AND t.AD_Window_ID=? AND ((t.TabLevel=0 AND 0=?) OR t.AD_Tab_ID=?))\t\t\t WHERE tb.IsActive='Y' AND tb.Action='W' AND tb.AD_ToolBarButton_ID=? AND tb.AD_Tab_ID IS NULL AND (tbr.AD_Tab_ID IS NULL OR t.AD_Tab_ID IS NOT NULL) ORDER BY tbr.AD_Client_ID DESC, tbr.AD_Window_ID, tbr.AD_Tab_ID \t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    private static final long serialVersionUID = 751989571891306735L;
    private static CLogger s_log = CLogger.getCLogger(MToolBarButtonRestrict.class);

    public MToolBarButtonRestrict(Properties ctx, String AD_ToolBarButtonRestrict_UU, String trxName) {
        super(ctx, AD_ToolBarButtonRestrict_UU, trxName);
    }

    public MToolBarButtonRestrict(Properties ctx, int AD_ToolBarButtonRestrict_ID, String trxName) {
        super(ctx, AD_ToolBarButtonRestrict_ID, trxName);
    }

    public MToolBarButtonRestrict(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static int[] getOfWindow(Properties ctx, int AD_Role_ID, int AD_Window_ID, boolean reportViewer, String trxName) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("sql=SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND (AD_Window_ID IS NULL OR (Action='W' AND AD_Window_ID=?)) AND AD_Tab_ID IS NULL AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Tab_ID IS NULL AND IsActive='Y' AND Action=?)");
        }
        int[] ids = DB.getIDsEx(trxName, GET_OF_WINDOW_SQL, Env.getAD_Client_ID(ctx), AD_Role_ID, AD_Window_ID, reportViewer ? "R" : "W");
        return ids;
    }

    public static int[] getOfTab(Properties ctx, int AD_Role_ID, int AD_Window_ID, int AD_Tab_ID, String trxName) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("sql=SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND AD_Window_ID=? AND AD_Tab_ID=? AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Process_ID IS NULL AND IsActive='Y')");
        }
        int[] ids = DB.getIDsEx(trxName, GET_OF_TAB_SQL, Env.getAD_Client_ID(ctx), AD_Role_ID, AD_Window_ID, AD_Tab_ID);
        return ids;
    }

    public static int[] getOfReport(Properties ctx, int AD_Role_ID, int AD_Process_ID, String trxName) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("sql=SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND (AD_Process_ID IS NULL OR (Action='R' AND AD_Process_ID=?)) AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Tab_ID IS NULL AND IsActive='Y' AND Action=?)");
        }
        int[] ids = DB.getIDsEx(trxName, GET_OF_REPORT_SQL, Env.getAD_Client_ID(ctx), AD_Role_ID, AD_Process_ID, "R");
        return ids;
    }

    public static int[] getProcessButtonOfTab(Properties ctx, int AD_Role_ID, int AD_Tab_ID, String trxName) {
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("sql=SELECT AD_ToolBarButton_ID FROM AD_ToolBarButtonRestrict WHERE IsActive = 'Y' AND AD_Client_ID IN (0, ?) AND (AD_Role_ID IS NULL OR AD_Role_ID = ?) AND Action='W' AND AD_ToolBarButton_ID IN (SELECT AD_ToolBarButton_ID FROM AD_ToolBarButton WHERE AD_Tab_ID=? AND AD_Process_ID IS NOT NULL AND IsActive='Y' AND Action='W')");
        }
        int[] ids = DB.getIDsEx(trxName, GET_PROCESS_BUTTON_OF_TAB_SQL, Env.getAD_Client_ID(ctx), AD_Role_ID, AD_Tab_ID);
        return ids;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MToolBarButtonRestrict[").append(this.get_ID()).append(",AD_ToolBarButtonRestrict_ID=").append(this.getAD_ToolBarButtonRestrict_ID()).append("]");
        return sb.toString();
    }

    public static boolean isNewButtonRestricted(int windowID) {
        return MToolBarButtonRestrict.isNewButtonRestricted(windowID, 0);
    }

    public static boolean isNewButtonRestricted(int windowID, int tabID) {
        boolean isReadWrite = MRole.getDefault().getWindowAccess(windowID);
        if (!isReadWrite) {
            return true;
        }
        return MToolBarButtonRestrict.isToolbarButtonRestricted(windowID, tabID, 200031);
    }

    public static boolean isToolbarButtonRestricted(int windowID, int tabID, int toolbarBtnID) {
        int roleID;
        int clientID = Env.getAD_Client_ID(Env.getCtx());
        String key = clientID + "_" + (roleID = MRole.getDefault().getAD_Role_ID()) + "_" + windowID + "_" + tabID + "_" + toolbarBtnID;
        if (cache_toolbarBtnRestriction.containsKey(key)) {
            return cache_toolbarBtnRestriction.get(key);
        }
        String isExclude = DB.getSQLValueString(null, SQL_IS_TOOLBAR_BTN_EXCLUDED, clientID, roleID, windowID, windowID, tabID, tabID, toolbarBtnID);
        boolean isRestricted = isExclude != null && isExclude.equals("Y");
        cache_toolbarBtnRestriction.put(key, isRestricted);
        return isRestricted;
    }
}

