/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessor2;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MClientInfo;
import org.compiere.model.MOrgInfo;
import org.compiere.model.MRequestProcessorLog;
import org.compiere.model.MRequestProcessorRoute;
import org.compiere.model.MSchedule;
import org.compiere.model.X_R_RequestProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MRequestProcessor
extends X_R_RequestProcessor
implements AdempiereProcessor,
AdempiereProcessor2 {
    private static final long serialVersionUID = 8231854734466233461L;
    private static CLogger s_log = CLogger.getCLogger(MRequestProcessor.class);
    private MRequestProcessorRoute[] m_routes = null;

    public static MRequestProcessor[] getActive(Properties ctx) {
        ArrayList<MRequestProcessor> list;
        block6: {
            list = new ArrayList<MRequestProcessor>();
            String sql = "SELECT * FROM R_RequestProcessor WHERE IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRequestProcessor(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MRequestProcessor[] retValue = new MRequestProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MRequestProcessor(Properties ctx, String R_RequestProcessor_UU, String trxName) {
        super(ctx, R_RequestProcessor_UU, trxName);
        if (Util.isEmpty(R_RequestProcessor_UU)) {
            this.setInitialDefaults();
        }
    }

    public MRequestProcessor(Properties ctx, int R_RequestProcessor_ID, String trxName) {
        super(ctx, R_RequestProcessor_ID, trxName);
        if (R_RequestProcessor_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setKeepLogDays(7);
        this.setOverdueAlertDays(0);
        this.setOverdueAssignDays(0);
        this.setRemindDays(0);
    }

    public MRequestProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MRequestProcessor(MClient parent, int Supervisor_ID) {
        this(parent.getCtx(), 0, parent.get_TrxName());
        this.setClientOrg(parent);
        this.setName(parent.getName() + " - " + Msg.translate(this.getCtx(), "R_RequestProcessor_ID"));
        this.setSupervisor_ID(Supervisor_ID);
    }

    public MRequestProcessorRoute[] getRoutes(boolean reload) {
        ArrayList<MRequestProcessorRoute> list;
        block7: {
            if (this.m_routes != null && !reload) {
                return this.m_routes;
            }
            String sql = "SELECT * FROM R_RequestProcessor_Route WHERE R_RequestProcessor_ID=? ORDER BY SeqNo";
            list = new ArrayList<MRequestProcessorRoute>();
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getR_RequestProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRequestProcessorRoute(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block7;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        this.m_routes = new MRequestProcessorRoute[list.size()];
        list.toArray(this.m_routes);
        return this.m_routes;
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MRequestProcessorLog> list;
        block6: {
            list = new ArrayList<MRequestProcessorLog>();
            String sql = "SELECT * FROM R_RequestProcessorLog WHERE R_RequestProcessor_ID=? ORDER BY Created DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getR_RequestProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MRequestProcessorLog(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    this.log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MRequestProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        String sql = "DELETE FROM R_RequestProcessorLog WHERE R_RequestProcessor_ID=" + this.getR_RequestProcessor_ID() + " AND (Created+" + this.getKeepLogDays() + ") < getDate()";
        int no = DB.executeUpdate(sql, this.get_TrxName());
        return no;
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName(), new String[0]);
        }
        return this.getDateNextRun();
    }

    @Override
    public String getServerID() {
        return "RequestProcessor" + this.get_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord || this.is_ValueChanged("AD_Schedule_ID")) {
            long nextWork;
            String timeZoneId = null;
            if (this.getAD_Client_ID() == 0 && this.getAD_Org_ID() == 0 || this.getAD_Org_ID() > 0) {
                MOrgInfo orgInfo = MOrgInfo.get(this.getAD_Org_ID());
                timeZoneId = orgInfo.getTimeZone();
            }
            if (Util.isEmpty(timeZoneId, true)) {
                MClientInfo clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID());
                if (clientInfo == null) {
                    clientInfo = MClientInfo.get(this.getCtx(), this.getAD_Client_ID(), this.get_TrxName());
                }
                timeZoneId = clientInfo.getTimeZone();
            }
            if ((nextWork = MSchedule.getNextRunMS(System.currentTimeMillis(), this.getScheduleType(), this.getFrequencyType(), this.getFrequency(), this.getCronPattern(), timeZoneId)) > 0L) {
                this.setDateNextRun(new Timestamp(nextWork));
            }
        }
        return true;
    }

    @Override
    public String getFrequencyType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequencyType();
    }

    @Override
    public int getFrequency() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getFrequency();
    }

    @Override
    public boolean isIgnoreProcessingTime() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).isIgnoreProcessingTime();
    }

    @Override
    public String getScheduleType() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getScheduleType();
    }

    @Override
    public String getCronPattern() {
        return MSchedule.get(this.getCtx(), this.getAD_Schedule_ID()).getCronPattern();
    }
}

