/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import org.compiere.model.X_M_Product_Category;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.idempiere.cache.ImmutableIntPOCache;
import org.idempiere.cache.ImmutablePOSupport;

public class MProductCategory
extends X_M_Product_Category
implements ImmutablePOSupport {
    private static final long serialVersionUID = 6444388652482234582L;
    private static ImmutableIntPOCache<Integer, MProductCategory> s_cache = new ImmutableIntPOCache("M_Product_Category", 20);
    private static CCache<Integer, Integer> s_products = new CCache("M_Product", "M_Product_Category|M_Product", 100);
    private static CLogger s_log = CLogger.getCLogger(MProductCategory.class);

    public static MProductCategory get(int M_Product_Category_ID) {
        return MProductCategory.get(Env.getCtx(), M_Product_Category_ID);
    }

    public static MProductCategory get(Properties ctx, int M_Product_Category_ID) {
        Integer ii = M_Product_Category_ID;
        MProductCategory retValue = s_cache.get(ctx, ii, e -> new MProductCategory(ctx, (MProductCategory)e));
        if (retValue != null) {
            return retValue;
        }
        retValue = new MProductCategory(ctx, M_Product_Category_ID, null);
        if (retValue.get_ID() == M_Product_Category_ID) {
            s_cache.put(M_Product_Category_ID, retValue, e -> new MProductCategory(Env.getCtx(), (MProductCategory)e));
            return retValue;
        }
        return null;
    }

    public static boolean isCategory(int M_Product_Category_ID, int M_Product_ID) {
        Integer category;
        Integer product;
        block10: {
            if (M_Product_ID == 0 || M_Product_Category_ID == 0) {
                return false;
            }
            product = M_Product_ID;
            category = s_products.get(product);
            if (category != null) {
                return category == M_Product_Category_ID;
            }
            String sql = "SELECT M_Product_Category_ID FROM M_Product WHERE M_Product_ID=?";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, M_Product_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        category = rs.getInt(1);
                    }
                }
                catch (Exception e) {
                    s_log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block10;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (category != null) {
            s_products.put(product, category);
            if (s_log.isLoggable(Level.FINE)) {
                s_log.fine("M_Product_ID=" + M_Product_ID + "(" + String.valueOf(category) + ") in M_Product_Category_ID=" + M_Product_Category_ID + " - " + (category == M_Product_Category_ID));
            }
            return category == M_Product_Category_ID;
        }
        s_log.log(Level.SEVERE, "Not found M_Product_ID=" + M_Product_ID);
        return false;
    }

    public MProductCategory(Properties ctx, String M_Product_Category_UU, String trxName) {
        super(ctx, M_Product_Category_UU, trxName);
        if (Util.isEmpty(M_Product_Category_UU)) {
            this.setInitialDefaults();
        }
    }

    public MProductCategory(Properties ctx, int M_Product_Category_ID, String trxName) {
        super(ctx, M_Product_Category_ID, trxName);
        if (M_Product_Category_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setMMPolicy("F");
        this.setPlannedMargin(Env.ZERO);
        this.setIsDefault(false);
        this.setIsSelfService(true);
    }

    public MProductCategory(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProductCategory(MProductCategory copy) {
        this(Env.getCtx(), copy);
    }

    public MProductCategory(Properties ctx, MProductCategory copy) {
        this(ctx, copy, null);
    }

    public MProductCategory(Properties ctx, MProductCategory copy, String trxName) {
        this(ctx, 0, trxName);
        this.copyPO(copy);
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.hasLoopInTree()) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "ProductCategoryLoopDetected"));
            return false;
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord && success) {
            this.insert_Accounting("M_Product_Category_Acct", "C_AcctSchema_Default", null);
        }
        return success;
    }

    public boolean isFiFo() {
        return "F".equals(this.getMMPolicy());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasLoopInTree() {
        CPreparedStatement pstmt;
        ResultSet rs;
        block8: {
            int productCategoryId = this.getM_Product_Category_ID();
            int newParentCategoryId = this.getM_Product_Category_Parent_ID();
            rs = null;
            pstmt = null;
            String sql = " SELECT M_Product_Category_ID, M_Product_Category_Parent_ID FROM M_Product_Category";
            Vector<SimpleTreeNode> categories = new Vector<SimpleTreeNode>(100);
            try {
                pstmt = DB.prepareStatement(sql, null);
                rs = pstmt.executeQuery();
                while (true) {
                    if (!rs.next()) {
                        if (this.hasLoop(newParentCategoryId, categories, productCategoryId)) {
                            break;
                        }
                        break block8;
                    }
                    if (rs.getInt(1) == productCategoryId) {
                        categories.add(new SimpleTreeNode(rs.getInt(1), newParentCategoryId));
                    }
                    categories.add(new SimpleTreeNode(rs.getInt(1), rs.getInt(2)));
                }
            }
            catch (SQLException e) {
                try {
                    s_log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                return true;
            }
            DB.close(rs, pstmt);
            return true;
        }
        DB.close(rs, pstmt);
        return false;
    }

    private boolean hasLoop(int parentCategoryId, Vector<SimpleTreeNode> categories, int loopIndicatorId) {
        Iterator<SimpleTreeNode> iter = categories.iterator();
        boolean ret = false;
        while (iter.hasNext()) {
            SimpleTreeNode node = iter.next();
            if (node.getNodeId() != parentCategoryId) continue;
            if (node.getParentId() == 0) {
                return false;
            }
            if (node.getNodeId() == loopIndicatorId) {
                return true;
            }
            ret = this.hasLoop(node.getParentId(), categories, loopIndicatorId);
        }
        return ret;
    }

    @Override
    public MProductCategory markImmutable() {
        if (this.is_Immutable()) {
            return this;
        }
        this.makeImmutable();
        return this;
    }

    private static class SimpleTreeNode {
        private int nodeId;
        private int parentId;

        public SimpleTreeNode(int nodeId, int parentId) {
            this.nodeId = nodeId;
            this.parentId = parentId;
        }

        public int getNodeId() {
            return this.nodeId;
        }

        public int getParentId() {
            return this.parentId;
        }
    }
}

