/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.compiere.model.MInvoice;
import org.compiere.model.MPayment;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_C_PaymentAllocate;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPaymentAllocate
extends X_C_PaymentAllocate {
    private static final long serialVersionUID = 2894385378672375131L;
    private MInvoice m_invoice = null;

    public static MPaymentAllocate[] get(MPayment parent) {
        Query query = MTable.get(parent.getCtx(), 812).createQuery("C_Payment_ID=?", parent.get_TrxName());
        query.setParameters(parent.getC_Payment_ID()).setOnlyActiveRecords(true);
        List<MPaymentAllocate> list = query.list();
        return list.toArray(new MPaymentAllocate[list.size()]);
    }

    public MPaymentAllocate(Properties ctx, String C_PaymentAllocate_UU, String trxName) {
        super(ctx, C_PaymentAllocate_UU, trxName);
        if (Util.isEmpty(C_PaymentAllocate_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPaymentAllocate(Properties ctx, int C_PaymentAllocate_ID, String trxName) {
        super(ctx, C_PaymentAllocate_ID, trxName);
        if (C_PaymentAllocate_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setAmount(Env.ZERO);
        this.setDiscountAmt(Env.ZERO);
        this.setOverUnderAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setInvoiceAmt(Env.ZERO);
    }

    public MPaymentAllocate(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public void setC_Invoice_ID(int C_Invoice_ID) {
        super.setC_Invoice_ID(C_Invoice_ID);
        this.m_invoice = null;
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null && this.getC_Invoice_ID() != 0) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    public int getC_BPartner_ID() {
        if (this.m_invoice == null) {
            this.getInvoice();
        }
        if (this.m_invoice == null) {
            return 0;
        }
        return this.m_invoice.getC_BPartner_ID();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MPayment payment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if ((newRecord || this.is_ValueChanged("C_Invoice_ID")) && (payment.getC_Charge_ID() != 0 || payment.getC_Invoice_ID() != 0 || payment.getC_Order_ID() != 0)) {
            this.log.saveError("PaymentIsAllocated", "");
            return false;
        }
        BigDecimal check = this.getAmount().add(this.getDiscountAmt()).add(this.getWriteOffAmt()).add(this.getOverUnderAmt());
        if (check.compareTo(this.getInvoiceAmt()) != 0) {
            this.log.saveError("Error", Msg.parseTranslation(this.getCtx(), "@InvoiceAmt@(" + String.valueOf(this.getInvoiceAmt()) + ") <> @Totals@(" + String.valueOf(check) + ")"));
            return false;
        }
        if (newRecord || this.is_ValueChanged("C_Invoice_ID")) {
            this.getInvoice();
            if (this.m_invoice != null) {
                this.setAD_Org_ID(this.m_invoice.getAD_Org_ID());
            }
        }
        return true;
    }
}

