/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.Properties;
import org.compiere.model.MInvoice;
import org.compiere.model.MPaySelection;
import org.compiere.model.X_C_PaySelectionLine;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MPaySelectionLine
extends X_C_PaySelectionLine {
    private static final long serialVersionUID = -1880961891234637133L;
    private MInvoice m_invoice = null;

    public MPaySelectionLine(Properties ctx, String C_PaySelectionLine_UU, String trxName) {
        super(ctx, C_PaySelectionLine_UU, trxName);
        if (Util.isEmpty(C_PaySelectionLine_UU)) {
            this.setInitialDefaults();
        }
    }

    public MPaySelectionLine(Properties ctx, int C_PaySelectionLine_ID, String trxName) {
        super(ctx, C_PaySelectionLine_ID, trxName);
        if (C_PaySelectionLine_ID == 0) {
            this.setInitialDefaults();
        }
    }

    private void setInitialDefaults() {
        this.setIsSOTrx(false);
        this.setOpenAmt(Env.ZERO);
        this.setPayAmt(Env.ZERO);
        this.setDiscountAmt(Env.ZERO);
        this.setWriteOffAmt(Env.ZERO);
        this.setDifferenceAmt(Env.ZERO);
        this.setIsManual(false);
    }

    public MPaySelectionLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionLine(MPaySelection ps, int Line, String PaymentRule) {
        this(ps.getCtx(), 0, ps.get_TrxName());
        this.setClientOrg(ps);
        this.setC_PaySelection_ID(ps.getC_PaySelection_ID());
        this.setLine(Line);
        this.setPaymentRule(PaymentRule);
    }

    @Deprecated(forRemoval=true, since="11")
    public void xsetInvoice(int C_Invoice_ID, boolean isSOTrx, BigDecimal OpenAmt, BigDecimal PayAmt, BigDecimal DiscountAmt) {
        this.setInvoice(C_Invoice_ID, isSOTrx, OpenAmt, PayAmt, DiscountAmt, Env.ZERO);
    }

    public void setInvoice(int C_Invoice_ID, boolean isSOTrx, BigDecimal OpenAmt, BigDecimal PayAmt, BigDecimal DiscountAmt, BigDecimal WriteOffAmt) {
        this.setC_Invoice_ID(C_Invoice_ID);
        this.setIsSOTrx(isSOTrx);
        this.setOpenAmt(OpenAmt);
        this.setPayAmt(PayAmt);
        this.setDiscountAmt(DiscountAmt);
        this.setWriteOffAmt(WriteOffAmt);
        this.setDifferenceAmt(OpenAmt.subtract(PayAmt).subtract(DiscountAmt).subtract(WriteOffAmt));
    }

    public MInvoice getInvoice() {
        if (this.m_invoice == null) {
            this.m_invoice = new MInvoice(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName());
        }
        return this.m_invoice;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        MPaySelection parent = new MPaySelection(this.getCtx(), this.getC_PaySelection_ID(), this.get_TrxName());
        if (newRecord && parent.isProcessed()) {
            this.log.saveError("ParentComplete", Msg.translate(this.getCtx(), "C_PaySelection_ID"));
            return false;
        }
        this.setDifferenceAmt(this.getOpenAmt().subtract(this.getPayAmt()).subtract(this.getDiscountAmt()).subtract(this.getWriteOffAmt()));
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        this.setHeader();
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (!success) {
            return success;
        }
        this.setHeader();
        return success;
    }

    private void setHeader() {
        String sql = "UPDATE C_PaySelection ps SET TotalAmt = (SELECT COALESCE(SUM(psl.PayAmt),0) FROM C_PaySelectionLine psl WHERE ps.C_PaySelection_ID=psl.C_PaySelection_ID AND psl.IsActive='Y') WHERE C_PaySelection_ID=" + this.getC_PaySelection_ID();
        DB.executeUpdateEx(sql, this.get_TrxName());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MPaySelectionLine[");
        sb.append(this.get_ID()).append(",C_Invoice_ID=").append(this.getC_Invoice_ID()).append(",PayAmt=").append(this.getPayAmt()).append(",DifferenceAmt=").append(this.getDifferenceAmt()).append("]");
        return sb.toString();
    }
}

