/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.AdempiereProcessor;
import org.compiere.model.AdempiereProcessorLog;
import org.compiere.model.MClient;
import org.compiere.model.MInterestArea;
import org.compiere.model.MLdapAccess;
import org.compiere.model.MLdapProcessorLog;
import org.compiere.model.MLdapUser;
import org.compiere.model.X_AD_LdapProcessor;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Msg;

public class MLdapProcessor
extends X_AD_LdapProcessor
implements AdempiereProcessor {
    private static final long serialVersionUID = -1477519989047580644L;
    private static CLogger log = CLogger.getCLogger(MLdapProcessor.class);
    private MClient[] m_clients = null;
    private MInterestArea[] m_interests = null;
    private int m_auth = 0;
    private int m_ok = 0;
    private int m_error = 0;

    public static MLdapProcessor[] getActive(Properties ctx) {
        ArrayList<MLdapProcessor> list;
        block6: {
            list = new ArrayList<MLdapProcessor>();
            String sql = "SELECT * FROM AD_LdapProcessor WHERE IsActive='Y'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MLdapProcessor(ctx, rs, null));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        MLdapProcessor[] retValue = new MLdapProcessor[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MLdapProcessor(Properties ctx, String AD_LdapProcessor_UU, String trxName) {
        super(ctx, AD_LdapProcessor_UU, trxName);
    }

    public MLdapProcessor(Properties ctx, int AD_LdapProcessor_ID, String trxName) {
        super(ctx, AD_LdapProcessor_ID, trxName);
    }

    public MLdapProcessor(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getServerID() {
        return "Ldap" + this.get_ID();
    }

    public String getInfo() {
        StringBuilder msgreturn = new StringBuilder("Auth=").append(this.m_auth).append(", OK=").append(this.m_ok).append(", Error=").append(this.m_error);
        return msgreturn.toString();
    }

    @Override
    public Timestamp getDateNextRun(boolean requery) {
        if (requery) {
            this.load(this.get_TrxName(), new String[0]);
        }
        return this.getDateNextRun();
    }

    @Override
    public AdempiereProcessorLog[] getLogs() {
        ArrayList<MLdapProcessorLog> list;
        block6: {
            list = new ArrayList<MLdapProcessorLog>();
            String sql = "SELECT * FROM AD_LdapProcessorLog WHERE AD_LdapProcessor_ID=? ORDER BY Created DESC";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, this.get_TrxName());
                    pstmt.setInt(1, this.getAD_LdapProcessor_ID());
                    rs = pstmt.executeQuery();
                    while (rs.next()) {
                        list.add(new MLdapProcessorLog(this.getCtx(), rs, this.get_TrxName()));
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block6;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        AdempiereProcessorLog[] retValue = new MLdapProcessorLog[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int deleteLog() {
        if (this.getKeepLogDays() < 1) {
            return 0;
        }
        StringBuilder sql = new StringBuilder("DELETE FROM AD_LdapProcessorLog ").append("WHERE AD_LdapProcessor_ID=").append(this.getAD_LdapProcessor_ID()).append(" AND (Created+").append(this.getKeepLogDays()).append(") < getDate()");
        int no = DB.executeUpdate(sql.toString(), this.get_TrxName());
        return no;
    }

    @Override
    public int getFrequency() {
        return 1;
    }

    @Override
    public String getFrequencyType() {
        return "M";
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("MLdapProcessor[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",Port=").append(this.getLdapPort()).append("]");
        return sb.toString();
    }

    public MLdapUser authenticate(MLdapUser ldapUser, String usr, String o, String ou) {
        boolean found;
        String OptOutDate;
        boolean IsActive;
        String Password;
        int AD_User_ID;
        int R_InterestArea_ID;
        int AD_Client_ID;
        StringBuilder info;
        StringBuilder error;
        block37: {
            ResultSet rs;
            CPreparedStatement pstmt;
            String sql;
            boolean isUnique;
            String EMailVerify;
            String Name;
            String EMail2;
            String LdapUser;
            String Value;
            block35: {
                if (ldapUser == null) {
                    ldapUser = new MLdapUser();
                }
                error = null;
                info = null;
                if (usr == null || usr.trim().length() == 0) {
                    error = new StringBuilder("@NotFound@ User");
                    ldapUser.setErrorString(error.toString());
                    ++this.m_error;
                    log.warning(error.toString());
                    return ldapUser;
                }
                usr = usr.trim();
                if (o == null || o.length() == 0) {
                    error = new StringBuilder("@NotFound@ O");
                    ldapUser.setErrorString(error.toString());
                    ++this.m_error;
                    log.warning(error.toString());
                    return ldapUser;
                }
                AD_Client_ID = this.findClient(o);
                if (AD_Client_ID == 0) {
                    error = new StringBuilder("@NotFound@ O=").append(o);
                    ldapUser.setErrorString(error.toString());
                    ++this.m_error;
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(error.toString());
                    }
                    return ldapUser;
                }
                R_InterestArea_ID = 0;
                if (ou != null && ou.length() > 0 && (R_InterestArea_ID = this.findInterestArea(AD_Client_ID, ou)) == 0) {
                    error = new StringBuilder("@NotFound@ OU=").append(ou);
                    ldapUser.setErrorString(error.toString());
                    ++this.m_error;
                    if (log.isLoggable(Level.CONFIG)) {
                        log.config(error.toString());
                    }
                    return ldapUser;
                }
                ++this.m_auth;
                AD_User_ID = 0;
                Value = null;
                LdapUser = null;
                EMail2 = null;
                Name = null;
                Password = null;
                IsActive = false;
                EMailVerify = null;
                isUnique = false;
                sql = "SELECT AD_User_ID, Value, LdapUser, EMail, Name, Password, IsActive, EMailVerify FROM AD_User WHERE AD_Client_ID=? AND (EMail=? OR Value=? OR LdapUser=?)";
                pstmt = null;
                rs = null;
                try {
                    try {
                        pstmt = DB.prepareStatement(sql, null);
                        pstmt.setInt(1, AD_Client_ID);
                        pstmt.setString(2, usr);
                        pstmt.setString(3, usr);
                        pstmt.setString(4, usr);
                        rs = pstmt.executeQuery();
                        if (rs.next()) {
                            AD_User_ID = rs.getInt(1);
                            Value = rs.getString(2);
                            LdapUser = rs.getString(3);
                            EMail2 = rs.getString(4);
                            Name = rs.getString(5);
                            Password = rs.getString(6);
                            IsActive = "Y".equals(rs.getString(7));
                            EMailVerify = rs.getString(8);
                            isUnique = rs.next();
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, sql, e);
                        error = new StringBuilder("System Error");
                        DB.close(rs, pstmt);
                        rs = null;
                        pstmt = null;
                        break block35;
                    }
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
            if (error != null) {
                ++this.m_error;
                ldapUser.setErrorString(error.toString());
                return ldapUser;
            }
            if (AD_User_ID == 0) {
                error = new StringBuilder("@NotFound@ User=").append(usr);
                info = new StringBuilder("User not found - ").append(usr);
            } else if (!IsActive) {
                error = new StringBuilder("@NotFound@ User=").append(usr);
                info = new StringBuilder("User not active - ").append(usr);
            } else if (EMailVerify == null) {
                error = new StringBuilder("@UserNotVerified@ User=").append(usr);
                info = new StringBuilder("User EMail not verified - ").append(usr);
            } else {
                info = usr.equalsIgnoreCase(LdapUser) ? new StringBuilder("User verified - Ldap=").append(usr).append(isUnique ? "" : " - Not Unique") : (usr.equalsIgnoreCase(Value) ? new StringBuilder("User verified - Value=").append(usr).append(isUnique ? "" : " - Not Unique") : (usr.equalsIgnoreCase(EMail2) ? new StringBuilder("User verified - EMail=").append(usr).append(isUnique ? "" : " - Not Unique") : new StringBuilder("User verified ?? ").append(usr).append(" - Name=").append(Name).append(", Ldap=").append(LdapUser).append(", Value=").append(Value).append(isUnique ? "" : " - Not Unique")));
            }
            if (error != null) {
                this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info.toString(), error.toString());
                ldapUser.setErrorString(Msg.translate(this.getCtx(), error.toString()));
                return ldapUser;
            }
            if (R_InterestArea_ID == 0) {
                this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info.toString(), null);
                ldapUser.setOrg(o);
                ldapUser.setOrgUnit(ou);
                ldapUser.setUserId(usr);
                ldapUser.setPassword(Password);
                return ldapUser;
            }
            OptOutDate = null;
            found = false;
            sql = "SELECT IsActive, OptOutDate FROM R_ContactInterest WHERE R_InterestArea_ID=? AND AD_User_ID=?";
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, R_InterestArea_ID);
                    pstmt.setInt(2, AD_User_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        found = true;
                        IsActive = "Y".equals(rs.getString(1));
                        OptOutDate = rs.getString(2);
                        isUnique = rs.next();
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, sql, e);
                    error = new StringBuilder("System Error (2)");
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    break block37;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (error != null) {
            ++this.m_error;
            ldapUser.setErrorString(error.toString());
            return ldapUser;
        }
        if (!found) {
            error = new StringBuilder("@UserNotSubscribed@ User=").append(usr);
            info = new StringBuilder("No User Interest - ").append(usr).append(" - R_InterestArea_ID=").append(R_InterestArea_ID);
        } else if (OptOutDate != null) {
            error = new StringBuilder("@UserNotSubscribed@ User=").append(usr).append(" @OptOutDate@=").append(OptOutDate);
            info = new StringBuilder("Opted out - ").append(usr).append(" - OptOutDate=").append(OptOutDate);
        } else if (!IsActive) {
            error = new StringBuilder("@UserNotSubscribed@ User=").append(usr);
            info = new StringBuilder("User Interest Not Active - ").append(usr);
        } else {
            info = new StringBuilder("User subscribed - ").append(usr);
        }
        if (error != null) {
            this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info.toString(), error.toString());
            ldapUser.setErrorString(Msg.translate(this.getCtx(), error.toString()));
            return ldapUser;
        }
        this.logAccess(AD_Client_ID, AD_User_ID, R_InterestArea_ID, info.toString(), null);
        ldapUser.setOrg(o);
        ldapUser.setOrgUnit(ou);
        ldapUser.setUserId(usr);
        ldapUser.setPassword(Password);
        return ldapUser;
    }

    private int findClient(String client) {
        if (this.m_clients == null) {
            this.m_clients = MClient.getAll(this.getCtx());
        }
        int i = 0;
        while (i < this.m_clients.length) {
            if (client.equalsIgnoreCase(this.m_clients[i].getValue())) {
                return this.m_clients[i].getAD_Client_ID();
            }
            ++i;
        }
        return 0;
    }

    private int findInterestArea(int AD_Client_ID, String interestArea) {
        if (this.m_interests == null) {
            this.m_interests = MInterestArea.getAll(this.getCtx());
        }
        int i = 0;
        while (i < this.m_interests.length) {
            if (AD_Client_ID == this.m_interests[i].getAD_Client_ID() && interestArea.equalsIgnoreCase(this.m_interests[i].getValue())) {
                return this.m_interests[i].getR_InterestArea_ID();
            }
            ++i;
        }
        return 0;
    }

    private void logAccess(int AD_Client_ID, int AD_User_ID, int R_InterestArea_ID, String info, String error) {
        if (error != null) {
            log.log(Level.CONFIG, info);
            ++this.m_error;
        } else {
            log.log(Level.INFO, info);
            ++this.m_ok;
        }
        MLdapAccess access = new MLdapAccess(this.getCtx(), 0, null);
        access.setAD_Client_ID(AD_Client_ID);
        access.setAD_User_ID(AD_User_ID);
        access.setR_InterestArea_ID(R_InterestArea_ID);
        access.setIsError(error != null);
        access.setSummary(info);
        access.saveEx();
    }

    @Override
    public String getScheduleType() {
        return "F";
    }

    @Override
    public String getCronPattern() {
        return null;
    }
}

