/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTable;
import org.compiere.model.Query;
import org.compiere.model.X_AD_ChangeLog;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Util;

public class MChangeLog
extends X_AD_ChangeLog {
    private static final long serialVersionUID = 3082084206319959526L;
    private static int[] s_changeLog = null;
    private static CLogger s_log = CLogger.getCLogger(MChangeLog.class);
    public static String NULL = "NULL";

    public static synchronized boolean isLogged(int AD_Table_ID) {
        int index;
        if (s_changeLog == null || s_changeLog.length == 0) {
            MChangeLog.fillChangeLog();
        }
        return (index = Arrays.binarySearch(s_changeLog, AD_Table_ID)) >= 0;
    }

    public static synchronized void resetLoggedList() {
        s_changeLog = null;
    }

    private static void fillChangeLog() {
        s_changeLog = new Query(Env.getCtx(), "AD_Table", "IsChangeLog='Y' OR EXISTS (SELECT * FROM AD_Column c WHERE AD_Table.AD_Table_ID=c.AD_Table_ID AND c.ColumnName='EntityType')", null).setOrderBy("AD_Table_ID").getIDs();
        if (s_log.isLoggable(Level.INFO)) {
            s_log.info("#" + s_changeLog.length);
        }
    }

    public MChangeLog(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MChangeLog(Properties ctx, String AD_ChangeLog_UU, String trxName) {
        super(ctx, AD_ChangeLog_UU, trxName);
    }

    public MChangeLog(Properties ctx, int AD_ChangeLog_ID, String trxName) {
        super(ctx, 0, trxName);
    }

    @Deprecated
    public MChangeLog(Properties ctx, int AD_ChangeLog_ID, String TrxName, int AD_Session_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue) {
        this(ctx, AD_ChangeLog_ID, TrxName, AD_Session_ID, AD_Table_ID, AD_Column_ID, Record_ID, AD_Client_ID, AD_Org_ID, OldValue, NewValue, null);
    }

    public MChangeLog(Properties ctx, int AD_ChangeLog_ID, String TrxName, int AD_Session_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue, String event) {
        this(ctx, AD_ChangeLog_ID, TrxName, AD_Session_ID, AD_Table_ID, AD_Column_ID, Record_ID, null, AD_Client_ID, AD_Org_ID, OldValue, NewValue, event);
    }

    public MChangeLog(Properties ctx, int AD_ChangeLog_ID, String TrxName, int AD_Session_ID, int AD_Table_ID, int AD_Column_ID, int Record_ID, String Record_UU, int AD_Client_ID, int AD_Org_ID, Object OldValue, Object NewValue, String event) {
        this(ctx, 0, TrxName);
        if (AD_ChangeLog_ID == 0 && (AD_ChangeLog_ID = DB.getNextID(AD_Client_ID, "AD_ChangeLog", TrxName)) <= 0) {
            this.log.severe("No NextID (" + AD_ChangeLog_ID + ")");
        }
        this.setAD_ChangeLog_ID(AD_ChangeLog_ID);
        this.setTrxName(TrxName);
        this.setAD_Session_ID(AD_Session_ID);
        this.setAD_Table_ID(AD_Table_ID);
        this.setAD_Column_ID(AD_Column_ID);
        String saveUUID = MSysConfig.getValue("AD_CHANGELOG_SAVE_UUID", "B");
        if (Record_ID > 0 && (!"U".equals(saveUUID) || Util.isEmpty(Record_UU))) {
            this.setRecord_ID(Record_ID);
        }
        if ("U".equals(saveUUID) || "A".equals(saveUUID) || "B".equals(saveUUID) && (Record_ID <= 0 || MTable.get(AD_Table_ID).isUUIDKeyTable())) {
            this.setRecord_UU(Record_UU);
        }
        this.setClientOrg(AD_Client_ID, AD_Org_ID);
        this.setOldValue(OldValue);
        this.setNewValue(NewValue);
        this.setEventChangeLog(event);
    }

    public void setOldValue(Object OldValue) {
        if (OldValue == null) {
            super.setOldValue(NULL);
        } else {
            super.setOldValue(OldValue.toString());
        }
    }

    public boolean isOldNull() {
        String value = this.getOldValue();
        return value == null || value.equals(NULL);
    }

    public void setNewValue(Object NewValue) {
        if (NewValue == null) {
            super.setNewValue(NULL);
        } else {
            super.setNewValue(NewValue.toString());
        }
    }

    public boolean isNewNull() {
        String value = this.getNewValue();
        return value == null || value.equals(NULL);
    }
}

