/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Random;
import java.util.logging.Level;
import org.compiere.model.IAttachmentLazyDataSource;
import org.compiere.util.CLogger;
import org.compiere.util.MimeType;

public class MAttachmentEntry {
    private String m_name = "?";
    private boolean m_isDataSet = false;
    private byte[] m_data = null;
    private static long s_seed = System.currentTimeMillis();
    private static Random s_random = new Random(s_seed);
    private int m_index = 0;
    protected CLogger log = CLogger.getCLogger(this.getClass());
    private IAttachmentLazyDataSource m_ds = null;
    private boolean m_isUpdated = false;

    public MAttachmentEntry(String name, byte[] data, int index) {
        this.setName(name);
        this.setData(data);
        this.setIndex(index);
    }

    public MAttachmentEntry(String name, byte[] data) {
        this(name, data, 0);
    }

    public MAttachmentEntry(String name, int index, IAttachmentLazyDataSource ds) {
        this.setName(name);
        this.setIndex(index);
        this.setLazyDataSource(ds);
    }

    public MAttachmentEntry(MAttachmentEntry copy) {
        this.m_isDataSet = copy.m_isDataSet;
        this.m_ds = copy.m_ds;
        this.m_data = copy.m_data != null ? Arrays.copyOf(copy.m_data, copy.m_data.length) : null;
        this.m_index = copy.m_index;
        this.m_name = copy.m_name;
    }

    public byte[] getData() {
        if (!this.m_isDataSet && this.m_ds != null) {
            this.setData(this.m_ds.getData());
        }
        return this.m_data;
    }

    public void setData(byte[] data) {
        this.m_data = data;
        this.m_isDataSet = true;
    }

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        if (name != null) {
            this.m_name = name;
        }
        if (this.m_name == null) {
            this.m_name = "?";
        }
    }

    public int getIndex() {
        return this.m_index;
    }

    public String toString() {
        return this.m_name;
    }

    public String toStringX() {
        StringBuilder sb = new StringBuilder(this.m_name);
        if (this.getData() != null) {
            sb.append(" (");
            float size = this.getData().length;
            if (size <= 1024.0f) {
                sb.append(this.getData().length).append(" B");
            } else if ((size /= 1024.0f) > 1024.0f) {
                sb.append(size /= 1024.0f).append(" MB");
            } else {
                sb.append(size).append(" kB");
            }
            sb.append(")");
        }
        sb.append(" - ").append(this.getContentType());
        return sb.toString();
    }

    public void dump() {
        StringBuilder hdr = new StringBuilder("----- ").append(this.getName()).append(" -----");
        System.out.println(hdr.toString());
        if (this.getData() == null) {
            System.out.println("----- no data -----");
            return;
        }
        int i = 0;
        while (i < this.getData().length) {
            char data = (char)this.getData()[i];
            System.out.print(data);
            ++i;
        }
        System.out.println();
        System.out.println(hdr.toString());
        int ii = this.getData().length - 1;
        int nullCount = 0;
        while (this.getData()[ii--] == 0) {
            ++nullCount;
        }
        StringBuilder msgout = new StringBuilder("----- Length=").append(this.getData().length).append(", EndNulls=").append(nullCount).append(", RealLength=").append(this.getData().length - nullCount);
        System.out.println(msgout.toString());
    }

    public File getFile() {
        return this.getFile(this.getName());
    }

    public File getFile(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            fileName = this.getName();
        }
        return this.getFile(new File(System.getProperty("java.io.tmpdir") + File.separator + fileName));
    }

    public File getFile(File file) {
        if (this.getData() == null || this.getData().length == 0) {
            return null;
        }
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(this.getData());
            fos.close();
        }
        catch (IOException ioe) {
            this.log.log(Level.SEVERE, "getFile", ioe);
            throw new RuntimeException(ioe);
        }
        return file;
    }

    public boolean isPDF() {
        return this.m_name.toLowerCase().endsWith(".pdf");
    }

    public boolean isGraphic() {
        String m_lowname = this.m_name.toLowerCase();
        return m_lowname.endsWith(".gif") || m_lowname.endsWith(".jpg") || m_lowname.endsWith(".png");
    }

    public String getContentType() {
        return MimeType.getMimeType(this.m_name);
    }

    public InputStream getInputStream() {
        if (this.getData() == null) {
            return null;
        }
        return new ByteArrayInputStream(this.getData());
    }

    public void setIndex(int index) {
        if (index > 0) {
            this.m_index = index;
        } else {
            long now = System.currentTimeMillis();
            if (s_seed + 3600000L < now) {
                s_seed = now;
                s_random = new Random(s_seed);
            }
            this.m_index = s_random.nextInt();
        }
    }

    public void setLazyDataSource(IAttachmentLazyDataSource ds) {
        this.m_ds = ds;
    }

    public IAttachmentLazyDataSource getLazyDataSource() {
        return this.m_ds;
    }

    public void setUpdated(boolean updated) {
        this.m_isUpdated = updated;
    }

    public boolean isUpdated() {
        return this.m_isUpdated;
    }
}

