/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.GridTabVO;
import org.compiere.model.MRole;
import org.compiere.model.MUserDefWin;
import org.compiere.model.MWindow;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class GridWindowVO
implements Serializable {
    private static final long serialVersionUID = 6884332743173214735L;
    private static final CLogger log = CLogger.getCLogger(GridWindowVO.class);
    private static CCache<Integer, GridWindowVO> s_windowsvo = new CCache("AD_Window", "AD_Window|GridWindowVO", 10);
    private static final CCache<String, ArrayList<GridTabVO>> s_gridTabsCache = new CCache("AD_Tab", "GridTabVOs Cache", 100, 0, false, 0);
    public Properties ctx;
    public int WindowNo;
    public int AD_Window_ID = 0;
    public String AD_Window_UU = "";
    public String Name = "";
    public String Description = "";
    public String Help = "";
    public String WindowType = "";
    public int AD_Image_ID = 0;
    public int AD_Color_ID = 0;
    public String IsReadWrite = null;
    public int WinWidth = 0;
    public int WinHeight = 0;
    public boolean IsSOTrx = false;
    public ArrayList<GridTabVO> Tabs = null;
    public int AD_Table_ID = 0;
    public String EntityType = null;
    public static final String WINDOWTYPE_QUERY = "Q";
    public static final String WINDOWTYPE_TRX = "T";
    public static final String WINDOWTYPE_MMAINTAIN = "M";

    public static GridWindowVO get(int AD_Window_ID, int windowNo) {
        return GridWindowVO.get(AD_Window_ID, windowNo, -1);
    }

    public static GridWindowVO get(int AD_Window_ID, int windowNo, int AD_Menu_ID) {
        return GridWindowVO.create(Env.getCtx(), windowNo, AD_Window_ID, AD_Menu_ID);
    }

    public static GridWindowVO create(int WindowNo, int AD_Window_ID) {
        return GridWindowVO.create(Env.getCtx(), WindowNo, AD_Window_ID);
    }

    public static GridWindowVO create(Properties ctx, int WindowNo, int AD_Window_ID) {
        return GridWindowVO.create(ctx, WindowNo, AD_Window_ID, 0);
    }

    public static GridWindowVO create(Properties ctx, int WindowNo, int AD_Window_ID, int AD_Menu_ID) {
        Boolean windowAccess;
        if (log.isLoggable(Level.CONFIG)) {
            log.config("#" + WindowNo + " - AD_Window_ID=" + AD_Window_ID + "; AD_Menu_ID=" + AD_Menu_ID);
        }
        String menuIsReadWrite = null;
        if (AD_Window_ID == 0 && AD_Menu_ID != 0) {
            String sql = "SELECT AD_Window_ID, IsSOTrx, IsReadOnly FROM AD_Menu WHERE AD_Menu_ID=? AND Action='W'";
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, AD_Menu_ID);
                    rs = pstmt.executeQuery();
                    if (rs.next()) {
                        AD_Window_ID = rs.getInt(1);
                        String IsSOTrx = rs.getString(2);
                        Env.setContext(ctx, WindowNo, "IsSOTrx", IsSOTrx != null && IsSOTrx.equals("Y"));
                        String IsReadOnly = rs.getString(3);
                        menuIsReadWrite = IsReadOnly != null && IsReadOnly.equals("Y") ? "Y" : "N";
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "Menu", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return null;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            if (log.isLoggable(Level.CONFIG)) {
                log.config("AD_Window_ID=" + AD_Window_ID);
            }
        }
        GridWindowVO vo = s_windowsvo.get(AD_Window_ID);
        boolean clone = false;
        if (vo != null) {
            vo = vo.clone(WindowNo, false);
            clone = true;
        } else {
            vo = new GridWindowVO(ctx, WindowNo);
            vo.AD_Window_ID = AD_Window_ID;
        }
        if (menuIsReadWrite != null) {
            vo.IsReadWrite = menuIsReadWrite;
        }
        if (!clone) {
            MWindow window = MWindow.get(AD_Window_ID);
            boolean base = Env.isBaseLanguage(vo.ctx, "AD_Window");
            if (window != null) {
                vo.Name = base ? window.getName() : window.get_Translation("Name");
                String string = vo.Description = base ? window.getDescription() : window.get_Translation("Description");
                if (vo.Description == null) {
                    vo.Description = "";
                }
                String string2 = vo.Help = base ? window.getHelp() : window.get_Translation("Help");
                if (vo.Help == null) {
                    vo.Help = "";
                }
                vo.WindowType = window.getWindowType();
                vo.AD_Color_ID = window.getAD_Color_ID();
                vo.AD_Image_ID = window.getAD_Image_ID();
                vo.WinHeight = window.getWinHeight();
                vo.WinWidth = window.getWinWidth();
                vo.IsSOTrx = window.isSOTrx();
                Env.setContext(ctx, WindowNo, "IsSOTrx", vo.IsSOTrx);
                vo.AD_Window_UU = window.getAD_Window_UU();
                vo.EntityType = window.getEntityType();
            } else {
                vo = null;
            }
            s_windowsvo.put(AD_Window_ID, vo.clone(0, false));
        }
        MRole role = MRole.getDefault(ctx, false);
        Boolean bl = windowAccess = vo != null ? role.getWindowAccess(vo.AD_Window_ID) : null;
        if (vo != null && windowAccess == null) {
            vo = null;
        }
        if (vo != null && windowAccess != null) {
            String string = vo.IsReadWrite = windowAccess != false ? "Y" : "N";
        }
        if (vo == null) {
            log.log(Level.SEVERE, "No Window - AD_Window_ID=" + AD_Window_ID + ", AD_Role_ID=" + String.valueOf(role));
            log.saveError("AccessTableNoView", "(Not found)");
            return null;
        }
        if (vo.IsReadWrite == null) {
            log.saveError("AccessTableNoView", "(found)");
            return null;
        }
        MUserDefWin userDef = MUserDefWin.getBestMatch(ctx, AD_Window_ID);
        if (userDef != null) {
            if (userDef.getName() != null) {
                vo.Name = userDef.getName();
            }
            if (userDef.getDescription() != null) {
                vo.Description = userDef.getDescription();
            }
            if (userDef.getHelp() != null) {
                vo.Help = userDef.getHelp();
            }
        }
        GridWindowVO.createTabs(vo);
        if (vo.Tabs == null || vo.Tabs.size() == 0) {
            return null;
        }
        return vo;
    }

    private static boolean createTabs(GridWindowVO mWindowVO) {
        mWindowVO.Tabs = new ArrayList();
        MRole role = MRole.getDefault(mWindowVO.ctx, false);
        String sql = GridTabVO.getSQL(mWindowVO.ctx);
        String cacheKey = sql + "|" + mWindowVO.AD_Window_ID;
        ArrayList<GridTabVO> cacheTabs = s_gridTabsCache.get(cacheKey);
        if (cacheTabs != null) {
            boolean firstTabIsNull = false;
            for (GridTabVO cacheTab : cacheTabs) {
                GridTabVO tabvo = cacheTab.clone(mWindowVO.ctx, mWindowVO.WindowNo);
                if (!GridTabVO.checkAccessAndShowPreference(tabvo, role)) {
                    if (!mWindowVO.Tabs.isEmpty()) continue;
                    firstTabIsNull = true;
                    continue;
                }
                if (firstTabIsNull) continue;
                GridTabVO.loadUserDefTab(tabvo);
                if (mWindowVO.Tabs.isEmpty()) {
                    GridTabVO.updateContext(tabvo);
                }
                if (!tabvo.IsReadOnly && "N".equals(mWindowVO.IsReadWrite)) {
                    tabvo.IsReadOnly = true;
                }
                mWindowVO.Tabs.add(tabvo);
            }
            if (mWindowVO.Tabs.size() == 0) {
                log.log(Level.SEVERE, "No Tabs - AD_Window_ID=" + mWindowVO.AD_Window_ID + " - " + sql);
                return false;
            }
        } else {
            cacheTabs = new ArrayList();
            int TabNo = 0;
            CPreparedStatement pstmt = null;
            ResultSet rs = null;
            try {
                try {
                    pstmt = DB.prepareStatement(sql, null);
                    pstmt.setInt(1, mWindowVO.AD_Window_ID);
                    rs = pstmt.executeQuery();
                    boolean firstTab = true;
                    boolean firstTabIsNull = false;
                    while (rs.next()) {
                        GridTabVO mTabVO;
                        if (mWindowVO.AD_Table_ID == 0) {
                            mWindowVO.AD_Table_ID = rs.getInt("AD_Table_ID");
                        }
                        if ((mTabVO = GridTabVO.create(mWindowVO, TabNo, rs, mWindowVO.WindowType.equals(WINDOWTYPE_QUERY), mWindowVO.WindowType.equals(WINDOWTYPE_TRX))) != null) {
                            cacheTabs.add(mTabVO.clone(Env.getCtx(), 0));
                        }
                        if (!GridTabVO.checkAccessAndShowPreference(mTabVO, role)) {
                            mTabVO = null;
                        }
                        if (mTabVO != null) {
                            GridTabVO.loadUserDefTab(mTabVO);
                            if (firstTab) {
                                GridTabVO.updateContext(mTabVO);
                            }
                        }
                        if (mTabVO == null && firstTab) {
                            firstTabIsNull = true;
                        }
                        if (mTabVO == null || firstTabIsNull) continue;
                        if (!mTabVO.IsReadOnly && "N".equals(mWindowVO.IsReadWrite)) {
                            mTabVO.IsReadOnly = true;
                        }
                        mWindowVO.Tabs.add(mTabVO);
                        ++TabNo;
                        firstTab = false;
                    }
                }
                catch (SQLException e) {
                    log.log(Level.SEVERE, "createTabs", e);
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    return false;
                }
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
            s_gridTabsCache.put(cacheKey, cacheTabs);
            if (TabNo == 0 || mWindowVO.Tabs.size() == 0) {
                log.log(Level.SEVERE, "No Tabs - AD_Window_ID=" + mWindowVO.AD_Window_ID + " - " + sql);
                return false;
            }
        }
        Env.setContext(mWindowVO.ctx, mWindowVO.WindowNo, "BaseTable_ID", mWindowVO.AD_Table_ID);
        return true;
    }

    private GridWindowVO(Properties Ctx, int windowNo) {
        this.ctx = Ctx;
        this.WindowNo = windowNo;
    }

    public void setCtx(Properties newCtx) {
        this.ctx = newCtx;
        int i2 = 0;
        while (i2 < this.Tabs.size()) {
            GridTabVO tab = this.Tabs.get(i2);
            tab.setCtx(newCtx);
            ++i2;
        }
    }

    public GridWindowVO clone(int windowNo) {
        return this.clone(windowNo, true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public GridWindowVO clone(int windowNo, boolean cloneTabs) {
        GridWindowVO clone = null;
        try {
            clone = new GridWindowVO(this.ctx, windowNo);
            clone.AD_Color_ID = this.AD_Color_ID;
            clone.AD_Image_ID = this.AD_Image_ID;
            clone.AD_Table_ID = this.AD_Table_ID;
            clone.AD_Window_ID = this.AD_Window_ID;
            clone.AD_Window_UU = this.AD_Window_UU;
            clone.Description = this.Description;
            clone.EntityType = this.EntityType;
            clone.Help = this.Help;
            clone.IsReadWrite = this.IsReadWrite;
            clone.IsSOTrx = this.IsSOTrx;
            clone.Name = this.Name;
            clone.WindowType = this.WindowType;
            clone.WinWidth = this.WinWidth;
            clone.WinHeight = this.WinHeight;
            clone.Tabs = null;
            if (!cloneTabs) return clone;
            clone.Tabs = new ArrayList();
            int i2 = 0;
            while (true) {
                if (i2 >= this.Tabs.size()) {
                    Env.setContext(this.ctx, windowNo, "IsSOTrx", clone.IsSOTrx);
                    Env.setContext(this.ctx, windowNo, "BaseTable_ID", clone.AD_Table_ID);
                    return clone;
                }
                GridTabVO tab = this.Tabs.get(i2);
                GridTabVO cloneTab = tab.clone(clone.ctx, windowNo);
                if (cloneTab == null) {
                    return null;
                }
                clone.Tabs.add(cloneTab);
                if (clone.Tabs.size() == 1) {
                    GridTabVO.updateContext(cloneTab);
                }
                ++i2;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }
}

