/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.install;

import java.sql.Timestamp;
import java.util.logging.Level;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class TranslationHandler
extends DefaultHandler {
    private int m_AD_Client_ID = -1;
    private String m_trxName = null;
    private String m_AD_Language = null;
    private boolean m_isBaseLanguage = false;
    private String m_TableName = null;
    private String m_updateSQL = null;
    private String m_curID = null;
    private String m_curUUID = null;
    private String m_trl = null;
    private String m_curColumnName = null;
    private StringBuffer m_curValue = null;
    private StringBuffer m_sql = null;
    private Timestamp m_time = new Timestamp(System.currentTimeMillis());
    private int m_updateCount = 0;
    private static final CLogger log = CLogger.getCLogger(TranslationHandler.class);

    public TranslationHandler(int AD_Client_ID) {
        this(AD_Client_ID, null);
    }

    public TranslationHandler(int AD_Client_ID, String trxName) {
        this.m_AD_Client_ID = AD_Client_ID;
        this.m_trxName = trxName;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("idempiereTrl") || qName.equals("adempiereTrl") || qName.equals("compiereTrl")) {
            this.m_AD_Language = attributes.getValue("language");
            this.m_isBaseLanguage = Language.isBaseLanguage(this.m_AD_Language);
            this.m_TableName = attributes.getValue("table");
            this.m_updateSQL = "UPDATE " + this.m_TableName;
            if (!this.m_isBaseLanguage) {
                this.m_updateSQL = String.valueOf(this.m_updateSQL) + "_Trl";
            }
            this.m_updateSQL = String.valueOf(this.m_updateSQL) + " SET ";
            if (log.isLoggable(Level.FINE)) {
                log.fine("AD_Language=" + this.m_AD_Language + ", Base=" + this.m_isBaseLanguage + ", TableName=" + this.m_TableName);
            }
        } else if (qName.equals("row")) {
            this.m_curID = attributes.getValue("id");
            this.m_curUUID = attributes.getValue("uuid");
            this.m_trl = attributes.getValue("trl");
            this.m_sql = new StringBuffer();
        } else if (qName.equals("value")) {
            this.m_curColumnName = attributes.getValue("column");
        } else {
            log.severe("UNKNOWN TAG: " + qName);
        }
        this.m_curValue = new StringBuffer();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_curValue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (!(qName.equals("idempiereTrl") || qName.equals("adempiereTrl") || qName.equals("compiereTrl"))) {
            if (qName.equals("row")) {
                if (this.m_sql.length() > 0) {
                    this.m_sql.append(",");
                }
                this.m_sql.append("Updated=").append(DB.TO_DATE(this.m_time, false));
                if (!this.m_isBaseLanguage) {
                    if (this.m_trl != null && ("Y".equals(this.m_trl) || "N".equals(this.m_trl))) {
                        this.m_sql.append(",IsTranslated='").append(this.m_trl).append("'");
                    } else {
                        this.m_sql.append(",IsTranslated='Y'");
                    }
                }
                this.m_sql.append(" WHERE ");
                if (this.m_curUUID != null) {
                    MTable table2 = MTable.get(Env.getCtx(), this.m_TableName);
                    if (table2.isIDKeyTable()) {
                        StringBuilder sql = new StringBuilder("SELECT ").append(this.m_TableName).append("_ID").append(" FROM ").append(this.m_TableName).append(" WHERE ").append(this.m_TableName).append("_UU =?");
                        int ID = DB.getSQLValueEx(null, sql.toString(), this.m_curUUID);
                        this.m_sql.append(this.m_TableName).append("_ID=").append(ID);
                    } else {
                        this.m_sql.append(PO.getUUIDColumnName(this.m_TableName)).append("=").append(DB.TO_STRING(this.m_curUUID));
                    }
                } else {
                    this.m_sql.append(this.m_TableName).append("_ID=").append(this.m_curID);
                }
                if (!this.m_isBaseLanguage) {
                    this.m_sql.append(" AND AD_Language='").append(this.m_AD_Language).append("'");
                }
                if (this.m_AD_Client_ID >= 0) {
                    this.m_sql.append(" AND AD_Client_ID=").append(this.m_AD_Client_ID);
                }
                this.m_sql.insert(0, this.m_updateSQL);
                try {
                    int no = DB.executeUpdateEx(this.m_sql.toString(), this.m_trxName);
                    if (no == 1) {
                        if (log.isLoggable(Level.FINE)) {
                            log.fine(this.m_sql.toString());
                        }
                        ++this.m_updateCount;
                    }
                    if (no == 0) {
                        log.warning("Not Found - " + this.m_sql.toString());
                    }
                    log.severe("Update Rows=" + no + " (Should be 1) - " + this.m_sql.toString());
                }
                catch (Exception e) {
                    throw new AdempiereException("Error: " + e.getLocalizedMessage() + " ... executing " + String.valueOf(this.m_sql), e);
                }
            } else if (qName.equals("value")) {
                if (this.m_sql.length() > 0) {
                    this.m_sql.append(",");
                }
                this.m_sql.append(this.m_curColumnName).append("=").append(DB.TO_STRING(this.m_curValue.toString()));
            }
        }
    }

    public int getUpdateCount() {
        return this.m_updateCount;
    }
}

